SUPPORT(gtblku,		dynamic allocation)
/*chain for allocation */
#define ALIGN int
#define NALIGN 1
#define WORD sizeof(union store)
union store { union store *ptr;
	      ALIGN dummy[NALIGN];
	      int calloc;	/*calloc clears an array of integers*/
};

static	union store *top;	/*top of allocated chain*/

static long r_gtblku(n, type, rstak, istak, cstak)
long *n, *type; float *rstak; long *istak; char *cstak;
{
	long int i; unsigned nn, nbyte; char *malloc(); char *p;
	union store *chain;
	if( (nn = (unsigned)*n) != *n)FATAL(allocating too much storage)
	nn++; /* 1 extra for possible truncation error */
	switch( (int)*type ) {
	case LGL:
	case INT:
	case REAL: nbyte = (nn+1)*sizeof(float);
		break;
	case CHAR: nbyte = nn;
		break;
	default: TERMINAL(bad type: %d, (int)*type)
		}
	p = malloc(nbyte + WORD);
	if( p==NULL ) FATAL(allocating too much dynamic storage)
	chain = (union store *)p;
	p += WORD; /* move past the chain pointer */
	chain->ptr = top; /* the previous top of the chain */
	top = chain; /* the new top */

	switch ( (int)*type ) {
	case INT:
	case LGL: i = ( (long int *)p ) - istak;
		break;
	case REAL: i = ( (float *)p ) - rstak;
		break;
	case CHAR: i = p - cstak;
		}
	return( i+2 ); /* +1 for FORTRAN indexing; +1 for truncation (?) */
}

long F77_SUB(gtblku,int=n,int=type,real=rstak,int=istak,char=cstak)
{
	return( r_gtblku(F_INTP(n),F_INTP(type),F_REALP(rstak),
			F_INTP(istak),F_CHARP(cstak)) );
}

F77_SUB(rlblku,int=n)
{
	r_rlblku(F_INTP(n));
}

static r_rlblku(n)
long *n;
{
	extern char end;
	int i;
	union store *chain;
	char *sbrk(), *brkloc, *p;

	i = *n; brkloc = sbrk(0);
	while (i-- > 0) {
		p = (char *) top;
		if( p < &end || p>brkloc) {
			MESSAGE(Dynamic allocation chain broken)
			F77_CALL(prtchn);
			TERMINAL
			}
		chain = top->ptr; /*new top */
		cfree( (char *) top); /* pop the last block */
		top = chain;
		}
	return;
}

F77_SUB(prtchn)		/* debug printing of allocated chain */
{
	char *sbrk(), *brkloc;
	int count; extern char end;
	union store *chain;

	chain = top; brkloc = sbrk(0); count = 0;
	printf("Allocation chain :");
	REPEAT {
		if((char *)chain < &end || (char *) chain > brkloc)break;
		printf(" %u",chain);
		if(((count++) % 5) == 0)printf("\n");
		chain = chain->ptr;
		}
	printf("\n Count: %d\n",count);
	if( chain != (union store *) NULL)
		MESSAGE(bad pointer chain element %u; break= %u,chain,brkloc)
	}
