ROUTINE(hcmmam,		cluster merge by maximum)
subroutine hcmmam(d,n,iold,inew,w)
real d(1), w(1)

#         we will merge row iold into row inew

#        this is a stmt function to compute the location within a packed
#   vector of the strictly lower triangle of a matrix by using
#   the row and column indices as if we were accessing the whole
#   m by m matrix.

ijm(i,j,m) = ((min0(i,j) - 1)*(2*m - min0(i,j) - 2))/2 + max0(i,j) - 1

#        now go across all columns

do l = 1,n
	if ((l != inew) & (l != iold) & (w(l) > 0.5)) {
		lnew = ijm(inew,l,n)
		lold = ijm(iold,l,n)
		if (d(lold) > d(lnew)) d(lnew) = d(lold)
		}
w(inew) = w(inew) + w(iold)
w(iold) = 0.0
return
end
