ROUTINE(l1,	fit by minimum absolute residuals)
subroutine l1(m,n,m2,n2,a,b,toler,x,e,s)
real a(m2,n2),x(n),e(m),b(m)
# barrodale and roberts, cacm (june 1974) pp 319-320
# algorithm 478

# solution of an overdetermined system of equations in the l1 norm
double precision sum
real min,max
integer out,s(m)
logical stage,test
# big must be set equal to any very large real constant
data big/BIG/
# initialization
m1 = m+1
n1 = n+1
do j = 1,n {
	a(m2,j) = j
	x(j) = 0.
	}
do i = 1,m {
	a(i,n2) = n+i
	a(i,n1) = b(i)
	if (b(i)<0.)
		do j = 1,n2
			a(i,j) = -a(i,j)
	e(i) = 0.
	}
# compute the marginal costs
do j = 1,n1 {
	sum = 0.0d0
	do i = 1,m
		sum = sum+a(i,j)
	a(m1,j) = sum
	}
# stage 1
# determine the vector to enter the basis
stage = TRUE
kount = 0
kr = 1
kl = 1
repeat {
	max = -1.
	do j = kr,n
		if (abs(a(m2,j))<=n) {
			d = abs(a(m1,j))
			if (d>max) {
				max = d
				in = j
				}
			}
	if (a(m1,in)<0.)
		do i = 1,m2
			a(i,in) = -a(i,in)
	repeat {
# determine the vector to leave the basis
		k = 0
		do i = kl,m {
			d = a(i,in)
			if (d>toler) {
				k = k+1
				b(k) = a(i,n1)/d
				s(k) = i
				test = TRUE
				}
			}
		repeat {
			if (k<=0)
				test = FALSE
			else {
				min = big
				do i = 1,k
					if (b(i)<min) {
						j = i
						min = b(i)
						out = s(i)
						}
				b(j) = b(k)
				s(j) = s(k)
				k = k-1
				}
# check for linear dependence in stage 1
			if (!test&&stage)
				break 1
			if (!test)
				break 3
			pivot = a(out,in)
			if (a(m1,in)-pivot-pivot<=toler)
				go to 10
			do j = kr,n1 {
				d = a(out,j)
				a(m1,j) = a(m1,j)-d-d
				a(out,j) = -d
				}
			a(out,n2) = -a(out,n2)
			}
		do i = 1,m2 {
			d = a(i,kr)
			a(i,kr) = a(i,in)
			a(i,in) = d
			}
		kr = kr+1
		go to 20
# pivot on a(out,in)
		10  do j = kr,n1
			if (j!=in)
				a(out,j) = a(out,j)/pivot
		do i = 1,m1
			if (i!=out) {
				d = a(i,in)
				do j = kr,n1
					if (j!=in)
						a(i,j) = a(i,j)-d*a(out,j)
				}
		do i = 1,m1
			if (i!=out)
				a(i,in) = -a(i,in)/pivot
		a(out,in) = 1./pivot
		d = a(out,n2)
		a(out,n2) = a(m2,in)
		a(m2,in) = d
		kount = kount+1
		if (!stage)
			go to 30
# interchange rows in stage 1
		kl = kl+1
		do j = kr,n2 {
			d = a(out,j)
			a(out,j) = a(kount,j)
			a(kount,j) = d
			}
		20  if (kount+kr!=n1)
			break 1
# stage 2
		stage = FALSE
# determine the vector to enter the basis
		30  max = -big
		do j = kr,n {
			d = a(m1,j)
			if (d<0.) {
				if (d>(-2.))
					next 1
				d = -d-2.
				}
			if (d>max) {
				max = d
				in = j
				}
			}
		if (max<=toler)
			go to 40
		if (a(m1,in)<=0.) {
			do i = 1,m2
				a(i,in) = -a(i,in)
			a(m1,in) = a(m1,in)-2.
			}
		}
	}
a(m2,n1) = 2.
go to 50
# prepare output
40  l = kl-1
do i = 1,l
	if (a(i,n1)<0.)
		do j = kr,n2
			a(i,j) = -a(i,j)
a(m2,n1) = 0.
if (kr==1) {
	do j = 1,n {
		d = abs(a(m1,j))
		if (d<=toler||2.-d<=toler)
			go to 50
		}
	a(m2,n1) = 1.
	}
50  do i = 1,m {
	k = a(i,n2)
	d = a(i,n1)
	if (k<=0) {
		k = -k
		d = -d
		}
	if (i<kl)
		x(k) = d
	else {
		k = k-n
		e(k) = d
		}
	}
a(m2,n2) = kount
a(m1,n2) = n1-kr
sum = 0.0d0
do i = kl,m
	sum = sum+a(i,n1)
a(m1,n1) = sum
return
end



