ROUTINE(leaps2,		Furnival and Wilson all-subset regression)
subroutine leaps2(rr,kx,nr,ndef,ibit,mbst,tol,regid,criter,ncoef,nreg,ns,xc,cn,ci,cl,co,toll,xn,xi,yi,yn,rm,nc,md,ili,
  iln,ipi,ipn,ni,nn,id)
real rr(nr,nr),xc(1),toll(1),tol
integer cn(1),ci(1),cl(ns,1),co(1)
integer nc(nr,1),md(nr,1),ili(nr,1),iln(nr,1),ipi(1),ipn(1),ni(1),nn(1),id(1)
real xn(1),xi(1),yi(1),yn(1),rm(ns,1)
real criter(1)
integer ncoef(1),regid(1)
INCLUDE(print)
#                   regressions by leaps and bounds                    *
#                     g.m.furnival and r.w.wilson                      *
#               yale university and u.s. forest service                *
#                           version 11/11/74                           *
ko = ns-1
ne = (kx+1)*(kx+2)/2
nd = nr
nl = ne*(kx+3)/3
if (kx<3||kx>=nd||ndef<=kx||mbst<=0||mbst>ko||ko>ns||nr<=kx||ibit<1||ibit>3)
	ERROR(Input parameter out of bounds)
kz = kx+1
ss = rr(kz,kz)/100.0
if (ibit==2) ss = ss/float(ndef)
if (ss<=0.0) ERROR(Diagonal element <= 0)
cn(1) = 0	# initialize
ci(1) = 0
two = 2.0*rr(kz,kz)*float(ndef)
low = ko-mbst+1
do l = 1,kz {
	id(l) = ((kz-1)*kz*(kz+1)-(kz-l)*(kz-l+1)*(kz-l+2))/6
	ipn(l) = 1
	ili(1,l) = l
	rm(ko+1,l) = -two
	co(l) = 2**(kx-l)
	nc(1,l) = l
	toll(l) = tol*rr(l,l)
	if (toll(l)<=0.0) ERROR(Diagonal element <= 0)
	do m = 1,ko {
		cl(m,l) = 0
		rm(m,l) = two
		}
	}
ls = 0
do l = 1,kz	# store matrices as vectors
	do m = l,kz {
		ls = ls+1
		md(l,m) = ls
		md(m,l) = ls
		xc(ls) = rr(l,m)
		xn(ls) = xc(ls)
		rr(m,l) = rr(l,m)
		}
for(n=1; n<=kx; n=n+1){	# invert matrix stepwise
	do la = n,kx {
		l = ili(1,la)
		if (xc(md(l,l))>=toll(l)) {
			rs = xc(md(kz,kz))-xc(md(l,kz))*xc(md(l,kz))/xc(md(l,l))
			if (rs<rm(ko,n)) j = la
			if (rs<rm(1,n)) call store(rs,ci(1)+co(l),ko,cl,rm,n,ns,nd)
			}
		}
	if (rm(ko,n)==two) break
	m = ili(1,j)
	ili(1,j) = ili(1,n)
	ili(1,n) = m
	iln(1,n) = m
	ci(1) = ci(1)+co(m)
	call pivot(xc,kz,m,md,nd,ne)
	}
k = n-1
kp = k+1
if (k!=kx){
	ENCODE("Screen-matrix singular: Variables")
	for(i=kp; i<=kx; i=i+1) ENCODE(I(ili(1,i)))
	EPRINT(" deleted")
	}
if(k<3) return	# too few variables remaining
km = k-1
sig = 2.0*xc(ls)/float(ndef-k)
yi(1) = xc(ls)
yn(1) = rr(kz,kz)
do l = 1,ls
	xi(l) = xc(l)
ni(1) = k
nn(1) = k
if (ibit!=1)
	do m = 1,k
		do l = 1,ko {
			if (ibit==2) rs = rm(l,m)/float(ndef-m)
			if (ibit==3) rs = rm(l,m)+sig*float(m)
			if (rs<rm(1,kz)) call store(rs,cl(l,m),ko,cl,rm,kz,ns,nd)
			}
mn = 2
mv = -1
while (mn!=1) {
	ip = ipn(mn)
	ipn(mn) = ip+1
	mv = mv-ipn(mn+1)+ip+2
	ipi(mv) = ip
	mn = mn-1
	in = ipn(mn)
	jc = mv
	bound = yi(ip)
	yi(ip) = two
	for(lb=ip; lb<=km; lb=lb+1) {	# find leap from bounds
		mt = mn+km-lb
		if (ibit==1&&rm(low,mt)>bound) break
		if (ibit==2&&rm(low,kz)>bound/float(ndef-mt)) break
		if (ibit==3&&rm(low,kz)>bound+sig*float(mt)) break
		}
	if(lb>km) next
	lc = km+ip-lb
	if (ip==1) lc = k
	do lb = ip,lc {	# regressions from inverse matrix
		is = lb+1
		call back(nc,lb,li,ipi,mv,rs,bound,ili,jc,id,xi,md,1,ni,nd,kz,nl)
		m = lb	# re-order variables
		if (lb<=nn(in)) {
			ln = iln(in,lb)
			while (rs>yi(m)) {
				yi(m+1) = yi(m)
				ili(ip,m) = ili(ip,m-1)
				iln(in,m) = iln(in,m-1)
				m = m-1
				}
			ili(ip,m) = li
			iln(in,m) = ln
			}
		yi(m+1) = rs
		ni(is) = lb
		nn(is) = lb
		}
	if (lc==k) lc = km
	mi = k-mv
	jc = mn
	do lb = ip,lc {	# regressions from product matrix
		is = lb+1
		call back(nc,lb,l,ipn,mn,yn(is),yn(in),iln,jc,id,xn,md,0,nn,nd,kz,nl)
		ci(is) = ci(ip)-co(nc(in,l))
		cn(is) = cn(in)+co(nc(in,l))
		if (yi(is)<rm(1,mi)) {
			call store(yi(is),ci(is),ko,cl,rm,mi,ns,nd)
			if (ibit!=1) {
				if (ibit==2) rs = yi(is)/float(ndef-mi)
				if (ibit==3) rs = yi(is)+float(mi)*sig
				if (rs<rm(1,kz)) call store(rs,ci(is),ko,cl,rm,kz,ns,nd)
				}
			}
		if (yn(is)<rm(1,mn)) {
			call store(yn(is),cn(is),ko,cl,rm,mn,ns,nd)
			if (ibit!=1) {
				if (ibit==2) rs = yn(is)/float(ndef-mn)
				if (ibit==3) rs = yn(is)+float(mn)*sig
				if (rs<rm(1,kz)) call store(rs,cn(is),ko,cl,rm,kz,ns,nd)
				}
			}
		mn = mn+1
		ipn(mn+1) = ipn(mn)+1
		in = is
		}
	if (lc==km) mn = mn-1
	}
nreg = 0	# output
do m = 1,k
	do la = 1,ko {
		l = ko-la+1
		if (rm(l,m)==two) break
		if (ibit==1) r2 = 100.0-rm(l,m)/ss
		if (ibit==2){
			rs = rm(l,m)/float(ndef-m)
			r2 = 100.0-rs/ss
			}
		if (ibit==3){
			rs = rm(l,m)+sig*float(m)
			r2 = 2.0*rs/sig-float(ndef)+1.0
			}
		nreg = nreg+1	# decode labels
		regid(nreg) = cl(l,m)
		criter(nreg) = r2
		ncoef(nreg) = m
		}
return
end



ROUTINE(pivot,		symetric pivot-returns negative inverse)
subroutine pivot(xi,kp,n,md,nd,nl)
real xi(nl),b
integer md(nd,nd)
xi(md(n,n)) = -1.0/xi(md(n,n))
do i = 1,kp
	if (i!=n) {
		b = xi(md(i,n))*xi(md(n,n))
		do j = i,kp
			if (j!=n)
				xi(md(i,j)) = xi(md(i,j))+b*xi(md(j,n))
		xi(md(i,n)) = b
		}
return
end



ROUTINE(store,		saves rss:s and labels for best regressions)
subroutine store(rss,cab,ko,cl,rm,n,ns,nd)
integer cab,cl(ns,nd)
real rm(ns,nd)
do l = 1,ko
	if (cab==cl(l,n))
		return
l = 0
repeat {
	l = l+1
	if (rss>rm((l+1),n))
		break 1
	rm(l,n) = rm(l+1,n)
	cl(l,n) = cl(l+1,n)
	}
rm(l,n) = rss
cl(l,n) = cab
return
end



ROUTINE(back,		look back computation of rss)
subroutine back(nc,lb,l,ipi,mv,rs,bnd,ili,jc,id,xi,md,ii,ni,nd,kz,nl)
real xi(nl)
integer nc(nd,nd),md(nd,nd),ili(nd,nd),ipi(nd),ni(nd),id(nd)
while (lb>ni(ipi(jc)))
	jc = jc-1
do j = jc,mv {	# adjust for previous pivots
	in = ipi(j)
	l = ili(in,lb)
	mm = id(in)
	if (j==mv)
		break 1
	is = ipi(j+1)
	ip = ili(in,is-1)
	b = xi(mm+md(ip,l))/xi(mm+md(ip,ip))
	ka = is
	while (ka<=lb) {
		kn = ili(in,ka)
		xi(id(is)+md(ka,lb)) = xi(mm+md(kn,l))-b*xi(mm+md(kn,ip))
		ka = ka+1
		}
	xi(id(is)+md(lb,kz)) = xi(mm+md(l,kz))-b*xi(mm+md(ip,kz))
	ni(is) = lb
	ili(is,lb) = lb
	if (ii==0)
		nc(is,lb) = nc(in,l)
	}
rs = bnd-xi(mm+md(l,kz))*xi(mm+md(l,kz))/xi(mm+md(l,l))	# current pivot
return
end



