ROUTINE(lowess,		locally weighted scatterplot smoother)
subroutine lowess(x,y,n,f,nsteps,delta,ys,rw,res)
real x(n),y(n),ys(n),rw(n),res(n)
logical ok
if (n<2){ ys(1) = y(1); return }
ns = max0(min0(ifix(f*float(n)),n),2)	# at least two, at most n points
for(iter=1; iter<=nsteps+1; iter=iter+1){	# robustness iterations
	nleft = 1; nright = ns
	last = 0	# index of prev estimated point
	i = 1	# index of current point
	repeat{
		while(nright<n){	# move nleft, nright to right if radius decreases
			d1 = x(i)-x(nleft)
			d2 = x(nright+1)-x(i)	# if d1<=d2 with x(nright+1)==x(nright), lowest fixes
			if (d1<=d2) break	# radius will not decrease by move right
			nleft = nleft+1
			nright = nright+1
			}
		call lowest(x,y,n,x(i),ys(i),nleft,nright,res,iter>1,rw,ok)	# fitted value at x(i)
		if (!ok) ys(i) = y(i)	# all weights zero - copy over value (all rw==0)
		if (last<i-1) {	# skipped points -- interpolate
			denom = x(i)-x(last)	# non-zero - proof?
			for(j=last+1; j<i; j=j+1){
				alpha = (x(j)-x(last))/denom
				ys(j) = alpha*ys(i)+(1.0-alpha)*ys(last)
				}
			}
		last = i	# last point actually estimated
		cut = x(last)+delta	# x coord of close points
		for(i=last+1; i<=n; i=i+1){	# find close points
			if (x(i)>cut) break	# i one beyond last pt within cut
			if(x(i)==x(last)){	# exact match in x
				ys(i) = ys(last)
				last = i
				}
			}
		i=max0(last+1,i-1)	# back 1 point so interpolation within delta, but always go forward
		} until(last>=n)
	do i = 1,n	# residuals
		res(i) = y(i)-ys(i)
	if (iter>nsteps) break	# compute robustness weights except last time
	do i = 1,n
		rw(i) = abs(res(i))
	call sort(rw,n)
	m1 = 1+n/2; m2 = n-m1+1
	cmad = 3.0*(rw(m1)+rw(m2))	# 6 median abs resid
	c9 = .999*cmad; c1 = .001*cmad
	do i = 1,n {
		r = abs(res(i))
		if(r<=c1) rw(i)=1.	# near 0, avoid underflow
		else if(r>c9) rw(i)=0.	# near 1, avoid underflow
		else rw(i) = (1.0-(r/cmad)**2)**2
		}
	}
return
end
