ROUTINE(lowest,		lowess estimate at single x value)
subroutine lowest(x,y,n,xs,ys,nleft,nright,w,userw,rw,ok)
real x(n),y(n),w(n),rw(n)
logical userw,ok
range = x(n)-x(1)
h = amax1(xs-x(nleft),x(nright)-xs)
h9 = .999*h
h1 = .001*h
a = 0.0	# sum of weights
for(j=nleft; j<=n; j=j+1){	# compute weights (pick up all ties on right)
	w(j)=0.
	r = abs(x(j)-xs)
	if (r<=h9) {	# small enough for non-zero weight
		if (r>h1) w(j) = (1.0-(r/h)**3)**3
		else      w(j) = 1.
		if (userw) w(j) = rw(j)*w(j)
		a = a+w(j)
		}
	else if(x(j)>xs)break	# get out at first zero wt on right
	}
nrt=j-1	# rightmost pt (may be greater than nright because of ties)
if (a<=0.0) ok = FALSE
else {	# weighted least squares
	ok = TRUE
	do j = nleft,nrt
		w(j) = w(j)/a	# make sum of w(j) == 1
	if (h>0.) {	# use linear fit
		a = 0.0
		do j = nleft,nrt
			a = a+w(j)*x(j)	# weighted center of x values
		b = xs-a
		c = 0.0
		do j = nleft,nrt
			c = c+w(j)*(x(j)-a)**2
		if(sqrt(c)>.001*range) {	# points are spread out enough to compute slope
			b = b/c
			do j = nleft,nrt
				w(j) = w(j)*(1.0+b*(x(j)-a))
			}
		}
	ys = 0.0
	do j = nleft,nrt
		ys = ys+w(j)*y(j)
	}
return
end
