ROUTINE(qgamm,quantile of gamma with shape eta at probability p)
real function qgamm(p,eta)
real p,eta
real a(19),f1,p1,q1,f2,pdif,pr,pabs,del1,dl,pl
real qnorms,pgamm,gamlog
integer i
data a/1.264616e-2,-1.425296e-2,1.400483e-2,-5.886090e-3,-1.091214e-2,-2.304527e-2,3.135411e-3,-2.728484e-4,
  -9.699681e-3,1.316872e-2,2.618914e-2,-0.2222222,5.406674e-5,3.483789e-5,-7.274761e-4,3.292181e-3,-8.729713e-3,
  0.4714045,1.0/
if(eta<=0.0) ERROR(ETA less or equal zero)
if(p<0.0||p>=1.0) ERROR(Probability out of range)
if(p==0.) return(0.)
pr = p
i = 1
if (eta<0.5) {
#	q1 = exp( (gamlog(eta+1)+p) /eta )
	f1 = 1.0/(9.0*eta)
	q1 = 1.0-f1+qnorms(pr)*sqrt(f1)
	q1 = q1*q1*q1*eta*2.0
	if (q1<=0.0)
		q1 = p**(9.0*f1)
	if (q1<=0.0)
		q1 = 0.0001
	}
else if (eta==0.5) {
	q1 = qnorms(0.5*(1.0-pr))
	return( q1*q1*0.5 )
	}
else if (eta==1.0) 
	return( -alog(1.0-pr) )
else {
	f1 = 0.5/eta
	f2 = sqrt(f1)*qnorms(pr)
	q1 = (((a(1)+a(2)*f2)*f1+(((a(3)+a(4)*f2)*f2+a(5))*f2+a(6)))*f1+(((((a(7)+a(8)*f2)*f2+a(9))*f2+a(10))*f2+a(11))*f2+a(
	  12)))*f1+(((((a(13)*f2+a(14))*f2+a(15))*f2+a(16))*f2+a(17))*f2*f2+a(18))*f2+a(19)
	q1 = q1*q1*q1*eta
	if(eta>=30.| (eta>=15 & pr>.49 & pr <=.99) | (pr>=.01 & pr <=.99 & eta>25.2-20.8*pr))
		return(q1)
	}
repeat {
	p1 = pgamm(q1,eta)
	pdif = pr-p1
	pabs = abs(pdif)
	if (pabs<=1.0e-8)break 
	if (pabs>=pl&&i!=1)
		del1 = -del1/2.
	else {	#     del1 is a newton-raphson correction
		del1 = alog(pabs)-(eta-1.0)*alog(q1)+q1+gamlog(eta)
		del1 = sign(exp(del1),pdif)
		if (-del1>q1)
			del1 = -.9*q1
		if (sign(1.,pdif)!=sign(1.,del1))
			del1 = sign(dl/2.0,pdif)
		}
	dl = abs(del1)
	pl = pabs
	q1 = amax1(q1+del1,R1MACH(1))	# dont allow non-positive result
	if (dl<=q1*1.0e-6)	# q1*1e-6 may underflow -- need <=, not <
		break 1
	i = i+1
	}
	until(i>50)
return (q1)
end
