ROUTINE(r9lgmc,log gamma correction factor for x greater/equal 10.)
real function r9lgmc(x)
real x
# august 1977 edition.  w. fullerton, c3, los alamos scientific lab.
# compute the log gamma correction factor for x .ge. 10.0 so that
#  alog (gamma(x)) = alog(sqrt(2*pi)) + (x-.5)*alog(x) - x + r9lgmc(x)

real algmcs(6),xbig,xmax,csevl
integer nalgm,inits
SAVE( nalgm,xbig,xmax )
# series for algm       on the interval  0.          to  1.00000d-02
#                                        with weighted error   3.40e-16
#                                         log weighted error  15.47
#                               significant figures required  14.39
#                                    decimal places required  15.86
data algmcs(1)/.1666389480 45186e0/
data algmcs(2)/-.0000138494 817606e0/
data algmcs(3)/.0000000098 108256e0/
data algmcs(4)/-.0000000000 180912e0/
data algmcs(5)/.0000000000 000622e0/
data algmcs(6)/-.0000000000 000003e0/
data nalgm,xbig,xmax/0,2*0.0/
if (nalgm==0) {	# initialize
	nalgm = inits(algmcs,6,R1MACH(3))
	xbig = 1.0/sqrt(R1MACH(3))
	xmax = exp(amin1(alog(R1MACH(2)/12.0),-alog(12.0*R1MACH(1))))
	}
if (x<10.0) ERROR(x must be greater/equal to ten)
if (x>=xmax) {
	ERROR(underflow -- x too large,zero returned,WARNING)
	return (0.)
	}
if (x<xbig)
	return( csevl(2.0*(10./x)**2-1.,algmcs,nalgm)/x )
else
	return( 1.0/(12.0*x) )
end
