ROUTINE(rchis,random chi-square with (integer) idf degrees of freedom)
real function rchis(idf,iseed)
integer idf,iseed
real rnormk,runifs,rexpos,rr,v,f1,f2,f
real a(19)
integer kunif,kappr1,kappr2,k,kk,i
data a/1.264616e-2,-1.425296e-2,1.400483e-2,-5.886090e-3,-1.091214e-2,-2.304527e-2,3.135411e-3,-2.728484e-4,
  -9.699681e-3,1.316872e-2,2.618914e-2,-0.2222222,5.406674e-5,3.483789e-5,-7.274761e-4,3.292181e-3,-8.729713e-3,
  0.4714045,1.0/
data kunif,kappr1,kappr2/8,16,60/
if (idf<=0) ERROR(idf less or equal zero)
k = idf
if (k>=kappr1||k>=kappr2) {
	f = k
	if (k>=kappr2) {	#the hilferty and wilson approximation
		v = 2.0/(9.0*f)
		return( f*(1.0-v+rnormk(iseed)*sqrt(v))**3 )
		}
	else {	#the 19 term goldstein approximation
		f1 = 1.0/f
		f2 = sqrt(f1)*rnormk(iseed)
		rr = (((a(1)+a(2)*f2)*f1+(((a(3)+a(4)*f2)*f2+a(5))*f2+a(6)))*f1+(((((a(7)+a(8)*f2)*f2+a(9))*f2+a(10))*f2+a(11))*f2+
		  a(12)))*f1+(((((a(13)*f2+a(14))*f2+a(15))*f2+a(16))*f2+a(17))*f2*f2+a(18))*f2+a(19)
		return( rr*rr*rr*f )
		}
	}
rr = 0.0
if (mod(k,2)!=0)
	rr = rnormk(iseed)**2
if (k!=1) {
	kk = k/2
	if (k>=kunif) {	#     add up logs of uniforms
		v = 1.0
		do i = 1,kk
			v = v*runifs(iseed)
		rr = rr-alog(v)*2.0
		}
	else {	#     add up exponentials
		v = 0.0
		do i = 1,kk
			v = v+rexpos(iseed)
		rr = rr+v*2.0
		}
	}
return(rr)
end
