ROUTINE(regsum,		regression summary)
subroutine regsum(n,p,c,coef,stderr,t,diag,res,rms,rsq,fval,int)
integer n,p
real c(p),coef(p),stderr(p),t(p),diag(p),res(n),rsq,fval,rms
logical int

integer i,df
real dotv,rss,rvar,rhat
# if X = QR then C = Q'y; coeficients and
# root diagonal elements of covariance matrix
# supplied in coef and diag
rss = dotv(res,n,res)
if(rss==0.)WARNING(regsum: Residuals are all zero; statistical summary meaningless)
if(n>p) {rvar = rss/float(n-p); rms = sqrt(rvar)}
else {
	WARNING(regsum: No degrees of freedom for residuals)
	rvar = 0.; rms = 0.}
do i = 1,p {
	stderr(i) = diag(i)*rms
	if(stderr(i)>0.)t(i) = coef(i)/stderr(i)
	else {NASET(t(i),REAL)}
	}
if(int) {
	df = p-1
	rhat = dotv(c(2),p-1,c(2))
	}
else {
	df = p
	rhat = dotv(c,p,c)
	}
fval = df*rvar; if(fval>0)fval = rhat/fval; else NASET(fval,REAL)
rsq = rhat+rss; if(rsq>0)rsq=rhat/rsq; else NASET(rsq,REAL)
return
end
