ROUTINE(svd,		singular value decomposition)
subroutine svd(a,m,n,u,nu,s,v,nv)
real a(m,1),u(m,1),v(n,1),s(1)
integer m,n,nu,nv
#a: m by n matrix to decompose
#u: matrix for left factor; returns nu columns nu must be 0,n,m
#s: vector for singular values
#v: matrix for left factor; returns nv columns, nv must be 0 or n

INCLUDE(stack)
POINTER jb,jc,jt,jstkgt

mn=max0(m,n); jb=jstkgt(3*mn,REAL); jc=jb+mn; jt=jc+mn
if(m<n){
	nn=n; mm=m #temps because transr writes back on them
	call transr(a,mm,nn)
	call svd2(a,n,m,v,nv,s,u,nu,rs(jb),rs(jc),rs(jt))
	}
else call svd2(a,m,n,u,nu,s,v,nv,rs(jb),rs(jc),rs(jt))
call jstkrl(1)
return
end

subroutine svd2(a,m,n,u,nu,s,v,nv,b,c,t)
real a(m,1),u(m,1),v(n,1)
integer m,n,nu,nv
real s(1)
real b(1),c(1),t(1)

tol=R1MACH(1)/R1MACH(4)	# smallest number divided by eps
c(1) = 0.e0
n1=n+1
k = 1
repeat { #Householder reduction
	k1 = k+1

#    elimination of a(i,k), i=k+1,...,m
	z = 0.e0
	do i = k,m
		z = z+a(i,k)**2
	b(k) = 0.e0
	if (z>tol) {
		z = sqrt(z)
		b(k) = z
		w = abs(a(k,k))
		q = 1.e0
		if (w!=0.e0)
			q = a(k,k)/w
		a(k,k) = q*(z+w)
		if (k!=n) {
			do j = k1,n {
				q = 0.e0
				do i = k,m
					q = q+a(i,k)*a(i,j)
				q = q/(z*(z+w))
				do i = k,m
					a(i,j) = a(i,j)-q*a(i,k)
				}

#    phase transformation
			q = -a(k,k)/abs(a(k,k))
			do j = k1,n
				a(k,j) = q*a(k,j)
			}
		}

#    elimination of a(k,j), j=k+2,...,n
	if (k==n)
		break 1
	z = 0.e0
	do j = k1,n
		z = z+a(k,j)**2
	c(k1) = 0.e0
	if (z>tol) {
		z = sqrt(z)
		c(k1) = z
		w = abs(a(k,k1))
		q = 1.e0
		if (w!=0.e0)
			q = a(k,k1)/w
		a(k,k1) = q*(z+w)
		do i = k1,m {
			q = 0.e0
			do j = k1,n
				q = q+a(k,j)*a(i,j)
			q = q/(z*(z+w))
			do j = k1,n
				a(i,j) = a(i,j)-q*a(k,j)
			}

#    phase transformation
		q = -a(k,k1)/abs(a(k,k1))
		do i = k1,m
			a(i,k1) = a(i,k1)*q
		}
	k = k1
	}

# tolerance for negligible elements
eps = 0.e0
do k = 1,n {
	s(k) = b(k)
	t(k) = c(k)
	eps = amax1(eps,s(k)+t(k))
	}
eps = eps*PRECISION

# initialization of u and v
if (nu!=0)
	do j = 1,nu {
		do i = 1,m
			u(i,j) = 0.e0
		u(j,j) = 1.e0
		}
if (nv!=0)
	do j = 1,nv {
		do i = 1,n
			v(i,j) = 0.e0
		v(j,j) = 1.e0
		}

# qr diagonalization
do kk = 1,n {
	k = n1-kk
	repeat {

#    test for split
		do ll = 1,k {
			l = k+1-ll
			if (abs(t(l))<=eps)
				go to 10
			if (abs(s(l-1))<=eps)
				break 1
			}

#    cancellation
		cs = 0.e0
		sn = 1.e0
		l1 = l-1
		do i = l,k {
			f = sn*t(i)
			t(i) = cs*t(i)
			if (abs(f)<=eps)
				break 1
			h = s(i)
			w = sqrt(f*f+h*h)
			s(i) = w
			cs = h/w
			sn = -f/w
			if (nu!=0)
				do j = 1,n {
					x = u(j,l1)
					y = u(j,i)
					u(j,l1) = x*cs+y*sn
					u(j,i) = y*cs-x*sn
					}
			}

#    test for convergence
		10  w = s(k)
		if (l==k)
			break 1

#    origin shift
		x = s(l)
		y = s(k-1)
		g = t(k-1)
		h = t(k)
		f = ((y-w)*(y+w)+(g-h)*(g+h))/(2.e0*h*y)
		g = sqrt(f*f+1.e0)
		if (f<0.e0)
			g = -g
		f = ((x-w)*(x+w)+(y/(f+g)-h)*h)/x

#    qr step
		cs = 1.e0
		sn = 1.e0
		l1 = l+1
		do i = l1,k {
			g = t(i)
			y = s(i)
			h = sn*g
			g = cs*g
			hh = abs(h)
			if (hh>abs(f))
				w = hh*sqrt(1.+(f*f)/(h*h))
			else {
				ff = abs(f)
				w = ff*sqrt(1.+(h*h)/(f*f))
				}
			t(i-1) = w
			cs = f/w
			sn = h/w
			f = x*cs+g*sn
			g = g*cs-x*sn
			h = y*sn
			y = y*cs
			if (nv!=0)
				do j = 1,n {
					x = v(j,i-1)
					w = v(j,i)
					v(j,i-1) = x*cs+w*sn
					v(j,i) = w*cs-x*sn
					}
			hh = abs(h)
			if (hh>abs(f))
				w = hh*sqrt(1.+(f*f)/(h*h))
			else {
				ff = abs(f)
				if (f!=0.0)
					w = ff*sqrt(1.+(h*h)/(f*f))
				else {
					s(i-1) = 0.0
					w = 0.0
					go to 20
					}
				}
			s(i-1) = w
			cs = f/w
			sn = h/w
			20  f = cs*g+sn*y
			x = cs*y-sn*g
			if (nu!=0)
				do j = 1,n {
					y = u(j,i-1)
					w = u(j,i)
					u(j,i-1) = y*cs+w*sn
					u(j,i) = w*cs-y*sn
					}
			}
		t(l) = 0.e0
		t(k) = f
		s(k) = x
		}

#    convergence
	if (w<0.e0) {
		s(k) = -w
		if (nv!=0)
			do j = 1,n
				v(j,k) = -v(j,k)
		}
	}

# sort singular values
do k = 1,n {
	g = -1.e0
	j = k
	do i = k,n
		if (s(i)>g) {
			g = s(i)
			j = i
			}
	if (j!=k) {
		s(j) = s(k)
		s(k) = g
		if (nv!=0)
			do i = 1,n {
				q = v(i,j)
				v(i,j) = v(i,k)
				v(i,k) = q
				}
		if (nu!=0)
			do i = 1,n {
				q = u(i,j)
				u(i,j) = u(i,k)
				u(i,k) = q
				}
		}
	}

if (nu!=0) # back transformation
	do kk = 1,n {
		k = n1-kk
		if (b(k)!=0.e0) {
			q = -a(k,k)/abs(a(k,k))
			do j = 1,nu
				u(k,j) = q*u(k,j)
			do j = 1,nu {
				q = 0.e0
				do i = k,m
					q = q+a(i,k)*u(i,j)
				q = q/(abs(a(k,k))*b(k))
				do i = k,m
					u(i,j) = u(i,j)-q*a(i,k)
				}
			}
		}
if (nv!=0)
	if (n>=2)
		do kk = 2,n {
			k = n1-kk
			k1 = k+1
			if (c(k1)!=0.e0) {
				q = -a(k,k1)/abs(a(k,k1))
				do j = 1,nv
					v(k1,j) = q*v(k1,j)
				do j = 1,nv {
					q = 0.e0
					do i = k1,n
						q = q+a(k,i)*v(i,j)
					q = q/(abs(a(k,k1))*c(k1))
					do i = k1,n
						v(i,j) = v(i,j)-q*a(k,i)
					}
				}
			}
return
end



