ROUTINE(xuni,		McGill Univ. Uniform Generator,
double precision function xuni(idummy))
unsigned congr1,congr2,congr3;

unsigned lambda1, lambda2;

congr()
{
	unsigned long t, tt;
	unsigned long c1, c2;
	t=congr1*lambda1; tt = t>>12;
	c1 = t - (tt<<12); /* tt is carry */
	t = congr2*lambda1+congr1*lambda2+tt; tt = t>>12;
	c2 = t - (tt<<12);
	t = congr3*lambda1+congr2*lambda2+tt;
	congr3 = t - ((t>>8)<<8);
	congr2 = c2; congr1 = c1;
}
/* shift generator */
unsigned long tausval;

taus()
{
	tausval ^= tausval >> 15;
	tausval ^= tausval << 17;
}

long iunival;

double F77_SUB(xuni,int=idummy )
{
	taus();congr();
	iunival = tausval ^ ( ( congr3<<24) | (congr2<<12) | congr1 );
	return( ((float)((iunival>>1) & 017777777777)) / 2147483648. );
			/* shift 1, div. by 2**31 */
}
