#include <stdio.h>
#include <signal.h>
#include "S.h"
#include "device.h"

#define min(x,y) ((x)<(y)?(x):(y))

/* number of local state variables to be retained by device */
#define NLOCAL 7

/* definitions for the state variables */
#define width ((long *)(cur_device->local_params))[0]
#define height ((long *)(cur_device->local_params))[1]
#define to_do ((long *)(cur_device->local_params))[2]
#define curx ((long *)(cur_device->local_params))[3]
#define cury ((long *)(cur_device->local_params))[4]
#define is_command ((long *)(cur_device->local_params))[5]
#define pic ((char **)(cur_device->local_params))[6]

/* defines that allow easy access of graphical parameters */
#define am(i)		(F77_COM(bgrp)[i-1])
#define notNew		(am(121))
extern float F77_COM(bgrp)[];

vector *printer(), *F77_SUB(bquxyz)(),
	*F77_SUB(bpntsz)(), *F77_SUB(blinsz)(), *F77_SUB(bpolyz)(),
	*F77_SUB(btextz)(), *F77_SUB(bsegsz)(), *F77_SUB(brdpnz)();
static vector  *wrap(), *flush(), *signalled(), *hook(),
	*clear(), *seek(), *point(), *line();
static emit_picture(), emit_line(), drawline();

static device d_printer = {
			/* leave these alone */
	FALSE,				/* active flag */
	0,				/* index in list of devices */
	(float *)NULL,			/* copy of parameter array */
	NLOCAL,				/* number of local parameters */
	(char *)NULL,			/* slot for the local parameters */
			/* functions performed by driver */
	{		/* <R> required <O> optional */
		printer,			/* initialize <R> */
		wrap,			/* wrap up <R> */
		flush,			/* flush <R> */
		signalled,		/* caught signal <R> */
		F77_SUB(bpntsz),	/* points <R> (bpntsz) */
		F77_SUB(blinsz),	/* lines <R> (blinsz) */
		F77_SUB(bpolyz),	/* polygon <R> (bpolyz) */
		F77_SUB(btextz),	/* text <R> (btextz) */
		F77_SUB(bsegsz),	/* segments <R> (bsegsz) */
		clear,			/* clear <R> */
		F77_SUB(brdpnz),	/* graphic input <R> (brdpnz) */
		NULL,			/* menu <O> */
		hook,			/* hook <O> */
		seek,			/* seek <O> (low level) */
		point,			/* point <O> (low level) */
		line,			/* line <O> (low level) */
		NULL,			/* length of string <O> (ignore this) */
		F77_SUB(bquxyz),	/* input <O> (low level) */
	}
};

FILE *outfile;

vector
*printer(a_width,a_height,a_where,a_how)
long *a_width,*a_height,*a_how;
char **a_where;
{
	device *d, *new_device();
	int i, (*osig)();

	/* initialize device structure */
	d = new_device(&d_printer, 0L);
	set_device(d->which);

	for(i=1; i<=39; i++)
		am(i) = 0.0;
	am(20) = 1.;	/* char size (x) in rasters */
	am(21) = 1.;	/* char size (y) in rasters */
	am(22) = 0.;	/* minimum x raster coordinate */
	am(23) = *a_width-1;	/* maximum x raster coordinate */
	am(24) = 0.;	/* minimum y raster coordinate */
	am(25) = *a_height-1;	/* maximum y raster coordinate */
	am(26) = .5;	/* char addressing offset x */
	am(27) = .5;	/* char addressing offset y */
	am(28) = .1;	/* x raster size in inches */
	am(29) = 1./6.;	/* y raster size in inches */
	am(30) = PRINTER;
	am(31) = 0;	/* no char rotation */
	am(1)  = 0.;	/* no char size change */

	if(**a_where=='\0') outfile = stdout;
	else {
		is_command = *a_how != 0;
		osig = signal(SIGINT, SIG_IGN);
		outfile = is_command ? popen(*a_where, "w") : fopen(*a_where, "w");
		signal(SIGINT, osig);
		if(outfile == NULL)
			PROBLEM "Cannot %s %s for printer output",
				is_command ? "exec" : "open", *a_where
			RECOVER(S_void);
	}

	width = *a_width;
	height = *a_height;
	to_do = 0;	/* nothing currently to display */
	pic = (char *) Perm_alloc(width*height,1);
	clear();

	F77_SUB(defltz)();	/* set default values for other parms */
	return(S_void);
}

static vector *
wrap()
{
	if(to_do) emit_picture();
	free(pic);
	if(outfile != stdout) {
		fprintf(outfile,"\014");	/* form feed */
		is_command? pclose(outfile) : fclose(outfile);
	}
	return(S_void);
}

static vector *signalled()
{
	fflush(outfile);
	return(S_void);
}

static vector *line(x,y)
long *x,*y;
{
	drawline((int)curx,(int)cury,(int)*x,(int)*y);
	curx = *x; cury = *y;
	return(S_void);
}

static vector *point(ich,crot)
F_CHARTYPE ich; float *crot;
{
	char *p;
	UNUSED(crot);
	p = pic + cury * width + curx;
	*p = *F_CHARP(ich);
	return(S_void);
}

static vector *seek(x,y)
long *x,*y;
{
	to_do = 1;
	curx = *x;
	cury = *y;
	return(S_void);
}

static vector *clear()
{
	char *p = pic; int n = width * height;
	if(to_do) emit_picture();
	while(n--) *p++ = ' ';
	return(S_void);
}

static vector *flush()
{
	return(S_void);
}

static vector *hook(type,x,n,y,m)
long *type, *n, *m;
float *x, *y;
{
	UNUSED(type); UNUSED(x); UNUSED(n); UNUSED(y);
	emit_picture();
	*m = 0;			/* nothing returned */
	return(S_void);
}

static emit_picture()
{
	char *p = pic + (height-1) * width;
	int i;
	to_do = 0;	/* current picture has now been displayed */
	if(outfile!=stdout) fprintf(outfile,"\014");	/* form feed */
	for(i=height; i>0; i--){ /* display each line from top to bottom */
		emit_line(p);
		p -= width;
		}
	fflush(outfile);
}

/* chop off trailing blanks and print line */
static emit_line(p)
char *p;
{
	int i;
	for(i = width-1; i>=0; i--) if(*(p+i) != ' ') break;
	if(i>=0) fprintf(outfile,"%.*s\n", i+1, p);
	else putc('\n', outfile);
}

static drawline(x1,y1,x2,y2)
int x1,y1,x2,y2;
{
	char *p; int i, t, dx, dy, e;

	if(x1==x2){	/* vertical line (bottom to top) */
		p = pic + min(y1,y2)*width + x1;
		for(i=abs(y1-y2)+1; i>0; i--, p += width)
			if(*p==' ') *p = '.';
	}
	else if(y1==y2){	/* horizontal line (left to right) */
		p = pic +y1*width + min(x1,x2);
		for(i=abs(x1-x2)+1; i>0; i--, p++)
			if(*p==' ') *p = '.';
	}
	else {	/* Bresenham's Algorithm, Newman & Sproull, 2nd ed, P 26 */
		if(x1>x2) {	/* make sure x2 >= x1 */
			t = x1; x1 = x2; x2 = t;
			t = y1; y1 = y2; y2 = t;
			}	
		p = pic + y1*width + x1;
		dy = y2 - y1;
		dx = x2 - x1;
		if(dy>=0 && dx>=dy){	/* x drives, dy +tive */
			e = 2*dy - dx;
			for(i=1; i<=dx; i++){
				if(*p==' ') *p = '.';
				if(e>0){ p += width; e += 2*dy - 2*dx; }
				else e += 2*dy;
				p += 1;
			}
		}
		else if(dy<0 && dx>= -dy){	/* x drives, dy -tive */
			e = 2*dy + dx;
			for(i=1; i<=dx; i++){
				if(*p==' ') *p = '.';
				if(e<0){ p -= width; e += 2*dy + 2*dx; }
				else e += 2*dy;
				p += 1;
			}
		}
		else if(dy>=0 && dy>dx){	/* y drives, dx +tive */
			e = 2*dx - dy;
			for(i=1; i<=dy; i++){
				if(*p==' ') *p = '.';
				if(e>0){ p += 1; e += 2*dx - 2*dy; }
				else e += 2*dx;
				p += width;
			}

		}
		else {				/* y -tive, dx +tive */
			e = 2*dx + dy;
			for(i=1; i<= -dy; i++){
				if(*p==' ') *p = '.';
				if(e>0){ p += 1; e += 2*dx + 2*dy; }
				else e += 2*dx;
				p -= width;
			}
		}
	}
}
