#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "S.h"
#include "device.h"

#define NLOCAL	3
#define ask ((long *)(cur_device->local_params))[0]
#define oldltype ((long *)(cur_device->local_params))[1]
#define oldsize ((float *)(cur_device->local_params))[2]
#define am(i)	(F77_COM(bgrp)[i-1])
#define Ltype	((int)am(8))
#define Csize	(am(18))
#define notNew	(am(121))

extern float F77_COM(bgrp)[];
vector *tek4014();
static void makeascii(), optout(), xyout();
vector *F77_SUB(bpntsz)(), *F77_SUB(blinsz)(), *F77_SUB(bpolyz)();
vector *F77_SUB(btextz)(), *F77_SUB(bsegsz)(), *F77_SUB(brdpnz)();

static vector *wrap(), *flush(), *signalled(),
	*clear(), *seek(), *point(), *line(), *getxy();

static device d_tek4014 = {
	FALSE,
	0,
	(float *) NULL,
	NLOCAL,
	(char *) NULL,
	{			/* <R> required <O> optional */
	tek4014,			/* initialize <R> */
	wrap,			/* wrap up <R> */
	flush,			/* flush <R> */
	signalled,		/* caught signal <R> */
	F77_SUB(bpntsz),	/* points <R> (bpntsz) */
	F77_SUB(blinsz),	/* lines <R> (blinsz) */
	F77_SUB(bpolyz),	/* polygon <R> (bpolyz) */
	F77_SUB(btextz),	/* text <R> (btextz) */
	F77_SUB(bsegsz),	/* segments <R> (bsegsz) */
	clear,			/* clear <R> */
	F77_SUB(brdpnz),	/* graphic input <R> (brdpnz) */
	NULL,			/* menu <O> */
	NULL,			/* hook <O> */
	seek,			/* seek <O> (low level) */
	point,			/* point <O> (low level) */
	line,			/* line <O> (low level) */
	NULL,			/* length of string <O> */
	getxy,			/* input <O> (low level) */
	}
};

FILE	*outfile;

vector *tek4014(a_ask,a_file)
long *a_ask;
char **a_file;
{
	device *d, *new_device();
	int i;
	d = new_device(&d_tek4014, 0L);	/* initialize device structure */
	set_device(d->which);
	for (i = 1; i <= 39; i++) am(i) = 0.0;
	am(20) = 34.;		/* char size in rasters */
	am(21) = 53.;
	am(22) = 0.0;
	am(23) = 4095.;
	am(24) = 0.0;
	am(25) = 3071.;
	am(26) = 1./6.;		/* char addressing offset */
	am(27) = 7./36.;
	am(28) = 0.0035;		/* raster size in inches */
	am(29) = am(28);
	am(30) = TEK4014;
	am(31) = 0;		/* allow char rotation */
	am(1) = 2.;		/* allow char size change */
	ask = *a_ask;
	oldltype = -1;
	oldsize = -1;
	if (**a_file) {		/* no interaction allowed */
		outfile = fopen (*a_file, "a");
		if (outfile == NULL)
			PROBLEM "Cannot open file" RECOVER(S_void);
		ask = 0;
	}
	else outfile = stdout;
	F77_SUB(defltz)();
	notNew = 1;	/* force erase on first real plotting */
	return(S_void);
}
static vector *wrap()
{
	if(ask) clear();
	return(S_void);
}

static vector *signalled()
{
	flush();
	return(S_void);
}

static vector *line(x, y)
long *x, *y;
{
	makeascii((int)*x,(int)*y);
	optout();	/* send out optimized binary */
	return(S_void);
}

static vector *point(ich, crot)
F_CHARTYPE ich;
float *crot;
{
	static float sizes[] = { 1.65, 1.5, 1., .9 }, curdiff;
	int i, j;
	UNUSED(crot);
	if(Csize != oldsize) {
		oldsize = Csize;
		curdiff = fabs( sizes[0] - oldsize );
		j = 0;
		for(i=1; i<4; i++)
			if(fabs(sizes[i] - oldsize) < curdiff) {
				j = i;
				curdiff = fabs(sizes[i] - oldsize);
			}
		fprintf(outfile,"\033%c", '8'+j);
	}
	fprintf(outfile,"\037%c",*F_CHARP(ich));
	return (S_void);
}

static vector *seek(x, y)
long *x, *y;
{
	int j;
	if (oldltype != Ltype) {
		oldltype = Ltype;
		j = ((int) oldltype-1) % 5;
		fprintf(outfile,"\035\033%c", '\140'+j);
	}
	makeascii((int)*x,(int)*y);
	xyout();	/* send out binary coords */
	return(S_void);
}

static vector *clear()
{
	if(ask>0) {
		fprintf(outfile, "\035 v @\037GO? ");
		fflush(outfile);
		while(getc(stdin) != '\n');	/* ignore reply */
	}
	else if(ask<0){	/* make copy */
		fprintf(outfile, "\033\027");
		fflush(outfile);
		sleep(30);
		}
	fprintf(outfile,"\033\014");	/* clear graphics screen */
	fflush(outfile);
	sleep(2);
	return(S_void);
}

static vector *flush()
{
	/* positionat bottom left, alpha mode, reduce char size */
	if(outfile==stdout){	/* only if output to terminal */
		fprintf(outfile,"\035 v @\037\033:");
		oldsize = -1; oldltype = -1;
		}
	fflush(outfile);
	return(S_void);
}

static char out[6], old[5];

static void makeascii(x,y)
int x,y;
{
	out[0] = ((y>>7) & 037) + 040;	/* upper 5 bits of y */
	out[1] = (((y & 03) <<2) | (x & 03)) + 0140;	/* lower 2 of x and y */
	out[2] = ((y & 0177) >> 2) + 0140;	/* mid 5 of y */
	out[3] = ((x>>7) & 037) + 040;	/* upper 5 bits of x */
	out[4] = ((x & 0177) >> 2) + 0100;	/* mid 5 of x */
}

static void optout()
{
	if(old[0] != out[0]) fputc(out[0],outfile);
	if(old[1] != out[1]) fputc(out[1],outfile);
	if(old[1] != out[1] || old[2] != out[2] || old[3] != out[3])
		fputc(out[2],outfile);
	if(old[3] != out[3]) fputc(out[3],outfile);
	fputc(out[4],outfile);
	strncpy(old,out,5);
}

static void xyout()
{
	out[6] = 0;
	fputc('\035',outfile);
	fputs(out,outfile);
	strncpy(old,out,5);
}

static vector *getxy(x, y, flag)
long *x, *y, *flag;
{
	int i, (*istat)();
#ifdef Research
#include <sys/ttyio.h>
#include <signal.h>
	struct sgttyb iostr;
#endif
#ifdef Berkeley
#include <signal.h>
#include <sgtty.h>
	struct sgttyb iostr;
#endif
#ifdef ATT_UNIX
#include <sys/signal.h>
#include <sys/termio.h>
	struct termio iostr; char lflag, ovmin;
#endif
	int oflags;
	char buf[10], *fgets();
	if(outfile!=stdout){	/* no input if non-interactive */
		*flag = -1;
		return(S_void);
	}
	fprintf(stderr,"\007\033\032");	/* bell, esc, sub - turn on cursor */
	istat=signal(SIGINT,SIG_IGN);
	fflush(stderr);
#ifdef ATT_UNIX
	ioctl(0, TCGETA, &iostr);
	lflag = iostr.c_lflag; ovmin = iostr.c_cc[VMIN];
	iostr.c_lflag &= ~(ECHO |ICANON);
	iostr.c_cc[VMIN] = 1;  /* 1 char at a time */
	ioctl(0,TCSETAF, &iostr);
#else
	ioctl(0, TIOCGETP, &iostr);
	oflags = iostr.sg_flags;
	iostr.sg_flags &= ~ECHO;
	iostr.sg_flags |= CBREAK;
	ioctl(0, TIOCSETP, &iostr);
#endif
	fgets(buf,10,stdin);
#ifdef ATT_UNIX
	iostr.c_lflag = lflag; iostr.c_cc[VMIN] = ovmin;
	ioctl(0, TCSETA, &iostr);
#else
	iostr.sg_flags = oflags;
	ioctl(0, TIOCSETP, &iostr);
#endif
	for(i=0; i<10; i++) if(buf[i]=='\n' || buf[i]=='\0') break;
	if(i != 5){
		*flag = -1;
		if(i==0) fgets(buf,10,stdin); /* one extraneous line generated when user gives CR */
		}
	else {
		*flag = (unsigned) buf[0];
		*x = ((buf[1] & 037)*32 + (buf[2] & 037))*4;
		*y = ((buf[3] & 037)*32 + (buf[4] & 037))*4;
		}
	signal(SIGINT,istat);
	return(S_void);
}
