#include <stdio.h>
#include <math.h>
#include <signal.h>
#include <setjmp.h>
#include "S.h"
#include "eval.h"
#include "y.tab.h"
#include "infix.h"
#include "options.h"
#include "sys_codes.h"

vector *do_op(), *do_math(), *do_summary(), *S_na_funs(), *fnd_data();
void cx_im(), cx_mod(), cx_arg(), cx_conj(), cx_mat_mul(), tabulate();
double asinh(), acosh(), atanh();

static vector *do_infix(), *do_unary(), *drop_levels(), *mycopy(), *mystrcopy();
static vector *demote_str(), *attr_union();
static int catchfpe(), screwup(), na_fill(), all_int(), tsok(), dimeq(), has_na();
static Casin(), Cacos(), Catan(), Cipower(), Cpower();
static long okmod();
static int na_flag;
static jmp_buf fpe_buf;

static int
catchfpe() {
	longjmp(fpe_buf,1);
}

static double signif(), i_pow();
static complex I = {0,1};

/* the following defines should probably go away and be replaced
 * by a run-time computation
 */
#define EXP_LIMIT 80
#define TRIG_LIMIT 1.e6

#define min(x1,x2)	((x1) < (x2) ? (x1) : (x2))
#define max(x1,x2)	((x1) > (x2) ? (x1) : (x2))
#define abs(x)		((x) < 0 ? -(x) : (x))

/* internal functions for use in the actual computations */
#ifdef __STDC__
#define loop(a,a1,a2,op) {\
	if(setjmp(fpe_buf)) { na_set(a); na_flag=TRUE; a++; a1++; a2++; }\
	signal(SIGFPE,catchfpe);\
	while(a < a##break){\
		if(a1 == a1##break)a1=a1##start;\
		if(a2 == a2##break)a2=a2##start;\
		if(is_na(a1) || is_na(a2)) na_set(a);\
		else *a = *a1 op *a2;\
		a++; a1++; a2++;\
		}\
	signal(SIGFPE,catchall);\
	}
#define floop(a,a1,a2,op) {\
	if(setjmp(fpe_buf)) { na_set(a); na_flag=TRUE; a++; a1++; a2++; }\
	signal(SIGFPE,catchfpe);\
	while(a < a##break){\
		if(a1 == a1##break)a1=a1##start;\
		if(a2 == a2##break)a2=a2##start;\
		if(is_na(a1) || is_na(a2)) na_set(a);\
		else op( a , a1 , a2 );\
		a++; a1++; a2++;\
		}\
	signal(SIGFPE,catchall);\
	}
#define cxloop(a,a1,a2,op) while(a < a##break){\
	if(a1 == a1##break)a1=a1##start;\
	if(a2==a2##break)a2=a2##start;\
	if(is_na(a1) || is_na(a2)) na_set(a);\
	else {\
		*a++ = cmpx_cmp( a1 , a2 ) op 0;\
	}\
	a1++; a2++;\
	}
#else
#define loop(a,a1,a2,op) {\
	if(setjmp(fpe_buf)) { na_set(a); na_flag=TRUE; a++; a1++; a2++; }\
	signal(SIGFPE,catchfpe);\
	while(a < a/**/break){\
		if(a1 == a1/**/break)a1=a1/**/start;\
		if(a2 == a2/**/break)a2=a2/**/start;\
		if(is_na(a1) || is_na(a2)) na_set(a);\
		else *a = *a1 op *a2;\
		a++; a1++; a2++;\
		}\
	signal(SIGFPE,catchall);\
	}
#define floop(a,a1,a2,op) {\
	if(setjmp(fpe_buf)) { na_set(a); na_flag=TRUE; a++; a1++; a2++; }\
	signal(SIGFPE,catchfpe);\
	while(a < a/**/break){\
		if(a1 == a1/**/break)a1=a1/**/start;\
		if(a2 == a2/**/break)a2=a2/**/start;\
		if(is_na(a1) || is_na(a2)) na_set(a);\
		else op( a , a1 , a2 );\
		a++; a1++; a2++;\
		}\
	signal(SIGFPE,catchall);\
	}
#define cxloop(a,a1,a2,op) while(a < a/**/break){\
	if(a1 == a1/**/break)a1=a1/**/start;\
	if(a2==a2/**/break)a2=a2/**/start;\
	if(is_na(a1) || is_na(a2)) na_set(a);\
	else {\
		*a++ = cmpx_cmp( a1 , a2 ) op 0;\
	}\
	a1++; a2++;\
	}
#endif
#define strloop(op) while(l <lbreak){\
	if(c1 == c1break)c1=c1start; if(c2==c2break)c2=c2start;\
	*l++ = strcmp(*c1++,*c2++) op 0; }
#define exprloop(op) Recover(encs1("comparisons with mode \"%s\" are undefined",token_name(m1)),NULL_ENTRY);
/*#define exprloop(op) while(l <lbreak){\
/*	if(e1 == e1break)e1=e1start; if(e2==e2break)e2=e2start;\
/*	*l++ = expr_cmp(e1++,e2++) op 0; }
*/
#define Machine(op)\
	case INT:  loop(l,l1,l2,op) break;\
	case REAL: loop(r,r1,r2,op) break;\
	case DOUBLE: loop(d,d1,d2,op) break;
#define Compare(op)\
	case INT: case LGL: loop(l,l1,l2,op) break;\
	case REAL: loop(l,r1,r2,op) break;\
	case DOUBLE: loop(l,d1,d2,op) break;

/* complex arithmetic */
#define Cadd(a,a1,a2) {\
	(a)->re = (a1)->re + (a2)->re; (a)->im = (a1)->im + (a2)->im;}
#define Csubtract(a,a1,a2) {\
	(a)->re = (a1)->re - (a2)->re; (a)->im = (a1)->im - (a2)->im;}
#define Cmultiply(a,a1,a2) {\
	complex Ctemp;\
	Ctemp.re = (a1)->re * (a2)->re - (a1)->im * (a2)->im;\
	Ctemp.im = (a1)->im * (a2)->re + (a1)->re * (a2)->im;\
	*(a) = Ctemp;}
#define Cinverse(a,a1) {\
	complex Ctemp;\
	Ctemp.re = (a1)->re ?\
			(1/((a1)->re + (a1)->im * ((a1)->im/(a1)->re))) :\
			0.0;\
	Ctemp.im = (a1)->im ?\
			(-1/((a1)->im + (a1)->re * ((a1)->re/(a1)->im))) :\
			0.0;\
	*(a) = Ctemp;}
#define Cdivide(a,a1,a2) {\
	complex Ctemp;\
	Ctemp.re = ((a2))->re ? ((a1)->re + (a1)->im * (((a2))->im/((a2))->re)) /\
			    ((a2)->re + (a2)->im * ((a2)->im/(a2)->re))\
			  : (a1)->im / (a2)->im;\
	Ctemp.im = (a2)->im ? (-(a1)->re + (a1)->im * ((a2)->re/(a2)->im)) /\
			    ((a2)->im + (a2)->re * ((a2)->re/(a2)->im))\
			  : (a1)->im / (a2)->re;\
	*(a) = Ctemp;}
#define Cequal(a,a1,a2) {\
	*(a) = ((a1)->re == (a2)->re) && ((a1)->im == (a2)->im); }
#define Cnotequal(a,a1,a2) {\
	*(a) = ((a1)->re != (a2)->re) || ((a1)->im != (a2)->im); }
#define Carg(a) (((a)->re==0&&(a)->im==0) ? 0 : atan2(0+(a)->im,(a)->re))
#define Cmod(a) hypot((a)->re, (a)->im)

#define ipwr(r,r1,i2)	*r = i_pow(*r1,*i2)
#define idpwr(d,d1,i2)	*d = i_pow(*d1,*i2)
#define rpwr(r,r1,r2)	if(*r1<0.)na_set(r); else if(*r2==0.)*r=1.; else *r = pow(*r1,*r2)
#define dpwr(r,r1,r2)	if(*r1<0.)na_set(r); else if(*r2==0.)*r=1.; else *r = pow(*r1,*r2)
#define imod(l,l1,l2)	*l = *l2 ? okmod(*l1, *l2) : *l1
#define dmod(d,d1,d2)	*d = *d2 ? *d1 - floor(*d1 / *d2) * *d2 : *d1
#define iidiv(l,l1,l2)	*l = *l2 ? (*l1 - okmod(*l1, *l2)) / *l2 : 0
#define didiv(d,d1,d2)	*d = *d2 ? floor(*d1 / *d2) : 0
#define round(x,p)	nonpositive ? floor(x/p+.5)*p : floor(x*p+.5)/p

#define New_na(p) (na_flag=TRUE, na_set(p))

vector *
do_op(ent,arglist)
vector *ent, *arglist;
{
	vector *value;
	if(sys_index<0 || sys_index> MAX_OP_CODE)
		Recover(enci1("internal error: bad code for operator (%ld)",
		  (long)sys_index),NULL_ENTRY);
	na_flag = FALSE;
	value = ent->length <= 2 ? do_unary(ent,arglist) : do_infix(ent,arglist);
	if(na_flag)
		Warning("NAs generated", ent);
	return(value);
}

static vector *
do_infix(ent, arglist)
vector *ent, *arglist;
{
	vector **children = arglist->value.tree, *result;
	vector  *data1, *data2, *data, *expr1, *expr2;
	int which = sys_index;
	int arith = IS_ARITHMETIC(which), tstype, m1, m2, m, used1;
	long n1, n2, n, offset1, offset2;
	double start, end, freq;
	long *l, *l1, *l2;
	float *r, *r1, *r2;
	double *d, *d1, *d2;
	complex *C, *C1, *C2;
	long *lbreak, *l1break, *l2break, *l1start, *l2start;
	float *rbreak, *r1break, *r2break, *r1start, *r2start;
	double *dbreak, *d1break, *d2break, *d1start, *d2start;
	complex *Cbreak, *C1break, *C2break, *C1start, *C2start;
	char **c1, **c2, **c1start, **c2start, **c1break, **c2break;
	int one_arg_is_zero_long;
	/*vector **e1, **e2, **e1start, **e2start, **e1break, **e2break;*/
if(check) {
	if(check_obj(children[0],NULL_STRING))
		Recover("Bad object in first operand",ent);
	if(check_obj(children[1],NULL_STRING))
		Recover("Bad object in second operand",ent);
}
	expr1 = drop_levels(children[0]);
	expr2 = drop_levels(children[1]);
	data1 = fnd_data(expr1);
	data2 = fnd_data(expr2);
	if(VOID(data1))
		Recover("Missing first operand", ent);
	if(VOID(data2))
		Recover("Missing second operand", ent);
	if(data1->length < 1 && data2->length < 1)
		return(blt_in_NULL);
	one_arg_is_zero_long = data1->length < 1 || data2->length < 1;
	m1 = data1->mode;
	if(arith)
		if(m1 == CHAR || !atomic_type(m1))
			Recover("Non-numeric first operand", ent);
		else if(m1 == LGL)
			m1 = INT;
	m2 = data2->mode;
	if(arith)
		if(m2 == CHAR || !atomic_type(m2))
			Recover("Non-numeric second operand", ent);
		else if(m2 == LGL)
			m2 = INT;
	if(which == AND_OP || which == OR_OP)
		m = m1 = m2 = LGL;
	else {
		m = coerce_to(m1, m2);
		if(m == UNKNOWN)
			Recover("Invalid mode for operand", ent);
		switch(which) {
		case PWR_OP:
			if(m1 == INT && m2 == INT)
				m = m1 = DOUBLE;
			if(all_int(data2)) {
				which=IPWR_OP; m2 = INT;
				if(m1!=COMPLEX) m = m1 = DOUBLE;
			}
			else m2=m1=m;
			break;
		case DIV_OP:
			m1=m2=m= (m==INT?DOUBLE:m); break;
		case MOD_OP:
			if(m1 == COMPLEX || m2==COMPLEX)
				Recover("Modulo not defined for complex numbers", ent);
		default:
			m1=m2=m;
		}
	}
	if(data1->mode != m1)
		expr1=coeves(expr1,m1,FALSE,PRECIOUS(expr1),&data1);
	if(data2->mode != m2)
		expr2=coeves(expr2,m2,FALSE,PRECIOUS(expr2),&data2);
	if(!arith) m = which == CMP_OP ? INT : LGL; /* the output mode */
	n1=data1->length; n2=data2->length;
	if(n1 < 1) {
		n1 = data1->length = 1;
		switch(m1){
		case LGL:
		case INT: na_set(data1->value.Long); break;
		case REAL: na_set(data1->value.Float); break;
		case DOUBLE: na_set(data1->value.Double); break;
		case COMPLEX: na_set(data1->value.Complex); break;
		case CHAR: /* do nothing */ break;
		}
	}
	if(n2 < 1) {
		n2 = data2->length = 1;
		switch(m2){
		case LGL:
		case INT: na_set(data2->value.Long); break;
		case REAL: na_set(data2->value.Float); break;
		case DOUBLE: na_set(data2->value.Double); break;
		case COMPLEX: na_set(data2->value.Complex); break;
		case CHAR: /* do nothing */ break;
		}
	}
	n = max(n1,n2);
	offset1 = offset2 = tstype = 0; used1 = -1;
	switch( (expr1!=data1) + (expr2!=data2) ) { /* number of structures */
	case 0:
		result = data = (used1 = n1 > n2) ? mycopy(data1,m,PRECIOUS(expr1))
					: mycopy(data2,m,PRECIOUS(expr2));
		break;
	/* one structure -- result identical if not shorter than other arg */
	case 1: 	
		if( expr1!=data1 && n1>=n2)
			{used1 = TRUE; result = mystrcopy(expr1,data1,m,&data);}
		else if( expr2!=data2 && n2>=n1)
			{used1 = FALSE; result = mystrcopy(expr2,data2,m,&data);}
		else
			result = data = (used1 = n1 > n2) ? mycopy(data1,m,PRECIOUS(expr1))
						: mycopy(data2,m,PRECIOUS(expr2));
		break;
	/* special cases for 2 objects with attributes */
	case 2: {
		vector *c1, *c2;
		if ((c1=find_comp(expr1,".Dim"))
			&& (c2=find_comp(expr2,".Dim")) 
			&& !dimeq(c1,c2))
				Recover("Dimension attributes do not match",ent);
		result = NULL;
		if((c1=find_comp(expr1,".Tsp")) && (c2=find_comp(expr2,".Tsp"))){
			tstype = tsok(c1,c2,&start,&end,&freq,&offset1,&offset2);
			switch(tstype) {
			case 0:	Recover("Incompatible time series",ent);
			case 1:	/* first arg spans second */
				result = mystrcopy(expr2,data2,m,&data); break;
			case 2:	/* second arg spans first */
				result = mystrcopy(expr1,data1,m,&data); break;
			case 3:	/* need to recompute start, end, drop other attrs*/
				data = alcvec(m,(long)((end-start)*freq+1.01));
				result = alctss(data, start, end, freq); break;
			case 4: /* exactly equal, other attributes survive */
				break;
			}
		}
		if(result == NULL) {
			if(n1 == n2)
				result = attr_union(expr1, expr2, m, &data);
			else if(used1 = n1 > n2)
				result = mystrcopy(expr1, data1, m, &data);
			else
				result = mystrcopy(expr2, data2, m, &data);
		}
		n = data->length;
		}
		break;
#ifdef lint
	default:
		result = NULL;
#endif
	}
	if(one_arg_is_zero_long) { /* special cases for empty operands */
		if(n>0) na_fill(data);
		return(result);
	}
	if(n % min(n1,n2) != 0 && tstype==0)	
		Warning("Length of longer object is not a multiple of the length of the shorter object", ent);
#ifdef lint
	l1 = l1start = l1break = l2 = l2start = l2break = l = lbreak = 0;
	r1 = r1start = r1break = r2 = r2start = r2break = r = rbreak = 0;
	d1 = d1start = d1break = d2 = d2start = d2break = d = dbreak = 0;
	C1 = C1start = C1break = C2 = C2start = C2break = C = Cbreak = 0;
	c1 = c1start = c1break = c2 = c2start = c2break = 0;
	/*e1 = e1start = e1break = e2 = e2start = e2break = 0;*/
#else
	/* set the initial pointers */
	switch(m) {
	case LGL:
	case INT:
		l = data->value.Long; lbreak = l + n; break;
	case REAL:
		r = data->value.Float; rbreak = r + n; break;
	case DOUBLE:
		d = data->value.Double; dbreak = d + n; break;
	case COMPLEX:
		C = data->value.Complex; Cbreak = C + n; break;
	}
	switch(m1) {
	case LGL:
	case INT:
		l1start = l1 = data1->value.Long + offset1; l1break = l1start +n1; break;
	case REAL:
		r1start = r1 = data1->value.Float + offset1; r1break = r1start +n1; break;
	case DOUBLE:
		d1start = d1 = data1->value.Double + offset1; d1break = d1start +n1; break;
	case COMPLEX:
		C1start = C1 = data1->value.Complex + offset1; C1break = C1start +n1; break;
	case CHAR:
		c1start = c1 = data1->value.Char + offset1; c1break = c1start +n1; break;
	default:
		/*e1start = e1 = data1->value.tree + offset1; e1break = e1start + n1*/;
	}
	switch(m2) {
	case LGL:
	case INT:
		l2start = l2 = data2->value.Long + offset2; l2break = l2start +n2; break;
	case REAL:
		r2start = r2 = data2->value.Float + offset2; r2break = r2start +n2; break;
	case DOUBLE:
		d2start = d2 = data2->value.Double + offset2; d2break = d2start +n2; break;
	case COMPLEX:
		C2start = C2 = data2->value.Complex + offset2; C2break = C2start +n2; break;
	case CHAR:
		c2start = c2 = data2->value.Char + offset2; c2break = c2start +n2; break;
	default:
		/*e2start = e2 = data2->value.tree + offset2; e2break = e2start + n2*/;
	}
#endif
	switch(which) {
	case ADD_OP:
		switch(m) {
		Machine(+)
		case COMPLEX: floop(C,C1,C2,Cadd) break;
		default: screwup("add");
		}
		break;
	case SUB_OP:
		switch(m) {
		Machine(-)
		case COMPLEX: floop(C,C1,C2,Csubtract) break;
		default: screwup("subtract");
		}
		break;
	case MUL_OP:
		switch(m) {
		Machine(*)
		case COMPLEX: floop(C,C1,C2,Cmultiply) break;
		default: screwup("multiply");
		}
		break;
	case DIV_OP:
		switch(m) {
		Machine(/)
		case COMPLEX: floop(C,C1,C2,Cdivide) break;
		default: screwup("divide");
		}
		break;
	case MOD_OP:
		switch(m) {
		case INT: floop(l,l1,l2,imod) break;
		case REAL: floop(r,r1,r2,dmod) break;
		case DOUBLE: floop(d,d1,d2,dmod) break;
		default: screwup("mod");
		}
		break;
	case PWR_OP:
		switch(m) {
		case REAL: floop(r,r1,r2,rpwr) break;
		case DOUBLE: floop(d,d1,d2,dpwr) break;
		case COMPLEX: floop(C,C1,C2,Cpower) break;
		default: screwup("power");
		}
		break;
	case IPWR_OP:
		switch(m) {
		case REAL: floop(r,r1,l2,ipwr) break;
		case DOUBLE: floop(d,d1,l2,idpwr) break;
		case COMPLEX: floop(C,C1,l2,Cipower) break;
		default: screwup("integer power");
		}
		break;
	case IDIV_OP:
		switch(m) {
		case INT:floop(l,l1,l2,iidiv) break;
		case REAL:floop(r,r1,r2,didiv) break;
		case DOUBLE: floop(d,d1,d2,didiv) break;
		default: screwup("integer divide");
		}
		break;
	case CMP_OP:
		switch(m1) {
		Compare(-)
		case COMPLEX: cxloop(l,C1,C2,-);
		case CHAR: strloop(-) break;
		default: exprloop(-)
		}
		for(l = result->value.Long, n = result->length; n>0; l++,n--)
			if(*l > 0) *l = 1L;
			else if(*l < 0) *l = -1L;
		break;
	case LT_OP:
		switch(m1) {
		Compare(<)
		case COMPLEX: cxloop(l,C1,C2,<);
		case CHAR: strloop(<) break;
		default: exprloop(<)
		}
		break;
	case GT_OP: switch(m1) {
		Compare(>)
		case COMPLEX: cxloop(l,C1,C2,>);
		case CHAR: strloop(>) break;
		default: exprloop(>)
		}
		break;
	case LE_OP:
		switch(m1) {
		Compare(<=)
		case COMPLEX: cxloop(l,C1,C2,<=);
		case CHAR: strloop(<=) break;
		default: exprloop(<=)
		}
		break;
	case GE_OP:
		switch(m1) {
		Compare(>=)
		case COMPLEX: cxloop(l,C1,C2,>=);
		case CHAR: strloop(>=) break;
		default: exprloop(>=)
		}
		break;
	case EQ_OP:
		switch(m1) {
		Compare(==)
		case COMPLEX: floop(l,C1,C2,Cequal) break;
		case CHAR: strloop(==) break;
		default: exprloop(==)
		}
		break;
	case NE_OP:
		switch(m1) {
		Compare(!=)
		case COMPLEX: floop(l,C1,C2,Cnotequal) break;
		case CHAR: strloop(!=) break;
		default: exprloop(!=)
		}
		break;
	case OR_OP:
		while(l < lbreak){
			if(l1 == l1break) l1 = l1start;
			if(l2 == l2break) l2 = l2start;
			if(is_na(l1)){
				if(is_na(l2)) na_set(l);
				else if(*l2) *l = TRUE;
				else na_set(l);
			}
			else if(is_na(l2)){
				if(*l1) *l = TRUE;
				else na_set(l);
			}
			else *l = *l1 | *l2;
			l++; l1++; l2++;
		}
		break;
	case AND_OP:
		while(l < lbreak){
			if(l1 == l1break) l1 = l1start;
			if(l2 == l2break) l2 = l2start;
			if(is_na(l1)){
				if(is_na(l2)) na_set(l);
				else if(! *l2) *l = FALSE;
				else na_set(l);
			}
			else if(is_na(l2)){
				if(! *l1) *l = FALSE;
				else na_set(l);
			}
			else *l = *l1 & *l2;
			l++; l1++; l2++;
		}
		break;
	}
	/* try to free unused argument */
	switch(used1) {
	case 0: if(!PRECIOUS(expr1))try_to_free(expr1,TRUE); break;
	case 1: if(!PRECIOUS(expr2))try_to_free(expr2,TRUE); break;
	}
if(check) {
	if(check_obj(result,NULL_STRING))
		Recover("Bad object in result",ent);
}

	return(result);
}

/* either uses e for result or makes a copy */
static vector *
mycopy(e,m,precious)
vector *e;
int m, precious;
{
	int m1 = e->mode;
	vector *value;

	if(!atomic_type(m1)){
		value = alcvec(m,e->length);
		if(e->name!=NULL_STRING) value->name = c_s_cpy(e->name);
		return value;
	}
	if(m==DOUBLE && m1!=DOUBLE && m1!=COMPLEX){ /* cant just copy */
		value = alcvec(DOUBLE,e->length);
		if(e->name!=NULL_STRING) value->name = c_s_cpy(e->name);
		return value;
	}
	if(m == COMPLEX && m1 != COMPLEX){
		value = alcvec(COMPLEX,e->length);
		if(e->name!=NULL_STRING) value->name = c_s_cpy(e->name);
		return value;
	}

	e =precious ? copy_data(e, NULL_ENTRY) : e ;
	value = New_vector();
	value->nalloc = value->length = e->length;
	value->mode = m; value->name = e->name;
	switch(m) { /* set the value pointer from the original or the copy */
	case LGL:
	case INT:
		switch(m1) {
		case LGL:
		case INT:
			value->value.Long = e->value.Long; break;
		case REAL:
			value->value.Long = (long *)e->value.Float; break;
		case DOUBLE:
			value->value.Long = (long *)e->value.Double; break;
		case COMPLEX:
			value->value.Long = (long *)e->value.Complex; break;
		case CHAR:
			value->value.Long = (long *)e->value.Char; break;
		default: goto make_copy;
		}
		break;
	case REAL:
		switch(m1) {
		case LGL:
		case INT:
			value->value.Float = (float *)e->value.Long; break;
		case REAL:
			value->value.Float = e->value.Float; break;
		case DOUBLE:
			value->value.Float = (float *)e->value.Double; break;
		case COMPLEX:
			value->value.Float = (float *)e->value.Complex; break;
		default: goto make_copy;
		}
		break;
	case DOUBLE:
		switch(m1) {
		case DOUBLE:
			value->value.Double = e->value.Double; break;
		case COMPLEX:
			value->value.Double = (double *)e->value.Complex; break;
		default: goto make_copy;
		}
		break;
	case COMPLEX:
		switch(m1) {
		case COMPLEX:
			value->value.Complex = e->value.Complex; break;
		default: goto make_copy;
		}
		break;
	case CHAR:
		switch(m1) {
		case CHAR:
			value->value.Char = e->value.Char; break;
		default: goto make_copy;
		}
		break;
	default: 
make_copy:
		Recover(encs2("system error: operator with input mode \"%s\", output mode \"%s\"",token_name(m1),token_name(m)),NULL_ENTRY);
	}
	return(value);
}

static vector *
mystrcopy(e1,data1,m,pdata)
vector *e1, *data1, **pdata;
int m;
{
	long n=e1->length;
	int precious = PRECIOUS(e1);
	vector **children = e1->value.tree, *child;
	vector *value = alcvec(STRUCTURE, n), **values;

	values = value->value.tree;
	while(n--) {
		child = *children++;
		if(child == data1) *values++ = *pdata = mycopy(child,m,precious);
		else *values++ = precious?copy_data(child, NULL_ENTRY):child;
	}
	return(value);
}

static e_cmp_level = 0;
#define MAX_LEVEL 200
static void
restore_level()
{
	e_cmp_level = 0;
}

int 
expr_cmp(ep1, ep2)
vector **ep1, **ep2;
{	/* a stub, in case we want to define this later: see RCS v. 67 for an attempt*/
	vector *e1 = *ep1, *e2 = *ep2;
	Recover(encs2("comparisons between modes \"%s\" and \"%s\" are undefined",
		token_name(data_mode(e1)),token_name(data_mode(e2))),NULL_ENTRY);
}

/* union of attributes of e1 and e2 */
static vector *
attr_union(e1,e2,m,pdata)
vector *e1, *e2, **pdata;
int m;
{
	long n1=e1->length, n2=e2->length,n;
	int precious;
	vector **children, *child, *value, **values, **v;

	value = alcvec(STRUCTURE,n1+n2);	/* enough space for sentinel */
	for(n=value->length, values=value->value.tree; n>0; n--, values++)
		*values = S_void;
	values = value->value.tree;
	precious = PRECIOUS(e1);	/* copy attrs of e1 */
	for(children = e1->value.tree; n1--; values++, children++){
		if(name_eq((*children)->name,".Data"))
			*values = *pdata = mycopy(*children,m,precious);
		else *values = precious ? copy_data(*children, NULL_ENTRY): *children;
	}
	precious = PRECIOUS(e2);	/* copy non-matched attrs of e2 */
	for(children = e2->value.tree; n2--; ){
		child = *children++;
		for(v = value->value.tree; ; v++)
			if(*v == S_void || name_eq((*v)->name,child->name)) break;
		if(*v == S_void)
			*values++ = precious ? copy_data(child, NULL_ENTRY) : child;
	}
	value->length = values - value->value.tree;
	return(value);
}

static int 
tsok(ts1, ts2, start, end, freq, offset1, offset2)
vector *ts1, *ts2;
double *start, *end, *freq;
long *offset1, *offset2;
{
	double *tsp1 = ts1->value.Double, *tsp2 = ts2->value.Double;
	double start1 = *tsp1++, end1 = *tsp1++, freq1 = *tsp1;
	double start2 = *tsp2++, end2 = *tsp2++, freq2 = *tsp2;

	if(fabs(freq1-freq2) > .001)return(0);
	*start = max(start1,start2); *end = min(end1,end2); *freq = freq1;
	if(*start>*end)return(0);
	*offset1 = (*start-start1) * freq1 + .01;
	*offset2 = (*start-start2) * freq2 + .01;
	if(start1==start2 && end1==end2) return(4);
	else if(*start==start1 && *end==end1) return(2);
	else if(*start==start2 && *end==end2) return(1);
	else return(3);
}

static int 
dimeq(dim1, dim2)
vector *dim1, *dim2;
{
	long n1 = dim1->length, n2 = dim2->length, *d1, *d2;

	if(n1!=n2) return(FALSE);
	d1 = dim1->value.Long; d2 = dim2->value.Long;
	while(n1--) if(*d1++ != *d2++)return(FALSE);
	return(TRUE);
}

static vector *
demote_str(e)
vector *e;
{
	if(e->length != 1 || e->mode != STRUCTURE) return(e);
	e = e->value.tree[0];
	if(!name_eq(e->name,".Data"))
		Recover("Inconsistent component name; should be .Data",NULL_ENTRY);
	return(e);
}

static 
screwup(what)
char *what;
{
	Recover(encs1("Invalid mode in %s operation",what), NULL_ENTRY);
}

static 
na_fill(ent)
vector *ent;
{
	char **c;
	long n = ent->length;
	vector **v;
	long *lp; float *fp; double *dp; complex *cp;

	if(n<1)return;
	switch(ent->mode) {
	case LGL:
	case INT:
		lp = ent->value.Long;
		while(n--){na_set(lp); lp++;}
		break;
	case REAL:
		fp = ent->value.Float;
		while(n--){na_set(fp); fp++;}
		break;
	case DOUBLE:
		dp = ent->value.Double;
		while(n--){na_set(dp); dp++;}
		break;
	case CHAR:
		c = ent->value.Char;
		while(n--) *c++ = NA_STRING;
		break;
	case COMPLEX:
		cp = ent->value.Complex;
		while(n--){na_set(cp); cp++;}
		break;
	default:
		if(NOT_RECURSIVE(ent->mode))return;
		v = ent->value.tree;
		while(n--) *v++ = S_void;
	}
	return;
}

static vector *
do_unary(ent,arglist)
vector *ent, *arglist;
{
	vector *data, *e1 = arglist->value.tree[0];
	int m1;
	long *l, n;
	float *r;
	double *d;
	complex *c;
if(check) {
	if(check_obj(e1,NULL_STRING))
		Recover("Bad object in operand",ent);
}
	if(PRECIOUS(e1))
		e1 = copy_data(e1, NULL_ENTRY);
	e1 = coeves(e1, sys_index==NOT_OP?LGL:ANY, FALSE, FALSE, &data);
	switch(sys_index) {
	case ADD_OP:
		return(e1);
	case SUB_OP:
		m1=data->mode; n=data->length;
		switch(m1) {
		case LGL:
			data->mode = INT; /* just treat as INT */
		case INT:
			l=data->value.Long;
			while(n--) {
				if(!is_na(l)) *l = - *l;
				l++;
			}
			break;
		case REAL:
			r=data->value.Float;
			while(n--) {
				if(!is_na(r)) *r = - *r;
				r++;
			}
			break;
		case DOUBLE:
			d=data->value.Double;
			while(n--) {
				if(!is_na(d)) *d = - *d;
				d++;
			}
			break;
		case COMPLEX:
			c=data->value.Complex;
			while(n--) {
				if(!is_na(c)) { c->re = -c->re; c->im = -c->im; }
				c++;
			}
			break;
		default:
			Recover(encs1("Cannot do unary minus on data of mode %s", token_name(m1)),ent);
		}
		break;
	case NOT_OP:
		n=data->length; l=data->value.Long;
		while(n--){
			if(!is_na(l)) *l = (*l==0L)? 1L : 0L;
			l++;
		}
		break;
	default: Recover("System error: invalid unary operator",NULL_ENTRY);
	}
if(check) {
	if(check_obj(e1,NULL_STRING))
		Recover("Bad object in result",ent);
}
	return(e1);
}

vector *
fnd_data(ent)
vector *ent;
{
	long n;
	vector *child, **children;

	if(ent->mode != STRUCTURE)
		return(ent);
	n = ent->length;
	children = ent->value.tree;
	while(n--) {
		child = *children++;
if(check && PRECIOUS(ent) != PRECIOUS(child)) Warning("PRECIOUS mismatch", ent);
		if(name_eq(child->name, ".Data"))
			return(child);
	}
	return(blt_in_NULL);
}

static vector *
drop_levels(ent)
vector *ent;
{
	long i, n;
	vector **children;

	if(ent->mode != STRUCTURE)
		return(ent);
	n = ent->length;
	children = ent->value.tree;
	for(i = 0; i < n; i++)
		if(name_eq(children[i]->name, ".Label"))
			break;
	if(i >= n)
		return(ent);
	if(PRECIOUS(ent))
		ent = copy_data(ent, NULL_ENTRY);
	children = ent->value.tree;
	children[i] = children[n-1];
	ent->length--;
	return(demote_str(ent));
}

vector *
do_math(ent,arglist)
vector *ent, *arglist;
{
	vector *arg = arglist->value.tree[0], *extra, *data;
	int which = sys_index, neg, got_na, digits, nonpositive;
	long n, *ldata, lsum, l;
	float *fdata, *fdata2, fsum;
	double *ddata, power, *ddata2, x, log_of_10, re, im, dsum;
	complex *cdata, csum;
if(check){
	if(check_obj(arg,NULL_STRING))
		Recover("Bad object in first argument",ent);
}
	na_flag = got_na = FALSE;
#ifdef lint
	extra = arglist->value.tree[1];
	power = i_pow(1e1, l = long_value(extra, ent));
	nonpositive = l <= 0;
	digits = (int)long_value(arglist->value.tree[1], ent);
#else
	switch((int)arglist->length) {
	case 1:
		switch(which) {
		case S_ROUND:
			power = 1;
			nonpositive = 1;
			break;
		case S_ATAN:
			extra = S_void;
			break;
		case S_SIGNIF:
			digits = 6;
			break;
		}
		break;
	case 2:
		switch(which) {
		case S_ROUND:
			l = long_value(arglist->value.tree[1], ent);
			nonpositive = l <= 0;
			power = i_pow(1e1, abs(l));
			break;
		case S_ATAN:
			extra = arglist->value.tree[1];
			break;
		case S_SIGNIF:
			digits = (int)long_value(arglist->value.tree[1], ent);
			break;
		default:
			Recover("Only 1 argument allowed", ent);
		}
		break;
	default:
		Recover(enci1("%ld arguments not allowed", arglist->length), ent);
	}
#endif
	if(PRECIOUS(arg))
		arg = copy_data(arg, NULL_ENTRY); /* overwritten for sure */
	data = fnd_data(arg);
	n = data->length;
	if(n == 0)
		if(atomic_type(data->mode))
			return(arg);
		else
			Recover(encs1("Math functions not defined for (zero-length) data of mode \"%s\"", token_name(data->mode)),ent);
	switch(which) {
	case S_ABS:
	case S_ROUND:
	case S_TRUNC:
	case S_FLOOR:
	case S_CEILING:
	case S_CUMSUM:
	case S_SIGNIF:
		if(data->mode == LGL) {
			vector *tmp = coedata(data, INT, FALSE, FALSE);
			*data = *tmp; /* substitute into existing structure*/
		}
		break;
	default:
		if(data->mode == LGL || data->mode == INT) {
			vector *tmp = coedata(data, DOUBLE, FALSE, FALSE);
			*data = *tmp; /* substitute into existing structure*/
		}
	}
	if(VOID(data))
		return(S_void);
	switch(data->mode) {
	case INT:
		ldata = data->value.Long;
		switch(which) {
		case S_ABS: 
			while(n--) {
				if(!is_na(ldata) && *ldata < 0)
					*ldata = -(*ldata);
				ldata++;
			}
			break;
		case S_CUMSUM:
			lsum = 0;
			while(n--) {
				if(got_na || is_na(ldata)) {
					got_na = TRUE;
					New_na(ldata);
				}
				else
					*ldata = lsum += *ldata;
				ldata++;
			}
			break;
		case S_ROUND:
			while(n--) {
				if(!is_na(ldata)) {
					if(neg = *ldata<0) *ldata = -*ldata;
					*ldata = round(*ldata, power);
					if(neg) *ldata = -*ldata;
				}
				ldata++;
			}
			break;
		default:
			break; /* FLOOR, TRUNC, etc do nothing */
		}
		break;
	case REAL:
		fdata = data->value.Float;
		switch(which) {
		case S_ABS: 
			while(n--){
				if(!is_na(fdata) && *fdata<0)*fdata =  -(*fdata);
				fdata++;
			}
			break;
		case S_FLOOR: 
			while(n--){
				if(!is_na(fdata)) *fdata = floor((double)*fdata);
				fdata++;
			}
			break;
		case S_CEILING: 
			while(n--){
				if(!is_na(fdata)) *fdata = ceil((double)*fdata);
				fdata++;
			}
			break;
		case S_TRUNC:
			while(n--){
				if(!is_na(fdata)) *fdata = *fdata <0?
					-(floor(-(double)*fdata)):
					floor((double)*fdata);
				fdata++;
			}
			break;
		case S_ROUND:
			while(n--) {
				if(!is_na(fdata)) {
					if(neg = (*fdata<0))*fdata = -*fdata;
					*fdata = round(*fdata, power);
					if(neg) *fdata = -*fdata;
				}
				fdata++;
			}
			break;
		case S_LOG: 
			while(n--){
				if(is_na(fdata)){}
				else if( *fdata>0) *fdata = log( (double)*fdata );
				else  New_na(fdata);
				fdata++;
			}
			break;
		case S_LOG10: 
			while(n--){
				if(is_na(fdata)){}
				else if( *fdata>0) *fdata = log10( (double)*fdata );
				else  New_na(fdata);
				fdata++;
			}
			break;
		case S_EXP: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata < -EXP_LIMIT) *fdata = 0;
				else if(*fdata > EXP_LIMIT) New_na(fdata);
				else *fdata = exp((double)*fdata);
				fdata++;
			}
			break;
		case S_SIN: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata < -TRIG_LIMIT || *fdata > TRIG_LIMIT)
					New_na(fdata);
				else *fdata = sin( (double)*fdata );
				fdata++;
			}
			break;
		case S_COS: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata< - TRIG_LIMIT || *fdata > TRIG_LIMIT)
					New_na(fdata);
				else *fdata = cos( (double)*fdata );
				fdata++;
			}
			break;
		case S_TAN: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata< - TRIG_LIMIT || *fdata > TRIG_LIMIT)
					New_na(fdata);
				else *fdata = tan( (double)*fdata );
				fdata++;
			}
			break;
		case S_ASIN: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata< - 1 || *fdata > 1)
					New_na(fdata);
				else *fdata = asin( (double)*fdata );
				fdata++;
			}
			break;
		case S_ACOS: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata< - 1 || *fdata > 1)
					New_na(fdata);
				else *fdata = acos( (double)*fdata );
				fdata++;
			}
			break;
		case S_ATAN:
			if(VOID(extra))
				while(n--){
					if(!is_na(fdata)) *fdata = atan(*fdata);
					fdata++;
				}
			else {
				if(extra->length!=n)
					Recover("atan only defined for two args of equal length",ent);
				extra = coevec(extra,REAL,FALSE,PRECIOUS(extra));
				fdata2 = extra->value.Float;
				while(n--){
					if(!(is_na(fdata)||is_na(fdata2)))
					 *fdata = atan2(0+(double)*fdata,(double)*fdata2);
					else na_set(fdata);
					fdata++;fdata2++;
				}
			}
			break;
		case S_SINH: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata < -EXP_LIMIT || *fdata > EXP_LIMIT)
					New_na(fdata);
				else *fdata = sinh( (double)*fdata );
				fdata++;
			}
			break;
		case S_COSH: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata< - EXP_LIMIT || *fdata > EXP_LIMIT)
					New_na(fdata);
				else *fdata = cosh( (double)*fdata );
				fdata++;
			}
			break;
		case S_TANH: 
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata < -EXP_LIMIT) *fdata = -1;
				else if(*fdata > EXP_LIMIT) *fdata = 1;
				else *fdata = tanh( (double)*fdata );
				fdata++;
			}
			break;
		case S_ASINH:
			while(n--){
				if(is_na(fdata)){}
				else *fdata = asinh( (double)*fdata );
				fdata++;
			}
			break;
		case S_ACOSH:
			while(n--){
				if(is_na(fdata)){}
				else if(*fdata < 1.0) New_na(fdata);
				else *fdata = acosh( (double)*fdata );
				fdata++;
			}
			break;
		case S_ATANH:
			while(n--){
				if(is_na(fdata)){}
				else if(fabs((double)*fdata) >= 1.0) New_na(fdata);
				else *fdata = atanh( (double)*fdata );
				fdata++;
			}
			break;
		case S_CUMSUM:
			fsum = 0;
			while(n--){
				if(got_na || is_na(fdata)) { got_na = TRUE; New_na(fdata); }
				else *fdata = fsum += *fdata;
				fdata++;
			}
			break;
		case S_SIGNIF:
			while(n--) {
				if(is_na(fdata)) continue;
				*fdata = (float)signif(*fdata, digits);
				fdata++;
			}
			break;
		default:
			Recover(enci1("Invalid internal code for math function: %ld", (long)which), ent);
		}
		break;
	case DOUBLE:
		ddata = data->value.Double;
		switch(which) {
		case S_ABS: 
			while(n--){
				if(!is_na(ddata) && *ddata<0)*ddata =  -(*ddata);
				ddata++;
			}
			break;
		case S_FLOOR: 
			while(n--){
				if(!is_na(ddata)) *ddata = floor(*ddata);
				ddata++;
			}
			break;
		case S_CEILING: 
			while(n--){
				if(!is_na(ddata)) *ddata = ceil(*ddata);
				ddata++;
			}
			break;
		case S_TRUNC:
			while(n--){
				if(!is_na(ddata)) *ddata = *ddata <0?
					-(floor(-*ddata)):
					floor(*ddata);
				ddata++;
			}
			break;
		case S_ROUND:
			while(n--) {
				if(!is_na(ddata)) {
					if(neg = (*ddata<0))*ddata = -*ddata;
					*ddata = round(*ddata, power);
					if(neg) *ddata = -*ddata;
				}
				ddata++;
			}
			break;
		case S_LOG: 
			while(n--) {
				if(is_na(ddata)){}
				else if( *ddata>0) *ddata = log(*ddata);
				else New_na(ddata);
				ddata++;
			}
			break;
		case S_LOG10: 
			while(n--) {
				if(is_na(ddata)){}
				else if( *ddata>0) *ddata = log10(*ddata);
				else New_na(ddata);
				ddata++;
			}
			break;
		case S_EXP: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata < -EXP_LIMIT) *ddata = 0;
				else if(*ddata > EXP_LIMIT) New_na(ddata);
				else *ddata = exp(*ddata);
				ddata++;
			}
			break;
		case S_SIN: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata< - TRIG_LIMIT || *ddata > TRIG_LIMIT)
					New_na(ddata);
				else *ddata = sin(*ddata);
				ddata++;
			}
			break;
		case S_COS: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata< - TRIG_LIMIT || *ddata > TRIG_LIMIT)
					New_na(ddata);
				else *ddata = cos(*ddata);
				ddata++;
			}
			break;
		case S_TAN: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata< - TRIG_LIMIT || *ddata > TRIG_LIMIT)
					New_na(ddata);
				else *ddata = tan(*ddata);
				ddata++;
			}
			break;
		case S_ASIN: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata< - 1 || *ddata > 1)
					New_na(ddata);
				else *ddata = asin(*ddata);
				ddata++;
			}
			break;
		case S_ACOS: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata< - 1 || *ddata > 1)
					New_na(ddata);
				else *ddata = acos(*ddata);
				ddata++;
			}
			break;
		case S_ATAN:
			if(VOID(extra))
				while(n--){
					if(!is_na(ddata)) *ddata = atan(*ddata);
					ddata++;
				}
			else {
				if(extra->length!=n)
					Recover("atan only defined for two args of equal length",ent);
				extra = coevec(extra,DOUBLE,FALSE,PRECIOUS(extra));
				ddata2 = extra->value.Double;
				while(n--){
					if(!(is_na(ddata)||is_na(ddata2)))
					 *ddata = atan2(0+*ddata, *ddata2);
					else na_set(ddata);
					ddata++;ddata2++;
				}
			}
			break;
		case S_SINH: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata < -EXP_LIMIT || *ddata > EXP_LIMIT)
					New_na(ddata);
				else *ddata = sinh(*ddata);
				ddata++;
			}
			break;
		case S_COSH: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata < -EXP_LIMIT || *ddata > EXP_LIMIT)
					New_na(ddata);
				else *ddata = cosh(*ddata);
				ddata++;
			}
			break;
		case S_TANH: 
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata < -EXP_LIMIT) *ddata = -1;
				else if(*ddata > EXP_LIMIT) *ddata = 1;
				else *ddata = tanh(*ddata);
				ddata++;
			}
			break;
		case S_ASINH:
			while(n--){
				if(is_na(ddata)){}
				else *ddata = asinh(*ddata);
				ddata++;
			}
			break;
		case S_ACOSH:
			while(n--){
				if(is_na(ddata)){}
				else if(*ddata < 1.0) New_na(ddata);
				else *ddata = acosh(*ddata);
				ddata++;
			}
			break;
		case S_ATANH:
			while(n--){
				if(is_na(ddata)){}
				else if(fabs(*ddata) >= 1.0) New_na(ddata);
				else *ddata = atanh(*ddata);
				ddata++;
			}
			break;
		case S_CUMSUM:
			dsum = 0;
			while(n--){
				if(got_na || is_na(ddata)) { got_na = TRUE; New_na(ddata); }
				else *ddata = dsum += *ddata;
				ddata++;
			}
			break;
		case S_SIGNIF:
			while(n--) {
				if(is_na(ddata)) continue;
				*ddata = signif(*ddata, digits);
				ddata++;
			}
			break;
		default:
			Recover(enci1("Invalid internal code for math function: %ld", (long)which), ent);
		}
		break;
	case COMPLEX:
		cdata = data->value.Complex;
		switch(which) {
		case S_ABS: 
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				cdata->re = fabs(cdata->re);
				cdata->im = fabs(cdata->im);
				cdata++;
			}
			break;
		case S_FLOOR: 
			while(n--){
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				cdata->re = floor(cdata->re);
				cdata->im = floor(cdata->im);
				cdata++;
			}
			break;
		case S_CEILING: 
			while(n--){
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				cdata->re = ceil(cdata->re);
				cdata->im = ceil(cdata->im);
				cdata++;
			}
			break;
		case S_TRUNC:
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				cdata->re = cdata->re < 0 ? (-floor(-cdata->re))
					: floor(cdata->re);
				cdata->im = cdata->im < 0 ? (-floor(-cdata->im))
					: floor(cdata->im);
				cdata++;
			}
			break;
		case S_ROUND: 
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				neg = cdata->re < 0;
				cdata->re = floor(fabs(cdata->re) * power + .5) / power;
				if(neg) cdata->re = -cdata->re;
				neg = cdata->im < 0;
				cdata->im = floor(fabs(cdata->im) * power + .5) / power;
				if(neg) cdata->im = -cdata->im;
				cdata++;
			}
			break;
		case S_LOG: 
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(cdata->re == 0 && cdata->im == 0) {
					New_na(cdata); cdata++;
					continue;
				}
				x = Carg(cdata);
				cdata->re = log(Cmod(cdata));
				cdata->im = x;
				cdata++;
			}
			break;
		case S_LOG10:
			log_of_10 = log(10.0);
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(cdata->re == 0 && cdata->im == 0) {
					New_na(cdata); cdata++;
					continue;
				}
				x = Carg(cdata);
				cdata->re = log10(Cmod(cdata));
				cdata->im = x/log_of_10;
				cdata++;
			}
			break;
		case S_EXP: 
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(cdata->re > EXP_LIMIT ||
				  cdata->im < -TRIG_LIMIT ||
				  cdata->im > TRIG_LIMIT) {
					New_na(cdata); cdata++;
					continue;
				}
				x = cdata->re < -EXP_LIMIT ? 0 : exp(cdata->re);
				cdata->re = x * cos(cdata->im);
				cdata->im = x * sin(cdata->im);
				cdata++;
			}
			break;
		case S_SIN:
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(cdata->re < -TRIG_LIMIT ||
				   cdata->re > TRIG_LIMIT ||
				   cdata->im < -EXP_LIMIT ||
				   cdata->im > EXP_LIMIT) {
					New_na(cdata); cdata++;
					continue;
				}
				re = cdata->re; im = cdata->im;
				cdata->re = sin(re) * cosh(im);
				cdata->im = cos(re) * sinh(im);
				cdata++;
			}
			break;
		case S_COS: 
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(cdata->re < -TRIG_LIMIT ||
				   cdata->re > TRIG_LIMIT ||
				   cdata->im < -EXP_LIMIT ||
				   cdata->im > EXP_LIMIT) {
					New_na(cdata); cdata++;
					continue;
				}
				re = cdata->re; im = cdata->im;
				cdata->re = cos(re) * cosh(im);
				cdata->im = -sin(re) * sinh(im);
				cdata++;
			}
			break;
		case S_TAN: 
			while(n--) {
				double ttt;
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				re = 2*cdata->re; im = 2*cdata->im;
				if(re < -TRIG_LIMIT ||
				   re > TRIG_LIMIT ||
				   im < -EXP_LIMIT ||
				   im > EXP_LIMIT) {
					New_na(cdata); cdata++;
					continue;
				}
				ttt = cos(re) + cosh(im);
				if(ttt == 0) {
					New_na(cdata); cdata++;
					continue;
				}
				cdata->re = sin(re) / ttt;
				cdata->im = sinh(im) / ttt;
				cdata++;
			}
			break;
		case S_ASIN: 
			while(n--) {
				if(!is_na(cdata) && Casin(cdata))
					New_na(cdata);	
				cdata++;
			}
			break;
		case S_ACOS: 
			while(n--) {
				if(!is_na(cdata) && Cacos(cdata))
					New_na(cdata);	
				cdata++;
			}
			break;
		case S_ATAN:
			while(n--) {
				if(!is_na(cdata) && Catan(cdata))
					New_na(cdata);	
				cdata++;
			}
			break;
		case S_SINH:
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(cdata->im < -TRIG_LIMIT ||
				   cdata->im > TRIG_LIMIT ||
				   cdata->re < -EXP_LIMIT ||
				   cdata->re > EXP_LIMIT) {
					New_na(cdata); cdata++;
					continue;
				}
				re = cdata->re; im = cdata->im;
				cdata->re = sinh(re) * cos(im);
				cdata->im = cosh(re) * sin(im);
				cdata++;
			}
			break;
		case S_COSH: 
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(cdata->im < -TRIG_LIMIT ||
				   cdata->im > TRIG_LIMIT ||
				   cdata->re < -EXP_LIMIT ||
				   cdata->re > EXP_LIMIT) {
					New_na(cdata); cdata++;
					continue;
				}
				re = cdata->re; im = cdata->im;
				cdata->re = cosh(re) * cos(im);
				cdata->im = sinh(re) * sin(im);
				cdata++;
			}
			break;
		case S_TANH: 
			while(n--) {
				double ttt;
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				re = 2*cdata->re; im = 2*cdata->im;
		                if(im < -TRIG_LIMIT ||
		                   im > TRIG_LIMIT ||
		                   re < -EXP_LIMIT ||
		                   re > EXP_LIMIT) {
					New_na(cdata); cdata++;
		                        continue;
		                } 
				ttt = cosh(re) + cos(im);
				if(ttt == 0) {
					New_na(cdata); cdata++;
					continue;
				}
				cdata->re = sinh(re) / ttt;
				cdata->im = sin(im) / ttt;
				cdata++;
			}
			break;
		case S_ASINH:
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				Cmultiply(cdata, cdata, &I);
				if(Casin(cdata)) {
					New_na(cdata); cdata++;
					continue;
				}
				Cmultiply(cdata, cdata, &I);
				cdata->re = -cdata->re; cdata->im = -cdata->im;
				cdata++;
			}
			break;
		case S_ACOSH:
			while(n--) {
				int lower_half = cdata->im < 0;
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(Cacos(cdata)) {
					New_na(cdata); cdata++;
					continue;
				}
				Cmultiply(cdata, cdata, &I);
				if(lower_half) {
					cdata->re = -cdata->re;
					cdata->im = -cdata->im;
				}
				cdata++;
			}
			break;
		case S_ATANH:
			while(n--) {
				int pos_branch = cdata->im == 0 && cdata->re > 1;
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				if(cdata->im == 0 && fabs(cdata->re) == 1) {
					New_na(cdata); cdata++;
					continue;
				}
				Cmultiply(cdata, cdata, &I);
				if(Catan(cdata)) {
					New_na(cdata); cdata++;
					continue;
				}
				Cmultiply(cdata, cdata, &I);
				if(!pos_branch) {
					cdata->re = -cdata->re;
					cdata->im = -cdata->im;
				}
				cdata++;
			}
			break;
		case S_CUMSUM:
			csum.re = csum.im = 0.;
			while(n--){
				if(got_na || is_na(cdata)) {got_na = TRUE; New_na(cdata); }
				else { Cadd(&csum, &csum, cdata); *cdata = csum; }
				cdata++;
			}
			break;
		case S_SIGNIF:
			while(n--) {
				if(is_na(cdata)) {
					cdata++;
					continue;
				}
				cdata->re = signif(cdata->re, digits);
				cdata->im = signif(cdata->im, digits);
				cdata++;
			}
			break;
		default:
			Recover(enci1("Invalid internal code for math function: %ld", (long)which), ent);
		}
		break;
	case CHAR:
		Recover("Numerical function not defined on character data",ent);
	default:
		Recover(encs1("Numerical function not defined on data of mode \"%s\"",token_name(data->mode)),ent);
	}
	if(na_flag)Warning("NAs generated",ent);
if(check){
	if(check_obj(arg,NULL_STRING))
		Recover("Bad object in result",ent);
}
	return(arg);
}

vector *
do_summary(ent, arglist)
vector *ent, *arglist;
{
	vector **oargs = arglist->value.tree, **args, *arg, *value;
	int which = sys_index, first, mode, anyall = which==S_ANY || which==S_ALL;
	long nargs = arglist->length, n, i, j;
	long *ldata, *lout, *lout2;
	float *fdata, *fout, *fout2;
	double *ddata, *dout, *dout2;
	complex *cdata, *cout;

	/* determine mode of result */
	args = (vector **)S_alloc(nargs, sizeof(vector *));
	mode = anyall ? LGL : INT;
	for(i = j = 0; i < nargs; i++) {
if(check){
	if(check_obj(oargs[i],NULL_STRING))
		Recover(enci1("Bad object in argument %ld", i+1),ent);
}
		arg = fnd_data(oargs[i]);
		if(arg == NULL_ENTRY)
			Recover(enci1("Bad argument, number %ld", i+1), ent);
		if(arg->length <= 0)
			continue;
		args[j++] = arg;
		if(!anyall)
			mode = coerce_to(mode, arg->mode);
	}
	if(!atomic_type(mode))
		Recover(encs1("Numeric summary undefined for mode \"%s\"",
			token_name(mode)), ent);
	nargs = j;

	/* initialize result */
	value = alcvec(LGL, which == S_RANGE ? 2L : 1L);
	switch(which) {
	case S_SUM:
	case S_ANY:
		value->value.Long[0] = 0;
		break;
	case S_PROD:
	case S_ALL:
		value->value.Long[0] = 1;
		break;
	case S_RANGE:
		na_set(value->value.Long + 1);
		/* fall through ... */
	case S_MIN:
	case S_MAX:
		na_set(value->value.Long);
		if(mode == COMPLEX)
			Recover("not defined for complex data", ent);
		break;
	default:
		Recover("system error: bad code for summary", ent);
	}
	value = coedata(value, mode, FALSE, FALSE);
#ifdef lint
	lout = lout2 = 0;
	fout = fout2 = 0;
	dout = dout2 = 0;
	cout = 0;
#else
	switch(mode) {
	case LGL:
	case INT:
		lout = value->value.Long; lout2 = lout+1;
		break;
	case REAL:
		fout = value->value.Float; fout2 = fout+1;
		break;
	case DOUBLE:
		dout = value->value.Double; dout2 = dout+1;
		break;
	case COMPLEX:
		cout = value->value.Complex;
		break;
	}
#endif

	/* do the summary */
	first = 1;
	for(i = 0; i < nargs; i++, args++) {
		if(setjmp(fpe_buf)) {
			switch(value->mode) {
			case LGL:
			case INT: na_set(value->value.Long); break;
			case REAL: na_set(value->value.Float); break;
			case DOUBLE: na_set(value->value.Double); break;
			case COMPLEX: na_set(value->value.Complex); break;
			}
			break;
		}
		signal(SIGFPE, catchfpe);
		arg = *args;
		if(!anyall && has_na(arg)) {
			switch(value->mode) {
			case LGL:
			case INT: na_set(value->value.Long); break;
			case REAL: na_set(value->value.Float); break;
			case DOUBLE: na_set(value->value.Double); break;
			case COMPLEX: na_set(value->value.Complex); break;
			}
			break;
		}
		if(arg->mode != mode)
			arg = coedata(arg, mode, FALSE, PRECIOUS(arg));
		n = arg->length;
#ifdef lint
		ldata = 0; fdata = 0; ddata = 0; cdata = 0;
#else
		switch(arg->mode) {
		case LGL:
		case INT: ldata = arg->value.Long; break;
		case REAL: fdata = arg->value.Float; break;
		case DOUBLE: ddata = arg->value.Double; break;
		case COMPLEX: cdata = arg->value.Complex; break;
		}
#endif
		switch(which) {
		case S_MAX: 
			switch(arg->mode) {
			case LGL:
			case INT:
				if(first) *lout = *ldata;
				while(n--) {
					if(*ldata > *lout) *lout = *ldata;
					ldata++;
				}
				break;
			case REAL:
				if(first) *fout = *fdata;
				while(n--) {
					if(*fdata > *fout) *fout = *fdata;
					fdata++;
				}
				break;
			case DOUBLE:
				if(first) *dout = *ddata;
				while(n--) {
					if(*ddata > *dout) *dout = *ddata;
					ddata++;
				}
				break;
			}
			break;
		case S_MIN:
			switch(arg->mode) {
			case LGL:
			case INT:
				if(first) *lout = *ldata;
				while(n--) {
					if(*ldata < *lout) *lout = *ldata;
					ldata++;
				}
				break;
			case REAL:
				if(first) *fout = *fdata;
				while(n--) {
					if(*fdata < *fout) *fout = *fdata;
					fdata++;
				}
				break;
			case DOUBLE:
				if(first) *dout = *ddata;
				while(n--) {
					if(*ddata < *dout) *dout = *ddata;
					ddata++;
				}
				break;
			}
			break;
		case S_RANGE:
			switch(arg->mode) {
			case LGL:
			case INT:
				if(first) *lout = *lout2 = *ldata;
				while(n--) {
					if(*ldata < *lout) *lout = *ldata;
					if(*ldata > *lout2) *lout2 = *ldata;
					ldata++;
				}
				break;
			case REAL:
				if(first) *fout = *fout2 = *fdata;
				while(n--) {
					if(*fdata < *fout) *fout = *fdata;
					if(*fdata > *fout2) *fout2 = *fdata;
					fdata++;
				}
				break;
			case DOUBLE:
				if(first) *dout = *dout2 = *ddata;
				while(n--) {
					if(*ddata < *dout) *dout = *ddata;
					if(*ddata > *dout2) *dout2 = *ddata;
					ddata++;
				}
				break;
			}
			break;
		case S_SUM:
			switch(arg->mode) {
			case LGL:
			case INT:
				while(n--) *lout += *ldata++;
				break;
			case REAL:
				while(n--) *fout += *fdata++;
				break;
			case DOUBLE:
				while(n--) *dout += *ddata++;
				break;
			case COMPLEX:
				while(n--) {
					Cadd(cout, cout, cdata);
					cdata++;
				}
				break;
			}
			break;
		case S_PROD:
			switch(arg->mode) {
			case LGL:
			case INT:
				while(n--) *lout *= *ldata++;
				break;
			case REAL:
				while(n--) *fout *= *fdata++;
				break;
			case DOUBLE:
				while(n--) *dout *= *ddata++;
				break;
			case COMPLEX:
				while(n--) {
					Cmultiply(cout, cout, cdata);
					cdata++;
				}
				break;
			}
			break;
		case S_ANY:
			while(n--) {
				if(*ldata == 1)
					*lout = 1;
				else if(is_na(ldata) && *lout == 0)
					na_set(lout);
				ldata++;
			}
			break;
		case S_ALL:
			while(n--) {
				if(*ldata == 0)
					*lout = 0;
				else if(is_na(ldata) && *lout == 1)
					na_set(lout);
				ldata++;
			}
			break;
		}
		first = 0;
	}
	signal(SIGFPE, catchall);
if(check){
	if(check_obj(value,NULL_STRING))
		Recover("Bad object in result",ent);
}
	return(value);
}

vector *
S_na_funs(ent, arglist)
vector *ent, *arglist;
{
	vector *arg, *value, *temp, *data, **vptr;
	char **cptr;
	int missing, which = sys_index, dmode;
	long *lptr, *outptr, nn, i, n;
	float *fptr;
	double *dptr;
	complex *cxptr;
	if(arglist->length != 1)
		Recover("Only one argument in testing for NA's", ent);
	arg = *arglist->value.tree;
if(check){
	if(check_obj(arg,NULL_STRING))
		Recover("Bad object in argument",ent);
}
	switch(which) {
	case 0: /* .is.na() */
		if(PRECIOUS(arg))arg = copy_data(arg, NULL_ENTRY); /* will get overwritten for sure */
		data = fnd_data(arg);
		if(VOID(data))return(arg);
		n = data->length; dmode = data->mode;
		value = alcvec(LGL,n); /* wasteful of space */
		nn = n; outptr = value->value.Long;
		while(nn--) *outptr++ = TRUE;
		outptr = value->value.Long;
		break;
	case 1: /* na.list() */
		data = coevec(arg,ANY,FALSE,CHECK_IT);
		n = data->length; dmode = data->mode;
		value = alcvec(INT,0L);
		outptr = value->value.Long;
		break;
	default:
		Recover(enci1("unknown index (%ld) in S_na_funs", (long)which), ent);
#ifdef lint
		value = 0; data = 0; dmode = 0; n = 0; outptr = 0;
#endif
	}
#ifdef lint
	lptr = 0; fptr = 0; dptr = 0; cxptr = 0; cptr = 0; vptr = 0;
#else
	switch(dmode) {
	case LGL:
	case INT:
		lptr = data->value.Long;
		break;
	case REAL:
		fptr = data->value.Float;
		break;
	case DOUBLE:
		dptr = data->value.Double;
		break;
	case COMPLEX:
		cxptr = data->value.Complex;
		break;
	case CHAR:
		cptr = data->value.Char;
		break;
	default:
		vptr = data->value.tree;
		break;
	}
#endif
	nn=n; while(nn--) {
		switch(dmode) {
		case LGL:
		case INT:
			missing = is_na(lptr); lptr++;
			break;
		case REAL:
			missing = is_na(fptr); fptr++;
			break;
		case DOUBLE:
			missing = is_na(dptr); dptr++;
			break;
		case COMPLEX:
			missing = is_na(cxptr); cxptr++;
			break;
		case CHAR:
			missing = is_na(cptr); cptr++;
			break;
		default:
			temp = *vptr++;
			missing = VOID( temp);
			break;
		}
		switch(which) {
		case 0: 
			*outptr++ = missing;
			break;
		case 1:
			if(missing){
				i = n-nn;
				if(value->nalloc>value->length){
					*outptr++ = i;
					value->length++;
				}
				else {
					append_data(value,value->length+1,1L,(char*)&i);
					outptr = value->value.Long+value->length;
				}
			}
			break;
		}
	}
	if(which == 0) {
		value->name = ".Data";
		*data = *value;
		value = arg;
	}
if(check){
	if(check_obj(value,NULL_STRING))
		Recover("Bad object in result",ent);
}
	return(value);
}

/* Does v have any NAs? */
static int 
has_na(v)
vector *v;
{
	int m = v->mode;
	long n = v->length;
	long *lptr;
	float *fptr;
	double *dptr;
	complex *cxptr;
	char **cptr;
	vector **vptr, *temp;

#ifdef lint
	lptr = 0; fptr = 0; dptr = 0; cxptr = 0; cptr = 0; vptr = 0;
#else
	switch(m) {
	case LGL:
	case INT:
		lptr = v->value.Long;
		break;
	case REAL:
		fptr = v->value.Float;
		break;
	case DOUBLE:
		dptr = v->value.Double;
		break;
	case COMPLEX:
		cxptr = v->value.Complex;
		break;
	case CHAR:
		cptr = v->value.Char;
		break;
	default:
		vptr = v->value.tree;
		break;
	}
#endif
	while(n--)
		switch(m) {
		case LGL:
		case INT:
			if(is_na(lptr)) return(1);
			lptr++;
			break;
		case REAL:
			if(is_na(fptr)) return(1);
			fptr++;
			break;
		case DOUBLE:
			if(is_na(dptr)) return(1);
			dptr++;
			break;
		case COMPLEX:
			if(is_na(cxptr)) return(1);
			cxptr++;
			break;
		case CHAR:
			if(is_na(cptr)) return(1);
			cptr++;
			break;
		default:
			temp = *vptr++;
			if(VOID(temp)) return(1);
			break;
		}
	return(0);
}
	
/*
 * The mode to which the input modes should be coerced, for an operator
 * or concatenation.  This function knows what the NUMERIC modes are and
 * uses the knowledge to speed up coercion; all other code should use
 * this function rather than deciding itself.
 */

coerce_to(m1, m2)
int m1, m2;
{
	if(m1 == MISSING) m1 = NULL;
	if(m2 == MISSING) m2 = NULL;
	if(m1>m2) {int m=m2; m2=m1; m1=m;}
	if(m2==NAME) return(m1==NAME || atomic_type(m1) ? CHAR : PARSE);
	if(m1==NAME) return(PARSE);
	if(m1==m2) return(m1);
	if(atomic_type(m2))
		return(m1 == LIST ? LIST:
		  (m2==COMPLEX ? (m1==CHAR ? CHAR : COMPLEX) : m2));
	if(atomic_type(m1)) return(m2);
	if(m1==PARSE || m2==PARSE) return(PARSE);
	if(m1==GRAPHICS || m2==GRAPHICS) return(GRAPHICS);
	if(LANGUAGE_TYPE(m1) || LANGUAGE_TYPE(m2)) return(PARSE);
	return(LIST);
}

/* support routines for Re, Im, Mod, Arg, Conj; call through .C */
void

cx_re(z, n, re)
complex z[];
long *n;
double re[];
{
	while((*n)--) {
		if(is_na(z)) {na_set(re);re++;}
		else *re++ = z->re;
		z++;
	}
}

void

cx_im(z, n, im)
complex z[];
long *n;
double im[];
{
	while((*n)--) {
		if(is_na(z)) {na_set(im);im++;}
		else *im++ = z->im;
		z++;
	}
}

void

cx_mod(z, n, mod)
complex z[];
long *n;
double mod[];
{
	while((*n)--) {
		if(is_na(z)) {na_set(mod);mod++;}
		else *mod++ = hypot(z->re, z->im);
		z++;
	}
}

void

cx_arg(z, n, arg)
complex z[];
long *n;
double arg[];
{
	while((*n)--) {
		if(is_na(z)) {na_set(arg);arg++;}
		else *arg++ = Carg(z);
		z++;
	}
}

void

cx_conj(z, n)
complex z[];
long *n;
{
	while((*n)--) {
		if(!is_na(z))
			z->im = -z->im;
		z++;
	}
}

/* support for elementary functions */
static 
Casin(z)
complex *z;
{
	double re = z->re, im = z->im, x, y, alpha, beta;

	x = hypot(re+1, im); y = hypot(re-1, im);
	alpha = (x + y)/2; beta = (x - y)/2;
	if(beta > 1)
		return(1);
	z->re = asin(beta);
	z->im = log(alpha + sqrt(alpha*alpha-1));
	if(im < 0 || (im == 0 && re >= 1))
		z->im = -z->im;
	return(0);
}

static 
Cacos(z)
complex *z;
{
	double re = z->re, im = z->im, x, y, alpha, beta;

	x = hypot(re+1, im); y = hypot(re-1, im);
	alpha = (x + y)/2; beta = (x - y)/2;
	if(beta > 1)
		return(1);
	z->re = acos(beta);
	z->im = -log(alpha + sqrt(alpha*alpha-1));
	if(im < 0 || (im == 0 && re >= 1))
		z->im = -z->im;
	return(0);
}

static 
Catan(z)
complex *z;
{
	double re = z->re, im = z->im, mo = Cmod(z), x, y;

	x = hypot(re, im+1); y = hypot(re, im-1);
	if(x == 0 || y == 0)
		return(1);
	z->re = 1 - mo*mo; z->im = 2 * re;
	z->re = Carg(z) / 2;
	z->im = log(x/y) / 2;
	if(re == 0 && im > 0)
		z->im = -z->im;
	return(0);
}

static 
Cipower(a, b, n)
complex *a, *b;
long *n;
{
	long nn = *n;
	complex c;

#define SMALL_POWER 8
	if(abs(nn) > SMALL_POWER) {
		c.re = nn; c.im = 0;
		Cpower(a, b, &c);
	} else {
		int neg = nn < 0;
		if(neg) nn = -nn;
		c.re = 1; c.im = 0;
		while(nn--) Cmultiply(&c, b, &c);
		if(neg) Cinverse(&c, &c);
		*a = c;
	}
}

static 
Cpower(a, b, c)
complex *a, *b, *c;
{
	double mod = Cmod(b), arg = Carg(b), re = c->re, im = c->im;
	double r, theta;

	if(mod <= 0) {
		a->im = 0;
		if(re > 0) a->re = 0;
		else if(re == 0) a->re = 1;
		else New_na(a);
	} else {
		mod = log(mod);
		r = exp(re*mod - im*arg);
		theta = re*arg + im*mod;
		a->re = r * cos(theta);
		a->im = r * sin(theta);
	}
}

double

asinh(x)
double x;
{
	double a, t;
	double sum, s = 1.0, ct = 0.0, fact = 1.0, x2;

	if(x == 0.0)
		return(0.0);
	a = fabs(x);
	if(a > 0.25) {
		t = a * sqrt((1/x)*(1/x) + 1.0);
		return(log(a+t) * (x/a));
	}
	x2 = x*x;
	do {
		sum = s;
		ct += 2.0;
		fact = -fact * x2 * (ct - 1.0) / ct;
		s = sum + fact / (ct + 1.0);
	} while(s != sum);
	return(x * sum);
}

double

acosh(x)
double x;
{
	double t;

	if(x < 1.0) {
		/*errno = EDOM;*/
		return(0.0);
	}
	t = sqrt((1.0/x + 1.0) * (1.0 - 1.0/x));
	return(log(x) + log(t + 1.0));
}

double
atanh(x)
double x;
{
	double sum, s = 1.0, ct = 1.0, fact = 1.0, x2;

	if(fabs(x) >= 1.0) {
		/*errno = EDOM;*/
		return(0.0);
	}
	if(fabs(x) > 0.25)
		return(0.5 * log((x+1.0)/(1.0-x)));
	x2 = x*x;
	do {
		sum = s;
		fact *= x2;
		ct += 2.0;
		s = sum + fact/ct;
	} while(s != sum);
	return(x * sum);
}

/* "correct" modulo operator; b nonzero */
static long

okmod(a, b)
long a, b;
{
	int m;

	b = abs(b);
	m = abs(a) % b;
	if(m && a < 0)
		m = b - m;
	return(m);
}

/*
 * Test for a vector being of mode INT or DOUBLEs that are exact
 * representations of integers; used by exponentiation operator.
 */
static 
all_int(p)
vector *p;
{
	int i;
	double *dptr, x;

	switch(p->mode) {
	case INT:
		return(1);
	case DOUBLE:
		dptr = p->value.Double;
		for(i = 0; i < p->length; i++, dptr++) {
			if(is_na(dptr))
				continue;
			x = fabs(*dptr);
			if(x > INTEGER_MAX || x > floor(x))
				return(0);
		}
		return(1);
	default:
		return(0);
	}
}

static double

signif(x, n)
double x;
int n;
{
	char *ecvt(), *s;
	int decpt, sign;

	s = ecvt(x, n, &decpt, &sign);
	x = atof(s) * pow(1e1, (double)decpt-n);
	return(sign ? -x : x);
}

/* complex matrix multiplication -- z should be NA-filled */
void

cx_mat_mul(X, Y, Z, RX, CY, N)
complex *X, *Y, *Z;
long *RX, *CY, *N;
{
	complex **x, **y, **z;
	long rx = *RX, cx = *N, ry = *N, cy = *CY, rz = *RX, cz = *CY, n = *N;
	complex sum, *xx, *yy;
	long i, j, k;
	
	x = (complex **)S_alloc(cx, sizeof(complex *));
	for(i = 0; i < cx; i++, X += rx)
		x[i] = X;
	y = (complex **)S_alloc(cy, sizeof(complex *));
	for(i = 0; i < cy; i++, Y += ry)
		y[i] = Y;
	z = (complex **)S_alloc(cz, sizeof(complex *));
	for(i = 0; i < cz; i++, Z += rz)
		z[i] = Z;
		
	for(i = 0; i < rz; i++)
		for(j = 0; j < cz; j++) {
			sum.re = sum.im = 0;
			for(k = 0; k < n; k++) {
				xx = &x[k][i];
				yy = &y[j][k];
				if(is_na(xx) || is_na(yy))
					break;
				sum.re += xx->re*yy->re - xx->im*yy->im;
				sum.im += xx->re*yy->im + xx->im*yy->re;
			}
			if(k == n)
				z[j][i] = sum;
		}
}

void 
tabulate(table, bins, npos)
long *table, *bins, *npos;
{
	long n = *npos, *p = bins;

	while(n--)
		table[*p++]++;
}

static double 
i_pow(x, n)
double x;
long n;
{
	double y;

	if(n == 0) return(1);
	if(x == 0) return(0);
	if(n < 0) {n = -n; x = 1/x;}
	for(y = 1; n >= 1; n >>= 1, x *= x)
		if(n & 1)
			y *= x;
	return(y);
}

void
comp_init()
{
/* will eventually compute EXP_LIMIT, TRIG_LIMIT */
}
