/*
 	yacc grammar and actions for QPE
	see pars_util.c for functions used in the actions here
*/
%union {
	long long_val;
	float float_val;
	double double_val;
	char *char_val;
	struct s_vector *vector_val;
	}
/* NOTE: if NAME ceases to be the first token in this list, revise
/* FIRST_TOKEN in S.h */
%token <char_val> NAME
%token <char_val> STRING
%token <vector_val> LITERAL
%token <vector_val> COMPILED
%token <char_val> LPAR
%token <char_val> RPAR
%token <char_val> LBRACK
%token <char_val> RBRACK
%token <char_val> LBRACE
%token <char_val> RBRACE
%token <char_val> COMMA
%token <char_val> EQUAL
%token <char_val> NOT
%token <char_val> COLON
%token <char_val> ADDOP
%token <char_val> MULOP
%token <char_val> LIST_SEP
%token <char_val> UARROW
%token <char_val> UMINUS
%token <char_val> DOLLAR
%token <char_val> LOGOP
%token <char_val> ANDOR
%token <char_val> LARROW
%token <char_val> RARROW
%token <char_val> SPOP
%token <char_val> TBLANK
%token <char_val> REPEAT
%token <char_val> IF
%token <char_val> ELSE
%token <char_val> BREAK
%token <char_val> SEMI
%token <char_val> NEXT
%token <char_val> WHILE
%token <char_val> FOR
%token <char_val> IN
%token <char_val> REC_RETURN
%token <char_val> RETURN
%token <char_val> ARGUMENT
%token <char_val> SYSTEM
%token <char_val> END_OF_FILE
%token <char_val> PARSE
%token <char_val> SYS_FUN
%token <char_val> MISSING
%token <char_val> FUN_CALL
%token <char_val> FUN_DEF
%token <char_val> QUESTION
%token <char_val> UNBALANCED
%token <char_val> DOUBLE_LBRACK
%token <char_val> UNKNOWN
%token <char_val> DOUBLE_RBRACK
%token <char_val> QUIT
%token <char_val> CONTINUE
%token <vector_val> COMMENT_EXPR
%token <char_val> ENTRY_TYPE
%token <char_val> FLEX_CALL
%token <char_val> DBLEARROW
%token <char_val> GRAPHICS
%token <char_val> ARG_LVALUE
%token <char_val> INTERNAL
%token <char_val> S_FUN_CALL
%token <char_val> S_DATA
%token <vector_val> SIMILAR
%token <vector_val> COMMENT
%token <vector_val> LEFT_COMMENT
%token <vector_val> FRAME
%token <vector_val> LVALUE
/*  NOTE: if LVALUE ceases to be the last token, revise LAST_TOKEN in
/*	S.h	*/
/*	define precedence rules	*/
%nonassoc ELSE
%right REPEAT
%right LARROW
%right DBLEARROW
%left RARROW
%nonassoc SIMILAR
%left ANDOR
%left NOT
%left LOGOP
%left ADDOP
%left MULOP
%left SPOP
%left COLON
%left UMINUS
%right UARROW
%left DOUBLE_LBRACK
%left LBRACK
%left DOLLAR
%type <vector_val> stat1 stat expr exprlist function arglist lbrace lexlist
%type <vector_val> arg opexpr fundef semi comma rpar fname comments lseps
%type <vector_val> formals formal exprel
%%
%{
#include <stdio.h>
#include "S.h"
/* redefine the lexical analyser name */
#define yylex() S_lex()

char *temp; long m;
%}
stat1	:	stat
		{ $$ = S_ptree = $1; }
	|	comments stat
		{ $$ = S_ptree =  mk_comment($1,$2); }
	|	stat1 LEFT_COMMENT
		{ $$ = S_ptree =  mk_comment($1,$2); }
	|	lexlist
		{ $$= S_ptree = $1; }
	;
comments:	COMMENT
		{$$ = $1;}
	|	comments COMMENT
		{ append_el(*($1->value.tree),(long)NOARG,*($2->value.tree)); $$=$1;}
	;
stat	:	/* empty */
		{ $$ = New_vector(); $$->mode = NULL; }
	|	END_OF_FILE
		{ $$ = New_vector(); $$->mode = END_OF_FILE; }
	|	SYSTEM
		{ $$=alcchar($1); $$ = alcf(".System",$$); $$->x.frame = cons_frame; }
	|	expr
		{$$=$1; }
	;
expr	:	lbrace exprlist RBRACE
		{
		  if($1 && $2->length>0) {
			vector **el = $2->value.tree;
			*el = add_comment($1,*el);
		  }
		  $$=do_lbrace($2); }
	|	REPEAT expr
		{	$$ = alc1(REPEAT,$2); $$->x.frame = cons_frame; }
	|	WHILE LPAR expr rpar expr
		{ $$=alc2(WHILE,$3,$5); if($4)$$=add_comment($$,$4); $$->x.frame = cons_frame; }
	|	FOR LPAR NAME IN expr rpar expr
		{ $$=New_vector(); $$->name=$3; $$->mode = NULL;
		$$=alc3(FOR,$$,$5,$7); if($6)$$=add_comment($$,$6); $$->x.frame = cons_frame; }
	|	IF LPAR expr rpar expr
		{ $$=alc2(IF,$3,$5); if($4)$$=add_comment($$,$4); $$->x.frame = cons_frame; }
	|	IF LPAR expr rpar expr ELSE expr
		{ $$=alc3(IF,$3,$5,$7); if($4)$$=add_comment($$,$4); $$->x.frame = cons_frame; }
	|	BREAK
		{ $$=New_vector(); $$->mode = BREAK; }
	|	NEXT
		{ $$=New_vector(); $$->mode = NEXT; }
	|	QUIT
		{ $$=New_vector(); $$->mode = QUIT; }
	|	RETURN LPAR arglist rpar
		{ $$=do_return($3); if($4)$$=add_comment($$,$4); }
	|	expr ADDOP expr
		{ if($3->mode == COMPLEX && ($$ = cmpx_op($1,$2,$3)))
			$$->x.frame = cons_frame;
		  else goto EXOPEX;}
	|	expr LOGOP expr
		{goto EXOPEX;}
	|	expr MULOP expr
		{goto EXOPEX;}
	|	expr ANDOR expr
		{goto EXOPEX;}
	|	expr UARROW expr
		{goto EXOPEX;}
	|	expr SPOP expr
		{goto EXOPEX;}
	|	expr SIMILAR expr
		{goto EXOPEX;}
	|	expr LBRACK arglist RBRACK
		{  clean_list($3); $$=do_op_list("[",$1,$3); }
 	|	LPAR expr rpar
 		{	$$=alcf("(",$2); $$->mode = LPAR;
 			if($3)$$=add_comment($$,$3);
 		}
	|	expr COLON expr
		{ EXOPEX: $$=append_el(alcf($2,$1),(long)NOARG,$3); $$->x.frame = cons_frame; }
	|	expr RARROW expr
		{ $$=$1; $1=$3; $3=$$; goto ASSIGNACT; }
	|	expr LARROW expr
		{ ASSIGNACT: $$ = do_assign(LARROW,$1,$3); $$->x.frame = cons_frame;}
	|	expr DBLEARROW expr
		{ $$ = do_assign(DBLEARROW,$1,$3); $$->x.frame = cons_frame;}
	|	ADDOP expr	%prec UMINUS
		{$$=alcuny($1,$2); $$->x.frame = cons_frame; }
	|	NOT expr
		{ $$=alcuny($1,$2); $$->x.frame = cons_frame; }
	|	SIMILAR expr
		{ $$=alcuny($1,$2); $$->x.frame = cons_frame; }
	|	LITERAL
		{$$=$1; $$->x.frame = cons_frame;}
	|	STRING
		{ $$=alcchar($1); $$->x.frame = cons_frame; }
	|	NAME
		{ $$=alc_name($1); $$->x.frame = cons_frame; }
	|	QUESTION
		{ $$=New_vector(); $$->mode = QUESTION; $$->x.frame = cons_frame; }
	|	expr LPAR arglist rpar
		{ clean_list($3); $$=do_fcall($3,$1);
			if($4)$$=add_comment($$,$4); }
	|	expr DOLLAR fname
		{ 
		 $$ = alcvec(CHAR,1L); $$->value.Char[0] = $3->value.name;
		 $$ = alc3(FUN_CALL,alc_name("$"),$1, $$);
		 $$->x.frame = cons_frame; }
	|	expr DOUBLE_LBRACK arglist DOUBLE_RBRACK
		{  clean_list($3); $$=do_op_list("[[",$1,$3); }
	|	fundef
		{ $$=$1; }
	;
exprlist :	exprel
		{ $$=alc1(LBRACE,$1); $$->x.frame = cons_frame; }
	|	exprlist semi exprel
		{ 
		  if($2){vector **last = ($1->value.tree+$1->length-1);
			*last = add_comment(*last,$2);
		  }
		  $$ = $3->mode==MISSING ? $1 : append_el($1,(long)NOARG,$3);
		}
	;
exprel	:	opexpr
		{ $$ = $1; }
	|	ELSE expr
		{ $$=alc1(ELSE,$2); $$->x.frame = cons_frame; }
	;	
lseps	:	LIST_SEP
		{ $$ = NULL; }
	|	lseps LIST_SEP
		{ $$ = NULL; }
lexlist	:	expr lseps
		{ $$ = alcvec(PARSE,1L);
			$$->value.tree[0] = $1; }
	|	lseps expr lseps
		{ $$ = alcvec(PARSE,1L);
			$$->value.tree[0] = $2; }
	|	lexlist expr lseps
		{ append_el($1,(long)NOARG,$2); $$=$1;}
	|	lexlist END_OF_FILE
		{ $$ = $1; }
semi	:	SEMI
		{$$ = NULL; }
	|	semi SEMI
		{$$ = $1; }
	|	semi COMMENT
		{$$ = mk_comment($1,$2); }
	;
lbrace	:	LBRACE
		{$$ = NULL; }
	|	lbrace COMMENT
		{$$ = mk_comment($1,$2); }
	;
rpar	:	RPAR
		{$$ = NULL; }
	|	LEFT_COMMENT RPAR
		{ $$ = mk_comment(NULL_ENTRY,$1); }
	|	rpar COMMENT
		{$$ = mk_comment($1,$2); }
fname	:	NAME
		{$$ = alc_name($1); $$->x.frame = cons_frame; }
	|	STRING
		{$$ = alc_name($1); $$->x.frame = cons_frame; }
	;
arglist	:	arg
		{ $$=alcf(NULL_STRING,$1); $$->x.frame = cons_frame;  }
	|	arglist comma arg
		{ if($2)$3 = add_comment($2,$3); $$=append_el($1,(long)NOARG,$3); }
	;
comma	:	COMMA
		{$$ = NULL; }
	|	comma COMMENT
		{$$ = mk_comment($1,$2); }
	;
arg	:	/* empty */
		{$$=New_vector(); $$->mode = MISSING; }
	|	expr
		{$$=$1;}
	|	fname EQUAL opexpr
		{ $$=copy_data($3,cons_frame); $$->name = $1->value.name; }
	;
opexpr	:	/*empty*/
		{$$=New_vector(); $$->mode = MISSING; }
	|	expr
		{$$=$1;}
	;
function:	FUN_DEF
		{$$ = NULL; }
	|	LEFT_COMMENT FUN_DEF
		{ $$ = mk_comment(NULL_ENTRY,$1); }
	|	function COMMENT
		{$$ = mk_comment($1,$2); }

fundef	:	function LPAR formals rpar expr
		{if($1)$5=add_comment($1,$5);
		if($4)$5=add_comment($4,$5);
		$$=$3; $$->mode = FUN_DEF;
		append_el($$,(long)NOARG,$5); }
	;
formals	:	/* empty */
		{ $$ = alcvec(LIST,0L); }
	|	formal
		{ $$ = alcvec(LIST,1L); $$->value.tree[0] = $1; }
	|	formals COMMA formal
		{ $$ = append_el($1,(long)NOARG,$3); }
	;
formal	:	NAME
		{ $$ = New_vector(); $$->mode = MISSING; $$->name = $1; }
	|	NAME EQUAL expr
		{ $$ = $3; $$->name = $1; }
	;
%%
