/* internal versions of data structure primitives & of alc___ coe___ routines */

#include <stdio.h>
#include "S.h"
#include "eval.h"
#include "y.tab.h"
#include "options.h"
#include <math.h>

vector *New_vector(), *alcvec(), *alctss(), *alclist(), *enc_data();
vector *coevec(), *coedata(), *coestr(), *coeves();
vector *copy_data(), *rec_check();
char *encs1(), *encs2(), *enci1(), *enci2(), *encr1(), *encd1();
char *coe_name(), *c_s_cpy();
long min_length();
int Data_mode();
void S_sink(), gt(), set_stdout();

static vector *copy_lev(), *copy_structure();
static vector *copy_check;
static na_fail(); static char *ch_collapse();

#define alcstr(n) alcvec(STRUCTURE,n)

vector *
alcvec(mode, length)
int mode;
long length;
{
	vector *ent = New_vector(), **vv, *v0;
	char **cc;

	ent->mode = mode;
	ent->length = length;
	if(length>max_block)Recover(enci1("Trying to allocate a vector with too many elements (%ld)",length),NULL_ENTRY);
	if(length<0)Recover(enci1("Trying to allocate vector with %ld elements",length),NULL_ENTRY);
	if(length<=SHORT_LIST_LENGTH)length=SHORT_LIST_LENGTH;
	ent->nalloc = length;
	switch(mode) {
	case INT:
	case LGL:
		ent->value.Long = (long *)S_alloc(length,sizeof(long)); break;
	case REAL:
		ent->value.Float = (float *)S_alloc(length,sizeof(float)); break;
	case CHAR:
		cc = ent->value.Char = (char **)S_alloc(length,sizeof(char *));
		while(length--)*cc++ = ""; break;
	case DOUBLE:
		ent->value.Double = (double *)S_alloc(length,sizeof(double));
		break;
	case COMPLEX:
		ent->value.Complex = (complex *)S_alloc(length,sizeof(complex));
		break;
	default:
		if(NOT_RECURSIVE(mode)) {
			if(ent->length>0) Recover(encs1("Objects of mode %s can't have length >0",token_name(mode)),NULL_ENTRY);
			ent->length = ent->nalloc = 0;
			break;
		}
		vv = ent->value.tree = (vector **)S_alloc(length,sizeof(vector *));
		v0 = LANGUAGE_TYPE(mode) ? S_void : blt_in_NULL;
		while(length--) *vv++ = v0; break;
	}
	return(ent);
}

vector *
alctss(data,start,end,nper)
vector *data; double start, end, nper;
{
	vector *ent = alcstr(2L), **children = ent->value.tree, *child;
	long length = (end-start)*nper +1.5;
	double *tsp;
if(check) {
	sanity(data,"data argument to alctss");
	if(data->length<length)Recover("alctss: data vector too short",data);
}
	if(PRECIOUS(data))data=copy_data(data,NULL_ENTRY);
	child = *children++ = data;
	child->name = ".Data";
	child = *children = alcvec(DOUBLE,3L);
	child->name = ".Tsp";
	tsp = child->value.Double;
	*tsp++ = start; *tsp++ = end; *tsp = nper;
	return(ent);
}

vector *
alclist(ncomp)
long ncomp;
{
	vector *ent = New_vector();
	ent->mode = LIST; ent->length = ncomp;
	if(ncomp<SHORT_LIST_LENGTH)ncomp = SHORT_LIST_LENGTH;
	ent->value.tree = (vector **)S_alloc(ncomp,sizeof(vector *));
	ent->nalloc = ncomp;
	return(ent);
}

vector *
coevec(actual, dmode, do_check, precious)
vector *actual;
int dmode, do_check, precious;
{
	vector *ent;

if(check){
	sanity(actual, "Vector argument to coevec");
}
	if(precious == CHECK_IT)
		precious = PRECIOUS(actual);
	switch(actual->mode) {
	case STRUCTURE: 
		ent = find_comp(actual, ".Data");
		if(ent == NULL_ENTRY)
			Recover("Invalid structure: no data", actual);
		break;
	default:
		ent = actual;
		break;
	}
	return(ent != NULL_ENTRY ? coedata(ent, dmode, do_check, precious) : ent);
}

#define naaction(l) (do_check ? na_fail(mode, dmode) : (na_set(l)))

static 
na_fail(mode, dmode)
int mode, dmode;
{
	Recover(encs2("Invalid data for conversion from %s to %s",
		token_name(mode),token_name(dmode)), NULL_ENTRY);
}

/*
 * coerce the data to the desired mode: should act so as to alter the
 * contents of the vector pointed to by ent, if ent is not deemed precious
 */
vector *
coedata(ent, dmode, do_check, precious)
vector *ent;
int dmode, do_check, precious;
{
	int mode = ent->mode; /* not data_mode() */
	long n = ent->length, *l;
	float *f;
	double *d;
	char **ch, *old_val = NULL_STRING;
	complex *cx;
	long navals;
	vector *temp;

	if(dmode==ANY)dmode = mode;
	if(min_length(dmode) > ent->length)
		Recover(encs1("Invalid data of mode \"%s\" (too short)",
			token_name(ent->mode)), NULL_ENTRY);
	if(dmode == mode) return(ent);
	if(precious)
		ent = copy_data(ent, NULL_ENTRY);
	switch(mode) { /* special cases */
	case NAME:
	case SYSTEM:
		if(dmode == CHAR) {
			temp = alcvec(CHAR, 1L);
			*(temp->value.Char) = ent->value.name;
			ent->mode = CHAR;
			ent->value.Char = temp->value.Char;
			break;
		} else if(!NOT_RECURSIVE(dmode)) { /* a list-y containing ent */
			temp = alcvec(dmode, 1L);
			*temp->value.tree = ent;
			return(temp);
		} /* else, its a zero length of the requested mode ... */
	case NULL:
	case MISSING:
		temp = alcvec(dmode, 0L);
		ent->mode = dmode;
		ent->length = 0;
		ent->value.name = temp->value.name;
		ent->nalloc = temp->nalloc;
		return(ent);
	}
	mode=ent->mode;
	switch(dmode) {
	case ANY:
		break;
	case LGL:
		switch(mode) {
		case LGL:
			break;
		case INT:
			l=ent->value.Long;
			while(n--){if(!is_na(l)) *l = (*l) != 0; l++;}
			break;
		case REAL:
			f = ent->value.Float;
			l = (long *)f;
			while(n--){if(!is_na(f)) *l = *f != 0.; l++; f++;}
			break;
		case DOUBLE:
			d = ent->value.Double;
			l = (long *)d;
			while(n--){
				if(!is_na(d)) *l = *d != 0.; else na_set(l);
				l++; d++;}
			break;
		case COMPLEX:
			cx = ent->value.Complex;
			l = (long *)cx;
			while(n--){
				if(!is_na(cx)) *l = (cx->re != 0. || cx->im != 0.); else na_set(l);
				l++; cx++;}
			break;
		case CHAR:
			ch = ent->value.Char;
			l = (long *)ch;
			while(n--) *l++ = strlen(*ch++)>0;
			break;
		default: Recover(encs1("Cannot coerce mode %s to logical",
			  token_name(mode)),ent);
			return(S_void);
		}
		break;
	case INT:
		switch(mode) {
		case LGL:
		case INT:
			
			break;
		case REAL:
			f = ent->value.Float;
			l = (long *)f;
			while(n--) {if(!is_na(f))*l = *f; l++; f++;}
			ent->value.Long = (long *)ent->value.Float;
			break;
		case DOUBLE:
			d = ent->value.Double;
			l = (long *)d;
			while(n--) {
				if(!is_na(d)) *l = *d; else na_set(l);
				l++; d++;}
			ent->value.Long = (long *)ent->value.Double;
			break;
		case COMPLEX:
			cx = ent->value.Complex;
			l = (long *)cx;
			while(n--){
				if(!is_na(cx)) *l = cx->re; else na_set(l);
				l++; cx++;}
			break;
		case CHAR:
			ch = ent->value.Char; navals = 0;
			l = (long *)ch; /* assumes long not bigger than char* */
			while(n--) {  char *c;
				c = *ch++;
				if(sscanf(c,"%ld",l) <= 0){ naaction(l); navals++;}
				l++;
			}
			ent->value.Long = (long *)ent->value.Char;
			if(navals>0){
				Warning(enci1("%ld missing values generated coercing to integer",navals),NULL_ENTRY);
			}
			break;
		default: Recover(encs1("Cannot coerce mode %s to integer",
			  token_name(mode)),ent);
			return(S_void);
		}
		break;
	case REAL:
		switch(mode) {
		case LGL:
		case INT:
			l = ent->value.Long;
			f = (float *)l;
			while(n--) {if(!is_na(l))*f = *l; f++; l++;}
			ent->value.Float = (float *)ent->value.Long;
			break;
		case REAL:
			break;
		case DOUBLE:
			d = ent->value.Double;
			f = (float *)d;
			while(n--) {
				if(!is_na(d))*f = (float) *d; else na_set(f);
				f++; d++;}
			ent->value.Float = (float *)ent->value.Double;
			break;
		case COMPLEX:
			cx = ent->value.Complex;
			f = (float *)cx;
			while(n--){
				if(!is_na(cx)) *f = (float) cx->re; else na_set(f);
				f++; cx++;}
			break;
		case CHAR:
			ch = ent->value.Char; navals = 0;
			f = (float *)ch;
			while(n--) {  char *c;
				c = *ch++;
				if(sscanf(c,"%f",f) <= 0){ naaction(f);navals++;}
				f++;
			}
			if(navals>0){
				Warning(enci1("%ld missing values generated coercing to single",navals),NULL_ENTRY);
			}
			ent->value.Float = (float *)ent->value.Char;
			break;
		default: Recover(encs1("Cannot coerce mode %s to single",
			  token_name(mode)),ent);
			return(S_void);
		}
		break;
	case DOUBLE: {
		double *dval;
		if(mode == DOUBLE){  break;}
		dval = d = (double *)S_alloc(n,sizeof(double));
		switch(mode) {
		case LGL:
		case INT:
			l = ent->value.Long;
			if(n*sizeof(long) > scrap) old_val = (char *)l;
			while(n--) {if(!is_na(l))*d = *l; else na_set(d); d++; l++;}
			break;
		case REAL:
			f = ent->value.Float;
			if(n*sizeof(float) > scrap) old_val = (char *)f;
			while(n--) {if(!is_na(f))*d = *f; else na_set(d); d++; f++;}
			break;
		case COMPLEX:
			cx = ent->value.Complex;
			if(n*sizeof(complex) > scrap) old_val = (char *)cx;
			while(n--){if(!is_na(cx)) *d = cx->re; else na_set(d);
				d++; cx++;}
			break;
		case CHAR:
			ch = ent->value.Char; navals = 0;
			if(n*sizeof(char *) > scrap) old_val = (char *)ch;
			while(n--) {
				long *ll;
				ll = (long *)d;
				if(sscanf(*ch++,"%lf",d)<= 0){naaction(ll);navals++;}
				d++;
			}
			if(navals>0){
				Warning(enci1("%ld missing values generated coercing to double",navals),NULL_ENTRY);
			}
			break;
		default: Recover(encs1("Cannot coerce mode %s to double",
			  token_name(mode)),ent);
			  return(S_void);
		}
		ent->value.Double = dval;
		ent->nalloc = ent->length;
		}
		break;
	case COMPLEX: {
		complex *cxval;
		if(mode == COMPLEX){ break;}
		cxval = cx = (complex *)S_alloc(n,sizeof(complex));
		switch(mode) {
		case LGL:
		case INT:
			l = ent->value.Long;
			if(n*sizeof(long) > scrap) old_val = (char *)l;
			while(n--) {if(!is_na(l))cx->re = *l; else na_set(cx);
				cx++; l++;}
			break;
		case REAL:
			f = ent->value.Float;
			if(n*sizeof(float) > scrap) old_val = (char *)f;
			while(n--) {if(!is_na(f))cx->re = *f; else na_set(cx); cx++; f++;}
			break;
		case DOUBLE:
			d = ent->value.Double;
			if(n*sizeof(double) > scrap) old_val = (char *)d;
			while(n--){if(!is_na(d)) cx->re = *d; else na_set(cx);
			d++; cx++;}
			break;
		case CHAR:
			ch = ent->value.Char;
			navals = 0;
			if(n*sizeof(char *) > scrap) old_val = (char *)ch;
			while(n--) {
				char *s = *ch + strlen(*ch) - 1;
				while(*s == ' ' || *s == '\t')
					s--;
				switch(sscanf(*ch, "%lf%lf", &cx->re, &cx->im)) {
				case 1:
					if(*s == 'i') {
						cx->im = cx->re;
						cx->re = 0;
					} else
						cx->im = 0;
					break;
				case 2:
					if(*s == 'i')
						break;
				default:
					naaction(cx);
					navals++;
				}
				ch++; cx++;
			}
			if(navals > 0)
				Warning(enci1("%ld missing values generated coercing to character",navals),NULL_ENTRY);
			break;
		default: Recover(encs1("Cannot coerce mode %s to complex",
			  token_name(mode)),ent);
			  return(S_void);
		}
		ent->value.Complex = cxval;
		ent->nalloc = ent->length;
		}
		break;
	case CHAR:
		if(mode ==CHAR) break;
		if(!NOT_RECURSIVE(mode)) {
			vector **from, *p; char **to; long n;
			temp = alcvec(CHAR,ent->length);
			for(n=temp->length, from = ent->value.tree, to = temp->value.Char;
			  n>0; n--, from++, to++){
				p = deparse(*from,(FILE *)NULL);
				if(p->length==1) *to = p->value.Char[0];
				else *to = ch_collapse(p);
			}
			ent = temp;
			break;
		}
		temp = enc_data(ent);
		ent->value.Char = temp->value.Char;
		ent->length = temp->length; ent->nalloc = temp->nalloc;
		break;
	case NAME:
		switch(mode) {
		default:
			temp = enc_data(ent); /* then treat as character */
			break;
		case CHAR:
			temp = ent;
			break;
		}
		ent->length = 1;
		ent->value.name = temp->value.Char[0];
		break;
	default:
		if(min_length(dmode)>ent->length) /* ensure no disasters from short vectors*/
			Recover(encs1("Object's length too small to coerce to mode %s",
			  token_name(dmode)),ent);
		if(!NOT_RECURSIVE(dmode) && atomic_type(mode)) { /* list of the elements */
			vector *p, **pp, *val; long n,i;
			n = ent->length;
			val = alcvec(LIST,n);
			pp = val->value.tree; i = 0;
			for(;n>0;n--,pp++,i++) {
				*pp = p = alcvec(mode,1L);
				switch(mode) {
				case LGL: case INT:
				  p->value.Long[0] = ent->value.Long[i]; break;
				case REAL:
				  p->value.Float[0] = ent->value.Float[i]; break;
				case CHAR:
				  p->value.Char[0] = ent->value.Char[i]; break;
				case DOUBLE:
				  p->value.Double[0] = ent->value.Double[i]; break;
				case COMPLEX:
				  p->value.Complex[0] = ent->value.Complex[i]; break;
				}
			}
			ent->value.tree = val->value.tree;
		}
		else if(atomic_type(mode)){
			temp = New_vector(); *temp = *ent;
			ent->value.tree = (vector **)S_alloc(1L,sizeof(vector *));
			ent->value.tree[0] = temp; ent->length = 1;
		} /* else, just change the mode */
	}
	if(old_val)free_block(old_val);
	if(dmode!=ANY)ent->mode = dmode;
	return(ent);
}

long 
min_length(mode)
int mode;
{
	long lmin=0;
	switch(mode) {
	case FUN_CALL:
	case FUN_DEF:
	case REPEAT:
	case NAME:
		lmin = 1; break;
	case FOR:
	case FRAME:
		lmin = 3; break;
	case LARROW:
	case DBLEARROW:
	case LBRACK:
	case DOUBLE_LBRACK:
	case IF:
	case WHILE:
	case COMPILED:
	case RARROW:
	case ARGUMENT:
		lmin=2; break;
	}
	return(lmin);
}

vector *
coestr(ent)
vector *ent;
/* specialized, used for attribute assignment in eval.c and sys_funs.c */
{
	vector *x = New_vector();

	*x = *ent;
	*ent = *alcvec(STRUCTURE,1L);
	*(ent->value.tree)=x; ent->name = x->name;
	 x->name = ".Data";
	return(ent);
}

char *
coe_name(ent)
vector *ent;
{
	switch(ent->mode) {
	case NAME: return(ent->value.name);
	case CHAR: return( *ent->value.Char);
	case INT:
	case LGL: return( enci1("%ld",*(ent->value.Long)));
	case REAL: return(encr1("%g",*(ent->value.Float)));
	case DOUBLE: return( encd1("%lg",*(ent->value.Double)));
	default: ent = deparse(ent,(FILE *)NULL); return(*(ent->value.Char));
	}
}
			
char *encs1(format, string)
char *format, *string;
{
	char *value;
	value = S_alloc(strlen(format)+strlen(string)+1L/*generous*/,sizeof(char));
	sprintf(value,format,string);
	return(value);
}

char *encs2(format, string1, string2)
char *format, *string1, *string2;
{
	char *value;
	value = S_alloc(strlen(format)+strlen(string1)+strlen(string2)+1L/*generous*/,sizeof(char));
	sprintf(value,format,string1,string2);
	return(value);
}

char *enci2(format, i1, i2)
char *format; long i1,i2;
{
	char *value = S_alloc(strlen(format)+35L,sizeof(char));
	sprintf(value,format,i1,i2);
	return(value);
}


char *enci1(format, i1)
char *format; long i1;
{
	char *value = S_alloc(strlen(format)+20L,sizeof(char));
	sprintf(value,format,i1);
	return(value);
}

char *encr1(format, r1)
char *format; double r1;
{
	char *value = S_alloc(strlen(format)+20L,sizeof(char));
	sprintf(value,format,r1);
	return(value);
}

char *encd1(format, d1)
char *format; double  d1;
{
	char *value = S_alloc(strlen(format)+20L,sizeof(char));
	sprintf(value,format,d1);
	return(value);
}

vector *
enc_data(ent)
vector *ent;
{
	int mode = ent->mode;
	long n = ent->length;
	vector *new_ent;
	char **value; char *buf, *c;
	long *l; float *f; double *d; complex *cx;

	if(mode==CHAR)return(ent);
	new_ent = alcvec(CHAR,n>0?n:1L); value = new_ent->value.Char;
	switch(mode) {
	case INT:
		l = ent->value.Long;
		while(n--){
			if(is_na(l))buf = "NA";
			else {
				buf = S_alloc(Integer_length+1,sizeof(char));
				sprintf(buf,"%ld",*l);
			}
			*value++ = buf; l++;
		}
		break;
	case LGL:
		l = ent->value.Long;
		while(n--){
			if(is_na(l))buf = "NA";
			else buf  = (*l != 0)? "TRUE" : "FALSE";
			*value++ = buf; l++;
		}
		break;
	case REAL:
		f = ent->value.Float;
		while(n--){
			if(is_na(f))buf = "NA";
			else {
				buf = S_alloc(Single_length+9,sizeof(char));
				sprintf(buf,Single_format,(double)*f);
			}
			*value++ = buf; f++;
		}
		break;
	case DOUBLE:
		d = ent->value.Double;
		while(n--){
			if(is_na(d))buf = "NA";
			else {
				buf = S_alloc(Double_length+9,sizeof(char));
				sprintf(buf,Double_format,*d);
			}
			*value++ = buf; d++;
		}
		break;
	case COMPLEX:
		cx = ent->value.Complex;
		while(n--){
			if(is_na(cx))buf = "NA";
			else {
				buf = S_alloc(Complex_length+17,sizeof(char));
				if(cx->im>=0.)sprintf(buf,Complex_format,cx->re,'+',cx->im);
				else sprintf(buf,Complex_format,cx->re,'-',-cx->im);
			}
			*value++ = buf; cx++;
		}
		break;
	case NAME:
		c = ent->value.name;
		*value = c;
		break;
	default: new_ent = deparse(ent, (FILE *)NULL);
	}
	return(new_ent);
}

/* like coevec, but doesn't throw away structure information */
vector *
coeves(ent, dmode, do_check, precious, Dataptr)
vector *ent, **Dataptr;
int dmode, do_check, precious;
{
	vector *value, **children, *child=NULL_ENTRY;
	long n;

	*Dataptr = value = coevec(ent,dmode,do_check,precious);
	if(ent->mode == STRUCTURE && value!=NULL) {
		/* find the data vector; if changed, replace it */
		n = ent->length; children = ent->value.tree;
		while(n--){
			child = *children++;
			if(name_eq(child->name,".Data")){
				n = children - ent->value.tree;
				break;
			}
		}
		if(value != child) {
			if(precious)ent = copy_structure(ent, n);
			*(ent->value.tree+n-1) = value; value->name = ".Data";
		}
	}
	else ent=value;
	return(ent);
}

vector *
copy_data(ent, frame)
vector *ent, *frame;
{
if(check)copy_check = rec_check(NULL_ENTRY,NULL_ENTRY,REC_INIT);
	return(copy_lev(ent,1,frame));
}

static vector *
copy_lev(ent, lev, frame)
vector *ent, *frame;
int lev;
{
	vector *value, **from_child, **to_child, *temp;
	char **cfrom, **cto;
	long length, nalloc;
	int mode;

if(check)sanity(ent,"object given to copy_data");
	value = New_vector();
	value->x.frame = frame;
	mode = value->mode = ent->mode; 
	length = value->length= ent->length;
	nalloc = value->nalloc = ent->nalloc;
	if(ent->name && *(ent->name))value->name = c_s_cpy(ent->name); 
if(check) {
#define MAX_COPY 200
	if(lev>MAX_COPY)Recover(enci1("copy_data: only %ld recursive levels allowed", (long)MAX_COPY),NULL_ENTRY);
}
	switch(mode) {
	case LGL:
	case INT:
		value->value.Long = (long *)S_alloc(nalloc,sizeof(long));
		MEMCPY(value->value.Long, ent->value.Long, length);
		break;
	case REAL: 
		value->value.Float = (float *)S_alloc(nalloc,sizeof(float));
		MEMCPY(value->value.Float, ent->value.Float, length);
		break;
	case DOUBLE: 
		value->value.Double = (double *)S_alloc(nalloc,sizeof(double));
		MEMCPY(value->value.Double, ent->value.Double, length);
		break;
	case COMPLEX: 
		value->value.Complex = (complex *)S_alloc(nalloc,sizeof(complex));
		MEMCPY(value->value.Complex, ent->value.Complex, length);
		break;
	case CHAR: 
		value->value.Char = cto = (char **)S_alloc(nalloc,sizeof(char *));
		cfrom = ent->value.Char;
		while(length--) {
			if(*cfrom){
				*cto = S_alloc(strlen(*cfrom)+1L,sizeof(char));
				strcpy(*cto,*cfrom);
			}
			else *cto = "";
			cto++; cfrom++;
		}
		break;
	case NAME:
	case SYSTEM:
		value->value.name = c_s_cpy(ent->value.name);
		break;
	case SYS_FUN:
		*value = *ent; /* mustn't change */
		break;
	case S_DATA: /* convert to QPE, then copy */
		temp = S_to_QPE(*(ent->value.Long),0L);
		*value = *copy_lev(temp,lev,frame);
		value->status = ent->status;
		break;
	default: 
		MEANINGFUL(to_child);
		if(nalloc) to_child = value->value.tree = (vector **)S_alloc(nalloc,sizeof(vector *));
		if(length) {
if(check) {
	from_child = ent->value.tree;
	rec_check(copy_check,ent,REC_ADD);
	while(length--){
		if(rec_check(copy_check,*from_child++,REC_CHECK)!=NULL_ENTRY)
			Recover("recursive structure in copying data",NULL_ENTRY);
	}
	length = ent->length;
	rec_check(copy_check,ent,REC_DELETE);
}
			from_child = ent->value.tree;
			while(length--){
				*to_child = copy_lev(*from_child,lev+1,frame);
				to_child++; from_child++;
			}
		}
		break;
	}
	return(value);
}


char *
c_s_cpy(name)
char *name;
{
	char *copy;
	if(!name)return(NULL);
	copy = S_alloc(strlen(name)+1L,sizeof(char));
	strcpy(copy,name);
	return(copy);
}

void 
set_precious(ent, frame)
vector *ent, *frame;
{
	long n; vector **children;
	if(!PRECIOUS(ent) || !frame) ent->x.frame = frame;
	if(NOT_RECURSIVE(ent->mode))return;
	for(n = ent->length, children = ent->value.tree; n>0; n--, children++)
		set_precious(*children,frame);
}

/* invoked by inline function data_mode for non-atomic modes; see $I/str*.h */
int 
Data_mode(ent)
vector *ent;
{
	int mode = ent->mode;
	long length = ent->length;
	vector **children, *p;

	if(mode != STRUCTURE)
		return(mode);
	children = ent->value.tree;
	while(length--) {
		p = *children++;
		if(name_eq(p->name, ".Data"))
			return( p->mode);
	}
	Recover("Invalid object: no data attribute",ent);
#ifdef lint
	return(0);
#endif
}

long 
Data_length(ent)
vector *ent;
{
	int mode = ent->mode;
	long length = ent->length;
	vector **children, *p;

	if(mode != STRUCTURE)
		return(length);
	children = ent->value.tree;
	while(length--) {
		p = *children++;
		if(name_eq(p->name, ".Data"))
			return(p->length);
	}
	Recover("Invalid object: no data", ent);
#ifdef lint
	return(0L);
#endif
}

/* check for loops in copying, saving, deparsing */
vector *
rec_check(checklist, ent, action)
vector *checklist, *ent;
int action;
{
	long n;
	vector **pp;
if(check) {
	if(checklist!=NULL_ENTRY || action!=REC_INIT)
		sanity(checklist,"List of recursive vectors in rec_check");
}
	switch(action) {
	case REC_INIT: /* initialize */
		if(checklist==NULL_ENTRY)checklist=alclist(0L);
		checklist->length = 0;
		return(checklist);
	case REC_ADD: /* add to list */
		if(checklist->length<checklist->nalloc)
			*(checklist->value.tree+(checklist->length++)) = ent;
		else append_el(checklist,(long)NOARG,ent);
		return(checklist);
	case REC_DELETE:
		if(--(checklist->length)<0)checklist->length  = 0;
		return(checklist);
	}
	/*check */
	n =checklist->length; pp = checklist->value.tree;
	while(n--) if(*pp++ == ent)return(*(pp-1));
	return(NULL_ENTRY);
}

/* copy all but n-th element */
static vector *
copy_structure(ent, n)
vector *ent;
long n;
{
	long nel = ent->length, i = 1;
	vector *value, **from, **to;

	value = alcstr(nel); from = ent->value.tree; to = value->value.tree;
	while(nel--) {
		if(i++ != n) *to = copy_data( *from ,NULL_ENTRY);
		to++; from++;
	}
	return(value);
}

/* names are equal if ptrs equal, or if they point to same string of chars */
int 
name_eq(s1, s2)
register char *s1, *s2;
{
	if(s1==s2)return(1);
	if(!s1 || !s2)return(0);
	while (*s1 == *s2++)
		if (*s1++=='\0')
			return(1);
	return(0);
}

/*
 * Generalized transpose: x is a matrix of dimension d,
 * d is a vector of length k and pi is a permutation on 1..k;
 * the permuted array pi(x) satisfies:
 *	pi(x)[i] = x[pi(i)]
 * for any set of k sbscripts i for which pi(i) is a
 * legitimate set of subscripts for x.  s is the size in
 * bytes of one element of x.  This routine assumes Fortran
 * storage order for arrays.  To make it work with C storage,
 * change the two inner for loops to
 *	for(t = i, r = k-1; r >= 0; r--) {
 * and
 *	for(t = ind[0]; r = 1; r < k; r++) {
 */

void

gt(x, S, d, K, pi)
char *x;
long *S, d[], *K, pi[];
{
	char *y, *xx, *yy;
	long s = *S, k = *K, i, j, r, t, *ind, n;

	if(k < 2)
		return;
	for(n = 1, i = 0; i < k; i++)
		n *= d[i];
	yy = y = Malloc(n*s);
	ind = CALLOC(k, long);
	for(i = 0; i < n; i++) {
		for(t = i, r = 0; r < k; r++) {
			ind[pi[r]] = t % d[pi[r]];
			t /= d[pi[r]];
		}
		for(t = ind[k-1], r = k-2; r >= 0; r--) {
			t *= d[r];
			t += ind[r];
		}
		xx = &x[t*s];
		for(j = 0; j < s; j++)
			*yy++ = *xx++;
	}
/* code to permute the dimension vector
	for(r = 0; r < k; r++)
		ind[r] = d[pi[r]];
	for(r = 0; r < k; r++)
		pi[r] = ind[r];
*/
	yy = y;
	n *= s;
	for(i = 0; i < n; i++)
		*x++ = *y++;
	(void)free((char *)yy);
	(void)free((char *)ind);
}

int sinkpipe = 0;

void 
S_sink(file, pipe, append)
char **file;
long *pipe, *append;
{
	static FILE *sinkfile = NULL;
	FILE *f = NULL;

	if(**file) {
		f = *pipe ? popen(*file, "w") : fopen(*file, *append ? "a" : "w"); 
		if(f == NULL)
			Recover(encs1("Cannot use %s as sink", *file), NULL_ENTRY);
	}
	if(sinkfile != NULL)
		sinkpipe ? pclose(sinkfile) : fclose(sinkfile);
	set_stdout(sinkfile = f);
	sinkpipe = **file ? *pipe : 0;
}

extern long F77_COM(xinout)[2];
#define OUTFC F77_COM(xinout)[1]

void 
set_stdout(f)
FILE *f;
{
	static FILE realstdout;
	static int first = 1;
	static long realoutfc, outfc;

	if(first) {
		realstdout = *stdout;
		realoutfc = OUTFC;
		first = 0;
	}
	fflush(stdout);
	*stdout = f == NULL ? realstdout : *f;
	OUTFC = f == NULL ? realoutfc : fileno(f);
}
	
#ifdef ATT_UNIX
/* copy n bytes from s1 to s2 (overlap allowed) */
/* needed on sys V machines where bcopy non-existent */
/* and memcpy may not work if overlaps exist */ 
#undef memcpy
char *
sbcopy(s1,s2,n)
register char *s1,*s2; register int n;
{
	int d; char *memcpy(), *val;
	d = abs(s1 - s2);
	val = s2;
	if(d>n) memcpy(s2,s1,n);
	else if(s1<s2) {
		s1 += n-1;
		s2 += n-1;
		while (--n >= 0)
			*s2-- = *s1--;
	}
	else if(s2<s1) {
		while (--n >= 0)
			*s2++ = *s1++;
	}
	return(val);
}
#endif

static char *
ch_collapse(ent)
vector *ent;
{
	long n,len; char *value, *v, **p, *from;
	len = 1;
	for(n=0,p=ent->value.Char; n>0; n--, p++)
		len += strlen(*p)+1;
	value = v = S_alloc(len,1);
	for(n=0,p=ent->value.Char; n>0; n--, p++){
		for(from = *p; *from; from++, v++) *v = *from;
		if(n>1)*v++ = '\n';
	}
	return(value);
}

no_nas_allowed(ent)
vector *ent;
{
	long n = ent->length, *l;
	float *f;
	double *d;
	complex *cx;

	switch(ent->mode) {
	case LGL:
	case INT:
		for(l=ent->value.Long; n--; l++) if(is_na(l)) goto bad;
		break;
	case REAL:
		for(f=ent->value.Float; n--; f++) if(is_na(f)) goto bad;
		break;
	case DOUBLE:
		for(d=ent->value.Double; n--; d++) if(is_na(d)) goto bad;
		break;
	case COMPLEX:
		for(cx=ent->value.Complex; n--; cx++) if(is_na(cx)) goto bad;
		break;
	}
	return;
bad:	Recover("Missing values not allowed", S_void);
}

char *Integer_format, *Single_format, *Double_format, *Complex_format;
long  Integer_length,  Single_length,  Double_length,  Complex_length;

void
make_formats()
{
	double scale;
	scale = log10((double)DOUBLE_BASE);
	Double_length = (long)ceil(scale*(double)(DOUBLE_DIGITS));
	Double_format = S_calloc(10,1);
	sprintf(Double_format,"%%.%ldg",Double_length);

	Complex_length = 2*Double_length + 2;
	Complex_format = S_calloc(21,1);
	sprintf(Complex_format,"%s%%c%si",Double_format, Double_format);

	scale = log10((float)SINGLE_BASE);
	Single_length = (long)ceil(scale*(float)(SINGLE_DIGITS));
	Single_format = S_calloc(10,1);
	sprintf(Single_format,"%%.%ldg",Single_length);

	Integer_length = ceil(log10((double)INTEGER_MAX));
	Integer_format = "%ld";
}
