#include <ctype.h>
define(`DIE',1)
define(`WARN',2)
define(`SILENT',3)
int errflag = WARN;	/* default is warnings inserting NA or null string */
define(`MAXLINE',2000)

main( argc, argv)
int argc; char *argv[];
{
	char nambuf[100];
	FILE *in, *out, *des;
	char name[100], mode[20], c, tab; int start, length, i;
	 
	if (argc >=1 && *argv[1] == '-') {
		switch (*++argv[1]) {
		case 'f':	/* fatal */
			errflag=DIE; break;
		case 'w':	/* warning */
			errflag=WARN; break;
		case 's':	/* silent */
			errflag=SILENT; break;
		default:
			FATAL(Error handling flags are -f -w or -s)
			}
		argc--; argv++;
		}

	switch(argc) {
	case 2:
		sprintf(nambuf,"%s.des",argv[1]);
		if((des = fopen(nambuf,"r")) == NULL)FATAL(Cannot open file %s,nambuf)
		sprintf(nambuf,"%s.ext",argv[1]);
		if((out = fopen(nambuf,"w")) == NULL)FATAL(Cannot open file %s,nambuf)
		break;
	case 4:
		if((des = fopen(argv[2],"r")) == NULL)FATAL(Cannot open file %s,argv[2])
		if((out = fopen(argv[3],"w")) == NULL)FATAL(Cannot open file %s,argv[3])
		break;
	default:
		FATAL(Usage: extract file [desfile extractfile])
		}

	if((in=fopen(argv[1],"r")) == NULL) FATAL(Cannot open file %s,argv[1])

	tab = '\0';
	if((c=fgetc(des)) == '-') {
		if(fgetc(des)=='f'){
			tab=fgetc(des);
			if(tab=='\n') {tab=' '; ungetc('\n',des);}	/* default field separator is whitespace */
			}
		fgets(nambuf, 100, des); /*throw rest of line away */
		}
	else ungetc(c,des);

	while ( fgets(nambuf, 100, des) != NULL ) { /* process each field */
		i = sscanf(nambuf,"%s %s %d %d",name, mode, &start, &length);
		if((tab=='\0' && i!=4)|(tab!='\0' && i!=3))
			fprintf(stderr,"Field named %s incorrectly described, it had %d fields; ignored\n",name,i);
		else fldext(name, mode, start, length, in, out, tab);
		rewind(in); /* rewind for the next field */
		}
}

fldext( name, mode, start, length, in, out, tab)
char *name, *mode; int start, length;
FILE *in, *out; char tab;
{
	long lpos, nrec, current, fldout();
	char cmode;

	cmode=islower(*mode)?toupper(*mode):*mode;
	fprintf(out,"( \"%s\" %c ", name, cmode);
	lpos=ftell(out); /* where to put the no. of records later */
	fprintf(out,"%6ld\n",999999L);
	nrec=fldout(cmode, start, length, in, out, tab);
	fprintf(out,")\n");
	current=ftell(out);
	fseek(out,lpos,0);
	fprintf(out,"%6ld",nrec);
	fseek(out,current,0);
}

long fldout(mode, start, length, in, out, tab)
char mode, tab; int start, length;
FILE *in, *out;
{
	long rcd; int l, nf; char *field, line[MAXLINE], *endfield;
	float r; char c; int i;

	rcd=0; l=0;
	while ( fgets(line, MAXLINE, in) != NULL) {
		rcd++;
		if(tab=='\0'){	/* by position */
			if(start+length>strlen(line)){	/* falls off end */
				if(errflag!=SILENT) fprintf(stderr,"Record %ld is too short for field starting at position %d\n",rcd,start);
				if(errflag==DIE) F77_CALL(zzabt);
				field = line; *field = '\0';
				}
			else {	/* no problem with field */
				field=line+start-1;
				for(endfield=field+length-1; *endfield==' ' && endfield>field; endfield--) ;	/* trailing blanks */
				*(++endfield)='\0';
				while(*field==' ')field++;	/* leading blanks */
				}
			}
		else {	/* by fields */
			field=line;
			for(nf=1; nf<start; nf++){ /* skip start-1 fields to begin */
				if (tab == ' ') while (isspace(*field) == 0) field++;
				else while(*field!=tab && *field!='\n') field++;
				if(*field=='\n'){
					if(errflag!=SILENT) fprintf(stderr,"Field %d does not exist in record %ld\n",start,rcd);
					if(errflag==DIE) F77_CALL(zzabt);
					*field = '\0'; break;
					}
				if (tab == ' ') while(isspace(*field) != 0) field++;
				else field++;
				}
			if(*field){
				if(tab==' ')for(endfield=field;isspace(*endfield)==0;endfield++);
				else for(endfield=field;*endfield!=tab&&*endfield!='\n';endfield++);
				*endfield='\0';
				}
			}
		if(mode=='C'){	/* character with surrounding quotes */
			fprintf(out,"\"%s\"",field);
			l+=2;
			}
		else {	/* numeric */
			if(*field == 0 || endfield<=field) 
				{ fprintf(out,"`NA'"); l+=2; }	/* numeric empty field not allowed */
			else {	/* check valid number */
				*(endfield++)='~'; *endfield='\0';
				i = sscanf(field,"%f%c",&r,&c);
				*(--endfield)='\0';
				if(i==2 && c=='~') fprintf(out,"%s",field);
				else {
					if(errflag!=SILENT) fprintf(stderr,"Invalid numeric field '%s' in record %ld\n",field,rcd);
					if(errflag==DIE) F77_CALL(zzabt);
					fprintf(out,"`NA'"); l+=2;
					}
				}
			}
		l+= endfield-field;
		if( l > 80) { fputc('\n',out); l=0;}
		else {fputc(' ',out); l++;}
		}
	if(l>0)fputc('\n',out);
	return(rcd);
}
