#correlation or covariance
FUNCTION cor (
	x		/MATRIX/
	y		/MATRIX,OPTIONAL/
	trim		/REAL,1,0./
	)
STATIC( integer n,p,q,i,j; logical var,streq)
var = streq(TEXT(fname),TSTRING(var))
if(MISSING(y)){ P(y)=P(x); COERCE(y/MATRIX/) }# y points to x w/o copying
STRUCTURE( rho/MATRIX,NCOL(x),NCOL(y)/)
CHECK(NROW(x)==NROW(y),FATAL(lengths must be equal))
n=NROW(x); p=NCOL(x); q=NCOL(y)
if(trim>0.) {
	if(var) {
		if(p==1 & MISSING(y)) rho=trvaru(x,n,trim)
		else FATAL(no trimmed covariances)
		}
	else call cormts(x,n,p,y,q,trim,rho)
	}
else { #least-squares
	call corvar(x,n,p,y,q,var,rho)
	}
if(p==1 | q==1) COERCE(rho/VECTOR/) # remove matrix structure if trivial
RETURN(rho)
END
