FUNCTION hclust(
	dist	/STR,OPTIONAL/
	method	/CHAR,1,STRING(compact)/
	sim=	/STR,OPTIONAL/
	)
STATIC( external hcmmam,hcmmim,hcmavm; logical dmat )
if(MISSING(dist)&MISSING(sim)) FATAL(Must give distance or similarity matrix)
dmat=MISSING(sim)	# is it distance matrix?
if(!dmat) P(dist)=P(sim)
STRUCTURE( Size/INT, FROM(dist), 1/ )
if(MISSING(Size)){	# we got full matrix, not dist
	COERCE(dist/MATRIX,NAFATAL/)
	if(NROW(dist)!=NCOL(dist))
		FATAL(Distance or similarity matrix must be square)
	call tolowr(dist,NROW(dist),NCOL(dist),dist,FALSE)	# collapse it to lower triangle
	Size=NROW(dist)
	}
else COERCE(dist/REAL,NAFATAL/)
n=Size; n1=Size-1
STRUCTURE(
	merge	/INT,MATRIX,n1,2/
	height	/REAL,n1/
	order	/INT,n/
	wts	/REAL,n/
	iscr	/INT,n/
	xscr	/REAL,n-1/
	)
CTABLE(meths,average,connected,compact)
imeth=match(method,meths)
switch(imeth){
case 1: call hcp(dist,n,dmat,hcmavm,merge[1,1],merge[1,2],height,wts,xscr)
case 2: call hcp(dist,n,dmat,hcmmim,merge[1,1],merge[1,2],height,wts,xscr)
case 3: call hcp(dist,n,dmat,hcmmam,merge[1,1],merge[1,2],height,wts,xscr)
default:  FATAL(Invalid method)
	}
call tree(merge[1,1],merge[1,2],height,n,order,iscr)	#make canonical tree with node ordering
RETURN(merge,height,order)
END
