FUNCTION optinit (
	x/REAL/,
	f/REAL/,
	g/REAL/,
	radius/REAL/,
	xtol/REAL/,
	gtol/REAL/,
	maxev/INT/,
	      )

STATIC(integer n, k, nr, ni, i
       real gsq, dotv)
n = LENGTH(x)
k = max(n * (n-1) / 2, 1)
nr = 8 + 7*n + k + n**2
ni = 5
STRUCTURE(rmem/REAL,nr/, imem/INT,ni/)
STRUCTURE(xnew/REAL,n/, fnew/REAL,1/, gnew/REAL,n/)

gsq = dotv(g,n,g)
rmem[1] = f
rmem[2] = radius**2
rmem[3] = xtol**2
rmem[4] = gtol**2
rmem[5] = gsq
do i = 1, n {
	rmem[8+i] = x[i]
	rmem[8+n+i] = g[i]
}
call rfill(0.01*sqrt(gsq)/radius, rmem[9 + 6*n], n)
call rfill(0.0, rmem[9 + 7*n + n**2], k)

imem[1] = maxev
imem[2] = 1
imem[3] = 1
imem[4] = 0
imem[5] = 0

RETURN(xnew, fnew, gnew, rmem, imem)

END
