FUNCTION polygon(&)
STRUCTURE(x/REAL/,y/REAL/)
PLOTARGS(NAOK)
ARG(
	density	/REAL,1,-1./
	angle	/REAL,1,45./
	border	/LGL,1,TRUE/
	PAR
	)
STATIC( CHARACTER(itype,1) )

if(MISSING(density) & !MISSING(angle)) density = 5
n=LENGTH(x)
if(n!=LENGTH(y))FATAL(Lengths of x and y do not match)
if(n<3)FATAL(At least 3 points required to form polygon)

QUERY( xaxt(itype) ); if(itype=="l") call logtrn(x,n)
QUERY( yaxt(itype) ); if(itype=="l") call logtrn(y,n)

j=0
repeat{
	for(i=j+1;i<=n;i=i+1) if(!NA(x[i])&!NA(y[i])) break
	if(i>n) break
	for(j=i+1;j<=n;j=j+1) if( NA(x[j])| NA(y[j])) break
	if(j-i<3) next
	if(density<0.) call polyz(x[i],y[i],j-i)
	else if(density>0.) call hatch(x[i],y[i],j-i,1./density,angle)
	if(border){
		call linesz(x[i],y[i],j-i)
		call segmtz(x[j-1],y[j-1],x[i],y[i],1)
		}
	}
END
