subroutine query(which,outstr,nres)
CHARACTER(which,*)
POINTER outstr

INCLUDE(print,stack,struct,graphics)
logical streq, doinit
POINTER vp,p,getvec
integer i,j,s
CHARACTER(c,1)

# Each line of table gives parameter name, beginning location in am() array,
# number of parameters involved, and mode of result
# if am() is negative, its absolute value gives action number for query

define(`NPAR',55)
CHARACTER(string,6,NPAR)
integer start(NPAR),leng(NPAR),mode(NPAR)
SAVE(doinit,string)
data doinit/TRUE/
data (start(i),leng(i),mode(i),i=1,NPAR)/ _
	72,	2,	REAL,
	130,	1,	REAL,
	100,	1,	REAL,
	119,	1,	CHAR,
	-1,	1,	REAL,
	74,	2,	REAL,
	10,	1,	REAL,
	20,	2,	REAL,
	48,	1,	REAL,
	75,	1,	REAL,
	67,	2,	REAL,
	30,	1,	REAL,
	98,	2,	REAL,
	96,	1,	REAL,
	131,	1,	REAL,
	44,	4,	REAL,
	123,	2,	REAL,
	79,	1,	REAL,
	49,	1,	REAL,
	122,	1,	CHAR,
	57,	3,	REAL,
	115,	1,	REAL,
	8,	1,	REAL,
	9,	1,	REAL,
	50,	4,	REAL,
	-2,	4,	REAL,
	54,	1,	REAL,
	82,	2,	REAL,
	80,	4,	REAL,
	82,	2,	REAL,
	112,	3,	REAL,
	128,	1,	REAL,
	-6,	1,	LGL,
	-3,	4,	REAL,
	90,	4,	REAL,
	-4,	4,	REAL,
	120,	1,	LGL,
	-5,	1,	CHAR,
	55,	2,	REAL,
	40,	4,	REAL,
	97,	1,	CHAR,
	70,	2,	REAL,
	94,	1,	REAL,
	14,	1,	REAL,
	66,	1,	REAL,
	116,	3,	REAL,
	76,	2,	REAL,
	61,	4,	REAL,
	104,	3,	REAL,
	103,	1,	CHAR,
	102,	1,	CHAR,
	65,	1,	LGL,
	109,	3,	REAL,
	108,	1,	CHAR,
	107,	1,	CHAR/
if(doinit){
	doinit = FALSE
	string(01) = TSTRING(1em)
	string(02) = TSTRING(acc)
	string(03) = TSTRING(adj)
	string(04) = TSTRING(bty)
	string(05) = TSTRING(cex)
	string(06) = TSTRING(cin)
	string(07) = TSTRING(col)
	string(08) = TSTRING(cra)
	string(09) = TSTRING(crt)
	string(10) = TSTRING(csi)
	string(11) = TSTRING(cxy)
	string(12) = TSTRING(dev)
	string(13) = TSTRING(din)
	string(14) = TSTRING(err)
	string(15) = TSTRING(exp)
	string(16) = TSTRING(fig)
	string(17) = TSTRING(fin)
	string(18) = TSTRING(font)
	string(19) = TSTRING(frm)
	string(20) = TSTRING(fty)
	string(21) = TSTRING(lab)
	string(22) = TSTRING(las)
	string(23) = TSTRING(lty)
	string(24) = TSTRING(lwd)
	string(25) = TSTRING(mai)
	string(26) = TSTRING(mar)
	string(27) = TSTRING(mex)
	string(28) = TSTRING(mfcol)
	string(29) = TSTRING(mfg)
	string(30) = TSTRING(mfrow)
	string(31) = TSTRING(mgp)
	string(32) = TSTRING(mkh)
	string(33) = TSTRING(new)
	string(34) = TSTRING(oma)
	string(35) = TSTRING(omd)
	string(36) = TSTRING(omi)
	string(37) = TSTRING(omo)
	string(38) = TSTRING(pch)
	string(39) = TSTRING(pin)
	string(40) = TSTRING(plt)
	string(41) = TSTRING(pty)
	string(42) = TSTRING(rsz)
	string(43) = TSTRING(smo)
	string(44) = TSTRING(srt)
	string(45) = TSTRING(tck)
	string(46) = TSTRING(tsp)
	string(47) = TSTRING(uin)
	string(48) = TSTRING(usr)
	string(49) = TSTRING(xaxp)
	string(50) = TSTRING(xaxs)
	string(51) = TSTRING(xaxt)
	string(52) = TSTRING(xpd)
	string(53) = TSTRING(yaxp)
	string(54) = TSTRING(yaxs)
	string(55) = TSTRING(yaxt)
	}
for(i=1; i<=NPAR; i=i+1)
	if(streq(which,string(i))) break
if(i>NPAR) ABORT(C(which)," is not a known graphical parameter")

#allocate structure leng(i), mode(i)
p = getvec(mode(i),leng(i))
vp = VALUE(p)
s = start(i)

if(s>0) 	# normal fill from am() array to result
	switch(mode(i)){
	case LGL:
		for(j=0; j<leng(i); j=j+1) ls(vp+j) = am(s+j) > .5
	case INT:
		for(j=0; j<leng(i); j=j+1) is(vp+j) = am(s+j)
	case REAL:
		for(j=0; j<leng(i); j=j+1) rs(vp+j) = am(s+j)
	case CHAR:
		for(j=0; j<leng(i); j=j+1){
			c = CHARMAKE(ifix(am(s+j)))	# split because of f77 bug
			is(vp+j) = istrng( c,1 )
			}
		}
else	# need explicit QUERY
	switch(abs(s)){
	case 1:	# cex
		QUERY( cex(rs(vp)) )
	case 2:	# mar
		QUERY( mar(rs(vp),rs(vp+1),rs(vp+2),rs(vp+3)) )
	case 3: # oma
		QUERY( oma(rs(vp),rs(vp+1),rs(vp+2),rs(vp+3)) )
	case 4: # omi
		QUERY( omi(rs(vp),rs(vp+1),rs(vp+2),rs(vp+3)) )
	case 5: # pch
		j = ifix(am(15))
		if(j<32) { is(vp) = j; MODE(p) = INT }
		else { c = CHARMAKE(j); is(vp) = istrng(c,1) }
	case 6: # new  (stored backwards!)
		QUERY( new(ls(vp)) )
	}

call zzrtrn(outstr,nres,p,istrng(which,-1))
return
end
