#dwmm     dwmm - weighted moving median or weighted median regression
subroutine dwmm(y,nn,nbi,bis,ideg,ys)
#
real y(1),bis(1),ys(1)
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
#
data zero/0./
n = nn
#
#  ensure odd- length smoothers
nh = (nbi-1)/2
nbm = 2*nh
nb = nbm+1
nhp1 = nh+1
#
#  get work space
ib0 = jstkgt(n+nb*2,3)
if (ierr!=2) {
	ib1 = ib0+nbm
	ib2 = jstkgt(n,2)
	if (ierr==2)
#
#  error
		call jstkrl(1)
	else {
		ib1m = ib1-1
		ib2m = ib2-1
#
		call rmovf(y,n,ys)
		call bsorti(ys,n,is(ib2))
		call brput(zero,rs(ib1),n)
		if (n<nb) {
#
#  get all, when n.lt.nb
			mm = nbm*2+1
			ix = ib1-mm/2
			nnp1 = (nn+1)/2
			nven = 0
			if (nnp1*2==n)
				nven = 1
			iso = +1
			i = 0
			repeat {
				i = i+1
				call biswt(mm,rs(ix))
				if (ideg<=0) {
					half = (sumx(rs(ib1),n))/2.0
					ys(i) = athaf(y,rs(ib1),is(ib2),half,n)
					}
				else {
					ys(i) = segl(y,nn,mm,rs(ix),i)
					if (ierr==2)
						break 1
					}
				if (i>=nnp1)
					if (i!=nnp1||nven<=0)
						iso = -1
					else {
						ix = ix+1
						next 1
						}
				mm = mm-2*iso
				if (i<nnp1)
					ix = ix+2*iso
				}
				until(i>=n)
			}
		else {
#
#  get center portion, (nh+1) to (n-nh)
			half = (sumx(bis,nb))/2.0
			ix = ib1m
			i = nh
			repeat {
				i = i+1
				ix = ix+1
				call rmovf(bis,nb,rs(ix))
				ys(i) = athaf(y,rs(ib1),is(ib2),half,nb)
				rs(ix) = 0.
				}
				until(i>=n-nh)
#
#  continue through upper end, from center to end
			mm = nb
			repeat {
				i = i+1
				mm = mm+2
				call biswt(mm,rs(ix))
				if (ideg<=0) {
					half = (sumx(rs(ix),nb))/2.0
					ys(i) = athaf(y,rs(ib1),is(ib2),half,nb)
					}
				else {
					ys(i) = segl(y,nn,mm,rs(ix),i)
					if (ierr==2)
						go to 10
					}
				}
				until(i>=n)
#
			call brput(zero,rs(ix),mm)
#
#  get lower end, from end to center
			ix = ib1-mm/2
			i = 0
			repeat {
				i = i+1
				call biswt(mm,rs(ix))
				if (ideg<=0) {
					half = (sumx(rs(ib1),nb))/2.0
					ys(i) = athaf(y,rs(ib1),is(ib2),half,nb)
					}
				else {
					ys(i) = segl(y,nn,mm,rs(ix),i)
					if (ierr==2)
						break 1
					}
				mm = mm-2
				ix = ix+2
				}
				until(i>=nh)
			}
#
#  release work space
		10  call jstkrl(2)
		if (ierr!=2)
			return
		}
	}
continue
return
end



