#segl     segl - linear regression using weighted repeated medians
real function segl(y,n,nbi,bis,loc)
#
real y(1),bis(1)
#
#  sabl error flag
common/errcm/ierr
#
#  dynamic core storage
INCLUDE(stack)
#
#
#  if n.le.0 just return y
if (n<=1)
	segl = y(1)
else {
#
#  ensure odd- length smoothers
	nh = (nbi-1)/2
	nbm = 2*nh
	nb = nbm+1
	nhp1 = nh+1
#
	lb = min0(nhp1,n)
	lbm = lb-1
	nhaf = n/2
	if (loc<=nhaf) {
#
#  do left end (beginning)
		iend = min0(loc+lbm,n)
		idx = 1
		jblo = nhp1-(loc-1)
		}
	else {
#
#  do right end
		iend = n
		idx = max0(loc-lbm,1)
		if (n>=nhp1)
			jblo = 1
		if (n<nhp1)
			jblo = nhp1-(loc-1)
		}
#
	idb = jblo-idx
	lenb = iend-idx+1
	tota = sumx(bis(jblo),lenb)
#
#  get work space
	ib1 = jstkgt(lenb,2)
	if (ierr!=2) {
		ib2 = jstkgt(lenb*4,3)
		if (ierr==2)
#
#  error
			call jstkrl(1)
		else {
			ib3 = ib2+lenb
			ib4 = ib3+lenb
			ib5 = ib4+lenb
			ib4m = ib4-1
			ib5m = ib5-1
#
#  get median slope across columns
			do ic = idx,iend {
#
#  get slopes and weights for each row, column ic
#  element ir has weight from bis(jblo+(ir-idx))
				ii = 0
				do ir = idx,iend
					if (ir!=ic) {
						dist = ic-ir
						ii = ii+1
						ibp = ib4m+ii
						rs(ibp) = (y(ic)-y(ir))/dist
						ibp = ib5m+ii
						irdb = ir+idb
						rs(ibp) = bis(irdb)
						}
#
#  get weighted median of slopes of column ic.  lenb=lenb-1
				irdb = ic+idb
				half = (tota-bis(irdb))/2.0
				call rmovf(rs(ib4),ii,rs(ib3))
				call bsorti(rs(ib3),ii,is(ib1))
				ibp = ib2+ic-idx
				rs(ibp) = athaf(rs(ib4),rs(ib5),is(ib1),half,ii)
				}
#
#  get weighted median across columns
			half = tota/2.0
			call rmovf(rs(ib2),lenb,rs(ib3))
			call bsorti(rs(ib3),lenb,is(ib1))
			slope = athaf(rs(ib2),bis(jblo),is(ib1),half,lenb)
#
#  get weighted median of y
			call rmovf(y(idx),lenb,rs(ib3))
			call bsorti(rs(ib3),lenb,is(ib1))
			ymed = athaf(y(idx),bis(jblo),is(ib1),half,lenb)
#
#  get weighted median of x
			call rvec(float(idx),float(iend),1.0,rs(ib3))
			call ivec(lenb,is(ib1))
			xx = athaf(rs(ib3),bis(jblo),is(ib1),half,lenb)
#
#  predicted y = wgt median y + slope* (loc-wgt med x)
			segl = ymed+slope*(float(loc)-xx)
#
#  release work space
			call jstkrl(2)
			if (ierr!=2)
				return
			}
		}
	continue
	}
return
end



