#random samples or permutations
FUNCTION sample(
	x	/ANY,NAOK/
	size	/INT,1,LENGTH(x)/
	replace	/LGL,1,FALSE/
	)

GETSEED	# initialize random number generators

if(LENGTH(x)==1){
	COERCE(x/INT,NAFATAL/)
	if(MISSING(size)) size=x
	n=x
	}
else { COERCE(x/ANY,VECTOR/); n=LENGTH(x) }
if(size<1) FATAL(Sample size must be positive)
if(!replace && size>n) FATAL(Sample size cannot be larger than population)

if(replace){	# sampling with replacement
	if(LENGTH(x)==1) {	# indices
		STRUCTURE(out/INT,size/)
		for(i=1; i<=size; i=i+1)
			out[i]=min0(ifix(uni(0)*float(n))+1,n)	# uniform on 1:n
		}
	else {	# data
		STRUCTURE(out/MODECALC(MODE(x)),size/)
		for(i=0; i<size; i=i+1){
			k=min0(ifix(uni(0)*float(n)),n-1)	# uniform on 0:(n-1)
			call pcopy(VALUE(x)+k,VALUE(out)+i,1,MODE(x))
			}
		}
	}
else{	# without replacement
	if(LENGTH(x)>1){
		call rsamp(VALUE(x),MODE(x),n,size)
		LENGTH(x)=size
		PUTSEED
		RETURN(x)
		}
	else if(size>n/3){	# use rsamp method
		STRUCTURE(out/INT,n/)
		for(i=1; i<=n; i=i+1) out[i]=i
		call isamp(out,n,size)
		LENGTH(out)=size
		}
	else {	# use hash table
		STRUCTURE(out/INT,size/)
		call tsamp(out,n,size)
		}
	}

PUTSEED

RETURN(out)
END
