#include "rotate.h"
#define INV_SQRT3 .57735026918962

F77_SUB(xform,real=in, int=n, int=out, int=scale)
{
	r_xform(F_REALP(in),F_INTP(n),F_INTP(out),F_INTP(scale));
}

static r_xform(in, n, out, scale)
float in[];
long *n, out[], *scale;
{
	float max = -1e20, min = 1e20, range;
	int i;

	if(*scale){
		for(i = 0; i < *n; i++) {
			max = in[i] > max ? in[i] : max;
			min = in[i] < min ? in[i] : min;
		}
		range = max - min;
		for(i = 0; i < *n; i++)
			out[i] = ((((in[i] - min) / range) * 2) - 1) * MAXCOORD * INV_SQRT3;
	}
	else
		for(i = 0; i < *n; i++)
			out[i] = in[i] * MAXCOORD * INV_SQRT3;
}
