FUNCTION symbols(&)
STRUCTURE(x,y)
PLOTARGS(NAOK)

CTABLE(kind,circles,squares,rectangles,stars,thermometers,boxplots)
STATIC(integer which; integer nscale(6))
INITIAL( nscale/1,1,2,0,2,4/ )	# number of columns to scale

nob=LENGTH(x)
if(nob!=LENGTH(y))FATAL(Lengths of x and y do not match)

which=-1
ALLARG(z)
	which=match(NAME(z),kind)
	if(which>0){ NAME(z)=USED; break }
NEXTARG
if(which<=0)FATAL(Missing symbol name (circles rectangles squares stars thermometers boxplots))

COERCE(z/MATRIX/)
ncol=NCOL(z)
if(nob!=NROW(z))FATAL(Number of symbol parameters must match number of points)
ARG(
	add	/LGL,1,FALSE/
	inches	/REAL,1,1./
	PAR
	&
	)
nsc = nscale(which)
if(which==5 && ncol<=nsc) FATAL(Thermometers need width height fill)
if(which==6 && ncol<5) FATAL(Boxplots need width height top bottom fraction)
call narang(z,LENGTH(z),zn,zx)
if(zn<0) FATAL(Parameters may not be negative)
if(nsc<ncol){
	call narang(z[1,nsc+1],nob*(ncol-nsc),zn,zx)
	if(zn<0|zx>1)FATAL(parameters not properly scaled between 0 and 1)
	}
if(!add){
	call scaler(x,y,z,nob,ncol,inches,x1,x2,y1,y2,nsc)
	SETUP(x1,x2,y1,y2)
	QUERY( usr(x1,x2,y1,y2) )
	call transf(x,y,z,nob,ncol,inches,nsc)
	}
else call conver(x,y,z,nob,ncol,x1,x2,y1,y2,inches,nsc)
switch (which){
	case 1:   call circs(x,y,z,nob)
	case 2,3: call rects(x,y,z[1,1],z[1,ncol],nob)
	case 4:   call strs(x,y,z,nob,ncol)
	case 5:   call therms(x,y,z,nob,ncol,inches)
	case 6:   call boxes(x,y,z,nob,ncol,inches)
	}
SPECIFY( usr(x1,x2,y1,y2) )
if(!add) CHAIN(axes,PAR,FILTER)
END
