SUPPORT(symbols,		symbol-drawing routines for symbols function)
subroutine circs(x,y,z,n)
real x(n),y(n),z(n)
do i=1,n
	if(!(NA(x(i))|NA(y(i))|NA(z(i))))
		call plarcz(x(i),y(i),z(i),0.,360.)
return
end

subroutine bx(x,y,w,h)
real xco(5), yco(5)
xco(1)=x-w;xco(2)=x+w;xco(3)=x+w;xco(4)=x-w;xco(5)=xco(1)
yco(1)=y+h;yco(2)=y+h;yco(3)=y-h;yco(4)=y-h;yco(5)=yco(1)
call linesz(xco,yco,5)
return
end

subroutine thbx(x,y,w,h)
real xco(5), yco(5)
xco(1)=x-w;xco(2)=x+w;xco(3)=x+w;xco(4)=x-w;xco(5)=xco(1)
yco(1)=y+h;yco(2)=y+h;yco(3)=y-h;yco(4)=y-h;yco(5)=yco(1)
call linesz(xco,yco,5)
yco(1)=y;   yco(2)=y
xco(1)=x-w; xco(2)=x-1.5*w
call linesz(xco,yco,2)
xco(1)=x+w; xco(2)=x+1.5*w
call linesz(xco,yco,2)
return
end

subroutine flbx(x,y,w,h,f1,f2)
real xco(4), yco(4)
xco(1)=x-w; xco(2)=x+w; xco(3)=x+w; xco(4)=x-w
yco(1)=y+(1-2*f1)*h; yco(2)=yco(1);
yco(3)=y-(1-2*f2)*h; yco(4)=yco(3)
call polyz(xco,yco,4)
return
end

subroutine bxplt(x,y,w,h,top,bot,f)
real xco(5), yco(5)
xco(1)=x-w;xco(2)=x+w;xco(3)=x+w;xco(4)=x-w;xco(5)=xco(1)
yco(1)=y+h;yco(2)=y+h;yco(3)=y-h;yco(4)=y-h;yco(5)=yco(1)
call linesz(xco,yco,5)
xco(1)=x;   xco(2)=x
yco(1)=y-h; yco(2)=y-h-bot
call linesz(xco,yco,2)
yco(1)=y+h; yco(2)=y+h+bot
call linesz(xco,yco,2)
xco(1)=x-w; xco(2)=x+w
yco(1)=y-h*(1-2*f); yco(2) = yco(1)
call linesz(xco,yco,2)
return
end

subroutine rects(x,y,w,h,n)
real x(n),y(n),w(n),h(n)
do i=1,n
	if(!(NA(x(i))|NA(y(i))|NA(w(i))||NA(h(i))))
		call bx(x(i),y(i),w(i)/2,h(i)/2)
return
end

subroutine therms(x,y,z,n,nz,inches)
real x(n),y(n),z(n,nz),inches
if(inches==0) s = 1; else s = inches
do i=1,n {
	if(NA(x(i))|NA(y(i))) next
	for(j=1; j<=nz; j=j+1) if(NA(z(i,j))) next 2
	call thbx(x(i),y(i),z(i,1)/2,z(i,2)/2)
	if(nz<4) call flbx(x(i),y(i),z(i,1)/2,z(i,2)/2,z(i,3)/s,0.)
	else     call flbx(x(i),y(i),z(i,1)/2,z(i,2)/2,z(i,3)/s,z(i,4)/s)
	}
return
end

subroutine boxes(x,y,z,n,nz,inches)
real x(n),y(n),z(n,nz),inches
if(inches==0) s = 1; else s = inches
do i=1,n {
	if(NA(x(i))|NA(y(i))) next
	for(j=1; j<=nz; j=j+1) if(NA(z(i,j))) next 2
	call bxplt(x(i),y(i),z(i,1)/2,z(i,2)/2,z(i,3),z(i,4),z(i,5)/s)
	}
return
end

subroutine strs(x,y,z,n,ncol)
real x(n),y(n),z(n,ncol)
INCLUDE(stack)
POINTER ssin,ccos,vect
angle=2.*PI/ncol
ccos=jstkgt(ncol,REAL)
ssin=jstkgt(ncol,REAL)
vect=jstkgt(ncol,REAL)
for(i=0;i<ncol;i=i+1){
	rs(ccos+i)=cos(i*angle)
	rs(ssin+i)=sin(i*angle)
	}
do i=1,n{
	if(NA(x(i))|NA(y(i))) next
	for(j=0;j<ncol;j=j+1)
		if(NA(z(i,j+1))) NASET(rs(vect+j))
		else rs(vect+j)=z(i,j+1)
	call str(x(i),y(i),rs(vect),ncol,rs(ccos),rs(ssin))
	}
call jstkrl(3)
return
end

subroutine str(x,y,z,ncol,ccos,ssin)
real xv(3),yv(3),ccos(ncol),ssin(ncol),z(ncol)
xv(1)=x
yv(1)=y
for(i=1; i<=ncol; i=i+1){
	if(NA(z(i))) next
	xv(2)=x+z(i)*ccos(i)
	yv(2)=y+z(i)*ssin(i)
	if(i==ncol) i=0
	if(NA(z(i+1))) call linesz(xv,yv,2)
	else {
		xv(3)=x+z(i+1)*ccos(i+1)
		yv(3)=y+z(i+1)*ssin(i+1)
		call linesz(xv,yv,3)
		}
	if(i==0) break
	}
return
end
