ifelse(OpSys,ATT,
`#include <sys/ioctl.h>
#include <termio.h>',
OpSys,Research,
`#include <sys/ttyio.h>',
`#include <sgtty.h>')
#include <stdio.h>
#include <signal.h>

#define LOWER5 037
#define LOWER7 0177
#define LOWER10 01777
#define TEKMD	"\033%!0"

#define NOBYPASS	"\012"			/* line feed */
#define GINMODE		"\033\032"		/* ESC SUB */
#define BELL		"\007"			/* bell */
#define COMMAND		"\007\033\032"		/* concat of above */

F77_SUB(zquxyz,int=ix,int=iy,int=indic)
{
	r_zquxyz(F_INTP(ix),F_INTP(iy),F_INTP(indic));
}

static r_zquxyz(ix,iy,indic)
long int *ix,*iy,*indic;
{
	extern float bgrp_[];
	int i, (*istat)();
	struct ifelse(OpSys,ATT,termio,sgttyb) iostr;
	int n, oflags; char lflag, ovmin;
	char buf[BUFSIZ];
	char dummy[BUFSIZ];
	write(2,TEKMD,4);	/* tek mode */
	write(2,COMMAND,3);	/* bell esc sub */
	istat=signal(SIGINT,SIG_IGN);
ifelse(OpSys,ATT,
	`ioctl(0, TCGETA, &iostr);
	lflag = iostr.c_lflag; ovmin = iostr.c_cc[VMIN];
	iostr.c_lflag &= ~(ECHO |ICANON);
	iostr.c_cc[VMIN] = 1;  /* 1 char at a time */
	ioctl(0,TCSETAF, &iostr);',
	`ioctl(0, TIOCGETP, &iostr);
	oflags = iostr.sg_flags;
	iostr.sg_flags &= ~ECHO;
	iostr.sg_flags |= CBREAK;
	ioctl(0, TIOCSETP, &iostr);')
	for (i=0;i<5;i++) buf[i] = '\0';	/* null the buffer */
	for (i=0;i<5;) {
		if (read(0,&buf[i],1) == 1) {
			if(i>0 && buf[i] >= ' ' && buf[i] <= '?') i++;
			else i++;
		}
	}
	read(0,dummy,BUFSIZ);      /* clear out buffer ?? */
	*indic = 0;
	if ( buf[0] == '\r' || buf[0] == '\n' ) {	/* quit */
		*indic = -1;
		*ix = *iy = 0;
	}
	else {
		*indic = buf[0] & LOWER7;
		*ix=(((buf[1] & LOWER5)<<5 | (buf[2] & LOWER5)) & LOWER10)<<2;
		*iy=(((buf[3] & LOWER5)<<5 | (buf[4] & LOWER5)) & LOWER10)<<2;
	}
	write(2,NOBYPASS,1);
/*
 * Note: above write is because
 * must turn off bypass for every GIN since
 * we don't know which read is the last one!
 */
ifelse(OpSys,ATT,
	`iostr.c_lflag = lflag; iostr.c_cc[VMIN] = ovmin;
	ioctl(0, TCSETA, &iostr);',
	`iostr.sg_flags = oflags;
	ioctl(0, TIOCSETP, &iostr);')
	istat=signal(SIGINT,istat);
}
