#ifdef DMD630
#include <dmd.h>
#else
#include <jerq.h>
#endif
#include <font.h>
#ifdef DMD630
#include <5620.h>
#define texture16 texture
#endif
#include "texture.h"
#ifndef DMD630
#ifdef mc68000
#define ringbell() (*((char*)(384*1024L+062)) = 2)
#endif
#endif
#ifndef SCRLOCKREQD
#define SCRLOCKREQD	0
#endif

Point PtCur;	/* current graphics position */
struct Proc *glayer = 0;
Bitmap *Slayer;
extern Font rotfont;

short xmn,xmx,ymn,ymx;
#undef CW
#define CW 9
short col = 0;
#ifdef DMD630
getchar()
{
	while((!(own()&RCV)) || (P->state&SCR_LOCK))
		wait(CPU);
	return(rcvchar());
}
#endif

#define NMENUS 8
char **menus[NMENUS];

static Texture16 menucurs={
	0x0FF0, 0x0810, 0x0810, 0x0810, 0x0810, 0x0FF0, 0x0FF0, 0x0FF0, 
	0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0810, 0x0FF0,
};

dographics()
{
	Point pt, p1, getpt(), getshort();
	register c; char s[2],**p,*getlab();
	Menu labmenu;
	short x,y,mflag,nl,getcoord();
	int i,j;
#ifdef DMD630
	struct Proc *upproc();
	Rectangle newrect();
	int exit();
#endif

	for(;;){
		c = getchar();
		switch(c){
		case 'I':	/* initialize - return rectangle coords */
			for(i=0; i<NMENUS; i++)
				if(menus[i]){
					freemenu(menus[i]);
					menus[i] = (char **) NULL;
					}
			request(MOUSE);	/* necessary to reset cursor */
#ifndef DMD630
#ifndef debug
#define debug() IpProc(55)()
#endif
			while( !(glayer=debug()) ) {
				sleep(60);	/* wait for user action */
				cursswitch((Texture16 *)0);
				}
			cursswitch((Texture16 *)0);
#else
			while(!(glayer = upproc(exit, newrect(3,display.rect), LOCAL, STKSIZE)))
				msgbox("too small",(char *) 0);
			current();	/* make this layer current */
			sleep(60);
#endif
			Slayer = (Bitmap *) glayer->layer;
			request(RCV|SCRLOCKREQD);
			rectf(Slayer, Slayer->rect, F_CLR);
			rectf(Slayer, Slayer->rect, F_XOR);
			sleep(20);
			rectf(Slayer, Slayer->rect, F_XOR);

			respond(xmn=Slayer->rect.origin.x+1);
			respond(ymn=Slayer->rect.origin.y+1);
			respond(xmx=Slayer->rect.corner.x-1);
			respond(ymx=Slayer->rect.corner.y-1);
			break;
		case '\035':	/* gs -- ignore */
			break;
		case '\037':	/* us -- exit graphics */
			return;
		case '\030':	/* can -- delete graphics layer */
			return;
#ifndef SIMPLE
		case 'P':	/* PRIM stuff */
			if(!glayer){ ringbell(); return; }
			doprim();
			return;
		case 'X':	/* Scatter plot matrix stuff */
			if(!glayer){ ringbell(); return; }
			doscat();
			return;
		case 'D':	/* interactive iDentify */
			if(!glayer){ ringbell(); return; }
			doident();
			return;
#endif
		case 'u': 	/* set menu */
			i = getcoord()%NMENUS;
			nl = getcoord();
			if(menus[i]) freemenu(menus[i]);
			p = menus[i] = (char **)alloc((nl+1) * sizeof(*p));
			for(i=0; i<nl; i++)
				*p++ = getlab();
			*p++ = NULL;
			return;
		case 'U': 	/* menu selection */
			i = getcoord()%NMENUS;
			nl = (getcoord()-1)%3 +1;
			if(!menus[i]) { respond(0); return; }
			request(MOUSE);
			cursswitch(&menucurs);
			do wait(MOUSE); while(bttn123()==0);
			labmenu.item = menus[i];
			i=menuhit(&labmenu, nl);
			cursswitch((Texture16 *)0);
			respond(i+1);
			request(RCV|SCRLOCKREQD);
			return;
		case 'Q':	/* query coordinates */
			request(MOUSE);
			wait(MOUSE);
			ringbell();
			do ;
			while (!bttn123());
			x = mouse.xy.x;
			y = mouse.xy.y;
			mflag = mouse.buttons;
			do 	/* collect extra button pushes while down */
				mflag |= mouse.buttons;
			while (bttn123());
			sleep(5);
			respond(x);
			respond(y);
			respond(mflag & 07);
			request(RCV|SCRLOCKREQD);
			break;
		case 'G':	/* filled polyGon */
			dopoly();
			break;
		case 'O':	/* new color */
			col = getchar()-' ';
			break;
		case 'R':	/* filled rectangle */
			pt=getpt();
			texture16( Slayer, Rpt(pt, getpt()), patterns+col, F_STORE);
			break;
		case 'C':	/* character */
			s[0] = getchar(); s[1] = '\0';
			string(&defont, s, Slayer, PtCur, col<0?F_XOR:col==0?F_CLR:F_OR);
			PtCur.x += CW;
			break;
		case 'S':	/* sideways character */
			s[0] = getchar(); s[1] = '\0';
			PtCur.y -= CW;
			string(&rotfont, s, Slayer, PtCur, col<0?F_XOR:col==0?F_CLR:F_OR);
			break;
		case 'E':	/* erase graphic area */
			if(glayer->state & (RESHAPED|MOVED))
				glayer->state &= ~(RESHAPED|MOVED);
			rectf(Slayer, inset(Slayer->rect,1), F_CLR);
			sleep(30);
			respond(xmn=Slayer->rect.origin.x+1);
			respond(ymn=Slayer->rect.origin.y+1);
			respond(xmx=Slayer->rect.corner.x-1);
			respond(ymx=Slayer->rect.corner.y-1);
			break;
		case 'M':	/* move */
			PtCur = getpt();
			break;
		case 'm':	/* relative move */
			PtCur = add(getshort(), PtCur);
			break;
		case 'l':	/* relative line */
			pt = p1 = getshort();
			if(p1.x == 0 && p1.y == 0)
				p1.x = 1;
			segment(Slayer, PtCur, add(p1, PtCur),
				col<0?F_XOR:col==0?F_CLR:F_OR);
			PtCur = add(pt ,PtCur);
			break;
		case 'L':	/* line */
			pt = p1 = getpt();
			if(p1.x == PtCur.x && p1.y == PtCur.y)
				p1.x++;
			segment(Slayer, PtCur, p1, col<0?F_XOR:col==0?F_CLR:F_OR);
			PtCur = pt;
			break;
		default:	/* anything else -- beep error and exit */
			ringbell();
			return;
		}
	}
}

#ifndef SIMPLE
#include "rotate.h"
doprim()
{
	extern long previous;
	short i,c,axis,size,sign,xsign,ysign,zsign,ptsize;
	short *x,*y,*z,n,getcoord();
	n = getcoord();
	x = (short *)alloc(n* sizeof(*x));
	y = (short *)alloc(n* sizeof(*y));
	z = (short *)alloc(n* sizeof(*z));
	for(i=0; i<n; i++){
		x[i] = getcoord();
		y[i] = getcoord();
		z[i] = getcoord();
	}
	previous=0; axis = X_TO_Y; size=5; sign=xsign=ysign=zsign= -1; ptsize=4;
	request(KBD);
	for(;;){
		rotate(x, y, z, n, ymx-ymn, xmx-xmn, ymn, xmn, axis, sign, size, ptsize);
		if(own()&KBD){
			c=kbdchar();
			switch(c & 0x7f){
			case 'x': axis = Y_TO_Z; xsign = sign = -xsign; break;
			case 'y': axis = Z_TO_X; ysign = sign = -ysign; break;
			case 'z': axis = X_TO_Y; zsign = sign = -zsign; break;
			case '-': sign = -sign; break;
			case '>': size--; if(size<1) size=1;  break;
			case '<': size++; if(size>7) size=7;  break;
			case 'h': sign = sign!=0 ? 0 : 1; break;
			case 'l': ptsize++; if(ptsize>15) ptsize=15;  break;
			case 'r': rectf(Slayer, inset(Slayer->rect,1), F_XOR);
				break;
			case 's': ptsize--; if(ptsize<2) ptsize=2; break;
			case 'q': goto out;
			default: ringbell();
			}
		}
		sleep(2);
	}
out:
	rectf(Slayer, inset(Slayer->rect,1), F_CLR);
	free(x); free(y); free(z);
	request(RCV|SCRLOCKREQD);
}

doscat()
{
	short *xyz,n,p,*status,getcoord(),i,nlabs,*limits;
	char **labs,**nams,*getlab(),*genlab();
	n = getcoord();
	p = getcoord();
	xyz = (short *)alloc((n*p) * sizeof(*xyz));
	status = (short *)alloc(n * sizeof(*status));
	nams = (char **)alloc(p * sizeof(*nams));
	limits = (short *)alloc((2*p) * sizeof(*limits));
	for(i=0; i<(n*p); i++)
		xyz[i] = getcoord();
	for(i=0; i<p; i++)	/* variable names */
		*(nams+i) = getlab();
	nlabs = getcoord();
	labs = (char **)alloc((n+1) * sizeof(*labs));
	if(nlabs) for(i=0; i<n; i++) *(labs+i) = getlab();
	else for(i=0; i<n; i++) *(labs+i) = genlab(i+1);
	*(labs+n) = NULL;
	scatmat(xyz, n, p, status, nams, labs, limits);
	free(xyz); free(status);
	for(i=0; i<p; i++) free(*(nams+i));
	free(nams);
	if(labs){
		for(i=0; i<nlabs; i++) free(*(labs+i));
		free(labs);
		}
	free(limits);
}

doident()
{
	short i;
	short *x,*y,*status,n,nl,getcoord(); char **label,*getlab();
	n = getcoord();
	x = (short *)alloc(n* sizeof(*x));
	y = (short *)alloc(n* sizeof(*y));
	status = (short *)alloc(n* sizeof(*status));
	for(i=0; i<n; i++){
		x[i] = getcoord();
		y[i] = getcoord();
		}
	nl = getcoord();	/* labels? */
	if(nl){
		label = (char **)alloc(nl * sizeof(*label));
		for(i=0; i<nl; i++)
			*(label+i)=getlab();
		}
	identify(x,y,n,label,nl,status);
	free(x); free(y); free(status);
	if(nl){
		for(i=0; i<nl; i++) free(*(label+i));
		free(label);
		}
}

char *
genlab(i)
short i;
{
	char buffer[10];
	char *pp;
	sprintf(buffer,"%d",i);
	pp = (char *)alloc(strlen(buffer)+1);
	strcpy(pp,buffer);
	return(pp);
}
#endif

short getcoord()
{
	short i;
	i = getchar() &037;
	i |= (getchar()&037) << 5;
	i |= (getchar()&077) << 10;
	return(i);
}

Point
getpt()
{
	Point p; 
	p.x = getchar() & 037;
	p.x |= (getchar()&037) << 5;
	p.y = getchar() & 037;
	p.y |= (getchar()&037) << 5;
	return(p);
}

Point
getshort()
{
	Point p; 
	p.x = (getchar() & 077)-31;
	p.y = (getchar() & 077)-31;
	return(p);
}

respond(i)
short i;
{
	char buf[10], *p; short j,sign;
	sign = i<0;
	if(sign) i = -i;
	p = buf+10;
	*--p = '\n'; j=1;
	do {
		*--p = i%10 + '0';
		i /= 10;
		j++;
	}
	while(i!=0);
	if(sign) { *--p = '-'; j++; }
	sendnchars(j, p);
}

char *
getlab()
{
	char buffer[100];
	char *p,*pp;
	p = &buffer[0];
	while(*(p++) = getchar());
	pp = (char *)alloc((short)(p-buffer));
	strcpy(pp,buffer);
	return(pp);
}

struct seg { short x, y, X, Y; char stat;} ;
typedef struct seg segS;
typedef struct seg * segP;


dopoly()
{
	segP sinp, sp;
	short i,x,y,prevx,prevy,firstx,firsty,n,getcoord(),colr;
	char c;
	if(col> 0) colr = (col - 1) % (sizeof(patterns)/sizeof(patterns[1])-1) + 1;
	else colr = 0;
	n = getcoord();
	sinp = (struct seg *) alloc(n*sizeof(struct seg));
	firstx = prevx = getcoord(); firsty = prevy = getcoord();
	sp = sinp;
	for(i=1; i<n; i++){
		x = getcoord(); y=getcoord();
		mkseg(sp++, prevx, prevy, x, y);
		prevx = x; prevy = y;
		}
	mkseg(sp, prevx, prevy, firstx, firsty);
	realfill(sinp, n, patterns+colr);
	free(sinp);
}

freemenu(q)
char **q;
{
	char **p;
	for(p=q; *p; p++) free(*p);
	free(q);
}
