ROUTINE(bplotz,		plot mixtures)
subroutine bplotz(x,y,z,n,title,xlab,ylab,zlab)
CHARACTER(title,*); CHARACTER(xlab,*)
CHARACTER(ylab,*); CHARACTER(zlab,*)
INCLUDE(graphics)
real hca(1),vca(1),ra(1)
real x(n),y(n),z(n),h(4),v(4)
CHARACTER(ipty,1)
equivalence(hca(1),hc),(vca(1),vc)
data h/0., 1., .5, 0./, v/0., 0., 0.866, 0./
QUERY( pty(ipty) )
call arpltz(1./v(3))
SPECIFY( usr(0.,1.,0.,v(3)) )
call linesz(h,v,4)	#  enclosing triangle
s = x(1)+y(1)+z(1)
do j=1,n	# compute max sum
	s = amax1(x(j)+y(j)+z(j),s)
do j = 1,n {
	sj = x(j)+y(j)+z(j)
	if (sj>0.05*s) {
		hc = (x(j)/sj)*h(1)+(y(j)/sj)*h(2)+(z(j)/sj)*h(3)
		vc = (x(j)/sj)*v(1)+(y(j)/sj)*v(2)+(z(j)/sj)*v(3)
		ra(1) = 0.25*sj/s
		call crclsz(hca,vca,ra,1)
		}
	}
QUERY( mgp(tline,aline,xline), srt(osrt), adj(oadj) )
SPECIFY( srt(90.), adj(0.) )
call gtextz(RIGHT,tline,0.0,ylab)
SPECIFY( srt(0.) )
call mtextz(BOTTOM,tline,xlab)
SPECIFY( adj(.5) )
call mtextz(BOTTOM,tline+1.0,title)
call mtextz(TOP,tline,zlab)
SPECIFY( adj(oadj), srt(osrt), pty(ipty) )
return
end
