ROUTINE(hhdonz,		number of classes for histogram by Doanes rule)
subroutine hhdonz(z,n,k,ke)
real z(n)
alog2(arg) = alog10(arg)/alog10(2.)
if(n<=0)return
xn = n
# compute the number of classes by sturgis rule
k = 2.+alog2(xn)
if (n<=2) return

# compute the first three moments
xm1 = 0.
do i = 1,n
	xm1 = xm1+z(i)
xm1 = xm1/xn
xm2 = 0.
xm3 = 0.
do i = 1,n {
	xm2 = xm2+(z(i)-xm1)**2
	xm3 = xm3+(z(i)-xm1)**3
	}
xm2 = xm2/xn
xm3 = xm3/xn
# compute the number of extra classes
if(xm2<=0) return
sbeta1 = sqrt(6.*(xn-2.)/((xn+1.)*(xn+3.)))
beta1 = sqrt(xm3**2/xm2**3)
t = 1.+(beta1/sbeta1)
ke = ifix(alog2(t)+.5)
k=k+ke
return
end
