SUPPORT(ssnap2,		interactive debugging of S structures)
subroutine ssnap2(fname,table,nstr)
POINTER fname,table(nstr,7)
#fname: pointer to name of S function
#table: the symbol table from an interface routine

INCLUDE(read,print,stack)
integer match2,i; CHARACTER(jgetch,1); POINTER p; logical streq
define(`DATAN',`table($1,4)')define(`KEYN',`table($1,3)')
define(`PSTR',`table($1,1)')define(`MISS',`table($1,7)!=0')

EPRINT("Debug called from ",C(TEXT(fname)))
repeat { #over lines of input
	call setprm(STDIN,"Debug: "//EOS)
	GETLINE; AUTO_CHECK=FALSE 
	if(LASTCH==0)break # end on empty line or "."
	if(LASTCH==1 & jgetch(INBUF,1)==".")break
	repeat { #over fields
		DECODE(CP(p))
		if(EOF) break	# end of line
		if(streq(TEXT(p),TSTRING(?))) {	# print the structures
			EPRINT("Keyname",T(15),"Dataname",T(30),"Missing?")
			for(i=1; i<=nstr; i=i+1) {
				if(KEYN(i)==NULL)ENCODE("<null>")
				else ENCODE(C(TEXT(KEYN(i))))
				ENCODE(T(15))
				if(DATAN(i)==NULL)ENCODE("<null>")
				else ENCODE(C(TEXT(DATAN(i))))
				EPRINT(T(30),L(MISS(i))) 
				}
			}
		else { #look it up
			i=match2(TEXT(p),KEYN(1),1,nstr)
			if(i<=0) EPRINT(C(TEXT(p))," not a recognized structure name")
			else {
				EPRINT(C(TEXT(KEYN(i))),":")
				ENCODE("Dataname: ")
				if(DATAN(i)==NULL)ENCODE(" <null>")
				else ENCODE(C(TEXT(DATAN(i))))
				EPRINT
				call dput(ERRORFC,PSTR(i))
				}
			}
		} #end of field
	} #end of line
return
end
