ROUTINE(rbiwt,		biweight regression of y vs single x variable)
subroutine rbiwt(x,y,n,a,b,sd,wts,ai,bi,xk,maxit,tol)
integer n,maxit
real x(n),y(n),wts(n),a,b,sd,ai,bi,xk,tol
#	compute the biweight regression estimates of a and b
#	in the model y = a + b * x + error.
#     sd is the estimated asymptotic residual standard error.
#     wts is a scratch vector of length n;  returns the final weights.

double precision wxy,wxx,wx,wy,w
real sum,sumxy
#     maxit is the maximum number of iterations to be allowed.
#     tol is the convergence criterion tolerance.
#     xk is the parameter "k".
#     ai and bi are starting values. (0,0) indicates use least-squares start
#
if(n<2)ERROR(Too few points to fit line)
if(ai==0. & bi==0.) {
	wxy = sumxy(x,y,n)
	wxx = sumxy(x,x,n)
	wx = sum(x,n)
	wy = sum(y,n)
	d = float(n)*wxx-wx**2
	a = (wy*wxx-wx*wxy)/d
	b = (float(n)*wxy-wy*wx)/d
	}
else {a=ai; b=bi}
for(iter = 1; iter<=maxit; iter=iter+1) {
	aold = a
	bold = b
	do i=1,n	# scale of residuals
		wts(i) = abs(y(i)-b*x(i)-a)
	scale = xmedu(wts,n)*xk
	w = 0.0d0
	wx = 0.0d0
	wy = 0.0d0
	wxy = 0.0d0
	wxx = 0.0d0
	do i=1,n {	# compute weights in wts; accumulate weighted sums
		wts(i) = 0.0
		if(scale>0.) u = (y(i)-a-b*x(i))/scale
		else if(y(i)-a-b*x(i)==0.) u=0.	# zero residuals get unit weight
		else u=2.	# make non-zero residuals get zero weight
		if (abs(u)<=1.0) {
			wts(i) = (1.0-u**2)**2
			w = w+wts(i)
			wx = wx+wts(i)*x(i)
			wy = wy+wts(i)*y(i)
			wxy = wxy+wts(i)*x(i)*y(i)
			wxx = wxx+wts(i)*x(i)*x(i)
			}
		}
	d = w*wxx-wx**2
	ASSERT(d>0)	# not all points can have zero weight
	a = (wy*wxx-wx*wxy)/d	# form new a and b estimates
	b = (w*wxy-wy*wx)/d
	if (abs(aold-a)<abs(a*tol)&&abs(bold-b)<abs(b*tol)) break
	}
sspsi = 0.0
spsip = 0.0
if(scale>0) {
	do i=1,n {	# std error of residuals
		u = ((y(i)-b*x(i)-a)/scale)**2
		if (u<=1.0) {
			v = 1.0-u
			sspsi = sspsi+u*(v**2)**2
			spsip = spsip+v*(1.0-u*5.0)
			}
		}
	sd = sqrt(sspsi*float(n))/abs(spsip)*scale
	}
else sd = 0.
return
end
