ROUTINE(rpois,random poisson with parameter xlam)
integer function rpois(xlam,iseed)
real xlam
integer iseed

real uni,qchis,pnorms,qnorms
real xold,rold,q,p,xk1,xkp,step1,twolam,eta,w,pchi1,xli,xkdl1,u,sum,step,xk,xkdl
integer i
SAVE(xold,rold)
data xold/-1.3/,rold/-1.3/
if (xlam<=0.0) ERROR(lambda not positive)
if (xlam<8.0) {	#algorithm for smaller xlam
	q = 1.0
	if (xlam!=rold) {
		rold = xlam
		p = exp(-xlam)
		}
	for(i=0; ; i=i+1){
		q = q*uni(iseed)
		if (p>q) break
		}
	return(i)
	}
else {	#initialize for larger xlam
	if (xlam!=xold) {
		xold = xlam
		xk1 = ifix(xlam)
#     find step at xk1, = xl**xk*exp(-xl)/gam(xk)
		xkp = xk1+1.0
		step1 = xk1*alog(xlam)-(xk1+0.5)*alog(xkp)-xlam+xkp-alog(1.0+1.0/(12.0*xkp)+1.0/(288.0*xkp*xkp))
		step1 = exp(step1)*0.3989423
#     find pchi1 using newton-raphson on qchis
		twolam = 2.0*xlam
		eta = 2.0*xk1+2.0
		w = 2.0/(9.0*eta)
		pchi1 = pnorms(((twolam/eta)**0.33333333+w-1.0)/sqrt(w))
		pchi1 = pchi1+(twolam-qchis(pchi1,eta))*step*0.707107*0.7
		pchi1 = 1.0-pchi1
		xli = 1.0/xlam
		xkdl1 = xk1*xli
		}
	u = uni(iseed)
	if(u>=.005 & u<=.995){
		sum = pchi1
		step = step1
		xk = xk1
		xkdl = xkdl1
		if (u>sum)
			repeat {	#increment sum
				xkdl = xkdl+xli
				step = step/xkdl
				xk = xk+1.0
				sum = sum+step
				}
				until(u<=sum)
		else
			repeat {	#decrement sum
				sum = sum-step
				if (sum<=u)
					break 1
				xk = xk-1.0
				step = step*xkdl
				xkdl = xkdl-xli
				}
		return( xk )
		}
#     use quadratic chi-square approx for extreme u
	u = qnorms(u)
	return( max0(0,ifix(xlam+sqrt(xlam)*u+(u*u-3.0)/4.0+0.5)) )
	}
end
