#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include "S.h"
#include "eval.h"
#include "y.tab.h"
#include "options.h"

#define MAX_DCTY		20
#define DATA_H_LEN		461

vector *S_get(), *S_ls_hash(), *S_obj_size(), *S_remove(), *S_scan();
vector *find_comp(), *get_data(), *get_hash(), *get_local(), *read_data();
vector *find_data(), *set_data(), *class_fun(), *class_op();
void S_init(), S_rd_line(), data_init(), set_options();
void do_rm(), flush_data(), frame0_assign(), interactive(), perm_assign();
void stamp_audit(), check_frame(), check_data(), install_search();
long which_frame(), which_comp();
int bad_name(), check_obj(), check_assign();
vector *S_void, *Search_list = NULL, *frame0 = NULL;
vector *Local_data = NULL_ENTRY, *S_data = NULL_ENTRY, *assign_data = NULL;
  /* perm. data used, assigned, to hash */
vector *blt_in_NA, *blt_in_TRUE, *blt_in_FALSE, *blt_in_NULL;
vector *h_S_data = NULL, *hash_data = NULL, *to_frame0 = NULL_ENTRY;
int Random_flag = FALSE, Initialized = FALSE;
char *Working_data = ".", *S_dict_file;
FILE *audit_file = NULL;
char *min_brk;

static char *rd_string(), *read_header(), *find_method(), *method_name();
static int d_mode_ok(), do_hash(), igets(), mode_ok();
static int na_fld(), na_fld2();
static long obj_size();
static FILE *do_search();
static vector *old_Program;
static vector *get_method(), *class_inheritor(), *find_class(), *next_call();
static void Random_assign(), bad_fld(), badread(), close_file(),
	fix_object(), dots_in_frame();
static void first_init_data(), make_dict_list(), make_error_code(), put_hash();
static void mark_hash(), nxt_fld(), dummy_hash();
static void read_error(), mark_C_item();
static void set_search(), setup_fun(), srch_and_rm(), read_values();
static void init_search(), fix_hash(), set_for_method();
static vector *new_data(), *pop_data(), *read_dict(), *class_call();
static x_h **dict_tables[MAX_DCTY], *Data_h_table[DATA_H_LEN];
static long dict_lens[MAX_DCTY], Data_h_length = DATA_H_LEN;
static FILE *file, *dict_files[MAX_DCTY];
static int search_len = 0, initializing = FALSE, hash_ok = TRUE;
static char *path, *this_name, *trouble = NULL;
static vector *saved_method;
static vector *deflt_class = NULL_ENTRY, *Deflt_class();

vector *
get_data(this_name, dmode)
char *this_name; int dmode;
{
	return(find_data(this_name, dmode, TRUE,Nframe>1?Local_data:NULL_ENTRY));
}

vector *
find_data(this_name , dmode, readit,local_data)
char *this_name; int dmode; int readit; vector *local_data;
{
	vector *value, *frame;
	vector **p; register long n, prev;
if(check){
	if(local_data)sanity(local_data,"local data in get_data");
	sanity(S_data,"global data in get_data");
	sanity(frame0,"frame 0 in get_data");
}
	if(local_data) {
		for(n=local_data->length, p=local_data->value.tree;n>0;
		  n--, p++)
			if(name_eq(this_name,(*p)->name) && mode_ok(*p,dmode,this_name))
				return(*p);
	}
	if(Frames && Frames->length) {
		frame = Frames->value.tree[0]; /* frame 1*/
		for(n=frame->length, p=frame->value.tree;n>0;
		  n--, p++)
			if(name_eq(this_name,(*p)->name) && mode_ok(*p,dmode,this_name))
				return(*p);
	}
	if(h_S_data && h_S_data->length) /* new in frame 0 this expression*/
		for(n=h_S_data->length, p=h_S_data->value.tree; n>0;
		  n--, p++)
			if(name_eq(this_name,(*p)->name) && mode_ok(*p,dmode,this_name))
				return(*p);
	for(n=frame0->length, p=frame0->value.tree; n>0; n--, p++)
		if(name_eq(this_name,(*p)->name) && mode_ok(*p,dmode,this_name))
				return(*p);
	for(n=S_data->length, p=S_data->value.tree; n>0; n--, p++) /* read in this expr */
		if(name_eq(this_name,(*p)->name) && mode_ok(*p,dmode,this_name))
			return(*p);
	if((value=get_hash(this_name,dmode))!=NULL_ENTRY ) /* the keep table */
		return(value);
	if(cur_frame != 1)prev = set_alloc(1L); else prev = 1;
	hash_ok = TRUE; /* may get reset during reading, in case of ambiguity */
	if( (value = read_data(this_name,dmode,readit,1))!=NULL_ENTRY){
		if(readit){if(hash_ok && do_hash(value))
				put_hash(this_name,value);
			else value=new_data(S_data,value);}
	}
	else value =NULL;
	if(prev!=1)set_alloc(prev);
	return(value);
}

/* special version used after read_header() -- could go away if STRUCTURE
/* was replaced by atribute pointer */
static int 
d_mode_ok(ent, dmode,name, readall)
vector *ent; int dmode, readall; char *name;
{	if(dmode!=ANY && ent->mode==STRUCTURE){
		read_values(ent, readall);
		if(!(dmode=mode_ok(ent,dmode,name)))ent->value.name =NULL;
		return(dmode);
	}
	return(mode_ok(ent,dmode,name));
}

static int 
mode_ok(ent, dmode, name)
vector *ent; int dmode; char *name;
{
	int mode = ent->mode; char *msg;
	if(dmode==ANY || mode == dmode )return(TRUE);
	if(mode == STRUCTURE) {
		ent = coevec(ent,ANY,TRUE,TRUE);
		mode = ent->mode;
		if(mode == dmode)return(TRUE);
	}
	if(atomic_type(dmode) && atomic_type(mode))return(TRUE);
	if(mode==ARGUMENT)return(FALSE); /* but don't complain */
	msg=S_alloc(80L+strlen(name),1);
	sprintf(msg,"Looking for object \"%s\" of mode \"%s\", ignored one of mode \"%s\"",
		name, token_name(dmode),token_name(mode));
	Warning(msg,NULL_ENTRY);
	return(FALSE);
}

static int 
do_hash(p)
vector *p;
{
	int mode;
	mode = p->mode;
	if(mode == STRUCTURE) {
		p = coevec(p,ANY,TRUE,TRUE);
		mode = p->mode;
	}
	if(Data_hash==FUN_DEF && mode==FUN_DEF  && !trouble)return(TRUE);
	else if(Data_hash==ANY)return(TRUE);
	else return(FALSE);
}

vector *
get_local(this_name, hint)
char *this_name; long hint;
{
	vector **p; long n;
	n=Local_data->length; p=NULL;
	if(hint-- >0 && hint<n ) {
		p = Local_data->value.tree+hint;
		if(this_name != NULL_STRING && !name_eq(this_name,(*p)->name))
			p=NULL;
	}
	/* could set n -= hint (+-1) to avoid double-checks */
	if(!p){
		p = Local_data->value.tree;
		while(n--){
			if(name_eq(this_name,(*p)->name))
				break;
			p++;
		}
	}
	return(++n?*p:NULL_ENTRY);
}
	

static vector *
new_data(datalist,ent)
vector *datalist,*ent;
{
	vector *new;
if(check) {
	sanity(ent,"vector arg to new_data");
	sanity(datalist,"datalist in new_data");
	if(datalist->mode!=LIST)Recover("Frame's datalist not mode \"list\"",datalist);
}
	append_el(datalist,0L,ent); /* insert it */
	new = *(datalist->value.tree); /* the version in the datalist */
	return( new);
}

vector *
set_data(frame,value,name)
char *name; vector *value; vector *frame;
{
	long prev, target, which_data; int n, c, perm;
	vector **datasets, *this_data; char *fname;
if(check) {
	sanity(frame,"frame for assignment");
	if(frame->mode!=LIST)
		Recover(encs1("System error: assignment frame for \"%s\" not a list",
		  name),NULL_ENTRY);
	check_frame(frame==Local_data ? Nframe : (perm ? 1 : which_frame(frame)),
		encs1("before assigning %s",name));
}
	if(IS_NULL_STRING(name))
		Recover("Illegal to assign to null name",NULL_ENTRY);
	if(value->mode == STRUCTURE &&  /* look for a "<-" method */
	  xact_comp(value,"class")!=NULL_ENTRY ) {
		vector *arglist, **args, *p;
		arglist = alcvec(LIST,2); args = arglist->value.tree;
		args[0] = p = alc_name(name); p->name = "x";
		p = New_vector(); *p = *value; p->name = "value";
		args[1] = p;
	  	this_data = class_fun(NULL_STRING, "<<-", S_void, arglist);
		if(this_data!=NULL_ENTRY) {
			this_data = eval(this_data); n = data_mode(this_data);
			if(NOT_RECURSIVE(n)) return; /* cancel the assignemnt*/
			if(p = xact_comp(this_data, "name")) name = string_value(p);
			if(p = xact_comp(this_data, "value")) value = p;
		}
	}
	n=frame->length; datasets = frame->value.tree;
	this_data = NULL_ENTRY; which_data = 0L;
	while(n--) {
		if(name_eq(name,(*datasets)->name) && (*datasets)->mode!=ARGUMENT){
			this_data = *datasets;
			which_data = datasets-frame->value.tree;
			break;
		}
		datasets++;
	}
	perm = frame==S_data || frame==h_S_data;
	target = frame==Local_data ? Nframe : (perm ? 1 : which_frame(frame));
	if(target==UNKNOWN_FRAME) target = cur_frame; /* assigning into a list */
	/* note that which_frame takes care of frame0 */
	/* get into the correct allocation frame */
	if(target != cur_frame)prev=set_alloc(target);
	else prev = target;
	if(this_data && target==prev/* if strings hashed wouldn't need*/ &&
		value->mode==this_data->mode && atomic_type(value->mode)
	  && this_data->nalloc >= value->length) { /* copy in */
		long length = value->length, mode = this_data->mode;
		switch((int)mode) {
		case LGL:
		case INT:
			MEMCPY(this_data->value.Long, value->value.Long, length);
			break;
		case REAL: 
			MEMCPY(this_data->value.Float, value->value.Float, length);
			break;
		case DOUBLE: 
			MEMCPY(this_data->value.Double, value->value.Double, length);
			break;
		case COMPLEX: 
			MEMCPY(this_data->value.Complex, value->value.Complex, length);
			break;
		case CHAR: 
			MEMCPY(this_data->value.Char, value->value.Char, length);
			break;
		default:
			if(length>0)Recover(encs1("Don't know how to assign moe \"%s\" as an atomic type",token_name((int)mode)),NULL_ENTRY);
		}
		this_data->length = length;
		if(!PRECIOUS(value))try_to_free(value,TRUE);
	}
	else {
		if(target != prev || PRECIOUS(value))
			value = copy_data(value,NULL_ENTRY);
		value->name = name = c_s_cpy(name);
		if(!this_data) {
			long pframe = cur_frame;
			if(perm && cur_frame>=1) {
				pframe = set_alloc(PERM_FRAME); /* protect the frame */
if(check && PRECIOUS(value))Warning("object to be appended to perm frame shouild not be precious\n\t\t(storage will be wasted)",value);
			}
			append_el(frame,0L,value); /* insert it */
			this_data = *(frame->value.tree);
			if(pframe!=cur_frame)set_alloc(pframe);
		}
		else {
			try_to_free(this_data,TRUE);
			this_data = frame->value.tree[which_data] = value;
		}
		set_precious(this_data,frame);
	}
	if( (c = *name)>='A' && c<='Z' && Initialized)switch(c) {
		/* check for illegal name, except when initializing */
	case 'T': if(!name[1] || name_eq(name,"TRUE"))goto badname;
		break;
			
	case 'F': if(!name[1] || name_eq(name,"FALSE"))goto badname;
		break;
	case 'N': if(!(name_eq(name,"NA") || name_eq(name,"NULL")))break;
badname:	Recover(encs1("Illegal to assign to the constant \"%s\"",name),NULL_ENTRY);
	}
	if(*name == '.') {/* object known in C code; install values, remember the name */
		if(target<2) {/* define target more precisely */
			if(frame==S_data) target = PERM_FRAME;
			else if(frame==h_S_data) target = FRAME0;
		}
 		if(check_assign(target,name,this_data))mark_C_item(target,name);
	}
if(check){
	check_frame(target, encs1("after assigning %s",name));
}
	if(prev!=cur_frame)set_alloc(prev);
	return(this_data);
}

void 
frame0_assign(name,data)
vector *data; char *name;
{
	char **names, *nptr[1]; long n, prev;
	if(!eval_open) { /* outside evaluator (should be in initialization) */
		prev = set_alloc(FRAME0);
		data = copy_data(data,frame0);
		data->name = c_s_cpy(name);
		append_el(frame0,0L,data);
		set_alloc(prev);
		return;
	}
	if((prev= cur_frame) > 1) {
		prev = set_alloc(1L);
		data = copy_data(data,NULL_ENTRY);
	}
	if(h_S_data->length==h_S_data->nalloc) { /* expand in FRAME0 */
		prev = set_alloc(FRAME0);
		n = h_S_data->length;
		append_el(h_S_data,n,S_void);
if(check && n!=to_frame0->length){
	Warning(enci2("length of obj., name lists for as'gn to frame 0 differ (%ld, %ld)",
		n, frame0->length),NULL_ENTRY);
}
 		append_data(to_frame0,n,1L,(char *)nptr);
		to_frame0->length = h_S_data->length = n;
		set_alloc(prev);
	}
	set_data(h_S_data,data,name); /* list of frame0's in this expr */
if(check) {
	sanity(to_frame0,"frame 0");
	if(to_frame0->mode !=CHAR) S_terminate("Internal frame 0 must be a character vector");
}
	n=to_frame0->length; names = to_frame0->value.Char;
	while(n--)if(name_eq(name,*names++))break;
	if(n<0) {
		nptr[0] = c_s_cpy(name);
 		append_data(to_frame0,0L,1L,(char *)nptr);
	}
	if(prev>1)set_alloc(prev);
}

static void 
mark_hash(name)
char *name;
{
 /* mark this name to be hashed at the conclusion of eval */
 /* called from make_dict*/
	char **names, *nptr[1]; long n;
	long prev = set_alloc(1L);
	if(!hash_data) hash_data = alcvec(CHAR,0L);
	n=hash_data->length; names = hash_data->value.Char;
	while(n--)if(name_eq(name,*names++))break;
	if(n<0) {
		nptr[0] = c_s_cpy(name);
 		append_data(hash_data,0L,1L,(char *)nptr);
	}
	set_alloc(prev);
}

static int
set_it(to_frame,name,target)
long to_frame; char *name, *target;
{
	long n;
	if(!name_eq(name,target))return(FALSE);
	if(to_frame>1 && to_frame == Frames->length)return(TRUE); /* local, the usual case*/
	if(to_frame<0)to_frame = 0;
	/* is there a version in a masking frame */
	for(n = Nframe<Frames->length?Nframe:Frames->length; n>to_frame /* and >=1 */;
	  n = parent_frame[n]){
		if(xact_comp(Frames->value.tree[n-1],name))return(FALSE); /* there is */
		if(n==1)break; /* checked all the way back now */
	}
	switch((int)to_frame) {
	case UNKNOWN_FRAME:
if(check) {
	Warning(encs1(
	  "Can't determine whether new value of \"%s\" is masked",
	  name),NULL_ENTRY);
}
	case FRAME0: case TO_FRAME0: return(TRUE);
	case PERM_FRAME: /* on S_data */
		if(xact_comp(frame0,name)
		|| (h_S_data && (xact_comp(h_S_data,name))))
		return(FALSE); /* masked by frame0*/
	}
	return(TRUE);
}

static char *sp_names[] = { ".Random.seed", ".Search.list",".Options",".Error",
	".Trace",".Program"};
#define N_SP_NAMES 6
#define SEED_NAME sp_names[0]
#define SEARCH_NAME sp_names[1]
#define OPT_NAME sp_names[2]
#define ERR_NAME sp_names[3]
#define TRACE_NAME sp_names[4]
#define PROG_NAME sp_names[5]

int 
check_assign(frame, name, value)
long frame; char *name; vector *value;
/* check for special datasets: if their value is supplied, use it to */
/* update the relevant internal quantitities; in any case return a flag */
/* that says whether the values were reset.  See also re_assign below */
{
	int n=FALSE;
	switch(name[1]) {
	case 'R':
		if((n = set_it(frame,name,SEED_NAME)) && value ) {
			seedin();
			mark_C_item(frame,SEED_NAME);
		}
		break;	
	case 'S':
		if((n = set_it(frame,name,SEARCH_NAME)) && value ) {
			set_search(value);
			mark_C_item(frame,SEARCH_NAME);
		}
		break;
	case 'O':
		if((n = set_it(frame,name,OPT_NAME)) && value ) {
			set_options(value);
			mark_C_item(frame,OPT_NAME);
		}
		break;
	case 'E':
		if((n = set_it(frame,name,ERR_NAME)) && value ) {
			error_code = (value->length) ? blt_in_TRUE : blt_in_FALSE;
			mark_C_item(frame,ERR_NAME);
		}
		break;
	case 'T':
		if((n = set_it(frame,name,TRACE_NAME)) && value ) {
			Trace = value;
			mark_C_item(frame,TRACE_NAME);
		}
		break;
	case 'P':
		if(!((n = set_it(frame,name,PROG_NAME)) && value))break;
		if(!(Program || Initialized)) {/* ONLY occurs in running boot_program() */
			long prev = set_alloc(PERM_FRAME);
			Program = copy_data(value,cons_frame);
			set_alloc(prev);
		}
		else if(frame>=1)
			Warning("Setting a temporary .Program has no effect",NULL_ENTRY);
		else {
			old_Program = Program;
			Program = NULL; /* will restore next time */
		}
		break;
	}
	return(n);
}

int re_assign(frame, name, value)
long frame; char *name; vector *value;
/* check for special datasets: similar to check_assign, but we assert that
/* the actual values haven''t changed, so only those objects containing
/* dynamic values known to C need to be reset.  Called from the compacting
/* code for loops in frame_keep */
{
	int n=FALSE;
	switch(name[1]) {
	case 'S':
		if((n = set_it(frame,name,SEARCH_NAME)) && value ) {
			install_search(value);
		}
		break;
	/* case 'O': assertion is that options  do not need to be reset
	/* note that the only dynamic thing in set_options is .Error & that
	/* will be copied itself if needed */
	case 'T':
		if((n = set_it(frame,name,TRACE_NAME)) && value ) {
			Trace = value;
		}
		break;
	}
	return(n);
}

static void
mark_C_item(nframe,name)
long nframe; char *name;
{
	char *p[1], **nn; long prev,i; vector *v;
	if(nframe<1)nframe = 1; /* force set_C_assign in eval_close */
	if(C_specials[nframe-1]->mode != CHAR){
		prev = set_alloc(PERM_FRAME);
		 C_specials[nframe-1] = alcvec(CHAR,(long)N_SP_NAMES);
		C_specials[nframe-1]->length = 0;
		set_alloc(prev);
	}
	v = C_specials[nframe-1];
	for(i =v->length, nn = v->value.Char; i>0 ; i--,nn++)
		if(name_eq(*nn,name))return; /* already recorded */
	if(v->length>=N_SP_NAMES) Recover("Internal error: too many special names",NULL_ENTRY);
	v->value.Char[v->length] = name;
	(v->length)++;
}


static vector *
pop_data(name)
char *name;
{
	/*vector *prev_local = Local_data;*/
	vector *value;
/* called via do_C_stop by eval_clear.  This currently pops the frame and THEN
/* calls do_C_stop.  If it (more sensibly?) called from the function that
/* set the stop, then Local_data would need to be set to the parent frame
/* and reset as below */
	value = get_data(name,ANY);
	if(VOID(value))Recover(encs1("No previous value of %s to restore",name),NULL_ENTRY);
	/*Local_data = prev_local;*/
	return(value);
}

void 
perm_assign(name,ent)
char *name; vector *ent;
{ /* mark this name to be permanently assigned at the conclusion of eval */
	char **names, *nptr[1]; long n, prev; UNUSED(ent);
	if(!assign_data){ prev = set_alloc(1L); assign_data = alcvec(CHAR,0L);
		set_alloc(prev);
	}
	n=assign_data->length; names = assign_data->value.Char;
	while(n--)if(name_eq(name,*names++))break;
	if(n<0) {
		prev = set_alloc(1L); nptr[0] = c_s_cpy(name);
 		append_data(assign_data,0L,1L,(char *)nptr);
		set_alloc(prev);
	}
}

vector *
S_obj_size(ent,arglist)
vector *ent, *arglist;
{
	long n = obj_size(arglist->value.tree[0]);
	vector *value = alcvec(INT,1L);
	UNUSED(ent);
	value->value.Long[0] = n;
	return(value);
}

static long 
obj_size(obj)
vector *obj;
{
	long n, size; int mode; char **names; vector **children;
	size = sizeof(vector);
	n = obj->length; mode = obj->mode;
	if(obj->name) size += strlen(obj->name)+1;
	if(n<1)return(size);
	switch(mode) {
	case LGL: case INT:
		return(size + n*sizeof(long));
	case REAL:
		return(size + n*sizeof(float));
	case DOUBLE:
		return(size + n*sizeof(double));
	case COMPLEX:
		return(size + n*sizeof(complex));
	case NAME:
		return(size + strlen(obj->value.name)+1);
	case CHAR:
		size += n*sizeof(char *);
		for(names = obj->value.Char; n>0; n--, names++)
			size += strlen(*names)+1;
		return(size);
	default:
		size += n * sizeof(vector *);
		if(NOT_RECURSIVE(mode))return(size);
		for(children = obj->value.tree; n>0; n--, children++)
			size += obj_size(*children);
		return(size);
	}
}	

void 
flush_data(error)
int error;
{
	vector *ent;
	long n; char *name, **names;
if(check){
	if(assign_data)sanity(assign_data,"assign_data in flush_data");
}
	if(!error) { 
		if(assign_data)
			for(n=assign_data->length, names=assign_data->value.Char;
			  n>0; n--,names++){
				name = *names;
				ent = xact_comp(S_data,name);
				if(!ent)ent = get_hash(name,ANY);
				if(!ent)ent = read_data(name,ANY,TRUE,1);
				if(!ent)Recover(
				 encs1("\"%s\" marked for assignment, but no value defined for it",name),NULL_ENTRY);
				put_data(name, Working_data, ent);
				/* hash according to option `keep'*/
				if(do_hash(ent))put_hash(name,ent);
				else if(get_hash(name,ANY)) /* delete old hashed version */
					un_hash(name,CHAR,Data_h_table,Data_h_length);
			}
		if(Random_flag)Random_assign();	/* take care of seed */
		if(hash_data && hash_data->length) { /* just for dictionaries ??*/
			for(n=hash_data->length, names = hash_data->value.Char;
			  n>0; n--, names++) {
				ent = xact_comp(h_S_data,*names);
				if(!ent) ent = xact_comp(S_data,*names);
				if(ent) put_hash(*names,ent);
				else Recover(encs1("Couldn't find \"%s\" to put into keep table",*names),NULL_ENTRY);
			}
			hash_data->length = 0;
		}
		if(to_frame0 && to_frame0->length) {
			for(n=to_frame0->length, names = to_frame0->value.Char;
			  n>0; n--, names++) {
				ent = xact_comp(h_S_data,*names);
				if(!ent) ent = xact_comp(frame0,*names);
				if(ent) set_data(frame0,ent,*names);
				/* else, ok -- presumably removed */
			}
		}			
	}
	else {
		Random_flag = FALSE;
		if(assign_data && (assign_data->length>0)){
			char **names;  vector *get_hash();
			n = assign_data->length; names = assign_data->value.Char;
			while(n--) {
				if(get_hash(*names,ANY))un_hash(*names,CHAR,Data_h_table,Data_h_length);
				names++;
			}
		}
	}
	h_S_data->length = 0; if(hash_data)hash_data->length = 0;
	if(to_frame0 && to_frame0->length) to_frame0->length = 0;
	assign_data = NULL;
}

long 
which_frame(frame)
vector *frame;
{
	vector **p; int n;
	if(frame == S_data) return(1L);
	else if(frame == frame0) return(FRAME0);
	else if(frame == NULL_ENTRY) return(NO_FRAME);
	else if(frame == h_S_data) return(TO_FRAME0);
	if(!Frames)S_terminate("Invalid assignment outside evaluation");
	n = Frames->length;
	p = Frames->value.tree + n;
	while(n--)if(*(--p)==frame)return(n+1);
	if(frame<S_data)return(TO_FRAME0); /*probably constant frame ?? */
	return(UNKNOWN_FRAME);
}

static void 
first_init_data()
/* initializaition of datasets permanently in memory, of cons_frame,
  and of search list */
{
	vector *value;
	static int first = TRUE; long mem;
	if(!first) {
		Recover("System error: init_data: recalled",NULL_ENTRY);
		return;
	}
	first = FALSE;
	Local_data =  alcvec(LIST,0L);/* so get_data() can function */
	set_alloc(PERM_FRAME);
	cons_frame = New_vector();
	/* the above should be numerically less than later, temporary
	   frames, to make PRECIOUS testing secure */
	S_void = New_vector();
	S_void->x.frame = cons_frame;
	blt_in_TRUE = alcvec(LGL,1L); *(blt_in_TRUE->value.Long) = TRUE;
	blt_in_TRUE->x.frame = cons_frame;
	blt_in_FALSE = alcvec(LGL,1L); *(blt_in_FALSE->value.Long) = FALSE;
	blt_in_FALSE->x.frame = cons_frame;
	blt_in_NA = alcvec(LGL,1L); na_set(blt_in_NA->value.Long);
	blt_in_NA->x.frame = cons_frame;
	blt_in_NULL = New_vector(); blt_in_NULL->mode = NULL;
	blt_in_NULL->x.frame = cons_frame;
	h_S_data = alcvec(LIST,0L); h_S_data->x.frame = cons_frame;
	to_frame0 = alcvec(CHAR,0L); to_frame0->x.frame = cons_frame;
	frame0 = alcvec(LIST,0L); frame0->x.frame = cons_frame;
	S_data = alcvec(LIST,0L); S_data->x.frame = S_data;
	init_search();
	if((S_dict_file = getenv("S_DICTIONARY"))!= NULL_STRING
	   && read_dict(S_dict_file,Data_h_table,Data_h_length)) fclose(file);
	if(read_dict((char *)NULL,Data_h_table,Data_h_length)) {
		Restart = TRUE;
		fclose(file);
		set_alloc(1L);
		mem_size(&mem);
		if(2.5*mem > max_memory)
			S_terminate("Restart failed to reduce memory significantly");
		if(4*mem > max_memory)
			fprintf(stderr,"Warning: you're starting off with a lot of memory used\n\tbetter increase options(\"memory\")\n");
		return;
	}
	value = read_data(".Options",LIST,TRUE,1);
	if(value==NULL_ENTRY)
		Warning("No default .Options vector",NULL_ENTRY);
	else frame0_assign(".Options",value);
	/* get two special operators whose name cannot be represented
	/* as a UNIX file name: "/" and "%/%"	*/
	value = get_data("\\057",FUN_DEF);
	if(!VOID(value))frame0_assign("/",value);
	value = get_data("%\\057%",FUN_DEF);
	if(!VOID(value))frame0_assign("%/%",value);
	/* hash in some constants for efficiency */
	frame0_assign("F",blt_in_FALSE); frame0_assign("FALSE",blt_in_FALSE); 
	frame0_assign("T",blt_in_TRUE); frame0_assign("TRUE",blt_in_TRUE);
	frame0_assign("NA",blt_in_NA); frame0_assign("NULL",blt_in_NULL); 
	flush_data(0); /* commit these assigns */
	set_alloc(1L); /* the initial frame */
}

void 
data_init()
{	/* initialize data lists for evaluating an expression */
	/* called form  eval_init() in eval.c */
	Local_data = S_data; S_data->length = 0;
	assign_data = hash_data = NULL;
	to_frame0->length = 0L;
}

/* find elements by name, for LIST and STRUCTURE **only!** */
vector *
find_comp(ent, name)
vector *ent; char *name;
{
	vector **children; long n;
	if(ent==NULL_ENTRY)return(NULL_ENTRY);
if(check){
	sanity(ent,"find_comp: vector argument");
}
	if(NOT_RECURSIVE(ent->mode))return(NULL_ENTRY); /* NOT data_mode(ent) */
	children = ent->value.tree;
if(check){
	sanity(ent,"find_comp: vector argument");
}
	return((n=which_comp(name,ent))?*(children+n-1):NULL_ENTRY);
}

vector *
S_get(ent, arglist)
vector *ent, *arglist;
{
	char *name, *p; int readit, readall, mode, which, nframe;
	long n;
	vector **args,  *arg, *oframe;
	n = arglist->length;
	which = sys_index; readit = which/10; which = which % 10;
	if(readit <= 1) readit = !readit;
	readall = readit == 1;
	args = arglist->value.tree;
	arg =args[0];
	name = string_value(arg);
	arg = args[1];
	p = string_value(arg);
	mode = mode_lookup(p); trouble = NULL; file = NULL;
	switch(which) {
	case 0:
		oframe = Local_data;
		Local_data = parent_data(1L); nframe = Nframe; arg = NULL_ENTRY;
		if(n>2 && logical_value(args[2], ent)) while(TRUE){ /* inherit */
			if((arg = xact_comp(Frames->value.tree[nframe-1],name))
			  !=NULL_ENTRY)break;
			if(nframe == 1)break;
			nframe = parent_frame[nframe];
		}
		if(!arg)
			arg = find_data(name, mode, readit,Nframe>1?Local_data:NULL_ENTRY);
		Local_data = oframe;
		break;
	case 1: /* where argument */
		if(n<3)Recover("Missing the \"where\" argument to .Internal",NULL_ENTRY);
		arg = coevec(args[2],CHAR,TRUE,CHECK_IT);
		if(arg->mode == CHAR && arg->length>0) {
			path = encs2("%s/%s",*(arg->value.Char),name);
			file = fopen(path,"r");
			if(!readit && (mode==ANY || file==NULL)){
				arg = file==NULL? NULL :blt_in_TRUE;
				break;
			}
			if(file==NULL && readit) {
				path = encs1("Error in reading \"%s\"",path);
				perror(path);
				Recover(NULL_STRING,NULL_ENTRY);
			}
			arg = New_vector();
			if(trouble= read_header(arg)) 
				if(readit)Recover(trouble,NULL_ENTRY);
				else {arg = NULL; break;}
			if(!d_mode_ok(arg,mode,name,readall))arg = NULL;
			else if(readit && !arg->value.name)read_values(arg,readall);
			/* above for mode STRUCTURE, where mode_ok may read*/
		}
		else arg = NULL;
		break;
	case 2: /* frame argument */
		if(n<3)Recover("Missing the \"frame\" argument to .Internal",NULL_ENTRY);
		n = long_value(args[2],ent);
		if(n<0 || n>Frames->length)
			Recover(enci1("Invalid frame number, %ld",n),NULL_ENTRY);
		if(n==0) {
			arg = to_frame0->length ? xact_comp(h_S_data,name) : NULL_ENTRY;
			if(!arg) arg = xact_comp(frame0,name);
		}
		else arg = xact_comp(Frames->value.tree[n-1],name);
		if(arg && mode!=ANY && arg->mode!=mode){
				trouble = encs1("of mode %s",token_name(mode));
				arg = NULL;
			}
		break;
	default: Recover(enci1("unknown index in S_get, %ld",(long)sys_index),NULL_ENTRY);
	}
	if(file) close_file(file);
	if(readit) {
		if(arg==NULL)
			Recover(trouble?encs2("Object \"%s\" : %s",name,trouble):
			   encs1("Object \"%s\" not found",name),NULL_ENTRY);
		if(trouble) Warning(encs2("Object \"%s\" : %s",name,trouble),NULL_ENTRY);
		return(arg);
	}
	else return(arg==NULL?blt_in_FALSE:blt_in_TRUE);
}

vector *
S_frame0(ent,arglist)
vector *ent, *arglist;
{
	UNUSED(ent);
	UNUSED(arglist);
	return(frame0);
}

static FILE *cur_dict_file = NULL;

static void 
close_file(file)
FILE *file;
{
	if(file!=cur_dict_file)fclose(file);
}

/* read_header returns NULL if all is well, with the side effect of
/* filling in the mode and length of ent.  If the file is not an S object
/* it returns a non-null string.  Any other problem causes an error */
static char *
read_header(ent)
vector *ent;
{
	int dmode, n;
	double copy_header;
	if((n=FREAD(&copy_header,1,file)) == 0)
		return( "Not an S object");
	else if(n!=1)
		badread("data_header");
	if(copy_header != (*data_header))
		return( "Not an S object");
	if(FREAD(&dmode,1,file) != 1)
	   badread("mode");
	ent->mode = dmode;
	if(FREAD(&ent->length,1,file) != 1)
	   badread("length");
	ent->nalloc = ent->length;
	return(NULL);
}

vector *
get_hash(name,mode)
char *name; int mode;
{
	long index, pos; vector *value;
	if(hash(name,CHAR,&index,&pos,Data_h_table,Data_h_length)){
		value = (vector *)index;
		if(!mode_ok(value,mode,name)) value=NULL_ENTRY;
	}
	else value = NULL_ENTRY;
	if(value && audit_file && value->x.frame == S_data)
	/* simulate the read on the audit file, for things from the working data */
		fprintf(audit_file,"#~get \"%s/%s\" 0 \"hash\"\n",
			 *(Search_list->value.Char),name);
	return(value);
}

int cache_ok = FALSE; /* temporary for debugging */
static void 
put_hash(name,value)
char *name; vector *value;
{
	vector *frame, *new;
	long index, pos, prev;
	char *np;
	if(value->mode == FUN_DEF)setup_fun(value->value.tree[value->length-1]);
	frame  = value->x.frame;
if(check){
	if(frame!=S_data && frame!=cons_frame && frame!=h_S_data) {
		fprintf(stderr,"Warning: data for keep \"%s\" marked by non-perm. frame (%ld)\n",name,which_frame(frame));
		Warning(NULL_STRING,NULL_ENTRY);
	}
}
	if(!name_eq(value->name,name)){np=value->name; value->name=name;}
	else np=NULL_STRING;
	cache_ok = TRUE; prev = set_alloc(CACHE_FRAME);
	if(hash(name,CHAR,&index,&pos,Data_h_table,Data_h_length))
		try_to_free((vector *)index,TRUE);
	pos = -1L; /* force hash_enter to rehash (& replace) */
	new = copy_data(value, frame); name = new->name;
	value->name = np;
	index  = (long)new;
	hash_enter(name,CHAR,index,pos,Data_h_table,Data_h_length);
	set_alloc(prev); cache_ok = FALSE;
}

vector *
S_ls_hash(ent,arglist)
vector *ent, *arglist;
{
	vector *value; char **names;
	long n,i; x_h **h, *p;
	UNUSED(ent); UNUSED(arglist);
	if(sys_index == 0)  /* frame 0 */
		return(to_frame0 ? to_frame0 : alcvec(CHAR, 0L));
	/* else, the whole hash table */
	n = 0; h = Data_h_table;
	for(i=0; i< Data_h_length; i++,h++) {
		p = *h;
		while(p){ n++; p = p->next;}
	}
	value = alcvec(CHAR,n); names = value->value.Char;
	h = Data_h_table;
	for(i=0; i< Data_h_length; i++,h++) {
		p = *h;
		while(p){ *names++ = c_s_cpy(p->name); p = p->next;}
	}
	return(value);
}

void 
clear_cache()
{	/* called when search list changed: deletes all hash entries */
	long n; x_h **h;
	for(n= Data_h_length, h = Data_h_table;n>0;n--,h++) {
		if(*h != (x_h *)NULL)
			*h = (x_h *)NULL;
	}
	if(free_level)clear_alloc(CACHE_FRAME);
}

long 
which_comp(name,ent)
char *name; vector *ent;
{
	char *p, *q, c; vector **children, *child; long n, i, match, pmatch;
	n=ent->length; children=ent->value.tree; match = pmatch = i = 0;
	while(n--) {
		i++; child = *children++; p = child->name;
		if(IS_NULL_STRING(p)) continue;
		q = name;
		while((c = *q++ )== *p++ )
			if( c == '\0')return(i); /* exact match */
		if(c == '\0') /* allow 1 (only) partial match */
			if(pmatch) pmatch = -1; else pmatch = i;
	}
	return(match?match:(pmatch>0?pmatch:0));
}

vector *
read_data(name,mode, read_it,into_frame)
char *name;  int mode; int read_it; int into_frame;
{
	char *dataset_name;
	long n, prev, file_pos;
	vector *ent;
	int readall = read_it==1;

	this_name = name; trouble = NULL;
	if((n=strlen(name))>MAX_FILE_NAME_LEN) {
		dataset_name = S_alloc(MAX_FILE_NAME_LEN+1L,sizeof(char));
		strncpy(dataset_name,name,MAX_FILE_NAME_LEN);
		name = dataset_name;
	}
	if(bad_name(name,n))return(NULL_ENTRY);
	prev = set_alloc((long)into_frame);
	ent = New_vector(); /* mode, length will be set by search() */
	file = do_search(name,mode,ent,TRUE,readall,&file_pos);
	if(file == NULL){set_alloc(prev); return(NULL_ENTRY);}
	else if(!read_it) return(alc_name(name));
	ent->name=c_s_cpy(name);
	add_error((fun_ptr)read_error);
	if(!ent->value.name)read_values(ent,readall);
	close_file(file);
	if(audit_file && !file_pos) { /* from working data */
		char *m;
		m = mode==ANY?"any":(mode==FUN_DEF?"function":token_name(mode));
		fprintf(audit_file,"#~get \"%s\" %ld \"%s\"\n",path,file_mtime(path),m);
	}
	del_error((fun_ptr)read_error);
	set_alloc(prev);
	return(ent);
}

static vector *
read_dict(name, dictionary,dlen)
char *name; x_h **dictionary; long dlen;
{
	vector *ent, *ename, *eloc, *ehash;
	long n, stringlen, i; char **chptr, *data;
	if(name == NULL) { /* the restart file */
		if((file = fopen(".Restart","r"))==NULL)return(NULL);
		unlink(".Restart");
		fputs("Reloading\n",stderr); fflush(stderr);
	}
	else if((file = fopen(name,"r"))==NULL)return(NULL);
	Perm_open(file);
	cur_dict_file = file;
	if(FREAD(&n,1,file)!=1)badread("initial length");
	ename = alcvec(CHAR,n);
	if(FREAD(&stringlen,1,file) != 1)badread("string lengths");
	data = S_alloc(stringlen,sizeof(char)); chptr = ename->value.Char;
	if(FREAD(data,stringlen,file) != stringlen)badread("character data");
	i=n; while(i--){
		*chptr++ = data;
		data += strlen(data)+1;
	}
	eloc = alcvec(INT,n);
	if(FREAD(eloc->value.Long,n,file) != n) badread("locations");
	ehash = alcvec(INT,n);
	if(FREAD(ehash->value.Long,n,file) != n) badread("hashes");
	if(dlen) { /* read & hash all the datasets */
		long prev, *ll, *hh;
		prev = set_alloc(PERM_FRAME); trouble = NULL;
		for(i=n, chptr = ename->value.Char, ll = eloc->value.Long, hh = ehash->value.Long;
		  i>0; i--, chptr++, ll++, hh++) {
			file = cur_dict_file; /* just in case it got changed*/
			fseek(file, *ll, 0);
			ent = New_vector();
			trouble = read_header(ent);
			if(trouble){
			  Warning(encs2(
			  "Can't read \"%s\" from dictionary: %s",*chptr,trouble),NULL_ENTRY);
			  continue;
			}
			ent->name=c_s_cpy(*chptr); ent->x.frame = cons_frame;
			read_values(ent, TRUE);
			hash_enter(ent->name, CHAR, (long)ent, -1L,
				  dictionary, dlen);
			if(dictionary==Data_h_table) {
				mark_hash(ent->name);
				check_assign(CACHE_FRAME,ent->name,ent);
			}
		}
		ent = ename;
		set_alloc(prev);
	}
	else {
		ent = alcvec(LIST,3L);
		ent->value.tree[0] = ename;
		ent->value.tree[1] = eloc;
		ent->value.tree[2] = ehash;
	}
	file = cur_dict_file; cur_dict_file = NULL;
	return(ent); /* note that file is left open */
}

bad_name(name,n)
char *name; long n;
{
	if((n==0) || (*(name+n-1)=='/'))return (TRUE);
	if(*name=='.' && ((n==1) || (n==2 && *(name+1)=='.')) )return(TRUE);
	return(FALSE);
}

static void 
read_values(ent, readall)
vector *ent;
int readall;
{
	int mode = ent->mode;
	long length = ent->length, *l_buf, *ll, i, stringlen;
	vector **children, *child;
	char **chptr, *data;
if(check){
	sanity(ent,"read_value vector");
}
	switch(mode) {
	case LGL:
	case INT:
		if(!readall) {
			ent->value.offset = ftell(file);
			break;
		}
		ent->value.Long = (long *)S_alloc(length, sizeof(long));
		if(FREAD(ent->value.Long, length, file) != length)
			badread("data values");
		break;
	case REAL: 
		if(!readall) {
			ent->value.offset = ftell(file);
			break;
		}
		ent->value.Float = (float *)S_alloc(length, sizeof(float));
		if(FREAD(ent->value.Float, length, file) != length)
			badread("data values");
		break;
	case DOUBLE: 
		if(!readall) {
			ent->value.offset = ftell(file);
			break;
		}
		ent->value.Double = (double *)S_alloc(length, sizeof(double)); 
		if(FREAD(ent->value.Double, length, file) != length)
			badread("data values");
		break;
	case COMPLEX: 
		if(!readall) {
			ent->value.offset = ftell(file);
			break;
		}
		ent->value.Complex = (complex *)S_alloc(length, sizeof(complex)); 
		if(FREAD(ent->value.Complex, length, file) != length)
			badread("data values");
		break;
	case CHAR: 
		if(!readall) {
			ent->value.offset = ftell(file);
			break;
		}
		chptr = ent->value.Char = (char **)S_alloc(length, sizeof(char *));
		if(FREAD(&stringlen, 1, file) != 1)
			badread("string lengths");
		data = S_alloc(stringlen,sizeof(char));
		if(FREAD(data, stringlen, file) != stringlen)
			badread("character data");
		while(length--) {
			*chptr++ = data;
			data += strlen(data) + 1;
		}
		break;
	case NAME:
		if(FREAD(&stringlen, 1, file) != 1)
			badread("name length");
		data = ent->value.name = S_alloc(stringlen, sizeof(char));
		if(FREAD(data, stringlen, file) != stringlen)
			badread("name data");
		break;
	default: 
		if(length == 0) break;
		children = ent->value.tree = (vector **)S_alloc(length,sizeof(vector *));
		if(FREAD(&stringlen, 1, file) != 1)
			badread("name lengths");
		data = S_alloc(stringlen, sizeof(char));
		if(FREAD(data, stringlen, file) != stringlen)
			badread("component names");
		i = length; ll = l_buf = (long *)S_alloc(i,sizeof(long));
		if(FREAD(l_buf, i, file) != i)
			badread("modes");
		while(i--) {
			*children++ = child = New_vector();
			child->mode = *ll++;
			child->name = data; data += strlen(data)+1;
			child->x.frame = ent->x.frame;
		}
		i = length; children = ent->value.tree; ll=l_buf;
		if(FREAD(l_buf, i, file) != i)
			badread("lengths");
		while(i--) {
			child = *children++;
			child->length = child->nalloc = *ll++;
		}
		i = length; children = ent->value.tree; ll = l_buf;
		if(FREAD(l_buf, i, file) != i)
			badread("value ptrs");
		while(i--) {
			fseek(file, *ll++, 0);
			read_values(*children++, readall);
		}
	}
}

static void 
badread(what)
char *what;
{	
	perror(encs2("Error in reading %s for object \"%s\": ", what, this_name));
	if(cur_dict_file == file)cur_dict_file = NULL;
	Recover(NULL_STRING,NULL_ENTRY);	
}

static void 
read_error(message)
char *message;
{
	UNUSED(message);
	if(file)fclose(file);
	file = NULL;
	hash_ok = TRUE;
}

static char *audit_filename;

static void 
init_search()
{
	char **names, *pref[3];
	vector *ent, *ent2;
	long prev;
	char *sfunctions;
	if(Search_list != NULL_ENTRY) Recover("Search list initialized twice",NULL_ENTRY);
 /* need a default list to start up */
	prev = set_alloc(1L); /* will force a copy in install_search */
	/* default: search current dir, home dir & a special system directory */
	if(!(sfunctions=getenv("S_FUNCTIONS")))
		sfunctions = encs1("%s/s",shome);
	ent = alcvec(CHAR,3L); names = ent->value.Char;
	names[0] = "./.Data";
	names[1] = encs1("%s/.Functions",sfunctions);
	names[2] = encs1("%s/.Datasets",sfunctions);
	if(access(*names,7)!=0) {
		fprintf(stderr,"Working data will be in %s/.Data\n",user_home);
		names[0] = encs1("%s/.Data",user_home);
	}
	if(access(*names,7)!=0) {
		if(access(*names,0)!=0){ /* initialize */
			if(system("S init_srch.sh"))
				S_terminate("Cannot initialize S: is your login directory writable?");
		}
		else S_terminate("Home database not writable");
	}
	names++; /* test QPE directory */
	if(access(*names,5)!=0) {
		if(access(*names,0)!=0) 
			S_terminate("No S data directory (weird!)");
		else S_terminate("Your S data directory doesn't have read permission");
	}
	/* set up Audit file */
	names = ent->value.Char;
	set_alloc(PERM_FRAME);
	audit_filename = encs1("%s/.Audit",names[0]);
	set_alloc(1L);
	if((audit_file = fopen(audit_filename,"a"))==NULL) {
		Warning("Cannot open audit file",NULL_ENTRY);
		audit_filename = "";
	}
	Search_list = ent; /* try to find an explicit .Search.list */
	ent2=get_data(".Search.list",ANY);
	if(!VOID(ent2)) ent = ent2;
	Search_list = NULL_ENTRY;
	set_alloc(FRAME0);
	ent = copy_data(ent,frame0);
	set_search(ent);
	frame0_assign(".Search.list",Search_list);
	set_alloc(prev);
}

void 
get_audit_file(p)
char **p;
{
	p[0] = audit_filename;
}

static FILE *
do_search( name, mode,ent,open_it,readall,pos_add)
char *name; int mode; vector *ent; int open_it;long *pos_add;
{
	char **places, *from, *to, *path0;
	long nd, name_len, tt;
	extern char *sys_errlist[];
	name_len = strlen(name);
	if(name_len> MAX_FILE_NAME_LEN ) {
		path = S_alloc(MAX_FILE_NAME_LEN+1L,sizeof(char));
		strncpy(path,name,MAX_FILE_NAME_LEN);
		name = path;
		name_len = MAX_FILE_NAME_LEN;
	}
	file = NULL; trouble = NULL;
	path0 = S_alloc(search_len+name_len+2,sizeof(char)); 
	places = Search_list->value.Char; hash_ok = TRUE;
	for(nd = 0; nd < Search_list->length; nd++) {
		if(dict_tables[nd] && hash(name,CHAR,pos_add,&tt,dict_tables[nd],dict_lens[nd])) {
			file = cur_dict_file = dict_files[nd];
if(check) {
	if(*pos_add <= 0)Recover(encs1("Invalid dictionary entry for \"%s\": position not positive",name),NULL_ENTRY);
}
			fseek(file,*pos_add,0);
			trouble = read_header(ent);
			if(trouble)Recover(encs2(
			  "Can't read \"%s\" from dictionary: %s",name,trouble),NULL_ENTRY);
			if(d_mode_ok(ent,mode,name,readall)) break;
			else hash_ok = FALSE;
		}
		from = *places++; /* try to open file */
		to = path = 
			strlen(from)<=search_len ? path0
			: S_alloc(2L+strlen(from)+strlen(name),sizeof(char));
		while(*from)*to++ = *from++;
		*to++ = '/'; from = name;
		while(*from)*to++ = *from++;
		*to = '\0';
		if( (file = fopen(path,"r"))!=NULL) {
			if(open_it) {
				if(trouble = read_header(ent)){
					file = NULL;
					Recover(encs2("%s: %s",trouble,path),NULL_ENTRY);
				}
				if(!d_mode_ok(ent,mode,name,readall)) {
					hash_ok = FALSE; continue;
				}
			}
			else {
				file = stdin/*anything not NULL */;
				if(audit_file && !nd)
					fprintf(audit_file,"#~access %s mode: %ld\n",
					  path, READ_ACCESS);
			}
		}
		else if(errno>0 && errno != ENOENT)
			trouble = encs2("File \"%s\":%s",path,sys_errlist[errno]);
		else continue; /* keep looking */
		if( trouble ) Recover(trouble,NULL_ENTRY);
		*pos_add = -nd; /* 0 for the working directory */
		break;
	}
	ent->x.frame = nd==0 ? S_data : cons_frame;
	  /*mark by frame whether working data (for audit)*/
	return(file);
}

static void 
set_search(ent)
vector *ent;
{
	int amode, ok;
	long i, l2; char **names;
	ent = coevec(ent,CHAR,TRUE,PRECIOUS(ent));
		MEANINGFUL(l2);
	if(ent==NULL_ENTRY || ent->length<1){
		Recover("Empty or non-character search list",ent);
		return;
	}
	names = ent->value.Char; amode = 7; /* first must be writable, others readable */
	ok = TRUE;
	for(i=0; i < ent->length; i++){
		if(is_na(names) || IS_NULL_STRING(*names)){
			Recover(enci1("Element %ld in new search list invalid",
			  ent->length - i),ent);
			return;
		}
		if(access(*names,amode)!=0){
			ok=FALSE;
			fprintf(stderr,"Can't open %s for %s\n",*names,
				amode==7?"read/write":"read");
			break;}
		amode = 5;
		l2 = strlen(*names++);
		if(l2>search_len)search_len = l2;
	}
	if(!ok){ /* failed */
		if(ent!=Search_list && Search_list!=NULL_ENTRY) {
			Recover("Invalid search list",NULL_ENTRY);
		}
		else S_terminate("Cannot set search list");
		return;
	}
	/* check whether the hash table could be out of date */
	if(Search_list!=NULL_ENTRY) {
		int need_clear = TRUE;
		/* things are safe ONLY if the new search list appends */
		/* to the old one */
		if(ent->length  >= Search_list->length) {
			long n = Search_list->length;
			char **p = ent->value.Char, **q = Search_list->value.Char;
			while(n--)if(!name_eq(*p++, *q++))break;
			if(n<0)need_clear = FALSE;
		}
		if(need_clear)add_exit((fun_ptr)clear_cache, 1L);
	}
	install_search(ent);
}

void
install_search(ent)
vector *ent;
/* actual installation of list; also called from check_frame0 & do_compact*/
{
	int diff = Search_list!=ent;
	Search_list = ent;
	Working_data = *(Search_list->value.Char);
	if(diff)make_dict_list((long)search_len);
}

static void 
make_dict_list(len)
long len;
{
	char *names, **p; vector *val; long n,i; int prev = set_alloc(FRAME0);
	names = S_alloc(len+13,1);
	for(n=0, p = Search_list->value.Char; n<Search_list->length;n++,p++) {
		strcpy(names,*p);
		i =strlen(names);
		strcpy(names+i,"/.dfile"); /* the file name */
		if(val = read_dict(names,(x_h **)NULL,0L)) { /* dictionary dataset:
			/* elements are: names, pos, hash */
			long dlen, *dpos, *dhash, np;char **dnames, *hn;
			vector **dp, *el; x_h **t;
			dp = val->value.tree;
			el = coevec(dp[0],CHAR,TRUE,TRUE);
			dlen = el->length; dnames = el->value.Char;
			el = coevec(dp[1],INT,TRUE,TRUE);
			dpos = el->value.Long;
			el = coevec(dp[2],INT,TRUE,TRUE);
			dhash = el->value.Long;
			np = dlen + dlen/2; nprime(&np);
			t = (x_h **)S_alloc(np,sizeof(x_h *));
			val = New_vector();
			val->value.Long = (long *)t; val->mode = INT;
			val->length = val->nalloc = np;
			for(;dlen>0;dlen--,dnames++,dpos++,dhash++) {
				hn = c_s_cpy(*dnames);
				hash_enter(hn, CHAR, *dpos, (*dhash)%np,
				  t, np);
			}
			dict_tables[n] = t; dict_lens[n] = np;
			dict_files[n] = fopen(names,"r");
		}
	}
	set_alloc((long)prev);
}
		
struct s_options S_options;

void 
set_options(list)
vector *list;
{
/* establish the in-memory copies of special options.  Note that all these should
/* be permanent storage, so that errors occuring in expressions that set options will
/* not leave pointers into hyper-space; see make_error for a way to handle this for
/* future additions (if any) to the set of known options */
	vector **pp;
	long n, nn;
	char *name;
	if(list==NULL_ENTRY)return;
	if(list->mode != LIST) {
		Warning("Object used to set options not a list -- ignored",list);
		return;
	}
	n=list->length;
	nn=n; pp=list->value.tree;
	while(nn--) {
		name = (*pp)->name;
		switch(*name) {
		case 's':
			if(name_eq("show",name))
				gr_show = logical_value(*pp,NULL_ENTRY);
			else if(name_eq("scrap",name))
				scrap = long_value(*pp,NULL_ENTRY);
			break;
		case 'e':
			if(name_eq("echo",name))
				S_echo_on = logical_value(*pp,NULL_ENTRY);
			else if(name_eq("error",name))
				make_error_code(*pp);
			else if(name_eq("expressions",name))
				expr_depth = long_value(*pp,NULL_ENTRY);
			break;
		case 'k':
			if(name_eq("keep",name)){
				name=(*pp)->length>0?string_value(*pp):"";
				if(name_eq(name,"function"))Data_hash=FUN_DEF;
				else if(name_eq(name,"any"))Data_hash=ANY;
				else Data_hash=0;
			}
			break;
		case 'p':
			if(name_eq("prompt",name)){
				name=(*pp)->length>0?string_value(*pp):"";
				strncpy(S_prompt,name,MAX_OPT_STRING);
			}
			break;
		case 'c':
			if(name_eq("continue",name)){
				name=(*pp)->length>0?string_value(*pp):"";
				strncpy(cont_prompt,name,MAX_OPT_STRING);
			}
			else if(name_eq("check",name))
				check = long_value(*pp,NULL_ENTRY);
			else if(name_eq("compact",name))
				Compact = long_value(*pp,NULL_ENTRY);
			break;
		case 'w':
			if(name_eq("width",name))S_p_width = long_value(*pp,NULL_ENTRY);
			else if(name_eq("warn",name))warn_level = long_value(*pp,NULL_ENTRY);
			break;
		case 'l':
			if(name_eq("length",name))S_p_length = long_value(*pp,NULL_ENTRY);
			break;
		case 'd':
			if(name_eq("digits",name))n_digits = long_value(*pp,NULL_ENTRY);
			break;
		case 'o':
			if(name_eq("object.size",name))max_block = long_value(*pp,NULL_ENTRY);
			break;
		case 'm':
			if(name_eq("memory",name))max_memory = long_value(*pp,NULL_ENTRY);
			break;
		case 'a':
			if(name_eq("audit.size",name))max_audit = long_value(*pp,NULL_ENTRY);
			break;
		case 'f':
			if(name_eq("free",name))free_level = long_value(*pp,NULL_ENTRY);
			break;
		}
		pp++;
	}
}

/* the initializer owns some global structure */
char *shome, *user_home;
int mainpid, running_S;
static char *stderr_buf = NULL_STRING;

void 
S_init()
{
	vector *opt;
	long i;
	/* initial options values */
	stderr_buf = Perm_alloc(BUFSIZ,1); setbuf(stderr,stderr_buf);
	S_echo_on = FALSE;
	S_p_width = 80, S_p_length = 48;
	n_digits = 7;
	Data_hash = FUN_DEF;
	max_block = 5000000; /* 5 megabytes */
	max_memory = 50000000; /* 50 megabytes */
	max_audit = 500000; /* 500 Kbtyes */
	gr_show = TRUE;
	check = FALSE;
	Compact = 1e5; scrap = 500;
	expr_depth = 256;
	set_alloc(PERM_FRAME); /* will bootstrap allocation, set to permanent */
	running_S = load_time[0]=='S';
	strcpy(S_prompt,"> ");
	shome = getenv("SHOME");
	if(IS_NULL_STRING(shome))
		S_terminate("Shell variable SHOME not in environment");
	user_home = getenv("HOME");
	if(IS_NULL_STRING(user_home))
		S_terminate("Shell variable HOME must be set to home directory");
	mainpid = getpid();
	cur_interact = isatty(0) && isatty(2); /* must start with both input &
		error messages on a terminal */
	frames_init(); /* initialize the evaluator objects */
	first_init_data(); /* datasets onto the datalist */
	make_formats(); /* the formats for numeric data */
	comp_init();
	error_code = blt_in_FALSE;
	clock_init();
	device_init();
	opt = get_data(".Options",ANY);
	if(opt!=NULL_ENTRY)set_options(opt);
	if(audit_file) {
		if((i=ftell(audit_file))>= max_audit)
			Warning(enci1("Audit file is %ld characters long.\nRun shell comand \"S TRUNC_AUDIT\" to truncate it",i),NULL_ENTRY);
		fprintf(audit_file,"#~New session: Time: %ld; Version: \"%s\"\n",
		time((long *)0), load_time);
	}
	init_load(); /* hash the initial load table */
	set_alloc(1L);
	min_brk = sbrk(0);
}

void 
check_data(what, verbose_p)
long *what; long *verbose_p;
{	/* this is a debugging routine, to be called via .C("check_data",i=T/F)
	/* It checks all frames if its argument is T, only current & global else
	/* each entry for each frame is checked for sanity (fatally) and for
	/* coming from the appropriate frame */
	long nfr, n, i, nd, nn, this_frame; int doall, err, verbose = *verbose_p; char *ch_buf;
	vector **datasets, **frames, *frame, *data;
	if(!Frames)Recover("No frames set",NULL_ENTRY);
	nfr = Frames->length;
	frames = Frames->value.tree;
	ch_buf =S_alloc(80L,1);
	this_frame = *what-1;
	doall = this_frame < 0;
	for(n= -1; n< nfr; n++) {
		if(n<0) frame = frame0;
		else frame = *frames++;
		if(!doall &&  n!=this_frame)continue;
		sprintf(ch_buf,"check_data: frame %ld",n+1);
		sanity(frame,ch_buf);
		if(verbose)fprintf(stderr,"%s, length %ld\n",ch_buf,frame->length);
		nd = frame->length; datasets = frame->value.tree; err = FALSE;
		for(i = 0; i < nd; i++, datasets++) {
			data = *datasets;
			sprintf(ch_buf,"check_data: frame %ld, object %ld",
			  n+1,i+1);
			nn = which_frame(data->x.frame);
			if(!data->name || !(*data->name)){
				fprintf(stderr,": no name for data:\n");
				deparse(data,stderr);
			}
			else if(data->x.frame!=frame){
				switch((int)nn) {
				case NO_FRAME: fprintf(stderr,"%s: object \"%s\" not protected\n",
					ch_buf,data->name);
					continue;
				case TO_FRAME0: fprintf(stderr,"%s: object \"%s\" from session frame\n",
					ch_buf,data->name);
					continue;
				case UNKNOWN_FRAME: fprintf(stderr,"%s: object \"%s\" from nonactive frame\n",
					ch_buf,data->name);
					continue;
				default: if(nn!=parent_frame[n+1]) fprintf(stderr,
					"%s: object \"%s\" is from frame %ld\n",ch_buf, data->name, nn);
				}
			}
		if(check_obj(data,NULL_STRING)){
			err=TRUE; *datasets = S_void;
			fputs(ch_buf,stderr);
			fprintf(stderr,"Error in object \"%s\"\n",data->name);
		}
		else if(verbose){
				fputs(ch_buf,stderr);
				fprintf(stderr,": data frame = %ld: ",nn);
				fprintf(stderr,"\"%s\" ok\n",data->name);
			}
		}
	if(err)fprintf(stderr,"Errors in frame %ld\n",nfr);
	fflush(stderr);
	}
	if(assign_data && (n=assign_data->length)>0){
		char **names = assign_data->value.Char;
		fputs("Marked for assignment:\n",stderr);
		while(n--){fputs(*names++,stderr);fputs("\n",stderr);}
	}
}

vector *
S_remove(ent, arglist)
vector *ent, *arglist;
{
	char **sets, *chapter, *file_path;
	long n = arglist->length, i, f, nn, prev;
	vector **args, *arg, *list, *frame;
	int which = sys_index;

	if(which==0 ? (n!=1) : (n!=2))
		Recover("Wrong number of args to .Internal for remove",ent);
	args = arglist->value.tree;
	arg =args[0];
	list = coevec(arg,CHAR,TRUE,PRECIOUS(arg)); n = list->length;
	arg = args[1];
	switch(which) {
	case 0:
		for(i = 0, sets = list->value.Char; i<n; i++, sets++)
			srch_and_rm(*sets);
		break;
	case 1: /* frame */
		f = long_value(arg,NULL_ENTRY);
		if(f<0 || f>Frames->length)
			Recover(enci1("Invalid frame number: %ld",f),NULL_ENTRY);
		if(f==0) { frame = frame0; prev = set_alloc(FRAME0);}
		else {frame = Frames->value.tree[f-1]; prev = set_alloc(f);}
		for(i = 0, sets = list->value.Char; i<n; i++, sets++){
			if(f) {
				nn = x_which_comp(*sets,frame);
				if(nn<1)Warning(encs1("Object \"%s\" not found on frame for removal",*sets),NULL_ENTRY);
			}
			else {
				long nn0;
				nn0 = to_frame0->length ? x_which_comp(*sets,h_S_data) : 0;
				nn = x_which_comp(*sets,frame0);
				if(nn && nn0 )del_comp(h_S_data,nn0);
				else if(nn0){ frame = h_S_data; nn = nn0;}
				else if(nn<1)Warning(encs1("Object \"%s\" not found on frame 0 for removal",*sets),NULL_ENTRY);
			}
			if(nn) { vector *obj = frame->value.tree[nn-1];
				del_comp(frame,nn);
				try_to_free(obj,TRUE);
				f = parent_frame[f];
				if(**sets == '.' && check_assign(f,*sets,NULL_ENTRY)) {
					/* there is no blocking version, so we should set
					/* values from the visible version */
					obj = find_data(*sets,ANY,TRUE,NULL_ENTRY);
					if(obj) check_assign(f,*sets,obj);
					else Warning(encs1("Can't find version of \"%s\" to restore internal values",*sets),NULL_ENTRY);
				}
				
			}
		}
		set_alloc(prev);
		break;
	case 2: /* where */
		if(arg->mode == CHAR) chapter = string_value(arg);
		else {
			i = long_value(arg,NULL_ENTRY);
			if(i<1 || i > Search_list->length)
				Recover(enci1("Argument	arg (%ld) not in the range of elements of search list",i),NULL_ENTRY);
			chapter = Search_list->value.Char[i-1];
		}
		for(i = 0, sets = list->value.Char; i<n; i++, sets++) {
			file_path = encs2("%s/%s",chapter,*sets);
			if(!access(file_path,2)){
				if(unlink(file_path))
				   Warning(encs1("Could not remove \"%s\"",
				     *sets), NULL_ENTRY);
			}
			else if(!access(file_path,0))
				Warning(encs1("\"%s\" exists but doesn't have write permission",*sets),NULL_ENTRY);
			else Warning(encs1("Object \"%s\" not found",*sets),NULL_ENTRY);
		}
		break;
	default: Recover(enci1("Invalid internal code (%ld) to remove()",(long)which),NULL_ENTRY);
	}
	return(S_void);
}

void 
do_rm(ent)
vector *ent;
{
	vector **p, *arg;
	long n, nn; char **sets, *set;
	for(n = Nargs(ent), p = Args(ent); n>0; n--, p++) {
		arg = *p;
		if(VOID(arg))continue;
		switch(arg->mode) {
		case NAME:
			sets = &(arg->value.name); nn = 1;
			break;
		default:
			arg = coevec(arg,CHAR,TRUE,PRECIOUS(arg));
			sets = arg->value.Char; nn = arg->length;
		}
		while(nn--) {
			set = *sets++;
			srch_and_rm(set);
		}
	}
}

static void 
srch_and_rm(set)
char *set;
{
	long pos;
	vector dummy; char *msg;
	char *file_path = encs2("%s/%s", Search_list->value.Char[0], set);

	if(!access(file_path, 6)) {
		file = fopen(file_path,"r"); msg = read_header(New_vector());
		close_file(file);
		if(msg) {
			Warning(encs2("\"%s\" not removed: %s",set,msg),NULL_ENTRY);
			return;
		}
		if(unlink(file_path)) {
			Warning(encs1("Could not remove \"%s\"", set), NULL_ENTRY);
			return;
		}
		fix_hash(set);
		if(*set == '.' && check_assign(0L,set,NULL_ENTRY)) {
			vector *obj;
			/* there is no blocking temporary version, so we should reset
			/* values from the permanent version */
			obj = find_data(set,ANY,TRUE,NULL_ENTRY);
			if(obj) check_assign(0L,set,obj);
			else Warning(encs1("Can't find version of \"%s\" to restore internal values",set),NULL_ENTRY);
		}
	} else if(!access(file_path, 0))
		Warning(encs1("\"%s\" exists but without write permission",set), NULL_ENTRY);
	else if(do_search(set, ANY, &dummy, FALSE, FALSE, &pos) != NULL)
		Warning(encs1("\"%s\" not on working database: not allowed to remove it",set),NULL_ENTRY);
	else
		Warning(encs1("Object \"%s\" not found", set), NULL_ENTRY);
}

static void 
fix_hash(set)
char *set;
{
	vector *pp;
	if(get_hash(set, ANY) != NULL) {
		un_hash(set, CHAR, Data_h_table, Data_h_length);
		if(*set == '.')
			if((pp = get_data(set, ANY)))
				check_assign(CACHE_FRAME, set, pp);
	}
}

static char *buf, *ptr; static long line_len; static int file_eof;

void 
S_rd_line(strings,nitem)
char **strings; long *nitem;
{
	long n = *nitem,i; int empty, c;
	char *buf, *p;
	if(cur_interact){
			fprintf(stderr,"%ld: ",n); /* prompt */
			fflush(stderr);
		}
	buf = S_alloc((long)BUFSIZ,1); n = BUFSIZ; i=0; p = buf; empty=TRUE;
	while( (c=getc(stdin))!='\n' && c!=EOF) {
		if(++i >= n){
			buf = S_realloc(buf,2*n,n,1); n *= 2;
			p = buf + i -1;
		}
		*p++ = c; empty=FALSE;
	}
	*p = '\0';	
	if(c==EOF || empty) *nitem = -1;
	*strings = buf;
}		

static int flush_record, multi_line, scan_prompt, exit_on_empty, sep;
static int iline, iitem;

static int 
na_fld(p,l)
char *p; double *l;
{
	while(*p == ' ')p++;
	if(sep && *p == sep)
		{ na_set(l); return(TRUE);}
	if(p[0] == 'N' && p[1] == 'A' && (isspace(p[2]) || p[2] == '\0'))
		{ na_set(l); return(TRUE);}
	else return(FALSE);
}

static int 
na_fld2(p,l)
char *p; complex *l;
{
	while(*p == ' ')p++;
	if(sep && *p == sep)
		{ na_set(l); return(TRUE);}
	if(p[0] == 'N' && p[1] == 'A' && (isspace(p[2]) || p[2] == '\0'))
		{ na_set(l); return(TRUE);}
	else return(FALSE);
}
vector *
S_scan(ent, arglist)
vector *ent, *arglist;
{
	char *p;
	long nmax, nfield, i, n;
	int ok, append;
	complex *cx;
	vector **args = arglist->value.tree, *value, **fields, *field;
	path = string_value(args[0]);
	if( *path == '\0') {
		file = stdin;
		setbuf(stdin, NULL_STRING);/* no buffering to avoid interference */
	} else {
		if((file=fopen(path,"r"))==NULL)
			Recover(encs1("Can't open file \"%s\" for reading",
			  path),NULL_ENTRY);
		add_error((fun_ptr)read_error);
	}
	scan_prompt = cur_interact && !*path;
	line_len = BUFSIZ/2; /* this could be an argument to the function */
	buf = S_alloc(line_len+2,1); buf[line_len] = '\n';
	ptr = buf+line_len; file_eof=FALSE; /* to initialize reader*/
	nmax = long_value(args[2],ent); if(nmax<0)nmax = INTEGER_MAX;
	sep = *string_value(args[3]);
	multi_line = logical_value(args[4],ent);
	exit_on_empty = scan_prompt && !multi_line;
	flush_record = logical_value(args[5],ent);
	append =logical_value(args[6],ent);
	value = args[1]; /* the list giving the pattern */
	if(PRECIOUS(value)) value = copy_data(value,NULL_ENTRY);
	MEANINGFUL(nfield);
	if(atomic_type(value->mode)) { /* just one field */
		nfield = 1;
		args = &value;
	}
	else if(value->mode!=LIST)
		Recover("The \"what\" argument should be a list",NULL_ENTRY);
	else {
		nfield = value->length;
		args = value->value.tree;
	}
	if(!append) for(n=nfield, fields = args; n>0; n--, fields++)
		(*fields)->length = 0;
	for(n=nfield, fields = args; n>0; n--, fields++){
		switch((*fields)->mode) {
		case INT: case REAL:
			coevec(*fields,DOUBLE,FALSE,FALSE); break;
		case LGL:
			Recover("mode \"logical\" not allowed",NULL_ENTRY);
		}
	}
	iline  = 0; iitem = 1;
	while(nmax>0) { /*loop over records */
		fields = args; n = nfield;
		while(n--) { /* loop over fields */
			if(!*ptr || *ptr == '\n') {/* buf empty */
				if(nfield-n>1 && !multi_line)
				  Recover(enci2("Less than %ld fields on line %ld",nfield,(long)iline),NULL_ENTRY);
				file_eof = igets()==EOF; ptr = buf;
			}
			if(file_eof){nmax = 0; break;}
			field = *fields++;
			if((i=field->length) < field->nalloc)
				(field->length)++;
			else if(field->mode == NULL){}
			else append_data(field,i,1L,(char *)field->value.Long);
			switch(field->mode) {
			case DOUBLE:
				ok =  na_fld(ptr,(field->value.Double+i)) ||
				  sscanf(ptr,"%lf",field->value.Double+i)==1;
				if(!ok)bad_fld(field->mode);
				nxt_fld();
				break;
			case CHAR:
				p = rd_string();
				if(!p){nmax = n = 0; field->length--;}
				else field->value.Char[i] = p;
				break;
			case COMPLEX:
				cx = field->value.Complex+i;cx->im = 0.;
				ok =  na_fld2(ptr,(field->value.Complex+i)) ||
				  sscanf(ptr,"%lf%lfi",&(cx->re),&(cx->im))==2 ||
				  sscanf(ptr,"%lf",&(cx->re))==1;
				if(!ok)bad_fld(field->mode);
				nxt_fld();
				break;
			case NULL:
				nxt_fld(); iitem--;
				break;
			default:
				Recover(encs1("Invalid mode (%s) in field for scan()",token_name(field->mode)),NULL_ENTRY);
			}
			nmax--; iitem++;
		}
		if(flush_record)ptr = ""; /* force new line next time */
	}
	if(nmax<0)Warning(enci1("Read %ld extra items to fill all fields",
		-nmax),NULL);
	if(file!=stdin) { del_error((fun_ptr)read_error); fclose(file);}
	else clearerr(stdin);
	return(value);
}

#define sgetc (*ptr ? (int)*ptr++ : igets())
#define unsgetc ptr--
#define nextchar *ptr
#define SMALL_STRING 16
static char *

get_line()
/* line_len, buf, and ptr are global for other reasons */
/* They all may be changed by this routine */
{
	int i;
	char c = '\0' ;
	int nread = 0 ;
	while ((i=getc(file))!=EOF && (c=(char)i)!='\n') {
		if (nread >= line_len) {
			/* The global ptr must be kept in sync with buf */
			int ptrdiff = ptr - buf ;
			buf = S_realloc(buf, line_len*2+2, line_len+2, sizeof(char)) ;
			ptr = buf + ptrdiff ;
			line_len *= 2 ;
		}
		buf[nread++] = c ;
	}
	buf[nread++] = '\n' ; buf[nread] = '\0' ;
	/* nread will be one more than number read */
	/* nread will be 1 if nothing was read before EOF */
	/* nread>1 and i=EOF if last line contained data but no \n */
	/* This should mimic fgets's return value */
	return((nread==1 && c!= '\n')?NULL:buf) ;
}

static int 
igets()
{
	while(TRUE) {
		if(cur_interact && !*path){fprintf(stderr,"%ld: ",iitem);fflush(stderr);}
		buf[line_len] = '\n'; /* in case of truncation, put in the newline*/
		iline++;
		if(!get_line()
			|| exit_on_empty && *buf == '\n'){file_eof=TRUE;return(EOF);}
		for(ptr = buf; *ptr != '\n'; ptr++)if(!isspace(*ptr))break;
		if(*ptr != '\n'){ptr = buf+1; return(*buf);}
	}
}

static void 
nxt_fld()
{
	/*  move over a field: possible leading space, then a span of */
	/*  non-spaces, then possible trailing space */
	/*  This is not appropriate for a field that can cross a line
	/*  or have internal space */
	int c;
	if(!*ptr)return;
	if(sep) {
		while((c = *ptr)!=sep){if(c=='\n' || !c)return; ptr++;}
		ptr++; /* skip over ONE sep character only */
	} else {
		while((c = *ptr)==' ' || c=='\t')ptr++;
		while(!isspace((c = *ptr))){if(!c)return; ptr++;}
		while((c = *ptr)==' ' || c=='\t')ptr++;
	}
}

static void 
bad_fld(mode)
int mode;
{
	char *field; long n;
	fprintf(stderr,"Data undecipherable, line %ld",iline);
	if(*path)fprintf(stderr," of file %s\n",path);
	else fputs("\n",stderr);
	if((n=strlen(ptr))>15)strcpy(ptr+12,"...");
	else ptr[n-1] = '\0'; /* get rid of new line */
	field = do_unlex(ptr);
	fprintf(stderr,"Field contains %s\n",field);
	Recover(
	 encs1("Can't interpret field as mode %s",token_name(mode)),NULL_ENTRY);
}

/* following is like makestring() in yylex.l */
/* but uses the local string getting code  */
static char *
rd_string()
{
	int c,quote; long limit,current; char *string;
	if(!sep) {
		while( (quote = sgetc)!=EOF && isspace(quote)){}
		if(quote != '"' && quote !='\''){unsgetc;quote = ' ';}
	}
	else quote = sep;
	limit=SMALL_STRING; current = 0;
	string = S_alloc((long)SMALL_STRING, sizeof(char) );
	while( (c=sgetc) != quote) {
		if(c == EOF) {
			if(current)Recover("End of file in character field in input",NULL_ENTRY);
			return(NULL);
		}
		if(c=='\n') {
			if(quote == '"' || quote== '\'' )
				Recover("New line in string not allowed",NULL_ENTRY);
			break;
		}
		if(c=='\t' && quote == ' ')break; /*white space*/
		if(c == '\\')  { /* escaped characters */
			c=sgetc;
			if(isdigit(c) ) {
				int i; char cc;
				unsgetc; c=0;
				for(i=0; i<4 && isdigit((cc=sgetc)) ; i++)
					c = 8*c + (cc - '0');
				if(i<4)unsgetc;
				}
			else switch(c) {
			case 'n': c='\n'; break;
			case 't': c='\t'; break;
			case 'b': c='\b'; break;
			case 'r': c='\r'; break;
			}
		}
		*(string + current++) = c;
		if(current >= limit) {
			string = S_realloc(string, limit * 2,limit ,sizeof(char));
			limit *= 2;
		}
	}
	*(string + current) = '\0';
	return(string);
}

static void 
make_error_code(ent)
vector *ent;
{
	vector *err_expr,*p;
	if(ent->length<1) { error_code = blt_in_FALSE; return; }
	switch(ent->mode) {
	case PARSE:
		err_expr = ent; break;
	case FUN_DEF:
		err_expr = alcvec(PARSE,1L);
		err_expr->value.tree[0] = p = alcvec(FUN_CALL,1L);
		p->value.tree[0] = ent; break;
	default:
		if(!LANGUAGE_TYPE(ent->mode)) {
			Warning("Non-expression for option error ignored",ent); 
			err_expr = NULL; break;
		}
		err_expr = alcvec(PARSE,1L);
		err_expr->value.tree[0] = ent;
	}
	if(cur_frame>1)set_data(Local_data,err_expr,".Error");
	else frame0_assign(".Error",err_expr);
	error_code = blt_in_TRUE;
}

static void 
setup_fun(body)
vector *body;
/* modify a function being hased to make it faster; namely,
/* look up any .Internal's it references */
{
	long mode = body->mode;
	if(mode == INTERNAL) {
		vector *routine = body->value.tree[1];
		body->value.tree[1] = internal_symbol(routine);
		
	}
	else if( LANGUAGE_TYPE(mode) && !NOT_RECURSIVE(mode)) {
		vector **children; long n;
		for(n=body->length, children=body->value.tree; n>0;
		    n--, children++)setup_fun(*children);
	}
}

/* return interactive flag -- for function interactive() */
void 
interactive(log)
long *log;
{
	*log = cur_interact;
}

/* put a message on the audit file */
void 
stamp_audit(string)
char **string;
{
	if(audit_file) fprintf(audit_file,"#~stamp %s\n",*string);
}

/* assign for random number seeds */
/* puts a pseudo-statement on the audit file so that an expression */
/* using random numbers can be re-executed and get the same result */

static void 
Random_assign()
{
	char *name = ".Random.seed";
	vector *ent;
	Random_flag = FALSE;
	ent = xact_comp(S_data,name);
	if(!ent) Recover("No value for .Random.seed",NULL_ENTRY);
	if(audit_file) {
		fputs("#~\n.Random.seed <- ", audit_file);
		deparse(ent, audit_file);
	}
	put_data(name, Working_data, ent);
	/* hash according to option `keep'*/
	if(do_hash(ent))put_hash(name,ent);
	else if(get_hash(name,ANY)) /* delete old hashed version */
		un_hash(name,CHAR,Data_h_table,Data_h_length);
}

void
check_frame(nframe,msg)
long nframe; char *msg;
{
	long i,n; vector **p, *frame; int err;
	if(nframe>1)frame = Frames->value.tree[nframe-1];
	else if(nframe==FRAME0)frame = h_S_data;
	else frame = S_data;
	n = frame->length; p = frame->value.tree; err = FALSE;
	for(i=0; i<n; i++,p++)
		if(check_obj(*p,NULL_STRING)){ *p = S_void; err = TRUE;}
	if(err)Recover(encs2("Errors in frame %s, %s", enci1("%ld",cur_frame),msg)
		,NULL_ENTRY);
}

int
check_obj(v,set)
vector *v; char *set;
{
	long i,n; vector **p; char *msg, *name; int err;
	msg = sanity(v,NULL_STRING);
	if(msg) {
		if(*msg == 'T')name = "<unknown name>";
		else name = v->name ? v->name : "";
		if(set != NULL_STRING) fprintf(stderr,"Error: %s, in element \"%s\", somewhere in object \"%s\"\n",
			msg, name, set);
		else fprintf(stderr,"Error: %s, in object \"%s\"\n",msg,name);
		fflush(stderr);
		return(TRUE);
	}
	if(NOT_RECURSIVE(v->mode))return(FALSE); /* not data_mode() */
	name = v->name ? v->name : "";
	n = v->length; p = v->value.tree; err = FALSE;
	for(i=0; i<n; i++, p++)
		if(check_obj(*p,name)) err = TRUE;
	return(err);
}

/* test for a special
/* class-dependent version  of a function call */
vector *
class_fun(group_name, call_name,old_call, arglist)
char *group_name, *call_name; vector *old_call, *arglist;
{
	vector *object, *class_attr, **args, *Class;
	char *fname, *class_name; int by_group;
	args = arglist->value.tree; object = args[0];
	if(object->mode != STRUCTURE ||
		!(class_attr = xact_comp(object,"class")))
			return(NULL_ENTRY);
	if((Class = xact_comp(Local_data,".Class")) /* if in a method */
	  && !(class_attr = find_class(class_attr, string_value(Class))))
		class_attr = Deflt_class();
	if(!call_name || !*call_name) {
		vector *def;
		if(data_mode(old_call)!=FUN_CALL) {
			Warning("unable to determine function name",old_call);
			return(NULL_ENTRY);
		}
		def = old_call->value.tree[0];
		if(data_mode(def)!=FUN_DEF)call_name = string_value(def);
		else {
			Warning("unable to determine function name",old_call);
			return(NULL_ENTRY);
		}
	}
	fname = find_method(call_name, group_name, &class_attr, &by_group);
	if(fname) {
		vector *method, *group, *generic, *p, *frame;
		method = alcvec(CHAR,1); method->value.Char[0] = fname;
		generic = alcvec(CHAR,1); generic->value.Char[0] = call_name;
		group = alcvec(CHAR,1); group->value.Char[0] = by_group ? group_name : "";
		p = class_call(call_name,old_call, arglist, &frame, group_name);
		set_for_method(frame,class_attr,method,generic,group);
		return(p);
	}
	else return(NULL_ENTRY);
	
}

vector *
class_method(object, call_name, class_attr, old_call, frame,which)
char *call_name; long which;
vector *object, *class_attr, *old_call, *frame;
{
	vector *p = class_attr, *method, *group, *generic; long i;
	int by_group = FALSE; char *group_name = NULL_STRING;
	char *fname;
	if(which==1) p = class_inheritor(p); /* NextMethod */
	fname = find_method(call_name, group_name, &p, &by_group);
	if(!fname)return(NULL_ENTRY);
	method = alcvec(CHAR,1); method->value.Char[0] = fname;
	if(which>1)return(method);
	generic = alcvec(CHAR,1); generic->value.Char[0] = call_name;
	group = alcvec(CHAR,1); group->value.Char[0] = by_group ? group_name : "";
	set_for_method(Local_data,p,method,generic,group);
	return(saved_method);
}

static vector *
get_method(name,obj)
char *name; vector *obj;
{
	if(!obj) obj = get_data(name,ANY);
	if(!obj)return(NULL_ENTRY);
	obj = coevec(obj,ANY,FALSE,FALSE);
	switch(obj->mode) {
	case PARSE:
		if(obj->length>0)return(obj->value.tree[0]);
		else return(obj);
	case FUN_DEF:
		return(obj->value.tree[obj->length-1]);
	default:
		if(!LANGUAGE_TYPE(obj->mode))Warning("Expected an expression for a method",obj);
		return(obj);
	}	
}

vector *
class_op(group_name, call_name,call, arglist)
char *group_name, *call_name; vector *call, *arglist;
{
	vector *object, *class_attr, *class2, **args, *class_fun, *method;
	char *fname, *fn2, **methods, *class_name;
	int by_group,by_group2; long n, i, which;
	if(!call_name || !*call_name)
		call_name = string_value(call->value.tree[0]);
	if(class_attr = xact_comp(Local_data,".Class")) /* if in a method */
		class_name = string_value(class_attr);
	else class_name = NULL_STRING;
	args = arglist->value.tree; n = arglist->length;
	fname = (char *)NULL;
	for(i = 0; i < n; i++) {
		object = args[i];
		if(object->mode != STRUCTURE) continue;
		if(!(class_attr = xact_comp(object,"class"))) continue;
		if(class_name  && !(class_attr == find_class(class_attr,class_name)))
			class_attr = Deflt_class();
		if(!(fn2 = find_method(call_name, group_name, &class_attr, &by_group2)))
			continue;
		if(!fname) { /* first method found */
			method = alcvec(CHAR,n); methods = method->value.Char;
			method->name = ".Method"; /*the names of the methods */
			fname = methods[i] = fn2; by_group = by_group2;
			class_fun = saved_method;
		}
		else if(name_eq(fname, fn2)) methods[i] = fname;
		else if(by_group && !by_group2) { /* use the new method instead */
			long j;
			for(j=0; j<i; j++ ) methods[j] = "";
			fname = methods[i] = fn2; by_group = FALSE;
			class_fun = saved_method;
		}
		else return(NULL_ENTRY); /* incompatible methods */
	}
	saved_method = class_fun; /* restore the correct method expression */
	if(fname) {
		vector *group, *generic, *p, *frame;
		generic = alcvec(CHAR,1); generic->value.Char[0] = call_name;
		group = alcvec(CHAR,1); group->value.Char[0] = by_group ? group_name : "";
		p = class_call(call_name,call, arglist, &frame, group_name);
		set_for_method(frame,class_attr,method,generic,group);
		return(p);
	}
	else return(NULL_ENTRY);
}

static void
fix_object(arglist,class_attr,which)
vector *arglist, *class_attr; long which;
{
	vector **args, *object, *new_obj; long nargs, i;
	nargs = arglist->length; args = arglist->value.tree;
	object = args[which];
	if(object->mode != STRUCTURE || !(i = x_which_comp("class",object)))
		Recover("Invalid object for method",object);
	new_obj = alcvec(STRUCTURE, object->length);
	MEMCPY(new_obj->value.tree,object->value.tree,object->length);
	new_obj->value.tree[i-1] = class_attr; new_obj->name = object->name;
	if(PRECIOUS(arglist))set_data(arglist,new_obj,object->name);
	else args[which] = new_obj;
}

static vector *
class_call(call_name, old_call, arglist,frame_p,group_name)
char *call_name, *group_name;
vector *old_call, *arglist, **frame_p;
{
	extern vector *quick_args();
	vector *body;
	vector *object, *frame, **args;
	 /* fill in the args from the original call*/
	frame = *frame_p = quick_args(arglist, group_name);
	body = saved_method;
	if(frame==Local_data)return(body); /* just evaluate it in the current frame */
	if(data_mode(old_call)!=FUN_CALL) { /* the case of replacements ?? */
		old_call = alcvec(FUN_CALL,1);
		old_call->value.tree[0] = alc_name(call_name);
	}
	object = alcvec(FRAME,3); /* a frame object to be evaluated */
	args = object->value.tree;
	args[0] = body;
	args[1] = frame;
	args[2] = old_call;
	set_precious(object,Local_data); /* ?? */
	return(object);
}


static char *
method_name(fun,class)
char *fun, *class;
{
	long n1, n2; char *buf;
	n1 = strlen(fun); n2 = strlen(class);
	buf = S_alloc(n1+n2+2,1);
	strcpy(buf,fun);
	buf[n1] = '.';
	strcpy(buf+n1+1,class);
	return(buf);
}

static char *
find_method(fname, group_name, p_class_attr, p_by_group)
char *fname, *group_name; vector **p_class_attr; int *p_by_group;
{
	char *class_fun, *class_name; vector *class_attr, *this, **els;
	int found, more; long i, n;
	class_attr = *p_class_attr; found = FALSE;
	this = coevec(class_attr,ANY,FALSE,FALSE);
	if(this->mode == CHAR && this->length==1)
		{n = 1; els = &this;}
	else {
		this = coevec(this, LIST, TRUE, PRECIOUS(class_attr));
		n = this->length; els = this->value.tree;
	}
	for(i=0; i<n && !found;i++) { /* look for a method at this level */
		class_name = string_value(els[i]);
		class_fun = method_name(fname, class_name);
		saved_method = get_method(class_fun,NULL_ENTRY);
		if(!saved_method) {/* put in a dummy definition */
			dummy_hash(class_fun);
			
		}
		else if(saved_method->length != 0 ) { /* not the dummy */
			*p_by_group = 0;
			found = TRUE;
		}
		if(!found && group_name && *group_name) {
			class_fun = method_name(group_name, class_name);
			saved_method = get_method(class_fun,NULL_ENTRY);
			if(!saved_method) {/* put in a dummy definition */
				dummy_hash(class_fun);
				
			}
			else if(saved_method->length != 0 ) {
				*p_by_group = 1;
				found = TRUE;;
			}
		}
	}
	if(found) return(class_fun);
	 /* look at the earlier inheritance by calling me recursively */
	if(class_attr->mode!=STRUCTURE || !xact_comp(class_attr,"inheritance"))
		return(NULL_STRING);
	class_attr = class_inheritor(class_attr);
	class_fun = find_method(fname, group_name, &class_attr, p_by_group);
	if(class_fun) {
		*p_class_attr = class_attr;
	}
	return(class_fun);
}

static void
dots_in_frame(frame,i,nargs)
vector *frame; long i, nargs;
{
	vector * dots; long ndots;
	ndots = frame->length -  nargs + 1;
	dots = alcvec(LIST,ndots);
	MEMCPY(dots->value.tree,frame->value.tree+i,ndots);
	dots->name = "...";
	frame->value.tree[i] = dots;
	frame->length -= ndots - 1;
}

/* hash_enter a dummy expression (used for methods) */
static void
dummy_hash(name)
char *name;
{
	vector *new;
	long index, pos, prev;
	cache_ok = TRUE; prev = set_alloc(CACHE_FRAME);
	pos = -1L; /* force hash_enter to rehash (& replace) */
	new = alcvec(PARSE,0); new->name = S_alloc(strlen(name)+1,1);
	strcpy(new->name,name);
	index  = (long)new;
	hash_enter(name,CHAR,index,pos,Data_h_table,Data_h_length);
	set_alloc(prev); cache_ok = FALSE;
}


static vector *
class_inheritor(class_attr)
vector *class_attr;
{
	vector *ancestor, *new, *prev, **vals, *p;
	int simple;
	simple = (class_attr->mode != STRUCTURE ||
	   !(ancestor = xact_comp(class_attr,"inheritance")) ||
	   ((ancestor = coevec(ancestor,LIST,FALSE,CHECK_IT))->length<1));
	new = simple ?Deflt_class() :
	  copy_data(ancestor->value.tree[0],NULL_ENTRY);
	prev = copy_data(class_attr,NULL_ENTRY);
	prev->name = "previous";
	if(new->mode == STRUCTURE) {
		long i;
		i = x_which_comp(new,"previous");
		if(i>0) /* rather odd: should we warn? */
			new->value.tree[i-1] = prev;
		else append_el(new, new->length, prev);
	}
	else {
		p = new; new = alcvec(STRUCTURE,2); vals = new->value.tree;
		vals[0] = p; p->name = ".Data";
		vals[1] = prev;
	}
	new->name = "class";
	return(new);
}

vector *
get_next_method(object,old_call)
vector *object, *old_call;
{
	char *name, *call_name, *group_name; long i,n; int by_group;
	vector *class, *call, *group, *p, *frame,*method, **args, *def;
	if(!(class = xact_comp(Local_data,".Class")))
		Recover("called from outside a method (no \".Class\" in frame)",NULL_ENTRY);
	name = string_value(class);
	group = xact_comp(Local_data,".Group");
	if(!group)
		Recover("called from outside a method (no \".Group\" in frame)",NULL_ENTRY);
	group_name = string_value(group);
	if(!(call = xact_comp(Local_data,".Generic")))
		Recover("called from outside a method (no \".Generic\" in frame)",NULL_ENTRY);
	call_name = string_value(call);
	if(!object) class = class_inheritor(class);
	else if(object->mode!=STRUCTURE ||
		!(object = xact_comp(object,"class")) ||
		 !(class = find_class(object,name)))
		class = Deflt_class();
	if(!(name = find_method(call_name,group_name,&class,&by_group)))
		{name = call_name; class = Deflt_class();}
	if(!(p = xact_comp(Local_data,".Method"))) 
		Recover("called from outside a method (no \".Method\" in frame)",NULL_ENTRY);
	method = alcvec(CHAR,(n=p->length));
	for(i=0; i<n; i++) if(*(p->value.Char[i])) method->value.Char[i] = name;
	def = coevec(get_data(name),ANY,FALSE,FALSE);
	if(!def || !(p = get_method(name,def))) 
		PROBLEM "method \"%s\" is supposed to exist but doesn't", name
		RECOVER(NULL_ENTRY);
	frame = quick_args(blt_in_empty,NULL_STRING); /* sets up a new frame*/
	set_for_method(frame,class,method,call,group);
	object = alcvec(FRAME,def->mode == FUN_DEF ? 4 : 3); /* a frame object to be evaluated */
	args = object->value.tree;
	args[0] = p;
	args[1] = frame;
	args[2] = next_call(old_call,def);
	if(def->mode == FUN_DEF)args[3] = def;
	set_precious(object,Local_data);
	return(object);
}


static vector *
find_class(class_attr,name)
vector *class_attr; char *name;
{
	int is_char; long i,n; vector *this, **els; char *this_name;
	this = coevec(class_attr,ANY,FALSE,FALSE);n = this->length;
	if((is_char = this->mode == CHAR) && n==1 && name_eq(this->value.Char[0],name))
	/* the usual case ... */ return(class_attr);
	if(!is_char) {
		this = coevec(this, LIST, TRUE, PRECIOUS(class_attr));
		els = this->value.tree;
	}
	for(i=0; i<n;i++) { /* look for the name at this level */
		if(is_char) this_name = this->value.Char[i];
		else this_name = string_value(els[i]);
		if(name_eq(name,this_name))
			if(is_char) {
				vector *new = alcvec(CHAR, n-i);
				MEMCPY(new->value.Char, this->value.Char+i,n-i);
				return(new);
			}
			else return( els[i]);
	}
	if(is_char)return(NULL_ENTRY);
	/* try the antecedents	*/
	for(i=0; i<n; i++)
		if(this=find_class(els[i],name))return(this);
	return(NULL_ENTRY);
}

static void
set_for_method(frame,class,method,generic,group)
vector *frame, *class, *method, *generic, *group;
{
	set_data(frame, class, ".Class");
	set_data(frame, method, ".Method");
	set_data(frame, generic, ".Generic");
	set_data(frame, group, ".Group");
}

static vector *Deflt_class()
{
	if(!deflt_class) {
		long prev = set_alloc(PERM_FRAME);
		deflt_class = alcvec(CHAR,1);
		deflt_class->value.Char[0] = "default";
		deflt_class->name = "class";
		deflt_class->x.frame = cons_frame;
		set_alloc(prev);
	}
	return(deflt_class);
}

static vector *
next_call(call,def)
vector *call, *def;
{
	vector *new, **p, **q; long i, n;
	if(def->mode != FUN_DEF)return(call);
	n = n=call->length; new = alcvec(FUN_CALL,n);
	p = new->value.tree; p[0] = call->value.tree[0];
	for(i=0, p++, n--, q=def->value.tree; i<n; i++)
		p[i] = alc_name((q[i])->name);
	return(new);
}
