#include <stdio.h>
#include <math.h>
#include "S.h"
#include "dist.h"
#include "y.tab.h"

vector *S_ranfuns(), *S_sample();
int seedin(), seedot();

static do_ranfun(), cseedi(), cseedo(); 
static double xuni(), rnorm(); 
static unsigned long congrval, lambda;
static unsigned long tausval;

vector
*S_ranfuns(ent, arglist)
vector *ent, *arglist;
{
	vector *x, *par1, *par2, **args = arglist->value.tree;
	int which = sys_index;
	long nn, l;
	float *f;

	x = coevec(args[0], INT, TRUE, CHECK_IT);
	if(VOID(x))
		Recover("Argument n not numeric",ent);
	if(x->length>1)nn = x->length;
	else nn = *(x->value.Long);
	if(nn<1)
		Recover(enci1("Sample size = %ld; should be >0",nn), ent);
	x = alcvec(REAL,nn);
	par1 = coevec(args[1],REAL,TRUE,CHECK_IT);
	if(VOID(par1))Recover("Argument \"par1\" not numeric",ent);
	par2 = coevec(args[2],REAL,TRUE,CHECK_IT);
	if(VOID(par2))Recover("Argument \"par2\" not numeric",ent);
	l = par2->length; f = par2->value.Float;
	while(l--)if(which==NORM_DIST && (*f++)<0.)
			Recover("Can't have negative second parameter",ent);
	seedin(); /*get random seed */
	do_ranfun(x->value.Float,nn,par1->value.Float,par1->length,
	  par2->value.Float,par2->length,which);
	seedot(TRUE); /*put random seed */
	return(x);
}

static do_ranfun(x, n, par1, len1, par2, len2, which)
float *x, *par1, *par2;
long n, len1, len2;
int which;
{
	float *t1 = par1, *t2 = par2, *end1 = par1+len1, *end2 = par2+len2;

	switch(which) {
	case NORM_DIST:
		while(n--){
			*x++ = rnorm()*(*t2) + *t1;
			if(++t1 >= end1) t1 = par1;
			if(++t2 >= end2) t2 = par2;
		}
		break;
	case UNIF_DIST:
		while(n--){
			*x++ = xuni()*(*t2-*t1) + *t1;
			if(++t1 >= end1) t1 = par1;
			if(++t2 >= end2) t2 = par2;
		}
		break;
	default:
		Recover(enci1("Unknown code for random number generator (%ld)",(long)which),NULL_ENTRY);
	}
}

/*  Random Normal (Kinderman & Monahan, Proc. ASA Comp) */
static double rnorm()
{
	double rnormk, u, x2;

	do {
		u = xuni();
		rnormk = 1.715527769*(xuni()-.5)/u;
		x2 = rnormk*rnormk/4.;
		if(x2<=1.-u) break;
	}
	while(x2 > -log(u));
	return(rnormk);
}

/*
 * convert seeds base 64 to congruential and
 * tausworthe shift values, and initialize multiplier
 */
static cseedi(seeds)
long *seeds;
{
	int i;
	for(i=0; i<12; i++)
		if(*(seeds+i)<0 || *(seeds+i)>63)
			Recover("Invalid random number seed: numbers must be between 0 and 63",NULL_ENTRY);
	seeds = seeds + 11;
	tausval = 0;
	for(i=0; i<6; i++)
		tausval = tausval<<6 | (unsigned)(*seeds--);
	congrval = 0;
	for(i=0; i<6; i++)
		congrval = congrval<<6 | (unsigned)(*seeds--);
	lambda = 69069;
	if(!(congrval % 2))
		Recover("Invalid random number seed: congruential part must be odd",NULL_ENTRY);
}

/*
 * convert congruential and tausworthe
 * shift values to seeds base 64
 */
static cseedo(seeds)
long *seeds;
{
	unsigned long tval;
	int i;

	tval = congrval;
	for(i=0; i<6; i++){ *seeds++ = tval % 64; tval >>= 6;}
	tval = tausval;
	for(i=0; i<6; i++){ *seeds++ = tval % 64; tval >>= 6;}
}

/* uniform generator */
static double xuni()
{
	unsigned long n;

	congrval = congrval * lambda;	/* congruential part (for 32-bit machine)*/
	tausval ^= tausval >> 15;	/* tausworthe part */
	tausval ^= tausval << 17;
	n = tausval ^ congrval;
	return( ((float)((n>>1) & 017777777777)) / 2147483648.);
}

/* get seeds from file */
seedin()
{
	vector *seed_data = get_data(".Random.seed", ANY);

	if(seed_data == NULL_ENTRY || seed_data->length < 12) {
		Recover("Invalid seeds for random number generators", seed_data);
		return;
	}
	seed_data = coevec(seed_data, INT, TRUE, TRUE);
	cseedi(seed_data->value.Long);
}

/* put seeds on file (with fake assignment to .Random.seed) */
seedot(fake)
int fake;
{
	vector *seed_data = alcvec(INT,12L);
	extern int Random_flag;

	cseedo(seed_data->value.Long);
	set_data(S_data, seed_data, ".Random.seed");
	if(fake)
		Random_flag = TRUE;
	else
		perm_assign(".Random.seed", seed_data);
}

/*
 * generate a sample of `size' on 1:range, without replacement;
 * uses hash table of computed values to detect repeat values
 */
vector *S_sample(ent, arglist)
vector *ent, *arglist;
{
	long size, i, index, *nn, pos, junk;
	double range, xx;
	x_h **h_table;
	long h_length;
	vector *value, **args;

	args = arglist->value.tree;
	size = long_value(args[0],ent);
	if(size<0)Recover("Negative sample size meaningless",ent);
	else if(size==0)return(alcvec(INT,0L));
	value = alcvec(INT,size);
	h_length= 3*size/2; if(h_length<20)h_length=20; /* hash table will be the */
		/*smallest prime >= 1.5*size, but not smaller than 23 */
	range = long_value(args[1],ent);
	nprime(&h_length);
	h_table = (x_h **)S_alloc(h_length,sizeof(x_h *));
	seedin();
	i=size; nn = value->value.Long;
	while(i) {
		xx = xuni()*range + 1.;
		index = xx>range ? range : xx;
		if(!hash((char *)&index,INT,&junk,&pos,h_table,h_length)){
			hash_enter((char *)&index,INT,index,pos,h_table,h_length);
			*nn++ = index; i--;
		}
	}
	seedot(TRUE);
	return(value);
}

/* powers mod 2^32 */
static unsigned long pow32(b,n)
unsigned long b, n;
{
	unsigned long p, ans;
	for(ans=1, p=b; n>0; n >>= 1, p *= p)
		if(n&1) ans *= p;
	return ans;
}

setseed(seed)
long *seed;
{
	unsigned long n = *seed, interval, pow32();
	interval = pow32((unsigned)2, (unsigned)20);
	congrval = ((unsigned) 1803752341) * pow32((unsigned) 69069, interval * n);
	tausval = 3697165728;
	seedot(FALSE);
}
