#include <stdio.h>
#include <signal.h>
#include "S.h"

#define BUFSIZE 4096

char buf[BUFSIZE+1];
long file_len, buf_len; char *buf_pos = buf; FILE *f;

static int broken();

main(argc, argv)
char *argv[];
int argc;
{
	char *next_line(), *p;
	if(argc!=2){
		fputs("Usage: reverse file\n",stderr);
		exit(1);
	}
	f = fopen(argv[1],"r");
	if(!f) {
		fprintf(stderr,"reverse: Can't open \"%s\"\n",argv[1]);
		exit(1);
	}
	if(fseek(f,0L,2) == -1) {
		fprintf(stderr,"reverse: Can't seek on \"%s\"\n",argv[1]);
		exit(1);
	}
	signal(SIGPIPE, broken);
	file_len = ftell(f);
	read_back();
	if(!buf_len) {
		fprintf(stderr,"reverse: file \"%s\" is empty\n",argv[1]);
		exit(1);
	}
	if(*buf_pos != '\n')
		fprintf(stderr,"Warning in reverse: last character of file \"%s\" not a new-line\n",argv[1]);
	while(p=next_line())puts(p);
	puts(buf); /* top line */
	exit(0);
}

char *next_line()
{
	char *p; long cur_len;
	*buf_pos = '\0';
	for(cur_len = buf_len-1, p = buf_pos-1; ; cur_len--, p--) {
		if(!cur_len) {
			if(!file_len)return(NULL);
			read_back();
			p = buf_pos; cur_len = buf_len;
			}
		if(*p == '\n')break;
	}
	buf_pos = p; buf_len = cur_len;
	return(p+1);
}

read_back()
{
	int n, i;
	i =buf_pos-buf;
	n = file_len>BUFSIZE-i ? BUFSIZE-i : file_len;
	if(n<=0){
		fprintf(stderr,"Error in reverse: line longer than %d characters\n",BUFSIZE);
		exit(1);
	}
	if(i)MEMCPY(buf + n, buf, i);
	fseek(f,(long)-n, 1);
	fread(buf,1,n,f);
	fseek(f,(long)-n,1);
	buf_len = n; buf_pos = buf+n-1; file_len -= n;
}


/*	Exit without complaint on broken pipe.  This usually happens
 *	when the awk script that we talk to terminates prematurely.
 *	Some versions of the Bourne shell notice this and give a
 *	non-zero return for the reverse/awk combination
 */

static int
broken()
{
	exit(0);
}

#ifdef ATT_UNIX
/* copy of the routine sbcopy from str_utils.c */

/* copy n bytes from s1 to s2 (overlap allowed) */
/* needed on sys V machines where bcopy non-existent */
/* and memcpy may not work if overlaps exist */ 
#undef memcpy
char *
sbcopy(s1,s2,n)
register char *s1,*s2; register int n;
{
	int d; char *memcpy(), *val;
	d = abs(s1 - s2);
	val = s2;
	if(d>n) memcpy(s2,s1,n);
	else if(s1<s2) {
		s1 += n-1;
		s2 += n-1;
		while (--n >= 0)
			*s2-- = *s1--;
	}
	else if(s2<s1) {
		while (--n >= 0)
			*s2++ = *s1++;
	}
	return(val);
}
#endif
