/*
 * Copyright 1992-4   BG Systems, Inc.
 * convert.c
 *
 * Routine to convert input string 
 *
 * Author         Date       Comments
 * John Green     21-Oct-94  Major revision for v 3.0 EPROM
 * John Green     01-Feb-95  Final rev 3.0 cleaning
 * John Green     15-Mar-95  Fixed scaling bug
 * John Green     27-Jun-95  Added support for multiplex dig in (OB1K-112)
 * John Green     20-Nov-97  Added support for encoders
 */

static char SccsId[] = "@(#)convert.c	1.6 24 Nov 1997";

#include <stdio.h>

#include "lv3.h"

extern int unpack_encoders(bglv *, char *, int );

int convert_serial(bglv *bgp, char *str)
{
   int i, digp, j;
   int k = 0;
   int m = 0;
   int st;
   float tmp[8];

   digp = 0;

   k = 1 + bgp->n_dig_in/4;
   if ( bgp->mp_dig_in == 0 )
   {
/*
 *  Load the digital input values into dioval
 */
      if ( k > 1)
      {
         i = 1;
         for ( j = 2; j >= 0; j-- )
         {
            if ( bgp->dig_in & 0x10<<j )
            {
               digp = 0x0f & (str[i++]-0x21);
               digp = (digp << 4) | 0x0f & (str[i++]-0x21);
               bgp->din[j] = digp;
            }
         }
      }
   }
   else
   {
/*
 *  Load the multiplex digital input array
 */
      i = 1;
      for ( j = 0; j < bgp->mp_dig_in/8; j++ )
      {
            digp = 0x0f & (str[i++]-0x21);
            digp = (digp << 4) | 0x0f & (str[i++]-0x21);
            bgp->mp_din[j] = digp;
      }
   }
/*
 *  Load the 8 analog values into inbuf
 */
   for (i = k; i < k+(bgp->n_analog_in*2); i += 2)
   {
      digp = ((0x3f & (str[i]-0x21)) << 6) |
                    (0x3f & (str[i+1]-0x21));
      tmp[(i-k)/2] = -1.0 + (2.0 * digp/4095);
   }
   for ( j = 0, k = 0; k < 8; k++ )
   {
      if ( bgp->analog_in >> k &0x1 )
      {
         bgp->ain[k] = tmp[j];
	 j++;
      }
   }

   if ( bgp->n_enc > 0 )
   {
      m = i;
      st = unpack_encoders(bgp, str, m);
   }

   digp =  ((0x0f & (str[22]-0x21)) <<  4) |
           (0x0f & (str[23]-0x21));
   return (0);
}
