/* This is an Imakefile which is included by all CDS Imakefiles.
 * produced by: joe@astro.as.utexas.edu 

 * You should edit this file before compiling
 * After you finish editing this file, you should edit the Makefile 
 * in src.lib/expect
 */

CDS_VERSION = 2.0.4 /* CDS Version */

/* This is the name of the C++ compiler you are using. */

CXX= g++

/* Uncomment this if you C++ compiler does not recognize the .cc suffix
 * g++ and Sun C++2.1 do recognize the .cc suffix
 * ATT C++ 2.0 does not */
 
/*#define CannotUseCcSuffix*/

/* Name of Make.
 * Note on NFS systems (such as the MIT Athena network), 
 * NFS and imake and UNIX make, conspire to add 255 nulls to the
 * end of the generate Makefiles and thus produce a "line too long"
 * error.  If this should happen to you, use GNU make which somehow 
 * avoids this bug.
 */

MAKE = gmake

/* Name of C compiler
 * A bug has been reported in which, src.lib/Cm/CmLabel.c includes the
 * ANSI version of the MOTIF header files even when compiling with 
 * a non-ANSI version of C.  Till I track down the bug, you should
 * use an ANSI version of C.
 */

CC=gcc

/* These are the flags to the C++ compiler
 *
 * If you are using AT&T C++, you should set the flags 
   -DXTFUNCPROTO -DUSE_LIBGXX_INLINES

 * If you are on a System V machine (i.e. the Sparc)
   -DSYSV
 */

CXXFLAGS= -g -pipe -O

/* Files to be included with C++ */
CXXINCLUDES =  

/* Standard include directories.
 * If your MOTIF or X11 headers are not in the default include path set this
 * to
   -I<absolute path of directory 1> -I<absolute path of directory 2>
 */

STD_INCLUDES = -I/mit/cdsdev/include

/* Standard defines */
STD_DEFINES = 

/* Extra load flags
 * If you are using libraries are not in the default load path set this
 * to 
   -L<absolute path of library 1> -L<absolute path of library 2>
 */

EXTRA_LOAD_FLAGS = -L/mit/cdsdev/decmipslib

/* This is if you have to add libraries other than At, Cm, expect */
BUILTIN_LIB = 

/* The lines below determine which libraries are needed and which get
 * bulit.
 *
 * If you already have the library built, you can comment out the line
 * corresponding the the library which is already built.
 *
 * To comment out a line, surround it with comment mark 
 */
/*#define SampleDefine like_this */

/* Build the Athena Tools scientific widget package. */
#define NeedAt
/*#define BuildAt*/

/* Build the CDS widget library.  This widget library provides a 
 * formatted text widget as well as a Tektronix widget
 */
#define NeedCm
#define BuildCm

/* Build the expect inter-process communication library.  Updates to
 * this library can be found anonymous ftp to durer.cme.nist.gov
 */
#define NeedExpect
#define BuildExpect

/* Build the GNU regex library.  This library is included in libg++
 * library.  If you are using g++, this should be commented out.
 */
#define NeedRegex

/* Build the Vprintf library.  This library should be bulit for 
 * BSD systems can be omitted for SystemV system, where it is 
 * included in the builtin package.  This library can be found
 * anonymous ftp to uunet.uu.net
 */ 

#define NeedVprintf

/**/# The lines below probably don't need to be changed

#ifdef CannotUseCcSuffix
YACCLEXTMP = yy.lex.C
#else
YACCLEXTMP = yy.lex.cc
#endif

.SUFFIXES: .o .cc .c .yacc .lex

.yacc.o:
	$(RM) yy.tmp lex.tmp $(YACCLEXTMP)
	yacc $*.yacc
	lex $*.lex
	cat y.tab.c | \
	sed -e "s/extern char \*malloc()\, \*realloc();//g" \
	    -e "s/yyparse() {/int "$*"::yyparse() {/g" \
	    -e 's/yyparse()$$/'$*"::yyparse()/g" \
	    -e "s/# define YYLMAX 200/# define YYLMAX 20000/g"\
	    -e "s/char yytext\[YYLMAX\];//g"\
	    -e "s/extern short yyerrflag;//g" \
	    -e "s/extern int yychar;//g" \
	    -e "s/extern int yyprevious;/static int yyprevious/g" \
	    -e "s/short yyexca/static short yyexca/g" \
	    -e "s/short yyact/static const short yyact/g" \
	    -e "s/short yypact/static const short yypact/g" \
	    -e "s/short yypgo/static const short yypgo/g" \
	    -e "s/short yyr1/static const short yyr1/g" \
	    -e "s/short yyr2/static const short yyr2/g" \
	    -e "s/short yychk/static const short yychk/g" \
	    -e "s/short yydef/static const short yydef/g" \
	    -e "s/int yyexca/static int yyexca/g" \
	    -e "s/int yyact/static const int yyact/g" \
	    -e "s/int yypact/static const int yypact/g" \
	    -e "s/int yypgo/static const int yypgo/g" \
	    -e "s/int yyr1/static const int yyr1/g" \
	    -e "s/int yyr2/static const int yyr2/g" \
	    -e "s/int yychk/static const int yychk/g" \
	    -e "s/int yydef/static const int yydef/g" \
            -e "s/YYSTYPE yylval, yyval;/static YYSTYPE yylval, yyval;/g" \
	    -e "s/struct yysvf \*yyestate/static struct yysvf \*yyestate/g" \
	    -e "s/extern int yychar;//g" \
	    -e "s/extern int yyerrflag;//g" \
	    -e "s/int yychar.*;//g" \
	    -e "s/int yynerrs.*;//g" \
	    -e "s/int yyerrflag.*;//g" \
	    -e "s/int yydebug.*;//g" \
	    -e "s/free(yys)/free((char \*)yys)/g" \
	    -e "s/free(yyv)/free((char \*)yyv)/g" \
	    -e "s/short yyerrflag = 0;//g" > yy.tmp

	cat lex.yy.c | \
	sed -e "s/yylex(){/int "$*"::yylex() {/g"\
	    -e "s/# define YYLMAX 200/# define YYLMAX 20000/g"\
	    -e "s/char yytext\[YYLMAX\];//g"\
	    -e "s/int yyvstop\[\]/static int yyvstop\[\]/g" \
	    -e "s/yysvec/"$*"yysvec/g" \
	    -e "s/yybgin/"$*"yybgin/g" \
	    -e "s/struct yywork \*yytop =/static struct yywork \*yytop =/g" \
            -e "s/int yylineno =1;//g" \
	    -e "s/int yytchar;//g" \
	    -e "s/int yyleng;//g" \
	    -e "s/int yymorfg;//g" \
	    -e "s/char yysbuf\[YYLMAX\];//g" \
	    -e "s/char \*yysptr = yysbuf;//g" \
	    -e "s/extern char \*yysptr, yysbuf\[\];//g"\
	    -e "s/extern int yyprevious;/static int yyprevious;/g" \
	    -e "s/int yyprevious =/static int yyprevious =/g" \
	    -e "s/extern char yytext\[\]//g" \
 	    -e "s/yylook(){/int "$*"::yylook(){/g" \
	    -e "s/struct yywork {/static struct yywork {/g" \
	    -e "s/char yymatch/static char yymatch/g" \
	    -e "s/char yyextra/static char yyextra/g" \
	    -e "s/int \*yyfnd/static int \*yyfnd/g" \
	    -e "s/extern struct yysvf \*yyestate;//g" \
	    -e "s/struct yysvf \*yyestate/static struct yysvf \*yyestate/g" \
            -e "s/struct yysvf \*yylstate/static struct yysvf \*yylstate/g" \
	    -e "/yyback(p\, m)/,/unput(c);\n}/ d" > lex.tmp

	cat yy.tmp lex.tmp | \
	sed -e "s/FILE \*yyin = *{stdin}, \*yyout = *{stdout};//g" \
            -e "s/extern int yylineno;//g" \
		> $(YACCLEXTMP)
	$(RM) y.tab.c lex.yy.c yy.tmp lex.tmp
#ifdef CannotUseCcSuffix
	$(CXX) -c $(CFLAGS) $(CXXFLAGS) $(CXXINCLUDES) $(YACCLEXTMP) 
	$(MV) yy.lex.o $*.o
#else
	$(CXX) -c $(CFLAGS) $(CXXFLAGS) $(CXXINCLUDES) $(YACCLEXTMP) -o $*.o
#endif 
	$(RM) $(YACCLEXTMP)

#ifndef NormalCPlusPlusObjectRule
#ifdef CannotUseCcSuffix
#define NormalCPlusPlusObjectRule()					@@\
.cc.o:									@@\
	$(RM) $*.o $*.C							@@\
	$(LN) $*.cc $*.C						@@\
	${CXX} -c ${CFLAGS} ${CXXFLAGS} $(CXXINCLUDES) $*.C		@@\
	$(RM) $*.C
#else
#define NormalCPlusPlusObjectRule()					@@\
.cc.o:									@@\
	$(RM) $*.o							@@\
	${CXX} -c ${CFLAGS} ${CXXFLAGS} $(CXXINCLUDES) $*.cc
#endif /* CannotUseCcSuffix */
#endif /* NormalCPlusPlusObjectRule */

#ifndef ProfiledCPlusPlusObjectRule
#define ProfiledCPlusPlusObjectRule()					@@\
.cc.o:									@@\
	$(RM) $@ profiled/$@						@@\
	$(CXX) -pg -c $(CFLAGS) $(CXXFLAGS) $*.cc			@@\
	$(MV) $*.o profiled/$*.o					@@\
	$(CXX) -c $(CFLAGS) $(CXXFLAGS) $*.cc
#endif

#ifndef DebuggedCPlusPlusObjectRule
#define DebuggedCPlusPlusObjectRule()					@@\
.cc.o:									@@\
	$(RM) $@ debugger/$@						@@\
	$(CXX) -pg -c $(CFLAGS) $(CXXFLAGS) $*.cc			@@\
	$(MV) $*.o debugger/$*.o					@@\
	$(CXX) -c $(CFLAGS) $(CXXFLAGS) $*.cc
#endif



/*
 * ComplexProgramTarget - generate rules for compiling and linking the 
 * program specified by $(OBJS) and $(SRCS), installing the program and its
 * man page, and generating dependencies.  It should only be used in 
 * Imakefiles that describe a single program.
 */
#ifndef ComplexCPlusPlusTarget
#define	ComplexCPlusPlusTarget(program)					@@\
        PROGRAM = program						@@\
									@@\
AllTarget(program)							@@\
									@@\
program: $(OBJS) $(DEPLIBS)						@@\
	RemoveTargetProgram($@)						@@\
	$(CXX) $(OBJS) $(LDOPTIONS) $(LOCAL_LIBRARIES) $(LDLIBS) $(EXTRA_LOAD_FLAGS)  -o $@ @@\
									@@\
SaberProgramTarget(program,$(SRCS),$(OBJS),$(LOCAL_LIBRARIES), /**/)	@@\
									@@\
InstallProgram(program,$(BINDIR))					@@\
InstallManPage(program,$(MANDIR))					@@\
DependTarget()								@@\
LintTarget()								@@\
									@@\
clean::									@@\
	$(RM) $(PROGRAM)
#endif /* ComplexCPlusPlusTarget */

/*
 * NormalCPlusPlusProgramTarget - generate rules to compile and link the indicated
 * program; since it does not use any default object files, it may be used for
 * multiple programs in the same Imakefile.
 */
#ifndef NormalCPlusPlusProgramTarget
#define NormalCPlusPlusProgramTarget(program,objects,deplibs,locallibs,syslibs)  @@\
program: objects deplibs                                                @@\
	RemoveTargetProgram($@)                                         @@\
	$(CXX) -o $@ objects $(LDOPTIONS) locallibs $(LDLIBS) syslibs $(EXTRA_LOAD_FLAGS) @@\
                                                                        @@\
clean::                                                                 @@\
	$(RM) program
#endif /* NormalCPlusPlusProgramTarget */

