/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/TextPlotP.h,v 3.1 91/01/03 17:29:25 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtTextPlotP_h
#define _AtTextPlotP_h    

#include <X11/IntrinsicP.h>

#ifdef _AtDevelopment_
#include "PlotP.h"
#include "TextPlot.h"    
#include "FontFamily.h"
#include "Text.h"
#else
#include <At/PlotP.h>
#include <At/TextPlot.h>  
#include <At/FontFamily.h>
#include <At/Text.h>
#endif
    
typedef struct _AtTextPlotClassPart {
    int higgledy_piggledy;
} AtTextPlotClassPart;

typedef struct _AtTextPlotClassRec {
    ObjectClassPart object_class;
    AtPlotClassPart plot_class;
    AtTextPlotClassPart textplot_class;
} AtTextPlotClassRec;


typedef struct _AtTextPlotPart {
    /* resources */
    String label;
    String fontFamily;
    int fontSize;
    int justify;
    int x;
    int y;
    Boolean floatingPosition;
    double floatingX;
    double floatingY;

    /* private state */
    AtText *labelText;
    AtFontFamily *ff;
    double xpercent, ypercent;
    int xpos, ypos;
    Boolean valid;
} AtTextPlotPart;

typedef struct _AtTextPlotRec {
    ObjectPart object;
    AtPlotPart plot;
    AtTextPlotPart textplot;
} AtTextPlotRec;


#endif /* _AtTextPlotP_h */
