@Part(ltxo, ROOT "/mit/las/spec/las.spc")
@Use(Database "/mit/las/spec")
@LibraryFile(Mathematics10)
@String(DraftDate="5/17/89")
@Module(LTxo: Text Output Utility)
@Comment(NOTE------> Be sure to update the "DraftDate" <-----NOTE)
@Comment(NOTE------> Be sure to update the "DraftDate" <-----NOTE)
@Comment(NOTE------> Be sure to update the "DraftDate" <-----NOTE)
@ModuleName[Text Output Utility (LTxo)]
@SpecAuthor[Linh Giang]
@Begin[Revisions]
12 Dec 88  Mory ... setup framework.
2  Mar 89  Lkgiang ... put in purpose and initial structures.
8  Mar 89  Lkgiang ... updated structures and procedures.
12 Mar 89  Lkgiang ... revised structure, do not want state info
28 Mar 89  Lkgiang ... revised structure, more specific
29 Mar 89  Lkgiang ... added the Get procedures and note on status
30 Mar 89  Lkgiang ... added one more command
3  Apr 89  Lkgiang ... rephrase LTxLoadFont's design
13 Apr 89  Lkgiang ... Updated the Scribe commands and
		       bounding box description.
21 Apr 89  Lkgiang ... Changed the names of Scribe command
28 Apr 89  Lkgiang ... Add "How To Use LTxo" section.
5  May 89  Lkgiang ... Add more commands .. such MULT and arrows.
13 May 89  Lkgiang ... Add LTxSetWantStipple & LTxSetChangeText.
17 May 89  Lkgiang ... Get rid of window id in LTxInfo structure.
@End[Revisions]

@Heading(Purpose)
LTxo is the text output utility that all pidgets and other procedures
that require text output should call to put complex text onto the
screen.  It is a set of general purpose procedures that allows text to
have different fonts, font sizes, and math symbols.  It also has the
capbability to automatically resize the text if the text does not fit
in the specified bounding box.  Ltxo allows the text to be either in
autofill, justified, or verbatim mode.

@Heading(Design of Implementation) 
@p(Scribe and Scribe-like Commands)@\
LTxo understands a subset of the Scribe commands in deciphering the
given text.  In addition, it allows the text to have some new
Scribe-like commands.  The list of commands which LTxo will take
is given below. (For further reference, see Scribe manual.)

@p(XFontStructs and GCs)@\
LTxo requires the main calling procedure (usually the manager) to load
the necessary fonts and create several GCs for the manipulation of
text.  The procedure to load fonts and create GCs is LTxLoadFont(). At
the end of the session, the main calling procedure should also call
LTxoFreeFont() to free all XFontStructs and Gcs.

@p(Bounding Box and Normalized Coordinates)@\
LTxo takes in a bounding box which defines where the text is to be
placed.  The bounding box consists of the x,y coordinates of the upper
left hand corner of the box and the width and height of the box.  LTxo
takes in the normalized device coordinates which means that the
bounding box's x,y coordinates, width and height are declared in
percentages. For example, width = 50 means that the width in pixels is
actually 50% of the window's pixel width.  Width = 100 means the
bounding box width is the whole window's width. It requires the
calling procedure to give the window's height and width so that LTxo
can figure out the actual pixel coordinates from the normalized
coordinates.  The reason for the conversion is because the X-Window
System expects pixel coordinates in order to draw text, but in the LAS
application, normalized coordinates were considered to be more useful
and convenient.

@Heading[Possible Scribe and Scribe-like Commands]
The following are Scribe commands:
@TabDivide(2)
@begin(format)
@@b               @\@b{boldface}
@@u               @\@u{underlines}
@@i               @\@i{italics}
@@+               @\superscripts
@@-               @\subscripts
@@center          @\centering
@@>               @\flushing to the right
@@r               @\go to times-roman
@@g               @\go to greek
@end(format)

The following are Scribe math formatting commands:
@TabDivide(2)
@begin(format)
@@Vec( )                  @\vector symbol on top of variables
@@Over(Num[ ] Denom[  ])  @\fractions
@@Sum(From[ ] To[  ])     @\summation
@@Int(From[ ] To[  ])     @\integration
@@Prod(From[ ] To[  ])    @\product
@@Sqrt( )                 @\sqrt
@end(format)

The following are the Scribe commands for symbols:
@TabDivide(3)
@begin(format)
@@Aleph  @\@Aleph @\Aleph
@@And @\@And @\logical intersection
@@Angle  @\@Angle @\angle
@@Approx  @\@Approx @\approximate equality 
@@Ast  @\@Ast @\asterisk 
@@Bullet  @\@Bullet @\Solid Bullet
@@DownArrow @\@DownArrow @\downarrow 
@@EmptySet  @\@EmptySet @\Empty Set or Null 
@@Eqv  @\@Eqv @\Equivalence
@@Exists  @\@Exists @\Exist Quantifier
@@ForAll  @\@ForAll @\Universal or ForAll Quantifier
@@Gte @\@Gte @\greater than & equal symbol 
@@Neq  @\@Neq @\inequality
@@Infty @\@Infty @\infinity symbol 
@@Inter @\@Inter @\set intersection
@@LeftArrow @\@LeftArrow @\lefthtarrow 
@@Lte @\@Lte @\less than & equal symbol 
@@In @\@In @\is a member of
@@Mult @\@Mult @\the muliplication sign 
@@Nabla @\@Nabla @\Nabla
@@NotIn @\@NotIn @\is not a member of
@@Or @\@Or @\logical union
@@Partial @\@Partial @\partial symbol 
@@PM @\@PM @\plus and minus
@@RigthArrow @\@RightArrow @\rightarrow 
@@Similar @\@Similar @\similarity
@@Subset @\@Subset @\subset
@@PrSubset @\@PrSubset @\proper subset
@@Supset @\@Supset @\supset
@@PrSupset @\@PrSupset @\proper supset
@@Union @\@Union @\set union
@@UpArrow @\@UpArrow @\uparrow 
@end(format)

The following are Scribe-like commands:
@TabDivide(2)
@begin(format)
@@^[1 to 6] @\increase sizes in same font (max of 6 steps)
@@v[1 to 6] @\decrease sizes in same font (max of 6 steps)
@@# @\a space
@@#(a number) @\skip (number) spaces
@@. @\linebreak
@@.(a number) @\skip (number) lines
@@h @\go to helvetica
@@f @\go to fixed-width font
@@c @\same as @@center
@end(format)

The following are the Scribe-like commands for symbols:
@TabDivide(2)
@begin(format)
@@DBRigthArrow @\ double line rightarrow
@@DBLeftArrow @\ double line lefthtarrow
@@DBUpArrow @\ double line uparrow
@@DBDownArrow @\ double line downarrow
@end(format)


The following is the Greek set:
@TabDivide(3)
@begin(format)
Greek Name    @\Ascii   @\Greek Symbol
----------    @\-----   @\------------
Alpha         @\a       @\@g(a)
Beta          @\b       @\@g(b)
Gamma         @\g       @\@g(g)
Delta         @\d       @\@g(d)
Epsilon       @\e       @\@g(e)
Zeta          @\z       @\@g(z)
Eta           @\h       @\@g(h)
Theta         @\q       @\@g(q)
Iota          @\i       @\@g(i)
Kappa         @\k       @\@g(k)
Lambda        @\l       @\@g(l)
Mu            @\m       @\@g(m)
Nu            @\n       @\@g(n)
Xi            @\x       @\@g(x)
Omicron       @\o       @\@g(o)
Pi            @\p       @\@g(p)
Rho           @\r       @\@g(r)
Sigma         @\s       @\@g(s)
Tau           @\t       @\@g(t)
Upsilon       @\u       @\@g(u)
Phi           @\f       @\@g(f)
Chi           @\c       @\@g(c)
Psi           @\y       @\@g(y)
Omega         @\w       @\@g(w)
@end(format)

The following are possible delimiters:
	{ }  ( )  [ ]  < >
Do not use "" because it is used as the interpreter delimiter.

Note1: Capitalize Greek corresponds to capitalize Ascii.
Note2: Ltxo are insensitive to upper and lower case commands.  
Note3: If user really wants a '@@' sign, type in two @@'s (i.e. '@@@@').

@newpage()
@Heading(Global Structures)

@begin(verbatim)
/* LTxBox is the structure that holds information for the bounding box
   of the text output. */

typedef struct _LTxBox{
   int             x;           /* x,y of bounding box */
   int             y;
   unsigned        height;      /* width & height of box */
   unsigned        width;       
   unsigned        border;      /* border width of box in pixels */
} LTxBox;

/* LTxInfo is the structure that holds all information necessary to 
   draw text with LTxDrawText. */

typedef struct _LTxInfo{
   LTxBox          box;           /* bounding box */
   char            *str;          /* text to be displayed */
   unsigned        font;          /* font for text */
   unsigned        size;          /* size for text */
   int             xflag;         /* horizontal alignment */
   int             yflag;         /* vertical alignment */
   int             mode;          /* verbatim, fill, or justify */
   Bool             resize;        /* allows LTxo to resize the font */
   int             too_small;     /* what to do when bounding box is */
				  /* too small */ 
   char            *short_str;    /* alternate text */
   unsigned long   foregd;        /* preferred background color*/
   unsigned long   backgd;        /* preferred foreground color */
   Bool  	   want_stipple;  /* user whats stipple tiles in GC */
   Bool  	   change_text_flag; /* tell if text has been changed */
} LTxInfo;                    

@end(verbatim)

@newpage()
@Heading(Global Macros)
The user can use the following procedures to set the values in the
Ltxo structure:

@begin(verbatim)
LTxSetX(info, value)
   value can be: an integer from 0 to 100
   default: 0

LTxSetY(info, value)
   value can be: an integer from 0 to 100
   default: 0

LTxSetHeight(info, value)
   value can be: an unsigned integer from 0 to 100
   default: 0 (will give error if width is zero)

LTxSetWidth(info, value)
   value can be: an unsigned integer from 0 to 100
   default: 0 (will give error if width is zero)

LTxSetBorder(info, value)
   value can be: an unsigned integer (in pixels) 
   default: 0 (i.e. no border)

LTxSetText(info, value)
   value can be: a pointer to a string
   default: null string

LTxSetFont(info, value)
   value can be: HELVET, HELVET_BOLD, HELVET_ITALICS
		 TIMES, TIMES_BOLD, TIMES_ITALICS 
		 GREEK, FIXED, SYMBOL, FANCY 
   default: HELVET

LTxSetSize(info, value)
   value can be: SMALLEST, SMALL, MEDSMALL, MEDIUM,
		 MEDBIG, BIG, BIGGEST (0 - 6)
   default: MEDIUM

LTxSetXflag(info, value)
   value can be:  H_LEFT, H_CENTER, H_RIGHT
   default: H_LEFT

LTxSetYflag(info, value)
   value can be:  V_LEFT, V_CENTER, V_RIGHT
   default: V_CENTER

LTxSetMode(info, value)
   value can be:  VERBATIM. FILL, JUSTIFY
   default: VERBATIM

LTxSetResize(info, value)
   value can be:  ON, OFF
   default: ON

LTxSetSmall(info, value)
   value can be: NO_SHOW, SHOW_SHORT, CLIP_LEFT_BOT,
		 CLIP_RIGHT_BOT, CLIP_LEFT_TOP, CLIP_RIGHT_TOP
   default: CLIP_RIGHT_BOT

LTxSetShort(info, value)
   value can be: a pointer to a string
   default: null string

LTxSetForegd(info, value)
   value can be: any color represented by an unsigned long integer.
		 now, it accepts either white or black.
   default: black foreground color.

LTxSetBackgd(info, value)
   value can be: any color represented by an unsigned long integer.
		 now, it accepts either white or black.
   default: white background color.

LTxSetWantStipple(info, value)
   value can be: ON or OFF
   defaut: OFF

LTxSetChangeTextFlag(info, value)
   value can be: ON or OFF
   defaut: OFF

@end(verbatim)

The user can use the following procedures to get the values of LTxo structure:

@begin(verbatim)
LTxGetX(info)
LTxGetY(info)
LTxGetHeight(info)
LTxGetWidth(info)
LTxGetBorder(info)
LTxGetText(info)
LTxGetFont(info)
LTxGetSize(info)
LTxGetXflag(info)
LTxGetYflag(info)
LTxGetMode(info)
LTxGetResize(info)
LTxGetSmall(info)
LTxGetShort(info)
LTxGetForegd(info)
LTxGetBackgd(info)
LTxGetWantStipple(info) 
LTxGetChangeTextFlag(info)
@end(verbatim)

@newpage()
@Heading(Procedures In Detail)
@begin(verbatim)

/**********************************************************************
 * Public Routine: LTxLoadFont(dpy,win)
 * Requires: 
 *  dpy = display.
 *  win = drawable for text to displayed on.
 * Description: 
 *  This routine loads in the set of popular fonts and creates
 *  several GCs. Whenever a font is needed and the available GCs are
 *  not of this font, one of these GCs will be set to the new font.
 *  Each GC will be checked to determine if it can be used, and only
 *  if none can, should one of the GCs be changed. This implementation
 *  design is a compromise between speed efficiency and memory usage
 *  but is needed in order to have many fonts available for users.
 *  Each application should not use too many fonts because it is
 *  aesthetically distracting but fonts of different sizes are needed
 *  to be available for resizing.    
 **********************************************************************/

LTxLoadFont(win)
     Window win;


/**********************************************************************
 * Public Routine: LTxFreeFont()
 * Description: 
 *  This procedure frees the text fonts and GCs which were loaded and
 *  created in LTxLoadFont(). Should be call only at the conclusion
 *  of the process.
 **********************************************************************/

LTxFreeFont()


/**********************************************************************
 * Public Routine: LTxCreateInfo()
 * Returns:
 *  Pointer to the LTxInfo structure that holds information for the
 *  text output. 
 * Description:
 *  Returns a pointer to the  LTxoInfo structure with the default
 *  values. Any changes should be set with the convenience procedures. 
 *  Note: The default values have nothing to do with each individual
 *        pidgets using LTxo.  The user has to set the necessary 
 *        information after creating the structure.
 **********************************************************************/

LTxInfo *LTxCreateInfo()

@newpage()

/**********************************************************************
 * Public Routine: LTxDrawText(win, win_width, win_height, info)
 * Requires: 
 *  win  = window for text output
 *  win_height = height of window
 *  win_width = width of window
 *  info = a pointer LTxInfo structure that holds information for text
 * Description:
 *  Draws the text given in the LTxInfo structure. If resize is
 *  set to ON, LTxDrawText will try to find smaller size fonts to
 *  fit in  the bounding box given.  If resize is set to OFF, then
 *  it checks for the too_small flag to decide what to do with text.
 *  The default is to clip arbitrarily from the right and bottom.
 **********************************************************************/

LTxDrawText(win, win_width, win_height, info)
     Window win;
     unsigned win_height, win_width;
     LTxInfo *info;


/**********************************************************************
 * Public Routine: LTxSelectSize(win, win_width, win_height, info)
 * Requires: 
 *  win  = window for text output
 *  win_height = height of window
 *  win_width = width of window
 *  info = a pointer LTxInfo structure that holds information for text
 * Modifies:
 *  The size field in the LTxInfo structure.
 * Description: 
 *  This routine will find the best size that will fit the text into
 *  the given bounding box using the given font.  
 **********************************************************************/

LTxSelectSize(win, win_width, win_height, info)
     Window win;
     unsigned win_height, win_width;
     LTxInfo *info;

@newpage()

/**********************************************************************
 * Public Routine: LTxSetBoxWidth(win, win_width, win_height, info)
 * Requires: 
 *  win  = window for text output
 *  win_height = height of window
 *  win_width = width of window
 *  info = a pointer LTxInfo structure that holds information for text
 * Modifies:
 *  The width field in the LTxInfo structure.
 * Description:
 *  This routine returns to the user the width required to hold text
 *  in LTxInfo structure.  This will only make sense with either
 *  labels or with verbatim text.  The width set will be in normalized
 *  coordinates .
 **********************************************************************/

LTxSetBoxWidth(win, win_width, win_height, info)
     Window win;
     unsigned win_height, win_width;
     LTxInfo *info;


/**********************************************************************
 * Public Routine: LTxSetBoxHeight(win, win_width, win_height, info)
 * Requires: 
 *  win  = window for text output
 *  win_height = height of window
 *  win_width = width of window
 *  info = a pointer LTxInfo structure that holds information for text
 * Modifies:
 *  The height field in the LTxInfo structure.
 * Description:
 *  This routine returns to the user the height required to hold text
 *  in LTxInfo structure.  This will only make sense with either
 *  labels or with verbatim text. If the environment is filled, then 
 *  the width field in the LTxInfo structure must be set in order for
 *  the routine to find the best fitting height for the text.  The
 *  height set will be in normalized coordinates .
 **********************************************************************/

LTxSetBoxHeight(win, win_width, win_height, info)
     Window win;
     unsigned win_height, win_width;
     LTxInfo *info;


/***********************************************************************
 * Public Routine: LTxGetFontIdSizeId(fontfamilyname, font_id_ret,
 *                                    size_id_ret) 
 * Requires:
 *  fontfamilyname = a LAS font family name.
 *  font_id_ret = pointer to variable holding font_id.
 *  size_id_ret = pointer to variable holding size_id.
 * Returns:
 *  0  if the fontfamilyname equals to one of the font names in LTxo
 *     and font_id and size_id are set accordingly.
 *  1  if the fontfamilyname does not equal to one of the font names in
 *     LTxo and the font_id and size_id are set to the defaults of
 *     LTxo. 
 * Description:
 *  This routine converts a font family name to the internal font and
 *  size ids for LTxo to manipulate the fonts. This routine is
 *  different from the others in that it does not set the LTxInfo
 *  structure.  Instead, it sets the two pointers that the caller
 *  provides. This routine is used mainly by pidgets to convert the
 *  font family name used in lecture file to the internal ids used by
 *  LTxo. 
 **********************************************************************/

LTxGetFontIdSizeId(fontfamilyname, font_id_ret, size_id_ret)
     char *fontfamilyname;
     unsigned *font_id_ret, *size_id_ret;

@end(verbatim)
@newpage()

@heading(How To Use LTxo)
@begin(itemize)
All procedures that call LTxo have to include "ltxo.h."

LTxLoadFont() have to be called to load in fonts and to create Graphic
Contexts (GCs). 

Where ever program exits, LTxFreeFont() should be call to free all font
structures and GCs.
@end(itemize)

@center[@b[STATUS and BUGS of LAS Version 6]]
@begin(itemize)
JUSTIFY is not implemented. 

Some symbols may have widths that are not all correct but they look
okay.  

All the flushes only work if the whole line is flush center or right.
Otherwise, you will get over-lapping. 

Sometimes, the overline bar does not appear under a sqrt ... never
found the bug.

Different clippings of different regions are not fully tested.
@end(itemize)


