;;; Get floating point number between 0 and 1

(define (frand)
  (/ (random) (1- (expt 2 31))))

;;; Get list of n zeros

(define (zeros n)
  (if (< n 1)
      '()
      (cons 0 (zeros (1- n)))))

;;; Print division returns "infinity" if b is zero
(define (p/ a b)
  (if (= b 0)
      "infinity"
      (/ a b)))

;;;;;;;;;;; library of scheme routines

(define (binomial p length)
  (bernoulli p length length))

(define (geometric p length)
  (let ((lst (list p))
	(last p)
	(q (- 1 p)))
    (for x 1 (< x length) (1+ x)
	 (let ((new-value (* last q)))
	   (set! lst (append lst (list new-value)))
	   (set! last new-value)))
    lst))

(define (bernoulli p n length)
  (let ((lst (list (expt (- 1 p) n)))
	(last (expt (- 1 p) n))
	(q (- 1 p))
	(p/q (/ p (- 1 p))))
    (for x 1 (< x length) (1+ x)
	 (let ((new-value (* last p/q (/ (- n x) (1+ n)))))
	   (set! lst (append lst (list new-value)))
	   (set! last new-value)))
    lst))

(define (pascal p r length)
  (let ((lst '())
	(last (expt p r))
	(q (- 1 p)))
    (for x 1 (< x r) (1+ x) ;; pad with r zeros
	 (set! lst (append lst (list 0))))
    (set! lst (append lst (list (expt p r)))) ;; initial value 
    (for x r (< x (+ r length)) (1+ x)
	 (let ((new-value (* last (/ x (* x q)))))
	   (set! lst (append lst (list new-value)))
	   (set! last new-value)))
    lst))

