/******************************************************************************

   Copyright 1991 McGill University

   Permission to use, copy, modify, and distribute this software and its
   documentation for any purpose without fee is hereby granted without fee,
   provided that the above copyright notice appear in all copies and that
   both that copyright notice and this permission notice appear in
   supporting documentation, and that the name of McGill not be used in
   advertising or publicity pertaining to distribution of the software
   without specific, written prior permission.  McGill makes no
   representations about the suitability of this software for any purpose.
   It is provided "as is" without express or implied warranty.

   MCGILL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL M.I.T.
   BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION
   OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
   CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   Author:
     Lee Iverson <leei@mcrcim.mcgill.edu>,
     McGill Research Centre for Intelligent Machines (McRCIM)

   $Id: SimpleImageP.h,v 1.1 91/04/28 15:54:25 joe Exp Locker: joe $

******************************************************************************/

#include <X11/copyright.h>

/* Derived from: */
/* $XConsortium: TemplateP.h,v 1.4 89/07/21 01:41:48 kit Exp $ */
/* Copyright	Massachusetts Institute of Technology	1987, 1988 */

#ifndef _SimpleImageP_h
#define _SimpleImageP_h

#include <SimpleImage.h>

/* include superclass private header file */
#include <X11/CoreP.h>

typedef struct {
    int empty;
} SimpleImageWidgetClassPart;

typedef struct _SimpleImageWidgetClassRec {
    CoreClassPart		core_class;
    SimpleImageWidgetClassPart	simple_image_class;
} SimpleImageWidgetClassRec;

extern SimpleImageWidgetClassRec simpleImageClassRec;

#include <GenericImage.h>

typedef struct {
    /* resources */
    float mag_x;
    float mag_y;
    Pixel foreground_pixel;
    String image_file;
    /* private state */
    GC annotateGC;
    Dimension width;
    Dimension height;
    GenericImage image;
} SimpleImageWidgetPart;

typedef struct _SimpleImageWidgetRec {
    CorePart	core;
    SimpleImageWidgetPart	simple_image;
} SimpleImageWidgetRec;

#endif /* _SimpleImageP_h */
