/**********************************************************************
 * File: ltxo_pri.h 
 * Private INCLUDE file for the LTxo procedures.
 **********************************************************************/

#ifndef LTXO_PRI_H
#define LTXO_PRI_H 1

/* continue from H_CENTER, H_LEFT, & H_RIGHT in ltxo.h. Use for 
   setting flags in ltxo_pri.c */
#define BOLD	    8
#define ITALICS	   16	
#define UNDERLINE  32
#define GRK        64
#define SYM       128

#define MAXFONT     10
#define MAXSIZE     7

#define NULLCHAR       '\0'
#define NL             '\n'
#define CR             '\r'
#define SP             ' '
#define COMMA          ','

#define MAX_LINES	60	/* max number of lines of text */
#define NONE      0		


/* font_map is the structure mapping each font we need to use with 
   the corresponding font that exists in the Athena X-Window System.
   It has the actual fontfile and a pointer to the XFontStruct of that
   font. */ 

typedef struct _font_map{
  char         *fontfile;
  XFontStruct  *fstruct;
} font_map;

/* sym_map is the structure that holds the width of the symbols used 
   in LAS. */

typedef struct _sym_map{
  int  width;
} sym_map;

/* family_map is the structure that holds the LAS font family names 
   and their corresponding font and size ids to the font_tbl array. */

typedef struct _family_map{
  char *las_name;
  unsigned font_id;
  unsigned size_id;
} family_map;

#define MAXSYM 41		/* number of symbols using so far */
#define MAXSYMSTRUCT 5		/* only 5 sizes in symbol-medium family */

#define MAXFAMILY 28		/* so far, only 4 family names with 7 
				   sizes each */

/* Private macros to find index to bold and italic fonts of the same 
   font family.  This depends on the two-dimensional font_tbl array. 
   If that table changes, these macros change. font_tbl is initialized
   in "ltxo_tbl.c." */

#define  findbold(x)   (x + 1)
#define  finditalic(x)   (x + 2)
#define  max(A,B)  ((A) > (B) ? (A) : (B))

/* The following are macros for math symbols */
#define FORALL   "\042"    /* got from the symbol-medium family */
#define EXISTS   "\044"
#define SIMILIAR "\176"
#define AST    "\052"
#define LTE    "\243"       
#define INF    "\245"	
#define LEFTARROW  "\254"
#define UPARROW    "\255"
#define RIGHTARROW "\256"
#define DOWNARROW  "\257"
#define PM     "\261"
#define GTE    "\263"
#define MULT   "\264"
#define PAR    "\266"
#define BULLET "\267"
#define NEQ    "\271"
#define EQV    "\272"
#define APPROX "\273"
#define ALEPH  "\300"
#define EMPTYSET "\306"
#define INTER    "\307"
#define UNION    "\310"
#define PRSUPSET "\311"
#define SUPSET   "\312"
#define PRSUBSET "\314"
#define SUBSET   "\315"
#define IN       "\316"
#define NOTIN    "\317"
#define ANGLE    "\320"
#define NABLA    "\321"
#define AND      "\331"
#define OR       "\332"
#define DBLEFTARROW  "\334"
#define DBUPARROW    "\335"
#define DBRIGHTARROW "\336"
#define DBDOWNARROW  "\337"
#define PI    "\325"
#define SQRT  "\326"
#define DOT   "\327"
#define SIG   "\345"
#define INT   "\362"

#define BIGSQRT  "2"		/* got from the sym-s family */
#define BIGINT   "I"
#define BIGPI    "P"
#define BIGSIG   "S"

/* These are the number representations (or command_ids) of the commands 
   available in LTxo thus far.  They are also ids to the sym_tbl in
   ltxo_tbl.c for the SYM_??? ids.  It is a pain in the neck defining
   them but for some reason 'enum' does not work. */ 

#define MAXCHARCOM 12		/* max chars in the a command - change 
				   according to class of commands --
				   so far: 'dbrightarrow' */ 

#define SYM_FORALL    0
#define SYM_EXISTS    1
#define SYM_SIMILIAR  2
#define SYM_AST       3
#define SYM_LTE       4
#define SYM_INFTY       5
#define SYM_LEFTARROW 6
#define SYM_UPARROW   7
#define SYM_RIGHTARROW 8
#define SYM_DOWNARROW  9
#define SYM_PM     10
#define SYM_GTE    11
#define SYM_MULT   12
#define SYM_PARTIAL    13
#define SYM_BULLET 14
#define SYM_NEQ    15
#define SYM_EQV    16
#define SYM_APPROX 17
#define SYM_ALEPH  18
#define SYM_EMPTYSET 19
#define SYM_INTER    20
#define SYM_UNION 21
#define SYM_PRSUPSET 22
#define SYM_SUPSET 23
#define SYM_PRSUBSET 24
#define SYM_SUBSET 25
#define SYM_IN     26
#define SYM_NOTIN  27
#define SYM_ANGLE  28
#define SYM_NABLA  29
#define SYM_AND    30
#define SYM_OR     31
#define SYM_DBLEFTARROW 32
#define SYM_DBUPARROW  33
#define SYM_DBRIGHTARROW 34
#define SYM_DBDOWNARROW 35
#define SYM_PI     36
#define SYM_SQRT    37
#define SYM_DOT   38
#define SYM_SIG   39
#define SYM_INT    40

/* Don't change what was above --- they are indexes to sym_tbl too. */

#define COM_BOLD        100	/* 'b' */
#define COM_ITA         101	/* 'i' */
#define COM_GREEK	102	/* 'g' */
#define COM_HELVET      103	/* 'h' - change to helvetica font */
#define COM_TIMES       104	/* 'r' - change to roman font */
#define COM_FIX         105	/* 'f' - change to fix font */
#define COM_RIGHT       106	/* '>' - flush right */
#define COM_U		107	/* 'u' */
#define COM_SPACE       108	/* '#' */
#define COM_NL		109	/* '.' */
#define COM_C		110	/* 'c' */
#define COM_CENTER	111	/* center */
#define COM_UP1		112	/* ^1 - increase size */
#define COM_UP2		113	/* ^2 */
#define COM_UP3		114	/* ^3 */
#define COM_UP4		115	/* ^4 */
#define COM_UP5		116	/* ^5 */
#define COM_UP6		117	/* ^6 */
#define COM_DOWN1	118	/* v1 - decrease size */
#define COM_DOWN2	119	/* v2 */
#define COM_DOWN3	120	/* v3 */
#define COM_DOWN4	121	/* v4 */
#define COM_DOWN5	122	/* v5 */
#define COM_DOWN6	123	/* v6 */
#define COM_SUPER	124	/* '+' */
#define COM_SUB		125	/* '-' */
#define COM_VEC 	126	/* vector above variable */
#define COM_OVER	127	/* over - fractions */
#define COM_SQRT	128	/* sqrt - square root */
#define COM_INT 	129	/* int - integration */
#define COM_SUM         130	/* sum - summation */
#define COM_PROD        131	/* prod - pi sign for product */

#define SUBCOM_NUM	201	/* subcommands */
#define SUBCOM_DENOM    202
#define SUBCOM_FROM     203
#define SUBCOM_TO       204

#define NO_COM         998       /*  '@' */
#define ERROR_COM      999	 /* error id */

XFontStruct *get_font_struct();

extern void load_font();
extern int endlimiter();
extern int getcommand_id();
extern int delimiter();
extern int getnumskip();
extern int script_offset();
extern void ltxErrAlert();
#endif LTXO_PRI_H
