.TH EXPECT 1 "3 January 1992"
.SH NAME
expect \- programmed dialogue with interactive programs
.SH SYNOPSIS
.B expect
[
.B \-dinN
]
[
.B \-c
.I cmds
]
[[
.B \-f
]
.I cmdfile
]
[
.I args
]
.SH INTRODUCTION
.B expect
is a program that "talks" to other interactive programs according to a
script.  Following the script,
.B expect
knows what can be expected from
a program and what the correct response should be.  An interpreted
language provides branching and high-level control structures to
direct the dialogue.  (Alternatively, the user may use the C language
directly.  See libexpect(3).)  In addition, the user can take control
and interact directly when desired, afterward returning control to the
script.
.PP
The name "expect" comes from the idea of
.I send/expect
sequences popularized
by uucp, kermit and other modem control programs.
However unlike uucp,
.B expect
is generalized so that it can be run as a user-level command
with any program and task in mind.
.RB ( expect
can actually talk to several programs at the same time.)
.PP
For example, here are some things
.B expect
can do:
.RS
.TP 4
\(bu
Cause your computer to dial you back,
so that you can login without paying for the call.
.TP
\(bu
Start a game (e.g., rogue) and if the optimal configuration doesn't appear,
restart it (again and again) until it does,
then hand over control to you.
.TP
\(bu
Run fsck, and in response to its questions, answer "yes", "no" or give control back to you,
based on predetermined criteria.
.TP
\(bu
Connect to another network or BBS (e.g., MCI Mail, CompuServe) and
automatically retrieve your mail so that it appears as if
it was originally sent to your local system.
.TP
\(bu
Carry environment variables, current directory,
or any kind of information across rlogin, telnet, tip, su, chgrp, etc.
.RE
.PP
There are a variety of reasons why the shell cannot perform these tasks.
(Try, you'll see.)
All are possible with
.BR expect .
.PP
In general,
.B expect
is useful for running any program which requires
interaction between the program and the user.
All that is necessary is that the interaction can be characterized
programmatically.
.B expect
can also give the user back control
(without halting the program being controlled) if desired.
Similarly, the user can return control to the
.I send/expect
script at any time.
.SH USAGE
.B expect
reads
.I cmdfile
for a list of commands to execute.
.B expect
may also be invoked implicitly on systems which support the #! notation
by marking the script executable, and making the first line in your script:

	#!/usr/local/bin/expect \-f

Of course, the path must accurately describe where
.B expect
lives.  /usr/local/bin is just an example.

The
.B \-c
flag prefaces a command to be executed before any in the script.
The command should be quoted to prevent being broken up by the shell.
This option may be used multiple times.
Multiple commands may be
executed with a single \-c by separating them with semicolons.
Commands are executed in the order they appear.  
.PP
The
.B \-d
flag enables some debugging output, which
primarily reports internal activity of commands such as 
.B expect
and
.BR interact .
This flag has the same effect as "debug 1" at the beginning of an expect
script, plus the version of
.B expect
is printed.
(The
.B strace
command is useful for tracing statements, and the
.B trace
command is useful for tracing variable assignments.)
.PP
The
.B \-f
flag prefaces a file from which to read commands from.
The flag itself is optional as it is only useful when using
the #! notation (see above),
so that other arguments may be supplied on the command line.
.PP
If the string "\-" is supplied as a filename, standard input is read instead.
(Use "./\-" to read from a file actually named "\-".)
.PP
The
.B \-i
flag causes
.B expect
to interactively prompt for commands instead of reading
them from a file.
Prompting is terminated via the
.B exit
command or upon EOF.
See
.B interpreter
(below) for more information.
.B \-i
is assumed if neither a command file nor
.B \-c
is used.
.PP
.B \-\-
may be used to delimit the end of the options.  This is useful if
you want to pass an option-like argument to your script without it being
interpreted by
.BR expect .
This can usefully be placed in the #! line to prevent any flag-like
interpretation by expect.  For example, the following will leave the
original arguments (including the script name) in the variable
.IR argv .

	#!/usr/local/bin/expect \-\-

Note that the usual getopt(3) and execve(2) conventions must be observed
when adding arguments to the #! line.
.PP




The file $expect_library/expect.rc is sourced automatically if present, unless
the
.B \-N
flag is used.  Immediately after this,
the file ~/.expect.rc is sourced automatically, unless the
.B \-n
flag is used.  Both of these are sourced after executing any
.B \-c
flags.
.PP
Optional
.I args
are constructed into a list and stored in the variable named
.IR argv .
.I argv
may be accessed with the usual list access commands.
For example, the length of
.I argv
is calculated by "llength $argv".
.PP
.I argv[0]
is defined to be the name of the script.
For example,
the following prints out the name of the script and the first two arguments:
.fi

	send_user [lrange $argv 0 2]

.fi
.SH COMMANDS
.B expect
uses
.I Tcl
(Tool Command Language).
Tcl provides control flow (e.g., if, for, break),
expression evaluation and several other features such as recursion,
procedure definition, etc.
Commands used here but not defined (e.g.,
.BR set ,
.BR if ,
.BR exec )
are Tcl commands (see tcl(3)).
.B expect
supports additional commands, described below.
Unless otherwise specified, commands return the empty string.
.PP
Commands are listed alphabetically so that they can be quickly located.
However, new users may find it easier to start by reading the descriptions
of
.BR spawn ,
.BR send ,
.BR expect ,
and
.BR interact ,
in that order.
Then read the examples at the rear of this man page.
.I
.TP 10
.BI close " [\-i spawn_id]"
closes the connection to the current process.
Most interactive programs will detect EOF on their stdin and exit;
thus
.B close
usually suffices to kill the process as well.
The
.B \-i
flag declares the process to close corresponding to the named spawn_id.
.IP
Both
.B expect
and
.B interact
will detect when the current process exits and implicitly do a
.BR close .
But if you kill the process by, say, "exec kill $pid",
you will need to explicitly call
.BR close .
.IP
No matter whether the connection is closed implicitly or explicitly,
you should call
.B wait
to clear up the corresponding kernel process slot.
.B close
does not call
.B wait
since there is no guarantee that closing a process connection will cause
it to exit.
See
.B wait
below for more info.
.TP
.BI debug " [\-f file] value"
causes further commands to send debugging information internal to
.B expect
to stderr if
.I value
is non-zero.  This output is disabled if
.I value
is 0.  The debugging information includes every character received,
and every attempt made to match the current output against the patterns.
.IP
If the optional
.I file
is supplied, all normal and debugging output is written to that file
(regardless of the value of
.IR value ).
Any previous debugging output file is closed.
.TP
.BI disconnect
disconnects a forked process from the terminal.  It continues running in the
background.  The process is given its own process group (if possible).
Standard I/O is redirected to /dev/null.
.IP
The following fragment uses
.B disconnect
to continue running the script in the background.  
.nf

      if [fork]!=0 exit
      disconnect
      . . .

.fi
The following script reads a password, and then runs a program
every hour that demands a password each time it is run.  The script supplies
the password so that you only have to type it once.
(See the
.B system
command which demonstrates how to turn off password echoing.)
.nf

      send_user "password?\\ "
      expect_user *
      # strip newline off end of password
      scan $expect_match %s pass
      for {} 1 {} {
            if [fork]!=0 {exec sleep 3600;continue}
            disconnect
            spawn priv_prog
            expect Password:
            send $pass
            . . .
            exit
      }

.fi
An advantage to using
.B disconnect
over the shell asynchronous process feature (&) is that
.B expect
can
save the terminal parameters prior to disconnection, and then later
apply them to new ptys.  With &,
.B expect
does not have a chance
to read the terminal's parameters since the terminal is already
disconnected by the time
.B expect
receives control.
.TP
.BI exit " [status]"
kills
.BR expect .
All connections to spawned processes are closed.  Closure will be detected
as an EOF by spawned processes.
.IP
Exit generates a signal 0 (see 
.BR trap ),
but otherwise takes
no other actions beyond what the normal _exit(2) procedure does.
Thus, spawned processes that do not check for EOF may continue to run.
(A variety of conditions are important to determining, for example, what
signals a spawned process will be sent, but these are system-dependent,
typically documented under exit(3).)
Spawned processes that continue to run will be inherited by init.
.IP
.I status
(or 0 if not specified) is returned as the exit status of
.BR expect .
.B exit
is implicitly executed if the end of the script is reached.
.TP
.BI expect " [[\-opts] patlist1 body1] ... [\-opts] patlistn [bodyn]"
waits until one of the patterns matches the output of a spawned process,
a specified time period has passed, or an end-of-file is seen.
If the final body is null, it may be omitted.
.IP
Patterns from the most recent
.B expect_before
command are implicitly used before any other patterns.
Patterns from the most recent
.B expect_after
command are implicitly used after any other patterns.
.IP
If the arguments to the entire
.B expect
statement require more than one line,
all the arguments may be "braced" into one so as to avoid terminating each
line with a backslash.  In this one case, the usual Tcl substitutions will
occur despite the braces.
.IP
Each
.I patlist
consists of a single pattern or list of patterns.
If a
.I patlist
is
.BR eof ,
the corresponding body is executed upon end-of-file.
If a
.I patlist
is
.BR timeout ,
the corresponding body is executed upon timeout.
The default timeout period is 10 seconds but may be set, for example to 30,
by the command "set timeout 30".  An infinite timeout may be designated
by the value \-1.
If a
.I patlist
is
.BR default ,
the corresponding body is executed upon either timeout or end-of-file.
.IP
If a pattern matches, then the corresponding body is executed.
.B expect
returns the result of the body (or null if no pattern matched).
In the event that multiple patterns match, the one appearing first is
used to select a body.
.IP
Each time new output arrives, it is compared to each pattern in the order
they are listed.  Thus, you may test for absence of a match by making
the last pattern something guaranteed to appear, such as a prompt.
In situations where there is no prompt, you must use
.B timeout
(just like you would if you were interacting manually).
.IP
Pattern lists are specified in two ways.  By default, 
pattern lists are lists of patterns that are specified as with Tcl's
.B string match
command.  (Such patterns are also similar to C-shell regular expressions
usually referred to as "glob" patterns).
.IP
For example, the following fragment looks for a successful login.
(Note that
.B abort
is presumed to be a procedure defined elsewhere in the script.)
.nf

.ta \w'      expect 'u +\w'connected    'u
      expect {
	connected	break
	busy	{print busy\\n ; continue}
	{failed {invalid password}} abort
	timeout	abort
      }

.fi
Braces are not necessary on the first or second
.IR patlist,
although the
the second body requires them, since it is a set of statements.
The third
.I patlist
contains two patterns.  The second one is surrounded
by braces to protect the literal space from breaking it up.
Alternatively, spaces may be escaped with backslashes.
More information on forming glob-style patterns can be found
in EXPECT HINTS below as well as the Tcl manual itself.
.IP
Alternatively, regexp-style patterns follow the syntax defined by Tcl's
command,
.B regexp
(short for "regular expression") command.
Lists of such patterns are specified using the regexp
alternation syntax (rather than the Tcl braced list).
(This alone tends to make regexp patterns easier to deal with.)
regexp patterns are introduced with the flag
.BR \-re .
The previous example can be rewritten using a regexp as:
.nf

.ta \w'      expect 'u +\w'connected    'u
      expect {
	connected	break
	busy	{print busy\\n ; continue}
	\-re "failed|invalid password" abort
	timeout	abort
      }

.fi
Both types of patterns are "unanchored".  This means that patterns
do not have to match the entire string, but can begin and end the
match anywhere in the string (as long as everything else matches).
Use ^ to match the beginning of a string, and $ to match the end.
Note that if you do not wait for the end of a string, your responses
can easily end up in the middle of the string as they are echoed from
the spawned process.  While still producing correct results, the output
can look unnatural.  Thus, use of $ is encouraged if you can exactly
describe the characters at the end of a string.
.IP
The
.B \-nocase
flag causes uppercase characters of the output to compare as if they were
lowercase characters.  The pattern is not affected.
.IP
While reading output,
more than 2000 bytes can force earlier bytes to be "forgotten".
This may be changed with the function
.BR match_max .
(Note that excessively large values can slow down the pattern matcher.)
If
.I patlist
is
.BR buffer_full ,
the corresponding body is executed if
.I match_max
bytes have been received and no other patterns have matched.
.IP
Upon matching a pattern (or eof or buffer_full),
any matching and previously unmatched output is saved in the variable
.IR expect_out(buffer) .
Up to 9 regexp substring matches are saved in the variables
.I expect_out(1,string)
through
.IR expect_out(9,string) .
The starting and ending indices (in a form suitable for
.BR lrange )
of the
10 strings are stored in the variables
.I expect_out(X,start)
and
.I expect_out(X,end)
where X is the corresponds to the substring position in the pattern.
0 refers to the entire pattern itself.  For example, if a process has produced output of "abcdefgh\\n", the result of:
.nf

      expect	"cd"

.fi
is as if the following statements had executed:
.nf

	set expect_out(0,start) 2
	set expect_out(0,end) 3
	set expect_out(0,string) cd
	set expect_out(buffer) abcd

.fi
and "efgh\\n" is left in the output buffer.
If a process produced the output "abbbcabkkkka\\n", the result of:
.nf

	expect \-re "b(b*).*(k+)"

.fi
is as if the following statements had executed:
.nf

	set expect_out(0,start) 1
	set expect_out(0,end) 10
	set expect_out(0,string) bbbcabkkkk
	set expect_out(1,start) 2
	set expect_out(1,end) 3
	set expect_out(1,string) bb
	set expect_out(2,start) 10
	set expect_out(2,end) 10
	set expect_out(2,string) k
	set expect_out(buffer) abbbcabkkkk

.fi
and "a\\n" is left in the output buffer.  The pattern "*" will
flush the output buffer without reading any more output from the
process.
.IP
Normally, the matched output is discarded from expect's internal buffers.
This may be prevented by prefixing a pattern with the
.B \-n
flag.  The name, placement, and existence of this flag is subject to change
in a future release.  Therefore, it should not be used in permanent scripts.
However, it is especially useful in experimenting (which is why it has
a one-character name).
.IP
By default, 
patterns are matched against output from the current process, however the
.B \-i
flag declares the output from the named spawn_id be matched against
any following patterns.  For example, the following example waits for
"connected" from the current process, or "busy", "failed" or "invalid
password" from the spawn_id named by $proc2.
.nf

      expect {
	connected	break
	\-i $proc2 busy	{print busy\\n ; continue}
	\-re "failed|invalid password" abort
	timeout	abort
      }

.fi
The variable
.I any_spawn_id
may be used to match patterns to any spawn_id.
Upon matching a pattern (or eof or buffer_full),
the variable,
.I expect_out(spawn_id)
is set to the spawn_id which produced
the matching output.
.IP
Actions such as
.B break
and
.B continue
cause control structures (i.e.,
.BR for ,
.BR proc )
to behave in the usual way.
The special argument
.B \-expect
to
.B continue
allows
.B expect
itself to continue
executing rather than returning as it normally would.
.IP
This is useful for avoiding explicit loops or repeated expect statements.
The following example is part of a fragment to automate rlogin.  The
.B continue
avoids having to write a second
.B expect
statement (to look for the prompt again) if the rlogin prompts for a password.
.nf

expect {
	Password: {
		system stty -echo
		send_user "password (for $user) on $host: "
		expect_user -re "(.*)\n"
		send_user "\n"
		send "$expect_out(1,string)\r"
		system stty echo
		continue -expect
	} incorrect* {
		send_user "invalid password or account\n"
		exit
	} timeout {
		send_user "connection to $host timed out\n"
		exit
	} eof {
		send_user "connection to host failed: $expect_out(buffer)"
		exit
	} -re $prompt
}

.fi
For example, the following fragment might help a user guide
an interaction that is already totally automated.  In this case, the terminal
is put into raw mode.  If the user presses "+", a variable is incremented.
If "p" is pressed, several newlines are returns are sent to the process,
perhaps to poke it in some way, and "i" lets the user interact with the
process, effectively stealing away control from the script.
In each case, the
.B continue \-expect
allows the current
.B expect
to continue pattern matching after executing the
current action.
.nf

system stty raw \-echo
expect_after { \-i $user_spawn_id
	"p" {send "\\r\\r\\r"; continue \-expect}
	"+" {incr foo; continue \-expect}
	"i" {interact; continue \-expect}
	"quit" exit
}

.fi
.IP
.B continue \-expect
resets the timeout timer.
.IP
When running in cooked mode,
SIGINT (usually generated by pressing ^C) will cause
.B expect
to timeout an internal read() prematurely.
This is useful for debugging scripts.
A ^C at any other time (except during
.BR interact )
will implicitly cause the
.B expect
program to exit (as if the
.B exit
command had been used).  SIGINT may be redefined by the trap command.
For example, to force a SIGINT to abort the program at any time, it suffices
to say "trap exit 2".
.TP
.BI expect_after " [expect args]"
takes the same arguments as
.BR expect ,
however it returns immediately.
Pattern-action pairs from the most recent
.B expect_after
are implicitly added to any following
.B expect
commands.  If a pattern matches, it is treated as if it had been
specified in the
.B expect
command itself, and the associated body is executed in the context
of the
.B expect
command.
If patterns from both
.B expect
and
.B expect_after
can match, the
.B expect
pattern is used.
.TP
.BI expect_before " [expect args]"
takes the same arguments as
.BR expect ,
however it returns immediately.
Pattern-action pairs from the most recent
.B expect_before
are implicitly added to any following
.B expect
commands.  If a pattern matches, it is treated as if it had been
specified in the
.B expect
command itself, and the associated body is executed in the context
of the
.B expect
command.
If patterns from both
.B expect_before
and
.B expect
can match, the
.B expect_before
pattern is used.
.TP
.BI expect_user  " [expect args] [patlist1 body1 ...] patlistn [bodyn]"
is like
.B expect
but it reads characters from stdin (i.e. keystrokes from the user).
By default, reading is performed in cooked mode.
Thus, lines must end with a return in order for
.B expect
to see them.
This may be changed via
.B stty
(see the
.B system
command below).
.TP
.BI expect_version " [[\-exit] version]"
is useful for assuring that the script is compatible with the current
version of expect.
.IP
With no arguments, the current version of
.B expect
is returned.  This version
may then be encoded in your script.  If you actually know that you are not
using features of recent versions, you can specify an earlier version.
.IP
Versions consist of up to three numbers separated by dots.  First
is the major number.  Scripts written for versions of
.B expect
with a
different major number will almost certainly not work.
.B expect_version 
returns an error if the major numbers do not match.
.IP
Second is the minor number.  Scripts written for a version with a
greater minor number than the current version
may depend upon some new feature and might not run.
.B expect_version
returns an error if the major numbers match, but the script minor number
is greater than that of the running expect.
.IP
Third is a number that plays no part in the version comparison.
However, it is incremented when the
.B expect
software
distribution is changed in any way, such as by additional documentation
or optimization.  It is reset to 0 upon each new minor version.
.IP
With the
.B \-exit
flag,
.B expect
prints an error and exits if the version is out of date.
.IP
There have been three major versions of Expect.  The first was never officially
released and only existed for two months, as I experimented and designed the
basic style of expect.  The second version lasted a year and a half
until the time when Tcl 6 and Expect 3 were issued.
Version 6 of Tcl was incompatible
with earlier versions, but John Ousterhout (Tcl's
author) suggested that enough
experience had been gained that such changes were appropriate, and this might
be the last time it could be done because further delay would be that much
more painful due to the ever-growing number of people using it.
I feel the same way.  I hope that the current version of
.B Expect
will last many years without the introduction of incompatibilities
that might render scripts obsolete.
.IP
During its one and a half year public lifetime, the second version of Expect
was requested (and perhaps even used) by
over 3000 sites.  I received numerous suggestions for improvements or
future directions.  Many of these either appear in the current version
or are addressed in the
.B expect
FAQ file.
.TP
.BI fork
creates a new process.  The new process is an exact copy of the current
.B expect
process.  On success,
.B fork
returns 0 to the new (child) process and return the process ID of the child
process to the parent process.
On failure (invariably due to lack of resources, e.g., swap space, memory),
.B fork
returns \-1 to the parent process, and no child process is created.
.IP
Forked processes exit via the
.B exit
command, just like the original process.
Forked processes are allowed to write to the log files.  If you do not
disable debugging or logging in most of the processes, the result can be
confusing.
.IP
Some pty implementations may be confused by multiple readers and writers,
even momentarily.  Thus, it is safest to
.B fork
before spawning processes.
.TP
.BI interact " [\-u spawn_id] [[\-f] string1 body1 ...] [\-f] stringn [bodyn]"
gives control of the current process to the user, so that
keystrokes are sent to the current process,
and the stdout and stderr of the current process are returned.
.IP
String-body pairs may be specified as arguments, in which case the
body is executed when the corresponding string is entered.  (The
string is not sent to the current process.)   The
.B interpreter
command is assumed, if the final body is missing.
.IP
If the arguments to the entire
.B expect
statement require more than one line,
all the arguments may be "braced" into one so as to avoid terminating each
line with a backslash.  In this one case, the usual Tcl substitutions will
occur despite the braces.
.IP
For example, the following command runs interact with the following
string-body pairs defined:  When ^Z is pressed,
.B expect
is suspended.
When ^A is pressed, the user sees "you typed a control-A" and the
process is sent a ^A.  When $ is pressed, the user sees the date.
When ^C is pressed,
.B expect
exits.  If "foo" is entered, the user sees "bar".
When ~~ is pressed, the
.B expect
interpreter runs interactively.
.nf

.ta \w'    interact 'u +\w'\\Cz  'u +\w'{'u
    interact {
	\\Cz	{exec kill \-STOP 0}
	\\Ca	{send_user "you typed a control\-A\\n";
			send "\\Ca"
		}
	$	{send_user "The date is [exec date]."}
	\\Cc	exit
	foo	{send_user "bar"}
	~~
    }

.fi
.IP
In string-body pairs, strings are matched in the order they are listed
as arguments.  Strings that partially match are not sent to the
current process in anticipation of the remainder coming.  If
characters are then entered such that there can no longer possibly be
a match, only the part of the string will be sent to the process that cannot
possibly begin another match.  Thus, strings that are substrings of
partial matches can match later, if the original strings that was attempting
to be match ultimately fails. 
.IP
Actions such as
.B break
and
.B continue
cause control structures (i.e.,
.BR for ,
.BR proc )
to behave in the usual way.
However
.B return
causes interact to return to its caller, while
.B return \-tcl
causes
.B interact
to cause a return in its caller.  For example, if "proc foo" called
.B interact
which then executed the action
.BR "return \-tcl" ,
.B proc foo
would return.  (This means that if
.B interact
calls
.B interpreter
interactivley typing
.B return
will cause the interact to continue, while
.B "return \-tcl"
will cause the interact to return to its caller.)
.IP
During
.BR interact ,
raw mode is used so that all characters may be passed to the current process.
If the current process does not catch job control signals,
it will stop if sent a stop signal (by default ^Z).
To restart it, send a continue signal (such as by "kill \-CONT <pid>").
If you really want to send a SIGSTOP to such a process (by ^Z),
consider spawning csh first and then running your program.
On the other hand, if you want to send a SIGSTOP to
.B expect
itself, first press the escape character, and then press ^Z.
.IP
String-body pairs can be used as a shorthand for avoiding having
to enter the interpreter and execute commands interactively.  The previous
terminal mode is used while the body of a string-body pair is being executed.
.IP
The
.B \-f
flag (for "fast") skips the possibility of a temporary mode switch
during pair processing.
This consequently prevents characters from being lost when the terminal is
returned to raw mode (an unfortunate feature of the terminal driver)
at the end of a key-body pair execution.
.B \-f
also skips the check that
.I spawn_id
might have changed.  The only reason not to use
.B \-f
is if your action
depends on running in cooked mode, or if it changes the value of
spawn_id.
.IP
The
.B \-F
flag indicates that all following flags behave as if
they each were declared with
.BR \-f .
.IP
The previous example is restated below in a more efficient form, using
.BR \-F .
The first line cannot use
.B \-f
because it would leave
the user back in the shell in raw mode.  The last line would remain in raw
mode but it is overridden by the
.B interpreter
command itself, which forces it into cooked mode temporarily.
The second line requires no extra \\r because
.B send
automatically adds one.
The other lines need no change and run fine with
\-f.
.nf

.ta \w'    interact 'u +\w'-f \\Cz  'u +\w'{'u
    interact {
	\\Cz	{kill \-STOP 0}
	\-F \\Ca	{send_user "you typed a control\-A\\n";
			send "\\Ca"
		}
	$	{send_user "The date is [exec date]."}
	\\Cc	exit
	foo	{send_user "bar"}
	~~
    }

.fi
.IP
During
.BR interact ,
previous use of
.B log_user
is ignored.  In particular,
.B interact
will force its output to be logged (sent to the standard output)
since it is presumed the user doesn't wish to interact blindly.
.IP
The
.B \-o
flag causes following key-body pairs to be applied to the output of
the current process.
This can be useful, for example, when dealing with hosts that
send unwanted characters during a telnet session.  
.IP
By default, 
.B interact
expects the user to be writing stdin and reading stdout of the
.B expect
process
itself.
The \-u flag (for "user") makes
.B interact
look for the user as the process named by its argument
(which must be a spawned id).  
.IP
This allows two unrelated processes to be joined
together without using an explicit loop.  To aid in debugging, expect
diagnostics always go to stderr (or stdout for certain logging and
debugging information).  For the same reason, the
.B interpreter
command will read interactively from stdin.
.IP
For example, the following fragment creates a login process.
Then it dials the user (not shown), and finally connects the two together.
Of course, any process may be substituted for login.
A shell, for example, would allow the user to work without supplying an
account and password.
.nf

	spawn login
	set login $spawn_id
	spawn tip modem
	# dial back out to user
	# connect user to login
	interact \-u $login

.fi
.TP
.BI interpreter
causes the user to be interactively prompted for
.B expect
and Tcl commands.
The result of each command is printed.
.IP
Actions such as
.B break
and
.B continue
cause control structures (i.e.,
.BR for ,
.BR proc )
to behave in the usual way.
However
.B return
causes interpreter to return to its caller, while
.B return \-tcl
causes
.B interpreter
to cause a return in its caller.  For example, if "proc foo" called
.B interpreter
which then executed the action
.BR "return \-tcl" ,
.B proc foo
would return.
Any other command causes
.B interpreter
to continue prompting for new commands.
.IP
By default, the prompt contains two integers.
The first integer describes the depth of
the evaluation stack (i.e., how many procedures have yet to return).  The
second integer is the Tcl history identifier.  The prompt can be set by
defining a procedure called "prompt1" whose return value becomes the next
prompt.  If a statement has open quotes, parens, braces, or brackets, a
secondary prompt (by default "+> ") is issued upon newline.  The secondary
prompt may be set by defining a procedure called "prompt2".
.IP
During
.BR interpreter ,
cooked mode is used, even if the its caller was using raw mode.
.TP
.BI log_file " [[\-a] file]"
If a filename is provided,
.B log_file
will record a transcript of the session (beginning at that point) in the file.
.B log_file
will stop recording if no argument is given.  Any previous log file is closed.
.IP
The
.I \-a
flag forces output to be logged that was suppressed by the
.B log_user
command.
.IP
The
.B log_file
command
.I appends
to old files rather than truncating them,
for the convenience of being able to turn logging off and on multiple
times in one session.
A simple way to always start with a fresh log file is to delete the log file
before using the
.B log_file
command for the first time in a script.  For example:
.nf

	exec rm transcript
	log_file transcript

.fi
.TP
.BI log_user " expression"
By default, the send/expect dialogue is logged to stdout
(and a logfile if open).
This logging is disabled by the command "log_user 0"
and reenabled by "log_user 1".
.TP
.BI match_max " [\-d] [\-i spawn_id] [size]"
defines the size of the buffer (in bytes) used internally by
.BR expect .
With no
.I size
argument, the current size is returned.
.IP
With the
.B \-d
flag, the default size is set.  (The initial default is 2000.)
With the
.B \-i
flag, the size is set for the named spawn id, otherwise it is set for
the current process.
.TP
.BI overlay " [\-# spawn_id] [\-# spawn_id] [...] program [args]"
executes
.IR "program args"
in place of the current
.B expect
program, which terminates.
A bare hyphen argument forces a hyphen in front of the command name as if
it was a login shell.
All spawn_ids are closed except for those named as arguments.  These
are mapped onto the named file descriptors.
.IP
Spawn_ids are mapped to file descriptors for the new program to inherit.
For example, the following line runs chess and allows it to be
controlled by the current process \- say, a chess master.
.nf

	overlay \-0 $spawn_id \-1 $spawn_id \-2 $spawn_id chess

.fi
This is more efficient than
"interact \-u", however, it sacrifices the ability to do programmed
interaction since the
.B expect
process is no longer in control.
.IP
Note that no controlling terminal is provided.  Thus, if you
disconnect or remap standard input, programs that do
job control (shells, login, etc) will not function properly.
.TP
.BI send " [\-s] [\-h] [\-i spawn_id] [\-raw] args"
Sends
.IR args
to the current process.
Strings are interpreted following Tcl rules.
For example, the command
.nf

	send "hello world\\r"

.fi
sends the characters, h e l l o <blank> w o r l d <return> to the 
current process.  
(Tcl includes a printf command (called
.BR format )
which can build arbitrarily complex strings.)
.IP
The
.I \-i
flag declares that the string be sent to the named spawn_id.
If the spawn_id is
.IR user_spawn_id ,
and the terminal is in raw mode, newlines in the string are translated
to return-newline
sequences so that they appear as it the terminal was in cooked mode.
The
.I \-raw
flag disables this translation.
.IP
The
.I \-s
flag forces output to be sent "slowly", thus avoid the common situation
where a computer outtypes an input buffer that was designed for a
human who would never outtype the same buffer.  This output is
controlled by the value of the variable "send_slow" which takes a two
element list.  The first element is an integer that describes the
number of bytes to send atomically.  The second element is a real
number that describes the number of seconds by which the atomic sends
must be separated.  For example, "set send_slow {10 .001}" would force
"send \-s" to send strings with 1 millisecond in between each 10
characters sent.
.IP
The
.I \-h
flag forces output to be sent (somewhat) like a human actually typing.
Human-like delays appear between the characters.  (The algorithm is
based upon a Weibull distribution, with modifications to suit this
particular application.)  This output is controlled by the value of
the variable "send_human" which takes a five element list.  The first
two elements are average interarrival time of characters in seconds.
The first is used by default.  The second is used at word endings, to
simulate the subtle pauses that occasionally occur at such
transitions.  The third parameter is a measure of varibility where .1
is quite variable, 1 is reasonably variable, and 10 is quite
invariable.  The extremes are 0 to infinity.  The last two parameters
are, respectively, a minimum and maximum interarrival time.  As an
example, the following command types a lot like the author (a fast and
consistent typist):
.nf

	set send_human {.1 .3 1 .05 2}
	send \-h "I'm hungry.  Let's do lunch."

.fi
while the following might be more suitable after a hangover:
.nf

	set send_human {.4 .4 .2 .5 100}
	send \-h "Goodd party lash night!"

.fi
Note that errors are not simulated, although you can set up error
correction situations yourself by embedding mistakes and corrections
in a send argument.
.IP
It is a good idea to precede the first
.B send
to a process by an
.BR expect .
.B expect
will wait for the process to start, while
.B send
cannot.
In particular, if the first
.B send
completes before the process starts running,
you run the risk of having your data ignored.
In situations where interactive programs offer no initial prompt,
you can precede
.B send
by a delay as in:
.nf

	# To avoid giving hackers hints on how to break in,
	# this system does not prompt for an external password.
	# Wait for 5 seconds for exec to complete
	spawn telnet very.secure.gov
	exec sleep 5
	send password\\r

.fi
.TP
.BI send_error " args"
is like
.BI send ,
except that the arguments are sent to stderr rather than the current
process.
.TP
.BI send_user " args"
is like
.BR send ,
except that the arguments are sent to stdout rather than the current
process.
.TP
.BI spawn " program [args]"
creates a new process running
.IR "program args" .
Its stdin, stdout and stderr are connected to expect,
so that they may be read and written by other
.B expect
commands.
The connection is broken by
.B close
or if the process itself closes any of the file descriptors.
.IP
When a process is started by
.BR spawn ,
the variable
.I spawn_id
is set to a descriptor referring to that process.
The process described by
.I spawn_id
is considered the
.IR "current process" .
.I spawn_id
may be read or written, in effect providing job control.
.IP
.I user_spawn_id
is a predefined variable containing a descriptor which refers to the user.
For example, when
.I spawn_id
is set to this value,
.B expect
behaves like
.BR expect_user .
Do not assume the value of
.I user_spawn_id
will remain the same from one version of
.B expect
to another.
.IP
.B spawn
returns the UNIX process id.
Note that the UNIX process id is not equivalent to the descriptor in
.IR spawn_id .
.IP
Internally,
.B spawn
uses a pty, initialized the same way as the user's tty.
When this is not possible
(i.e.,
.B expect
was not started with a controlling terminal),
.B spawn
uses the tty settings that correspond to "stty sane".  If the variable
.I stty_init
is defined, it is interpreted in the style of stty arguments
as further configuration for any pty used by future
.B spawn
commands.  For example, "set stty_init sane" repeats the default
initialization.
.IP
Normally,
.B spawn
takes little time to execute.  If you notice spawn taking a
significant amount of time, it is probably encountering ptys that are
wedged.  A number of tests are run on ptys to avoid entanglements with
errant processes.  (These take 10 seconds per wedged pty.)  Running
expect with the \-d option will show if
.B expect
is encountering many ptys in odd states.  If you cannot kill
the processes to which these ptys are attached, your only recourse may
be to reboot.
.IP
If
.I program
cannot be spawned successfully because exec(2) fails (e.g. when
.I program
doesn't exist), an error message will be returned by the next
.B interact
or
.B expect
command as if
.I program
had run and produced the error message as output.
This behavior is a natural consequence of the implementation of
.BR spawn .
Internally, spawn forks, after which the spawned process has no
way to communicate with the original
.B expect
process except by communication
via the spawn_id.
.TP
.BI strace " level"
causes following statements to be printed before being executed.
(Tcl's trace command traces variables.)
.I level
indicates how far down in the call stack to trace.
For example,
the following command runs
.B expect
while tracing the first 4 levels of calls,
but none below that.
.nf

	expect \-c "strace 4" script.exp

.fi
.TP
.BI system " args"
gives
.I args
to sh(1) as input,
just if it had been typed as a command from a terminal.
.B expect
waits until the shell terminates.
The return status from sh is handled the same way that
.B exec
handles its return status.
.IP
In contrast to
.B exec
which redirects stdin and stdout to the script,
.B system
performs no redirection
(other than that indicated by the string itself).
Thus, it is possible to use programs which must talk directly to /dev/tty.
For the same reason, the results of
.B system
are not recorded in the log.
.IP
.B system
understands and evaluates certain cases of "stty" directly, in order
to efficiently handle mode switching during
.B interpeter
and
.BR interact .
In particular, the arguments
.B raw
or
.B \-cooked
put the terminal into raw mode.
The arguments
.B \-raw
or
.B cooked
put the terminal into cooked mode.
The arguments
.B echo
and
.B \-echo
put the terminal into echo and noecho mode respectively.
.IP
The following example illustrates how to use
.B system
to temporarily disable echoing.
This could be used in otherwise-automatic
scripts to avoid embedding passwords in them.
(See more discussion on this under EXPECT HINTS below.)
.nf

	system stty \-echo
	send_user "Password: "
	expect_user {*\\n}
	set password $expect_match
	system stty echo

.fi
.TP
.BI trap " [[command] signals]"
causes the given 
.I command
to be executed upon future receipt of any of the given signals.
If
.I command
is absent, the signal actions are reset to their defaults.
If
.I command 
is the string SIG_IGN, the signals are ignored.
.I signals
is either a single signal or a list of signals.  Signals may be specified
numerically or symbolically as per signal(3).  The "SIG" prefix may be omitted.
ONEXIT (signal 0) is raised upon exit from expect.
.IP
With no arguments,
.B trap
prints the commands associated with each signal number.
.IP
For example, the command "trap {send_user "Ouch!"} SIGINT" will print "Ouch!"
each time the user presses ^C.  The default behavior is restored
by "trap SIGINT".
.IP
Note that output may be lost if signals arrive during reads (although this
is usually the desired behavior).
.IP
.B trap
will not let you override the action for SIGALRM as this is used internally
to
.BR expect .
The disconnect command sets SIGALRM to SIG_IGN (ignore).  You can reenable
this as long as you disable it during subsequent spawn commands.
.IP
Few checks on signals are made.  For example,
.B trap
does not prevent you from registering signals that the kernel refuses to catch.
See signal(3) for more info.
.TP
.BI wait " [\-i spawn_id]"
delays until a signal is received or one of the spawned processes terminates
(or stops due to tracing).
If any spawned process terminates that has not been been waited for,
return is immediate.  (See wait(2) for more info.)
.IP
.B wait
returns two integers.
The first integer is the pid of the process that was reaped by the wait.
In this case, the second integer
is the exiting information as per wait(2).  If there were no processes to
be waited on, the integers returned are \-1 followed by errno(3).
.IP
The
.B \-i
flag declares the process to wait corresponding to the named spawn_id
(NOT the process id).
.SH PRETTY-PRINTING
A vgrind definition is available for pretty-printing
.B expect
scripts.
Assuming the vgrind definition supplied with the
.B expect
distribution is
correctly installed, you can use it as:
.nf

	vgrind \-lexpect fil

.fi
.SH EXAMPLES
It many not be apparent how to put everything together that the man page
describes.  I encourage you to read and try out the many examples in
the test directory of the
.B expect
distribution.
Some of them are real programs.  Others are simply illustrative
of certain techniques, and of course, a couple are just quick hacks.
The INSTALL file has a quick overview of these programs.
.PP
The
.B expect
papers (see SEE ALSO) are also useful although invariably shorter.  However,
there is a significant amount of
explanatory text accompanying those examples.
.SH CAVEATS
.B expect
takes a rather liberal view of scoping.
In particular, variables read by commands specific to the
.B expect
program will be sought first from the local scope, and if not found, in the
global scope.  For example, this
obviates the need to place "global timeout" in every
procedure you write that uses
.BR expect .
On the other hand, variables written are always in the local scope (unless
a "global" command has been issued).

If you cannot enable the multispawning capability
(i.e., your system supports neither select (BSD *.*), poll (SVR>2),
nor something equivalent),
.B expect
will only be able to control a single process at a time.
In this case, do not attempt to set
.IR spawn_id ,
nor should you execute processes via exec while a spawned process
is running.  Furthermore, you will not be able to
.B expect
from multiple processes (including the user as one) at the same time.
.SH BUGS
It was really tempting to name the program "sex" (for either "Smart EXec"
or "Send-EXpect"), but good sense (or perhaps just Puritanism) prevailed.

Tcl 6.0 has a bug in it that impacts expect.  Namely,
.B split
does not correctly handle formatting characters.  This is fixed in Tcl 6.1.

Tcl 6.0 and 6.1 have a bug in it which may produce the error
"Tcl_WaitPids got unknown process" followed by a core dump.  The
problem is that Tcl assumes it knows about all forked processes.  When
it waits for one of it's own (i.e., in exec) and stumbles across one
that was spawned by expect, it generates that error.
Until this is fixed, make sure you do a "wait" on any spawned
processes that have exited before you call exec.  I'll add this to the
documentation.
.B system
is safe from this bug, so if don't need the differences provided by
.BR exec ,
you can use
.B system
meanwhile.

Since Tcl uses C-style null-terminated strings,
there is no way to represent strings with nulls in them.
.B expect
will record such output to the log and stdout, but it will strip them
out before performing string matching or storing in the variable
.IR expect_match .

When a shell is spawned on an HP-UX system, it complains about not being
able to access the tty.  However, it runs anyway.  You'll have to discard
that message in your scripts, though.  If you figure out why this occurs
please let me know.

Ultrix 4.1 (at least the latest versions around here) considers
timeouts of above 1000000 to be equivalent to 0.

Some implementations of ptys are designed so that the kernel throws
away any unread output after 10 to 15 seconds (actual number subject
to your device driver) after the process has closed the file
descriptor.  Thus
.B expect
programs such as
.nf

	spawn date
	exec sleep 20
	expect

.fi
will fail.  To avoid this, invoke non-interactive programs with
.B exec
rather than
.BR spawn .
While such situations are conceivable, in practice I have never
encountered a situation in which the final output of a truly
interactive program would be lost due to this behavior.

On the other hand, Cray UNICOS ptys throw away any unread output
immediately after the process has closed the file descriptor.  I have
reported this to Cray and they are working on a fix.
.SH EXPECT HINTS
There are a couple of things about
.B expect
that may be non-intuitive.
This section attempts to address some of these things with a couple of
suggestions.

A common expect problem is how to recognize shell prompts.  Since
these are customized differently by differently people and different
shells, portably automating rlogin can be difficult without knowing
the prompt.  A reasonable convention is to have users store a regular
expression describing their prompt (in particular, the end of it) in
the environment variable EXPECT_PROMPT.  Code like the following
can be used.  If EXPECT_PROMPT doesn't exist, the code still has a good chance of functioning correctly.
.nf

set prompt "(%|$|#) "          ;# default prompt
if [info exists env(EXPECT_PROMPT)] {
	set prompt $env(EXPECT_PROMPT)
}

expect -re $prompt

.fi
I encourage you to write
.B expect
patterns that include the end of whatever
you
.B expect
to see.  This avoids the possibility of answering a question
before seeing the entire thing.  In addition, while you may well be
able to answer questions before seeing them entirely, if you answer
early,  your answer may appear echoed back in the middle of the question.
In other words, the resulting dialogue be correct but look scrambled.

Most prompts include a space character at the end.
For example, the prompt from ftp is 'f', 't', 'p', '>' and <blank>.
To match this prompt, you must account for each of these characters.
It is a common mistake not to include the blank.  You can either
put the blank in explicitly (prefaced with a backslash) or use a *.

If you use a pattern of the form X*, the * will match all the output
received from the end of X to the last thing received.
This sounds intuitive but can be somewhat confusing because the phrase
"last thing received" can vary depending upon the speed of the computer
and the processing of I/O both by the kernel and the device driver.
.PP
In particular, humans tend to see program output arriving in huge chunks
(atomically) when in reality most programs produce output one
line at a time.  Assuming this is the case, the * in the pattern of the
previous paragraph may only match the end of the current line even though
there seems to be more, because at the time of the match that was all
the output that had been received.
.PP
.B expect
has no way of knowing that further output is coming unless your
pattern specifically accounts for it.
.PP
Even depending on line-oriented buffering is unwise.  Not only do programs
rarely make promises about the type of buffering they do, but system
indigestion can break output lines up so that lines break at seemingly
random places.  Thus, if you can express the last few characters
of a prompt when writing patterns, it is wise to do so.

If you are waiting for a pattern in the last output of a program
and the program emits something else instead, you will not be able to
detect that with the
.B timeout
keyword.  The reason is that
.B expect
will not timeout \- instead it will get an
.B eof
indication.
Use that instead.  Even better, use both.  That way if that line
is ever moved around, you won't have to edit the line itself.

Newlines are usually converted to carriage return, linefeed sequences
when output by the terminal driver.  Thus, if you want a pattern that
explicitly matches the two lines, from, say, printf("foo\\nbar"),
you should use the pattern {foo\\r\\nbar}.
.PP
A similar translation occurs when reading from the user, via
.BR expect_user .
In this case, when you press return, it will be
translated to a newline.  If
.B expect
then passes that to a program
which sets its terminal to raw mode (like telnet), there is going to
be a problem, as the program expects a true return.  (Some programs
are actually forgiving in that they will automatically translate
newlines to returns, but most don't.)  Unfortunately, there is no way to find
out that a program put its terminal into raw mode.
.PP
Rather than manually replacing newlines with returns, the solution is to
just do a "system stty raw", which will stop the translation.
Note, however, that this means that you will no longer get the cooked
line-editing features.
.PP
.B interact
implicitly sets your terminal to raw mode so this problem will not arise then.

It is often useful to store passwords (or other private information)
in
.B expect
scripts.  This is not recommended since anything that is
stored on a computer is susceptible to being accessed by anyone.
Thus, interactively prompting for passwords from a script is a smarter
idea than embedding them literally.  Nonetheless, sometimes such embedding
they only possibility.
.PP
Unfortunately, the UNIX file system has no direct way of creating
files which are executable but unreadable.  Systems which support
setgid shell scripts may indirectly simulate this as follows:
.PP
Create the
.B expect
script (that contains the secret data) as usual.
Make its permissions be 710 (-rwx--x---) and owned by a trusted group,
i.e., a group which is allowed to read it.  If necessary, create a new
group for this purpose.  Next, create a /bin/sh script with
permissions 2751 (-rwxr-s--x) owned by the same group as before.
.PP
The result is a script which may be executed (and read) by anyone.
When invoked, it runs the
.B expect
script.

I believe that the regexp-style patterns are much easier to use.  The
original release of Tcl/expect did not offer them, and hence the
glob-style patterns remain the default due to common practice.  Nonetheless, I
encourage you to avoid the glob-style patterns.  Here is a
description of the pitfalls of glob-style patterns, should you decide
to persevere.

Quoting conventions can be confusing when using double quotes,
braces, backslash sequences and white space in
.B expect's
glob-style
.IR patlists .
.I patlists
are actually scanned twice (just like Tcl's
.B case
.IR patlists )
which will break strings up on white space.
One solution is just to put a backslash in front of every whitespace character.
You can also protect whitespace by placing a second set of braces around the
pattern, however this will prevent backslash substitution.
Alternatively, you can double quote the braced pattern thereby allowing
backslash sequences.  (Admittedly it is just plain ugly.)
Just about any other combination looks right but fails for one reason or
another.
For example, if you wish to match the characters: a <space> b <return> <newline> <anything>, the following will work:
.nf

	expect {a\\ b\\r\\n*}
	expect "{a b\\r\\n*}"

.fi
The following commands fail.
.nf

	expect a b\\r\\n*
	# breaks around space, and b\\r\\n* becomes action

	expect {a b\\r\\n*}
	# breaks into 2 patterns (around space)

	expect {"a b\\r\\n*"}
	# breaks into 2 patterns (around space)

	expect {{a b\\r\\n*}}
	# double brace disables \\r\\n interpretation

	expect "a\\ b\\r\\n*"
	# breaks into 3 patterns (around space and newline)

	expect "a b\\r\\n*"
	# breaks into 3 patterns (around space and newline)

.fi
.SH SEE ALSO
.BR Tcl (3),
.BR libexpect (3)
.br
.I
"expect: Curing Those Uncontrollable Fits of Interactivity" \fRby Don Libes,
Proceedings of the Summer 1990 USENIX Conference,
Anaheim, California, June 11-15, 1990.
.br
.I
"Using
.B expect
to Automate System Administration Tasks" \fRby Don Libes,
Proceedings of the 1990 USENIX Large Installation Systems Administration
Conference, Colorado Springs, Colorado, October 17-19, 1990.
.br
.I
"Tcl: An Embeddable Command Language" \fRby John Ousterhout,
Proceedings of the Winter 1990 USENIX Conference,
Washington, D.C., January 22-26, 1990.
.I
"expect: Scripts for Controlling Interactive Programs" \fRby Don Libes,
Computing Systems, Vol. 4, No. 2, University of California Press Journals,
November 1991.
.SH AUTHOR
Don Libes, National Institute of Standards and Technology
.SH ACKNOWLEDGEMENTS
Thanks to John Ousterhout for Tcl, and Scott Paisley for inspiration.
.PP
The HISTORY file documents much of the evolution of expect.
It makes interesting reading and might give you further insight to this
software.  Thanks to the people mentioned in it that sent me bug fixes
or gave other assistance.
.PP
Design and implementation of
.B expect
was paid for by the U.S. government and is therefore in the public
domain.
However the author and NIST would like credit
if this program and documentation or portions of them are used.
