/* $Date: 92/02/16 08:41:45 $    $Revision: 1.3 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */

/***************************************************************************
  CmFigure.cc -  Widget wrapper
  Contact: joe, maschaub
****************************************************************************/

#include<CDS.h>
#include<CmCDS.h>
#include<CmModel.h>
#include<CmFigure.h>
#include<CmFigureClass.h>
#include<CmFigureEditor.h>
#include<Xm/Form.h>

#include<X11/StringDefs.h>


struct CmFigureResource {
  CmString name;
  CmString value;
};

struct CmFigureCallback {
  CmFigure *Figure;
  int callback_index;
  CmFigureCallback(CmFigure *f, int i) {
    Figure = f; callback_index = i;
  }
};

static void CmFigureSendCallbacks(Widget, 
			    CmFigureCallback* callback, 
			    XtPointer call_data) {
  callback->Figure->SendCallbacks(callback->callback_index, call_data); 
}

static const CmRegex WhiteSpace("[ \n\t\r\v\f]*", 1);

/*************************
 CmFigure Constructor
  Called by CmFigureResistrar
  Copies parameters to local variables
*************************/
CmFigure::CmFigure(CmFigure*   parent_cm_widget, 
		   const CmString  &name_string, 
		   CmFigureClass*  wc, 
		   CmCDS*  cdsptr) {
   Name = name_string;
   parent = parent_cm_widget;
   widget_parent = NULL;
   widget = NULL;
   cmfigure_class = wc;
   cds_ptr = cdsptr;
   use_default_parent = True;
   if(parent_cm_widget)
     parent_cm_widget->children.Append(this);
   
   for (int i=0; i< NumCallbacks(); i++)
     callbacks.Append(new CmString);
 }

/*************************
CmFigure consructor
  Copies parameters to local variables
*************************/
CmFigure::CmFigure( Widget parent_widget, const CmString & name_string, 
		   CmFigureClass*  wc, CmCDS*  cdsptr) {
  Name = name_string;
  widget_parent = parent_widget;
  parent = NULL;
  cmfigure_class = wc;
  cds_ptr = cdsptr;
  use_default_parent = True;
  widget = NULL;

  for (int i=0; i< NumCallbacks(); i++)
    callbacks.Append(new CmString);
}

/****************************************************************************
  CmFigure Copier
  Copies itself, returns a brand new pointer and copy of itself
****************************************************************************/
CmFigure* CmFigure::Copy(const CmString & node_name, 
			 CmFigure *parent) {
  CmFigure *  new_CmFigure = new CmFigure(parent, "untitled",
					  cmfigure_class,cds_ptr);


  // copy resources
  for (resources.MoveFirst(); resources.HasCurrent(); resources.MoveNext())
    new_CmFigure->ChangeResource(get_resource()->name, get_resource()->value);

  // copy scheme text
  for (int i=0; i < NumCallbacks(); i++) 
    * ((CmString *) new_CmFigure->callbacks[i]) = 
      * ((CmString *) callbacks[i]);
  
  // copy children
  for (children.MoveFirst(); children.HasCurrent(); children.MoveNext())
    ((CmFigure *)children.GetCurrent())->Copy(node_name, new_CmFigure);

  return new_CmFigure;
}

/*************************
 CmFigure Destructor
   Kills all the children
*************************/
CmFigure::~CmFigure() {
  for (children.MoveFirst(); children.HasCurrent(); children.MoveNext())
    delete (CmFigure *) children.GetCurrent();

  for (resources.MoveFirst(); resources.HasCurrent(); resources.MoveNext())
    delete (CmFigureResource *) resources.GetCurrent();
  
  for (callbacks.MoveFirst(); callbacks.HasCurrent(); callbacks.MoveNext())
    delete (CmString *) callbacks.GetCurrent();

  XtDestroyWidget(widget);
}


void CmFigure::SetIsMapped( CmBool map ) { 
  ChangeResource("mappedWhenManaged", map ? "True" : "False");
}

/*************************
 CmFigure AddCallback
 *************************/
void CmFigure::ChangeCallback(const CmString & cbtext,  
			      const CmString & text) {
  for (int i=0; i < NumCallbacks(); i++)
    if (cmfigure_class->CallbackName(i) == cbtext)
      *((CmString *) callbacks[i]) = text;
}

/*************************
 CmFigure SendCallbacks
 *************************/
void CmFigure::SendCallbacks(int index, XtPointer call_data) {
  if (cmfigure_class->UpdateCallbackProc)
    (* (cmfigure_class->UpdateCallbackProc))
     (this, cmfigure_class->CallbackName(index), call_data);

  CmString callback = *((CmString *) callbacks[index]);
  if (!callback.Matches(WhiteSpace))
    cds_ptr->Model()->Evaluate(callback);
}


static CmString empty = "";
/*************************
 CmFigure GetCallbackString
 *************************/
const CmString & CmFigure::GetCallbackString(const CmString &callback_text ) {
  for (int i=0; i < cmfigure_class->NumCallbacks(); i++) 
    if ( cmfigure_class->CallbackName(i) == callback_text )
      return *((CmString *) callbacks[i]);
  return empty;
}

static int counter = 0;

#define MAX_NUM_QUARKS 10

/*************************
 CmFigure Widgetize
  Called by CmFigureRegistrar
  Calls change_resources
  Redraw all widgets by creating new widgets and destroying the old ones.
**************************/
void CmFigure::Widgetize() {
  if (widget)
    XtDestroyWidget(widget);

  Widget child = widgetize();
  if (child)
    XtManageChild(child);
}

Widget CmFigure::widgetize()  {
  XrmBinding bindings[MAX_NUM_QUARKS];
  XrmQuark quarks[MAX_NUM_QUARKS];
  
  Widget widget_parent_of_this = 
    widget_parent ? widget_parent : parent->widget;

  XrmDatabase database = XtDatabase(XtDisplay(widget_parent_of_this));

  CmString widget_name = "CDS_widget_";
  widget_name += form("%d", counter);

  XrmStringToBindingQuarkList(widget_name, bindings, quarks);
  bindings[0] = XrmBindLoosely;

  int num_quarks = 0;
  
  while (quarks[num_quarks] != 0)
    num_quarks++;
  if (num_quarks > MAX_NUM_QUARKS -3) {
    cerr << "Uh! Oh! MAX_NUM_QUARKS in CmFigure.cc exceeded";
    return NULL;
  }

  for (CmFigureClass *wc = cmfigure_class; wc; wc = wc->SuperCmClass())
    for (int i = 0; i < wc->NumberOfResources(); i++)
      if (wc->Default(i) != "XtDefaultValue") {
	XrmStringToBindingQuarkList(wc->Resource(i).Chars(),
				    bindings + num_quarks,
				    quarks + num_quarks);
	XrmQPutStringResource(&database, bindings, quarks,
			      wc->Default(i).Chars());
      }

  for (resources.MoveFirst(); resources.HasCurrent(); resources.MoveNext()) {
    CmFigureResource *resource = 
      (CmFigureResource *) resources.GetCurrent();
    if (resource->value != "XtDefaultValue") {
// This is a hack to append the resource in back of the widget name
      XrmStringToBindingQuarkList(resource->name.Chars(), 
				  bindings + num_quarks,
				  quarks + num_quarks);
      XrmQPutStringResource(&database, bindings, quarks, 
			    resource->value.Chars());
    }
  }

  counter++;

  widget = XtVaCreateWidget(widget_name.Chars(),
			    cmfigure_class->GetWidgetClass(), 
			    widget_parent_of_this,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNtopAttachment, XmATTACH_POSITION,
			    XmNrightAttachment, XmATTACH_POSITION,
			    XmNbottomAttachment, XmATTACH_POSITION, NULL);

  WidgetList manage_list = new Widget[children.ListSize()];
  Cardinal manage_count = 0;
  for (children.MoveFirst(); children.HasCurrent(); children.MoveNext()) {
    Widget child = ((CmFigure *) children.GetCurrent())->widgetize(); 
    if (child)
      manage_list[manage_count++] = child;
  }

  if (manage_count)
    XtManageChildren(manage_list, manage_count);
  delete manage_list;

  // add callbacks to new widget
  for (i=0; i < NumCallbacks(); i++)
    XtAddCallback(widget, cmfigure_class->Callback(i).Chars(), 
		  (XtCallbackProc)CmFigureSendCallbacks, 
		  (XtPointer) new CmFigureCallback(this, i));

  // add event handler
  if (XtIsWidget(widget) && XtClass(widget) != xmFormWidgetClass)
    XtAddEventHandler(widget,  ButtonPressMask | ButtonReleaseMask | 
		      ButtonMotionMask, 0, 
		      (XtEventHandler) CmFigureActivated, 
		      (XtPointer) cds_ptr->Editor());
  return(widget);
}

/*************************
 CmFigure GetResource
  Gets the value of a certain resource
**************************/
const CmString & CmFigure::GetResource(const CmString &tok) {
  int low = 0;
  int high = NumberOfResources() -1;
  while (low <= high) {
    int mid = (low+high)/2;
    if (tok < get_resource(mid)->name)
      high = mid-1;
    else if (tok > get_resource(mid)->name)
      low = mid+1;
    else
      return (get_resource(mid)->value);
  }
  
  return(cmfigure_class->Default(tok));
}

/*************************
 CmFigure ChangeResource 
  Changes the value of a certain resource
**************************/
void CmFigure::ChangeResource(const CmString &name,  
			      const CmString &value) {
  if (cmfigure_class->Default(name) == value)
    DeleteResource(name);
  else {
    for (resources.MoveFirst(); resources.HasCurrent();
	 resources.MoveNext()) 
      if (name == get_resource()->name) {
	get_resource()->value = value;
	return;
      } else if (name < get_resource()->name) {
	CmFigureResource *  resource = new CmFigureResource;
	resource->name = name;
	resource->value = value;
	resources.InsertBefore(resource);
	return;
      }

    CmFigureResource *  resource = new CmFigureResource;
    resource->name = name;
    resource->value = value;
    resources.Append(resource);
  }
}

/*************************
 CmFigure DeleteResource
  Uses the command free to remove an resource from the array
**************************/
void CmFigure::DeleteResource(const CmString &name) {
  int low = 0;
  int high = NumberOfResources() -1;
  while (low <= high) {
    int mid = (low+high)/2;
    if (name < get_resource(mid)->name)
      high = mid-1;
    else if (name > get_resource(mid)->name)
      low = mid+1;
    else
      resources.Remove(mid);
  }
}

/*************************
 CmFigure SetParent
  Gets the name and widget of the parent of the CmFigure
**************************/
void CmFigure::SetParent(CmFigure *reference, 
			 const CmString & parent_name) {
  CmFigure *new_parent = reference->NameToCmFigure(parent_name);
  if (!new_parent)
    SetParent(reference->NameToCmFigure(parent_name));
  else
    cerr << "CmFigure::SetParent could not find widget " << parent_name
         << "\n";
}


/*************************
 CmFigure SetParent
  Gets the name and widget of the parent of the CmFigure
**************************/
void CmFigure::SetParent(CmFigure *  parent_cm_widget) {
  use_default_parent = False;
  parent->remove_child_from_list(this);
  parent = parent_cm_widget;
  parent->children.Append(this);
}


/*************************
 CmFigure NumCmFigures
**************************/
int CmFigure::NumCmFigures() { return(children.ListSize()); }

/*************************
 CmFigure GetCmFigure
**************************/
CmFigure* CmFigure::GetCmFigure(int i) { return((CmFigure*)children[i]); }

/*************************
 CmFigure AddCmFigure
  Calls add_child and widgetizes the child
**************************/
void CmFigure::AddCmFigure(CmFigure*  cw) {
  if ( ! cw ) return;
  children.Append(cw);
  cw->Widgetize();
}

/*************************
 CmFigure RemoveCmFigure 
  Deletes, unmaps and unmanages the child
**************************/
void CmFigure::RemoveCmFigure(CmFigure*  cw) {  
  if (cw) {
    remove_child_from_list(cw);
    delete cw;
  }
    cmdebug << "Removed child.\n";
}

void CmFigure::remove_child_from_list(CmFigure *  cw) {
  for (int i=0; i<children.ListSize(); i++) {
    if (children[i] == cw) {
      children.Remove(i);
      break;
    }
  }
}

/*************************
 CmFigure NameToCmFigure
  Converts the name of a widget to a CmFigure
**************************/
CmFigure *CmFigure::NameToCmFigure(const CmString & string) {
  if ( string == Name )
    return(this);
  
  for (children.MoveFirst(); children.HasCurrent(); children.MoveNext()) {
    CmFigure * cm_widget = 
      ((CmFigure *) children.GetCurrent())->NameToCmFigure(string);
    
    if (cm_widget)
      return(cm_widget); 
  }
  return((CmFigure *) NULL);
}

/*************************
 CmFigure WidgetToCmFigure
  Converts the widget to a Widget
**************************/
CmFigure *CmFigure::WidgetToCmFigure( Widget w) {
  if (w == widget)
    return(this);
  
  for (children.MoveFirst(); children.HasCurrent(); children.MoveNext()) {
    CmFigure *cm_widget = 
      ((CmFigure *) children.GetCurrent())->WidgetToCmFigure(w);

    if (cm_widget)
      return(cm_widget); 
  }
  return((CmFigure *) NULL);
}


/*************************
 CmFigure Map
  Uses XtMapWidget to map the widget
**************************/
void CmFigure::Map() {
  if (widget && XtIsRealized(widget))
    XtMapWidget(widget);
}

/*************************
 CmFigure UnMap
  Uses XtUnMapWidget to unmap the widget
*************************/
void CmFigure::Unmap() { 
  if (widget && XtIsRealized(widget))
    XtUnmapWidget(widget);
}

/*************************
 CmFigure Show
  Displays itself and all children
**************************/
void CmFigure::Show() { 
  Map();
  if (widget && XtIsRealized(widget))
    XRaiseWindow(XtDisplay(widget), XtWindow(widget));
 
  for (children.MoveFirst(); children.HasCurrent(); children.MoveNext())
    ((CmFigure *) children.GetCurrent())->Show();
}

/*************************
 CmFigure Hide
  Hides itself and all children
**************************/
void CmFigure::Hide() { 
  Unmap();
  for (children.MoveFirst(); children.HasCurrent(); children.MoveNext())
    ((CmFigure *) children.GetCurrent())->Hide();
}

/***************************
 Quotify - changes quotes to backslash quotes
****************************/

static inline CmString Quotify (CmString string) {
  string.Gsub("\"", "\\\"");
  return string;
}

/****************************************************************************
  CmFigure GetCmFigureDefinition
    Returns a sring which defines the CmFigure and all its children,
    i.e., the workarea form widget and its list of children.
****************************************************************************/
void CmFigure::GetCmFigureDefinition(CmString &def_string,
				     CmBool recursive = 1,
				     CmBool include_self = 1) {
  if (include_self) {
    // saving class name
    def_string +=  "\n\\begin_figure {" + cmfigure_class->ClassName() + "}\n";
    // saving name
    def_string += "\\figure_name \"" + Name + "\" \n";

    //saving parent
    if (parent && !use_default_parent)
      def_string += "\\figure_parent \"" + parent->Name + "\"\n";

    // add callback list to string
    for (int i=0; i < NumCallbacks(); i++ ) {
      CmString callback = * ((CmString *) callbacks[i]);
      if (!callback.Matches(WhiteSpace))
	def_string += "\\callback \"" + cmfigure_class->CallbackName(i) + 
	  "\" \"" + Quotify(callback) + "\"\n";
    }

    // added resources to def_string
    for (resources.MoveFirst(); resources.HasCurrent(); resources.MoveNext()) {
      CmFigureResource *resource = (CmFigureResource *) resources.GetCurrent();
      if (resource->value != cmfigure_class->Default(resource->name))  
	def_string += resource->name + " \"" 
	  + Quotify(resource->value) + "\";\n";
    }
    def_string += "\\end_figure\n";
  }
  for (children.MoveFirst(); children.HasCurrent(); children.MoveNext())
    ((CmFigure *) children.GetCurrent())->GetCmFigureDefinition(def_string);
}

// Resize
void CmFigure::Resize(int x, int y, int width, int height) {
  Position leftpos = x, toppos = y;
  Position rightpos = x + width, botpos = y + height;
  ChangeResource(XmNleftPosition, form("%d", leftpos));
  ChangeResource(XmNtopPosition, form("%d",toppos));
  ChangeResource(XmNrightPosition, form("%d", rightpos));
  ChangeResource(XmNbottomPosition, form("%d", botpos));
  
  if (widget) {
    XtVaSetValues(widget,
		  XmNleftPosition, (XtArgVal) leftpos,
		  XmNtopPosition, (XtArgVal) toppos,
		  XmNrightPosition, (XtArgVal) rightpos,
		  XmNbottomPosition, (XtArgVal) botpos, NULL);
    XSync(XtDisplay(widget), False);
  }
}

int CmFigure::NumCallbacks() {
  return cmfigure_class->NumCallbacks();
}

/*************************
 CmFigure
**************************/
ostream & operator << (ostream &stream, CmFigure * cm_widget) {
  CmString output;
  cm_widget->GetCmFigureDefinition(output, 1, 0);
  stream << output;
  return(stream);
}

