/* $Date: 92/02/16 08:41:55 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
#ifndef _CM_FIGURE_H
#define _CM_FIGURE_H

#include<CDS.h>
#include<CmList.h>

class CmCDS;
class CmFigureClass;
struct CmFigureResource;
struct CmFigureCallback;

class CmFigure {
 private:
  CmCDS* cds_ptr;

  CmFigure *parent;
  Widget widget_parent;

  Widget widget;
  CmFigureClass* cmfigure_class;

  CmList children;    // CmFigure *
  CmList resources;      // CmFigureResource
  CmList callbacks;     // CmFigureCallback

  void remove_child_from_list(CmFigure *);
  void get_default_resources(CmFigureClass *);
  CmBool use_default_parent;
  void add_resource(const CmString &, const CmString &);
  Widget widgetize();
 public:
  CmString Name;
  CmFigure(CmFigure*, const CmString &, CmFigureClass*,CmCDS*);
  CmFigure(Widget, const CmString &, CmFigureClass*, CmCDS*);
  ~CmFigure();
  CmFigure* Copy(const CmString &string) {
    return Copy(string, NULL);
  }
  CmFigure* Copy(const CmString &, CmFigure *);
  CmCDS* CDSPtr() { return cds_ptr; }

  // display routines
  void Widgetize();
  void Map();
  void Unmap();
  void Show();
  void Hide();
  void SetIsMapped( CmBool );

  CmFigureResource *get_resource() {
    return ((CmFigureResource *) resources.GetCurrent());
  }

  CmFigureResource *get_resource(int i) {
    return ((CmFigureResource *) resources[i]);
  }

  // resource routines
  int NumberOfResources() {return resources.ListSize();}
  void DeleteResource(const CmString &);
  const CmString &GetResource(const CmString &);
  void ChangeResource(const CmString &, const CmString &);


  // parent routines
  void SetParent(CmFigure*, const CmString &);
  void SetParent(CmFigure*);

  // converters
  CmFigure* NameToCmFigure(const CmString &);
  CmFigure* WidgetToCmFigure(Widget);
  CmFigureClass* GetCmFigureClass() {return(cmfigure_class);}

  // figure modification
  void GetCmFigureDefinition(CmString &, CmBool, CmBool);
  Widget GetWidget() { return(widget); }


  // children routines
  void AddCmFigure(CmFigure *);
  void RemoveCmFigure(CmFigure *);
  int NumCmFigures();
  CmFigure* GetCmFigure(int);
 
  // add Callback
  void ChangeCallback(const CmString &, 
		      const CmString &);
  void SendCallbacks(int, XtPointer);
  const CmString & GetCallbackString(const CmString &);
  int NumCallbacks();
  
  // Resize
  void Resize(int, int, int, int);
};

ostream & operator << (ostream &, CmFigure *);
#endif







