/* $Date: 92/02/16 08:42:53 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/****************************************************************************
 CmFigureClass.h - Figure Class (under CmFigureRegistrar)
 Contact: sniyogi, maschaub
 ****************************************************************************/

#ifndef _CMFigureCLASS
#define _CMFigureCLASS
#include <CDS.h>

class CmFigure;

struct CmResource {
    CmString ResourceString;        // List of editable keywords
    CmString DialogText;   // prompt in dialog box
    CmString DefaultValue; // default value
    int EditMode;         // and the manner they are to be edited via CmDialog
    Boolean IsCommon;
    
    CmList OptionList;
    CmString* Option;
};

  
struct CmCallback {
    CmString CallbackName;
    CmString Callback;
};

class CmFigureClass {
 private:
  CmString class_name;
  WidgetClass widget_class;            // Class type: XmLabel, XmText, etc.  
  CmFigureClass *super_cm_class;
  CmList resource_list;  // list of resources
  CmList callback_list; // list of possible callbacks
 public:
  CmFigureClass(const CmString &);      // Constructor
  ~CmFigureClass();                     // Destructor

  // Adding keyword, dialog text, and method of editing
  void AddResource(const CmString &, const CmString &, 
		   const CmString &, const int, const Boolean);   
  void AddOptionToResource(const CmString &, const CmString &);
  void AddCallback(const CmString &, const CmString &);
  int NumberOfResources() const { 
    return(resource_list.ListSize());
  }

  const CmString &ClassName() const {
    return (class_name);
  }

  const CmString &Resource(const int i)  {
    return(((CmResource *)resource_list[i])->ResourceString);
  };

  const CmString &DialogText(const int i) {
    return(((CmResource *)resource_list[i])->DialogText); 
  };

  const CmString &Default(const int i)   {
    return(((CmResource *) resource_list[i])->DefaultValue);
  };

  const CmString & Default( const CmString &);
  int EditMode(const int);
  Boolean IsCommon(const int);
  int NumOptions(const int );
  const CmString & Option(const int, const int );
  const CmString & CallbackName( const int );
  const CmString & Callback( const int );

  int NumCallbacks() const { 
    return(callback_list.ListSize()); 
  }
  void SetSuperCmClass(CmFigureClass *sfc) {super_cm_class = sfc;}
  CmFigureClass *SuperCmClass() {return super_cm_class; }

  void SetWidgetClass(const WidgetClass wc) {widget_class = wc;}
  WidgetClass GetWidgetClass() const {return (widget_class);}

  void (* UpdateCallbackProc)(CmFigure *, const CmString &, XtPointer);
};
#endif






